/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Concatenator
implements PlugIn {
    ImagePlus imp1;
    ImagePlus imp2;
    static boolean keep;
    static String title;

    public void run(String string) {
        if (!this.showDialog()) {
            return;
        }
        ImagePlus imagePlus = null;
        if (this.imp1.isComposite() || this.imp1.isHyperStack()) {
            ImagePlus[] imagePlusArray = new ImagePlus[]{this.imp1, this.imp2};
            imagePlus = this.concatenate(imagePlusArray, keep);
            if (imagePlus == null) {
                this.error();
            } else {
                imagePlus.setTitle(title);
            }
        } else {
            imagePlus = this.concatenate(this.imp1, this.imp2, keep);
        }
        if (imagePlus != null) {
            imagePlus.show();
        }
    }

    public ImagePlus concatenate(ImagePlus imagePlus, ImagePlus imagePlus2, boolean bl) {
        String string;
        ImageProcessor imageProcessor;
        int n;
        if (imagePlus.getType() != imagePlus2.getType() || imagePlus.isHyperStack() || imagePlus2.isHyperStack()) {
            this.error();
            return null;
        }
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        if (n2 != imagePlus2.getWidth() || n3 != imagePlus2.getHeight()) {
            this.error();
            return null;
        }
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus2.getStack();
        int n4 = imageStack.getSize();
        int n5 = imageStack2.getSize();
        ImageStack imageStack3 = imagePlus.createEmptyStack();
        int n6 = 1;
        for (n = 1; n <= n4; ++n) {
            imageProcessor = imageStack.getProcessor(n6);
            string = imageStack.getSliceLabel(n6);
            if (bl || imagePlus == imagePlus2) {
                imageProcessor = imageProcessor.duplicate();
                ++n6;
            } else {
                imageStack.deleteSlice(n6);
            }
            imageStack3.addSlice(string, imageProcessor);
        }
        n6 = 1;
        for (n = 1; n <= n5; ++n) {
            imageProcessor = imageStack2.getProcessor(n6);
            string = imageStack2.getSliceLabel(n6);
            if (bl || imagePlus == imagePlus2) {
                imageProcessor = imageProcessor.duplicate();
                ++n6;
            } else {
                imageStack2.deleteSlice(n6);
            }
            imageStack3.addSlice(string, imageProcessor);
        }
        ImagePlus imagePlus3 = new ImagePlus(title, imageStack3);
        imagePlus3.setCalibration(imagePlus.getCalibration());
        if (!bl) {
            imagePlus.changes = false;
            imagePlus.close();
            if (imagePlus != imagePlus2) {
                imagePlus2.changes = false;
                imagePlus2.close();
            }
        }
        return imagePlus3;
    }

    public ImagePlus concatenate(ImagePlus[] imagePlusArray, boolean bl) {
        int n = imagePlusArray.length;
        int n2 = imagePlusArray[0].getWidth();
        int n3 = imagePlusArray[0].getHeight();
        int n4 = imagePlusArray[0].getBitDepth();
        int n5 = imagePlusArray[0].getNChannels();
        int n6 = imagePlusArray[0].getNSlices();
        int n7 = imagePlusArray[0].getNFrames();
        boolean bl2 = n6 > 1 && n7 == 1;
        for (int i = 1; i < n; ++i) {
            if (imagePlusArray[i].getNFrames() > 1) {
                bl2 = false;
            }
            if (imagePlusArray[i].getWidth() == n2 && imagePlusArray[i].getHeight() == n3 && imagePlusArray[i].getBitDepth() == n4 && imagePlusArray[i].getNChannels() == n5 && (bl2 || imagePlusArray[i].getNSlices() == n6)) continue;
            return null;
        }
        ImageStack imageStack = new ImageStack(n2, n3);
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < n; ++i) {
            ImageStack imageStack2 = imagePlusArray[i].getStack();
            n6 = imagePlusArray[i].getNSlices();
            if (bl2) {
                n6 = imagePlusArray[i].getNSlices();
                n8 += n6;
                n9 = n7;
            } else {
                n7 = imagePlusArray[i].getNFrames();
                n9 += n7;
                n8 = n6;
            }
            for (int j = 1; j <= n7; ++j) {
                for (int k = 1; k <= n6; ++k) {
                    for (int i2 = 1; i2 <= n5; ++i2) {
                        int n10 = (j - 1) * n5 * k + (k - 1) * n5 + i2;
                        ImageProcessor imageProcessor = imageStack2.getProcessor(n10);
                        if (bl) {
                            imageProcessor = imageProcessor.duplicate();
                        }
                        String string = imageStack2.getSliceLabel(n10);
                        imageStack.addSlice(string, imageProcessor);
                    }
                }
            }
        }
        ImagePlus imagePlus = new ImagePlus("Concatenated Images", imageStack);
        imagePlus.setDimensions(n5, n8, n9);
        if (n5 > 1) {
            int n11 = 0;
            if (imagePlusArray[0].isComposite()) {
                n11 = ((CompositeImage)imagePlusArray[0]).getMode();
            }
            imagePlus = new CompositeImage(imagePlus, n11);
            ((CompositeImage)imagePlus).copyLuts(imagePlusArray[0]);
        }
        if (n5 > 1 && n9 > 1) {
            imagePlus.setOpenAsHyperStack(true);
        }
        if (!bl) {
            for (int i = 0; i < n; ++i) {
                imagePlusArray[i].changes = false;
                imagePlusArray[i].close();
            }
        }
        return imagePlus;
    }

    int getStackIndex(int n, int n2, int n3, int n4, int n5, int n6) {
        return (n3 - 1) * n4 * n5 + (n2 - 1) * n4 + n;
    }

    boolean showDialog() {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.noImage();
            return false;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object = WindowManager.getImage(nArray[i]);
            stringArray[i] = object != null ? ((ImagePlus)object).getTitle() : "";
        }
        GenericDialog genericDialog = new GenericDialog("Concatenator");
        genericDialog.addChoice("Stack1:", stringArray, stringArray[0]);
        genericDialog.addChoice("Stack2:", stringArray, nArray.length > 1 ? stringArray[1] : stringArray[0]);
        genericDialog.addStringField("Title:", title, 16);
        genericDialog.addCheckbox("Keep Source Stacks", keep);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        object = new int[3];
        int n = genericDialog.getNextChoiceIndex();
        int n2 = genericDialog.getNextChoiceIndex();
        title = genericDialog.getNextString();
        keep = genericDialog.getNextBoolean();
        this.imp1 = WindowManager.getImage(nArray[n]);
        this.imp2 = WindowManager.getImage(nArray[n2]);
        return true;
    }

    void error() {
        IJ.showMessage("Concatenator", "This command requires two images with\nthe same dimesions and data type.");
    }

    static {
        title = "Concatenated Stacks";
    }
}

