/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.plugin.HyperStackReducer;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import java.util.Vector;

public class ChannelSplitter
implements PlugIn {
    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus.isComposite()) {
            ImagePlus[] imagePlusArray = ChannelSplitter.split(imagePlus);
            for (int i = 0; i < imagePlusArray.length; ++i) {
                imagePlusArray[i].show();
            }
            imagePlus.changes = false;
            imagePlus.close();
        } else if (imagePlus.getType() == 4) {
            this.splitRGB(imagePlus);
        } else {
            IJ.error("Split Channels", "Multichannel image required");
        }
    }

    private void splitRGB(ImagePlus imagePlus) {
        boolean bl = IJ.altKeyDown();
        String string = imagePlus.getTitle();
        Calibration calibration = imagePlus.getCalibration();
        ImageStack[] imageStackArray = ChannelSplitter.splitRGB(imagePlus.getStack(), bl);
        if (!bl) {
            imagePlus.unlock();
            imagePlus.changes = false;
            imagePlus.close();
        }
        ImagePlus imagePlus2 = new ImagePlus(string + " (red)", imageStackArray[0]);
        imagePlus2.setCalibration(calibration);
        imagePlus2.show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        ImagePlus imagePlus3 = new ImagePlus(string + " (green)", imageStackArray[1]);
        imagePlus3.setCalibration(calibration);
        imagePlus3.show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        ImagePlus imagePlus4 = new ImagePlus(string + " (blue)", imageStackArray[2]);
        imagePlus4.setCalibration(calibration);
        imagePlus4.show();
    }

    public static ImagePlus[] split(ImagePlus imagePlus) {
        if (imagePlus.getType() == 4) {
            return null;
        }
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getNChannels();
        int n4 = imagePlus.getNSlices();
        int n5 = imagePlus.getNFrames();
        int n6 = imagePlus.getBitDepth();
        int n7 = n4 * n5;
        Vector<ImagePlus> vector = new Vector<ImagePlus>();
        HyperStackReducer hyperStackReducer = new HyperStackReducer(imagePlus);
        for (int i = 1; i <= n3; ++i) {
            ImageStack imageStack = new ImageStack(n, n2, n7);
            imageStack.setPixels(imagePlus.getProcessor().getPixels(), 1);
            ImagePlus imagePlus2 = new ImagePlus("C" + i + "-" + imagePlus.getTitle(), imageStack);
            imageStack.setPixels(null, 1);
            imagePlus.setPosition(i, 1, 1);
            imagePlus2.setDimensions(1, n4, n5);
            imagePlus2.setCalibration(imagePlus.getCalibration());
            hyperStackReducer.reduce(imagePlus2);
            if (imagePlus.isComposite() && ((CompositeImage)imagePlus).getMode() == 3) {
                IJ.run(imagePlus2, "Grays", "");
            }
            if (imagePlus2.getNDimensions() > 3) {
                imagePlus2.setOpenAsHyperStack(true);
            }
            vector.add(imagePlus2);
        }
        ImagePlus[] imagePlusArray = new ImagePlus[vector.size()];
        return vector.toArray(imagePlusArray);
    }

    public static ImageStack[] splitRGB(ImageStack imageStack, boolean bl) {
        int n = imageStack.getWidth();
        int n2 = imageStack.getHeight();
        ImageStack[] imageStackArray = new ImageStack[3];
        for (int i = 0; i < 3; ++i) {
            imageStackArray[i] = new ImageStack(n, n2);
        }
        int n3 = 1;
        int n4 = bl ? 1 : 0;
        int n5 = imageStack.getSize();
        for (int i = 1; i <= n5; ++i) {
            IJ.showStatus(i + "/" + n5);
            byte[] byArray = new byte[n * n2];
            byte[] byArray2 = new byte[n * n2];
            byte[] byArray3 = new byte[n * n2];
            ColorProcessor colorProcessor = (ColorProcessor)imageStack.getProcessor(n3);
            n3 += n4;
            colorProcessor.getRGB(byArray, byArray2, byArray3);
            if (!bl) {
                imageStack.deleteSlice(1);
            }
            imageStackArray[0].addSlice(null, byArray);
            imageStackArray[1].addSlice(null, byArray2);
            imageStackArray[2].addSlice(null, byArray3);
            IJ.showProgress((double)i / (double)n5);
        }
        return imageStackArray;
    }
}

