/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.NonBlockingGenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class BatchProcesser
implements PlugIn,
ActionListener,
ItemListener,
Runnable {
    private static final String MACRO_FILE_NAME = "BatchMacro.ijm";
    private static final String[] formats = new String[]{"TIFF", "8-bit TIFF", "JPEG", "GIF", "PNG", "PGM", "BMP", "FITS", "Text Image", "ZIP", "Raw"};
    private static String format = Prefs.get("batch.format", formats[0]);
    private static final String[] code = new String[]{"[Select from list]", "Add Border", "Convert to RGB", "Crop", "Gaussian Blur", "Invert", "Label", "Timestamp", "Max Dimension", "Measure", "Resize", "Scale", "Show File Info", "Unsharp Mask"};
    private String macro = "";
    private int testImage;
    private Button input;
    private Button output;
    private Button open;
    private Button save;
    private Button test;
    private TextField inputDir;
    private TextField outputDir;
    private GenericDialog gd;
    private Thread thread;
    private ImagePlus virtualStack;

    public void run(String string) {
        Object object;
        if (string.equals("stack")) {
            this.virtualStack = IJ.getImage();
            if (this.virtualStack.getStackSize() == 1) {
                this.error("This command requires a stack or virtual stack.");
                return;
            }
        }
        String string2 = IJ.getDirectory("macros") + MACRO_FILE_NAME;
        this.macro = IJ.openAsString(string2);
        if (this.macro == null || this.macro.startsWith("Error: ")) {
            IJ.showStatus(this.macro.substring(7) + ": " + string2);
            this.macro = "";
        }
        if (!this.showDialog()) {
            return;
        }
        String string3 = null;
        if (this.virtualStack == null) {
            string3 = this.inputDir.getText();
            if (string3.equals("")) {
                this.error("Please choose an input folder");
                return;
            }
            object = new File(string3 = this.addSeparator(string3));
            if (!((File)object).exists() || !((File)object).isDirectory()) {
                this.error("Input does not exist or is not a folder\n \n" + string3);
                return;
            }
        }
        object = this.outputDir.getText();
        object = this.addSeparator((String)object);
        File file = new File((String)object);
        if (!(((String)object).equals("") || file.exists() && file.isDirectory())) {
            this.error("Output does not exist or is not a folder\n \n" + (String)object);
            return;
        }
        if (this.macro.equals("")) {
            this.error("There is no macro code in the text area");
            return;
        }
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null) {
            imageJ.getProgressBar().setBatchMode(true);
        }
        IJ.resetEscape();
        if (this.virtualStack != null) {
            this.processVirtualStack((String)object);
        } else {
            this.processFolder(string3, (String)object);
        }
        IJ.showProgress(1, 1);
        if (this.virtualStack == null) {
            Prefs.set("batch.input", this.inputDir.getText());
        }
        Prefs.set("batch.output", this.outputDir.getText());
        Prefs.set("batch.format", format);
        this.macro = this.gd.getTextArea1().getText();
        if (!this.macro.equals("")) {
            IJ.saveString(this.macro, IJ.getDirectory("macros") + MACRO_FILE_NAME);
        }
    }

    boolean showDialog() {
        this.validateFormat();
        this.gd = new NonBlockingGenericDialog("Batch Process");
        this.addPanels(this.gd);
        this.gd.setInsets(15, 0, 5);
        this.gd.addChoice("Output Format:", formats, format);
        this.gd.setInsets(0, 0, 5);
        this.gd.addChoice("Add Macro Code:", code, code[0]);
        this.gd.setInsets(15, 10, 0);
        Dimension dimension = IJ.getScreenSize();
        this.gd.addTextAreas(this.macro, null, dimension.width <= 600 ? 10 : 15, 60);
        this.addButtons(this.gd);
        this.gd.setOKLabel("Process");
        Vector vector = this.gd.getChoices();
        Choice choice = (Choice)vector.elementAt(1);
        choice.addItemListener(this);
        this.gd.showDialog();
        format = this.gd.getNextChoice();
        this.macro = this.gd.getNextText();
        return !this.gd.wasCanceled();
    }

    void processVirtualStack(String string) {
        ImageStack imageStack = this.virtualStack.getStack();
        int n = imageStack.getSize();
        int n2 = 0;
        for (int i = 1; i <= n && !IJ.escapePressed(); ++i) {
            IJ.showProgress(i, n);
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            if (imageProcessor == null) {
                return;
            }
            ImagePlus imagePlus = new ImagePlus("", imageProcessor);
            if (!this.macro.equals("")) {
                WindowManager.setTempCurrentImage(imagePlus);
                String string2 = IJ.runMacro("i=" + n2++ + ";" + this.macro, "");
                if (string2 != null && string2.equals("[aborted]")) break;
            }
            if (!string.equals("")) {
                if (format.equals("8-bit TIFF") || format.equals("GIF")) {
                    if (imagePlus.getBitDepth() == 24) {
                        IJ.run(imagePlus, "8-bit Color", "number=256");
                    } else {
                        IJ.run(imagePlus, "8-bit", "");
                    }
                }
                IJ.saveAs(imagePlus, format, string + this.pad(i));
            }
            imagePlus.close();
        }
        if (string != null && !string.equals("")) {
            IJ.run("Image Sequence...", "open=[" + string + "]" + " use");
        }
    }

    String pad(int n) {
        String string = "" + n;
        while (string.length() < 5) {
            string = "0" + string;
        }
        return string;
    }

    void processFolder(String string, String string2) {
        String[] stringArray = new File(string).list();
        int n = 0;
        for (int i = 0; i < stringArray.length && !IJ.escapePressed(); ++i) {
            String string3 = string + stringArray[i];
            if (IJ.debugMode) {
                IJ.log(i + ": " + string3);
            }
            if (new File(string3).isDirectory() || stringArray[i].startsWith(".") || stringArray[i].endsWith(".avi") || stringArray[i].endsWith(".AVI")) continue;
            IJ.showProgress(i + 1, stringArray.length);
            ImagePlus imagePlus = IJ.openImage(string3);
            if (imagePlus == null) continue;
            if (!this.macro.equals("")) {
                WindowManager.setTempCurrentImage(imagePlus);
                String string4 = IJ.runMacro("i=" + n++ + ";" + this.macro, "");
                if (string4 != null && string4.equals("[aborted]")) break;
            }
            if (!string2.equals("")) {
                if (format.equals("8-bit TIFF") || format.equals("GIF")) {
                    if (imagePlus.getBitDepth() == 24) {
                        IJ.run(imagePlus, "8-bit Color", "number=256");
                    } else {
                        IJ.run(imagePlus, "8-bit", "");
                    }
                }
                IJ.saveAs(imagePlus, format, string2 + stringArray[i]);
            }
            imagePlus.close();
        }
    }

    String addSeparator(String string) {
        if (string.equals("")) {
            return string;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return string;
    }

    void validateFormat() {
        boolean bl = false;
        for (int i = 0; i < formats.length; ++i) {
            if (!format.equals(formats[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            format = formats[0];
        }
    }

    void addPanels(GenericDialog genericDialog) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 0));
        if (this.virtualStack == null) {
            this.input = new Button("Input...");
            this.input.addActionListener(this);
            panel.add(this.input);
            this.inputDir = new TextField(Prefs.get("batch.input", ""), 45);
            panel.add(this.inputDir);
            genericDialog.addPanel(panel);
        }
        panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 0));
        this.output = new Button("Output...");
        this.output.addActionListener(this);
        panel.add(this.output);
        this.outputDir = new TextField(Prefs.get("batch.output", ""), 45);
        panel.add(this.outputDir);
        genericDialog.addPanel(panel);
    }

    void addButtons(GenericDialog genericDialog) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 0));
        this.test = new Button("Test");
        this.test.addActionListener(this);
        panel.add(this.test);
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        panel.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        panel.add(this.save);
        genericDialog.addPanel(panel);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Choice choice = (Choice)itemEvent.getSource();
        String string = choice.getSelectedItem();
        String string2 = null;
        if (string.equals("Convert to RGB")) {
            string2 = "run(\"RGB Color\");\n";
        } else if (string.equals("Measure")) {
            string2 = "run(\"Measure\");\n";
        } else if (string.equals("Resize")) {
            string2 = "run(\"Size...\", \"width=512 height=512 interpolation=Bicubic\");\n";
        } else if (string.equals("Scale")) {
            string2 = "scale=1.5;\nw=getWidth*scale; h=getHeight*scale;\nrun(\"Size...\", \"width=w height=h interpolation=Bilinear\");\n";
        } else if (string.equals("Label")) {
            string2 = "setFont(\"SansSerif\", 18, \"antialiased\");\nsetColor(\"red\");\ndrawString(\"Hello\", 20, 30);\n";
        } else if (string.equals("Timestamp")) {
            string2 = this.openMacroFromJar("TimeStamp.ijm");
        } else if (string.equals("Crop")) {
            string2 = "makeRectangle(getWidth/4, getHeight/4, getWidth/2, getHeight/2);\nrun(\"Crop\");\n";
        } else if (string.equals("Add Border")) {
            string2 = "border=25;\nw=getWidth+border*2; h=getHeight+border*2;\nrun(\"Canvas Size...\", \"width=w height=h position=Center zero\");\n";
        } else if (string.equals("Invert")) {
            string2 = "run(\"Invert\");\n";
        } else if (string.equals("Gaussian Blur")) {
            string2 = "run(\"Gaussian Blur...\", \"sigma=2\");\n";
        } else if (string.equals("Unsharp Mask")) {
            string2 = "run(\"Unsharp Mask...\", \"radius=1 mask=0.60\");\n";
        } else if (string.equals("Show File Info")) {
            string2 = "path=File.directory+File.name;\ndate=File.dateLastModified(path);\nsize=File.length(path);\nprint(i+\", \"+getTitle+\", \"+date+\", \"+size);\n";
        } else if (string.equals("Max Dimension")) {
            string2 = "max=2048;\nw=getWidth; h=getHeight;\nsize=maxOf(w,h);\nif (size>max) {\n  scale = max/size;\n  w*=scale; h*=scale;\n  run(\"Size...\", \"width=w height=h interpolation=Bicubic average\");\n}";
        }
        if (string2 != null) {
            TextArea textArea = this.gd.getTextArea1();
            textArea.insert(string2, textArea.getCaretPosition());
            if (IJ.isMacOSX()) {
                textArea.requestFocus();
            }
        }
    }

    String openMacroFromJar(String string) {
        ImageJ imageJ = IJ.getInstance();
        Class<?> clazz = imageJ != null ? imageJ.getClass() : new ImageStack().getClass();
        String string2 = null;
        try {
            int n;
            InputStream inputStream = clazz.getResourceAsStream("/macros/" + string);
            if (inputStream == null) {
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[8192];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            string2 = stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
        return string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.input) {
            String string = IJ.getDirectory("Input Folder");
            if (string == null) {
                return;
            }
            this.inputDir.setText(string);
            if (IJ.isMacOSX()) {
                this.gd.setVisible(false);
                this.gd.setVisible(true);
            }
        } else if (object == this.output) {
            String string = IJ.getDirectory("Output Folder");
            if (string == null) {
                return;
            }
            this.outputDir.setText(string);
            if (IJ.isMacOSX()) {
                this.gd.setVisible(false);
                this.gd.setVisible(true);
            }
        } else if (object == this.test) {
            this.thread = new Thread((Runnable)this, "BatchTest");
            this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
            this.thread.start();
        } else if (object == this.open) {
            this.open();
        } else if (object == this.save) {
            this.save();
        }
    }

    void open() {
        String string = IJ.openAsString("");
        if (string == null) {
            return;
        }
        if (string.startsWith("Error: ")) {
            this.error(string.substring(7));
        } else if (string.length() > 30000) {
            this.error("File is too large");
        } else {
            this.gd.getTextArea1().setText(string);
        }
    }

    void save() {
        this.macro = this.gd.getTextArea1().getText();
        if (!this.macro.equals("")) {
            IJ.saveString(this.macro, "");
        }
    }

    void error(String string) {
        IJ.error("Batch Processer", string);
    }

    public void run() {
        ImageObserver imageObserver;
        TextArea textArea = this.gd.getTextArea1();
        String string = textArea.getText();
        if (string.equals("")) {
            this.error("There is no macro code in the text area");
            return;
        }
        ImagePlus imagePlus = null;
        imagePlus = this.virtualStack != null ? this.getVirtualStackImage() : this.getFolderImage();
        if (imagePlus == null) {
            return;
        }
        WindowManager.setTempCurrentImage(imagePlus);
        String string2 = IJ.runMacro("i=0;" + string, "");
        Point point = new Point(10, 30);
        if (this.testImage != 0 && (imageObserver = WindowManager.getImage(this.testImage)) != null) {
            ImageWindow imageWindow = ((ImagePlus)imageObserver).getWindow();
            if (imageWindow != null) {
                point = imageWindow.getLocation();
            }
            ((ImagePlus)imageObserver).changes = false;
            ((ImagePlus)imageObserver).close();
        }
        imagePlus.show();
        imageObserver = imagePlus.getWindow();
        if (imageObserver != null) {
            ((Window)imageObserver).setLocation(point);
        }
        this.testImage = imagePlus.getID();
    }

    ImagePlus getVirtualStackImage() {
        ImagePlus imagePlus = this.virtualStack.createImagePlus();
        imagePlus.setProcessor("", this.virtualStack.getProcessor().duplicate());
        return imagePlus;
    }

    ImagePlus getFolderImage() {
        String string = this.inputDir.getText();
        File file = new File(string = this.addSeparator(string));
        if (!file.exists() || !file.isDirectory()) {
            this.error("Input does not exist or is not a folder\n \n" + string);
            return null;
        }
        String[] stringArray = new File(string).list();
        String string2 = stringArray[0];
        if (string2.startsWith(".") && stringArray.length > 1) {
            string2 = stringArray[1];
        }
        String string3 = string + string2;
        this.setDirAndName(string3);
        return IJ.openImage(string3);
    }

    void setDirAndName(String string) {
        File file = new File(string);
        OpenDialog.setLastDirectory(file.getParent() + File.separator);
        OpenDialog.setLastName(file.getName());
    }
}

