/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class BatchConverter
implements PlugIn,
ActionListener {
    private static final String[] formats = new String[]{"TIFF", "8-bit TIFF", "JPEG", "GIF", "PNG", "PGM", "BMP", "FITS", "Text Image", "ZIP", "Raw"};
    private static String format = formats[0];
    private static double scale = 1.0;
    private static int interpolationMethod = 1;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private Button input;
    private Button output;
    private TextField inputDir;
    private TextField outputDir;
    private GenericDialog gd;

    public void run(String string) {
        if (!this.showDialog()) {
            return;
        }
        String string2 = this.inputDir.getText();
        if (string2.equals("")) {
            IJ.error("Batch Converter", "Please choose an input folder");
            return;
        }
        String string3 = this.outputDir.getText();
        if (string3.equals("")) {
            IJ.error("Batch Converter", "Please choose an output folder");
            return;
        }
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            IJ.error("Batch Converter", "Input does not exist or is not a folder\n \n" + string2);
            return;
        }
        File file2 = new File(string3);
        if (!(string3.equals("") || file2.exists() && file2.isDirectory())) {
            IJ.error("Batch Converter", "Output does not exist or is not a folder\n \n" + string3);
            return;
        }
        String[] stringArray = new File(string2).list();
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null) {
            imageJ.getProgressBar().setBatchMode(true);
        }
        IJ.resetEscape();
        for (int i = 0; i < stringArray.length && !IJ.escapePressed(); ++i) {
            String string4;
            if (IJ.debugMode) {
                IJ.log(i + "  " + stringArray[i]);
            }
            if (new File(string4 = string2 + stringArray[i]).isDirectory() || stringArray[i].startsWith(".") || stringArray[i].endsWith(".avi") || stringArray[i].endsWith(".AVI")) continue;
            IJ.showProgress(i + 1, stringArray.length);
            ImagePlus imagePlus = IJ.openImage(string4);
            if (imagePlus == null) continue;
            if (scale != 1.0) {
                int n = (int)(scale * (double)imagePlus.getWidth());
                int n2 = (int)(scale * (double)imagePlus.getHeight());
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                imageProcessor.setInterpolationMethod(interpolationMethod);
                imagePlus.setProcessor(null, imageProcessor.resize(n, n2, true));
            }
            if (format.equals("8-bit TIFF") || format.equals("GIF")) {
                if (imagePlus.getBitDepth() == 24) {
                    IJ.run(imagePlus, "8-bit Color", "number=256");
                } else {
                    IJ.run(imagePlus, "8-bit", "");
                }
            }
            IJ.saveAs(imagePlus, format, string3 + stringArray[i]);
            imagePlus.close();
        }
        IJ.showProgress(1, 1);
        Prefs.set("batch.input", this.inputDir.getText());
        Prefs.set("batch.output", this.outputDir.getText());
    }

    boolean showDialog() {
        this.gd = new GenericDialog("Batch Convert");
        this.addPanels(this.gd);
        this.gd.setInsets(15, 0, 5);
        this.gd.addChoice("Output Format: ", formats, format);
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        this.gd.addNumericField("Scale Factor: ", scale, 2);
        this.gd.setOKLabel("Convert");
        this.gd.showDialog();
        format = this.gd.getNextChoice();
        interpolationMethod = this.gd.getNextChoiceIndex();
        scale = this.gd.getNextNumber();
        return !this.gd.wasCanceled();
    }

    void addPanels(GenericDialog genericDialog) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 0));
        this.input = new Button("Input...");
        this.input.addActionListener(this);
        panel.add(this.input);
        this.inputDir = new TextField(Prefs.get("batch.input", ""), 45);
        panel.add(this.inputDir);
        genericDialog.addPanel(panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 0));
        this.output = new Button("Output...");
        this.output.addActionListener(this);
        panel.add(this.output);
        this.outputDir = new TextField(Prefs.get("batch.output", ""), 45);
        panel.add(this.outputDir);
        genericDialog.addPanel(panel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = object == this.input ? "Input" : "Output";
        String string2 = IJ.getDirectory(string + " Folder");
        if (string2 == null) {
            return;
        }
        if (object == this.input) {
            this.inputDir.setText(string2);
        } else {
            this.outputDir.setText(string2);
        }
        if (IJ.isMacOSX()) {
            this.gd.setVisible(false);
            this.gd.setVisible(true);
        }
    }
}

