/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Animator
implements PlugIn {
    private static double animationRate = Prefs.getDouble("fps", 7.0);
    private static int firstFrame = 0;
    private static int lastFrame = 0;
    private ImagePlus imp;
    private StackWindow swin;
    private int slice;
    private int nSlices;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        if (this.nSlices < 2) {
            IJ.error("Stack required.");
            return;
        }
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow == null || !(imageWindow instanceof StackWindow)) {
            if (string.equals("next")) {
                this.imp.setSlice(this.imp.getCurrentSlice() + 1);
            } else if (string.equals("previous")) {
                this.imp.setSlice(this.imp.getCurrentSlice() - 1);
            }
            if (imageWindow != null) {
                this.imp.updateStatusbarValue();
            }
            return;
        }
        this.swin = (StackWindow)imageWindow;
        ImageStack imageStack = this.imp.getStack();
        this.slice = this.imp.getCurrentSlice();
        IJ.register(Animator.class);
        if (string.equals("options")) {
            this.doOptions();
            return;
        }
        if (string.equals("start")) {
            this.startAnimation();
            return;
        }
        if (this.swin.getAnimate()) {
            this.stopAnimation();
        }
        if (string.equals("stop")) {
            return;
        }
        if (string.equals("next")) {
            this.nextSlice();
            return;
        }
        if (string.equals("previous")) {
            this.previousSlice();
            return;
        }
        if (string.equals("set")) {
            this.setSlice();
            return;
        }
    }

    void stopAnimation() {
        this.swin.setAnimate(false);
        IJ.wait(500 + (int)(1000.0 / animationRate));
        this.imp.unlock();
    }

    void startAnimation() {
        int n = firstFrame;
        int n2 = lastFrame;
        if (n < 1 || n > this.nSlices || n2 < 1 || n2 > this.nSlices) {
            n = 1;
            n2 = this.nSlices;
        }
        if (this.swin.getAnimate()) {
            this.stopAnimation();
            return;
        }
        this.imp.unlock();
        this.swin.setAnimate(true);
        long l = System.currentTimeMillis();
        Thread.currentThread().setPriority(1);
        int n3 = 1;
        Calibration calibration = this.imp.getCalibration();
        if (calibration.fps != 0.0) {
            animationRate = calibration.fps;
        }
        if (animationRate < 0.1) {
            animationRate = 1.0;
        }
        int n4 = this.imp.getNFrames();
        int n5 = this.imp.getNSlices();
        if (this.imp.isDisplayedHyperStack() && n4 > 1) {
            int n6 = this.imp.getFrame();
            n = 1;
            n2 = n4;
            while (this.swin.getAnimate()) {
                long l2 = System.currentTimeMillis();
                if (l2 < l) {
                    IJ.wait((int)(l - l2));
                } else {
                    Thread.yield();
                }
                l += (long)(1000.0 / animationRate);
                if ((n6 += n3) < n) {
                    n6 = n + 1;
                    n3 = 1;
                }
                if (n6 > n2) {
                    if (calibration.loop) {
                        n6 = n2 - 1;
                        n3 = -1;
                    } else {
                        n6 = n;
                        n3 = 1;
                    }
                }
                this.imp.setPosition(this.imp.getChannel(), this.imp.getSlice(), n6);
            }
            return;
        }
        if (this.imp.isDisplayedHyperStack() && n5 > 1) {
            this.slice = this.imp.getSlice();
            n = 1;
            n2 = n5;
            while (this.swin.getAnimate()) {
                long l3 = System.currentTimeMillis();
                if (l3 < l) {
                    IJ.wait((int)(l - l3));
                } else {
                    Thread.yield();
                }
                l += (long)(1000.0 / animationRate);
                this.slice += n3;
                if (this.slice < n) {
                    this.slice = n + 1;
                    n3 = 1;
                }
                if (this.slice > n2) {
                    if (calibration.loop) {
                        this.slice = n2 - 1;
                        n3 = -1;
                    } else {
                        this.slice = n;
                        n3 = 1;
                    }
                }
                this.imp.setPosition(this.imp.getChannel(), this.slice, this.imp.getFrame());
            }
            return;
        }
        long l4 = System.currentTimeMillis();
        int n7 = 0;
        double d = 0.0;
        while (this.swin.getAnimate()) {
            long l5 = System.currentTimeMillis();
            ++n7;
            if (l5 > l4 + 1000L) {
                l4 = System.currentTimeMillis();
                d = n7;
                n7 = 0;
            }
            IJ.showStatus((int)(d + 0.5) + " fps");
            if (l5 < l) {
                IJ.wait((int)(l - l5));
            } else {
                Thread.yield();
            }
            l += (long)(1000.0 / animationRate);
            this.slice += n3;
            if (this.slice < n) {
                this.slice = n + 1;
                n3 = 1;
            }
            if (this.slice > n2) {
                if (calibration.loop) {
                    this.slice = n2 - 1;
                    n3 = -1;
                } else {
                    this.slice = n;
                    n3 = 1;
                }
            }
            this.swin.showSlice(this.slice);
        }
    }

    void doOptions() {
        if (firstFrame < 1 || firstFrame > this.nSlices || lastFrame < 1 || lastFrame > this.nSlices) {
            firstFrame = 1;
            lastFrame = this.nSlices;
        }
        if (this.imp.isDisplayedHyperStack()) {
            int bl = this.imp.getNFrames();
            int n = this.imp.getNSlices();
            firstFrame = 1;
            if (bl > 1) {
                lastFrame = bl;
            } else if (n > 1) {
                lastFrame = n;
            }
        }
        boolean bl = !this.swin.getAnimate();
        Calibration calibration = this.imp.getCalibration();
        if (calibration.fps != 0.0) {
            animationRate = calibration.fps;
        } else if (calibration.frameInterval != 0.0 && calibration.getTimeUnit().equals("sec")) {
            animationRate = 1.0 / calibration.frameInterval;
        }
        int n = (double)((int)animationRate) == animationRate ? 0 : 3;
        GenericDialog genericDialog = new GenericDialog("Animation Options");
        genericDialog.addNumericField("Speed (0.1-1000 fps):", animationRate, n);
        if (!this.imp.isDisplayedHyperStack()) {
            genericDialog.addNumericField("First Frame:", firstFrame, 0);
            genericDialog.addNumericField("Last Frame:", lastFrame, 0);
        }
        genericDialog.addCheckbox("Loop Back and Forth", calibration.loop);
        genericDialog.addCheckbox("Start Animation", bl);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            if (firstFrame == 1 && lastFrame == this.nSlices) {
                firstFrame = 0;
                lastFrame = 0;
            }
            return;
        }
        double d = genericDialog.getNextNumber();
        if (!this.imp.isDisplayedHyperStack()) {
            firstFrame = (int)genericDialog.getNextNumber();
            lastFrame = (int)genericDialog.getNextNumber();
        }
        if (firstFrame == 1 && lastFrame == this.nSlices) {
            firstFrame = 0;
            lastFrame = 0;
        }
        calibration.loop = genericDialog.getNextBoolean();
        Calibration.setLoopBackAndForth(calibration.loop);
        boolean bl2 = genericDialog.getNextBoolean();
        if (d > 1000.0) {
            d = 1000.0;
        }
        if ((animationRate = d) != 0.0) {
            calibration.fps = animationRate;
        }
        if (bl2 && !this.swin.getAnimate()) {
            this.startAnimation();
        }
    }

    void nextSlice() {
        if (!this.imp.lock()) {
            return;
        }
        boolean bl = this.imp.isDisplayedHyperStack();
        int n = this.imp.getNChannels();
        int n2 = this.imp.getNSlices();
        int n3 = this.imp.getNFrames();
        if (bl && n > 1 && (n2 <= 1 && n3 <= 1 || !IJ.controlKeyDown() && !IJ.spaceBarDown() && !IJ.altKeyDown())) {
            int n4 = this.imp.getChannel() + 1;
            if (n4 > n) {
                n4 = n;
            }
            this.swin.setPosition(n4, this.imp.getSlice(), this.imp.getFrame());
        } else if (bl && n2 > 1 && (n3 <= 1 || !IJ.altKeyDown())) {
            int n5 = this.imp.getSlice() + 1;
            if (n5 > n2) {
                n5 = n2;
            }
            this.swin.setPosition(this.imp.getChannel(), n5, this.imp.getFrame());
        } else if (bl && n3 > 1) {
            int n6 = this.imp.getFrame() + 1;
            if (n6 > n3) {
                n6 = n3;
            }
            this.swin.setPosition(this.imp.getChannel(), this.imp.getSlice(), n6);
        } else {
            this.slice = IJ.altKeyDown() ? (this.slice += 10) : ++this.slice;
            if (this.slice > this.nSlices) {
                this.slice = this.nSlices;
            }
            this.swin.showSlice(this.slice);
        }
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void previousSlice() {
        if (!this.imp.lock()) {
            return;
        }
        boolean bl = this.imp.isDisplayedHyperStack();
        int n = this.imp.getNChannels();
        int n2 = this.imp.getNSlices();
        int n3 = this.imp.getNFrames();
        if (bl && n > 1 && (n2 <= 1 && n3 <= 1 || !IJ.controlKeyDown() && !IJ.spaceBarDown() && !IJ.altKeyDown())) {
            int n4 = this.imp.getChannel() - 1;
            if (n4 < 1) {
                n4 = 1;
            }
            this.swin.setPosition(n4, this.imp.getSlice(), this.imp.getFrame());
        } else if (bl && n2 > 1 && (n3 <= 1 || !IJ.altKeyDown())) {
            int n5 = this.imp.getSlice() - 1;
            if (n5 < 1) {
                n5 = 1;
            }
            this.swin.setPosition(this.imp.getChannel(), n5, this.imp.getFrame());
        } else if (bl && n3 > 1) {
            int n6 = this.imp.getFrame() - 1;
            if (n6 < 1) {
                n6 = 1;
            }
            this.swin.setPosition(this.imp.getChannel(), this.imp.getSlice(), n6);
        } else {
            this.slice = IJ.altKeyDown() ? (this.slice -= 10) : --this.slice;
            if (this.slice < 1) {
                this.slice = 1;
            }
            this.swin.showSlice(this.slice);
        }
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void setSlice() {
        GenericDialog genericDialog = new GenericDialog("Set Slice");
        genericDialog.addNumericField("Slice Number (1-" + this.nSlices + "):", this.slice, 0);
        genericDialog.showDialog();
        if (!genericDialog.wasCanceled()) {
            int n = (int)genericDialog.getNextNumber();
            if (this.imp.isDisplayedHyperStack()) {
                this.imp.setPosition(n);
            } else {
                this.imp.setSlice(n);
            }
        }
    }

    public static double getFrameRate() {
        return animationRate;
    }
}

