/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.EllipseRoi;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.gui.WaitForUserDialog;
import ij.gui.Wand;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.macro.ExtensionDescriptor;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroExtension;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Variable;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.ImageCalculator;
import ij.plugin.Macro_Runner;
import ij.plugin.Straightener;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Info;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Fitter;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.plugin.frame.ThresholdAdjuster;
import ij.process.AutoThresholder;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.FloodFiller;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.DicomTools;
import ij.util.StringSorter;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class Functions
implements MacroConstants,
Measurements {
    Interpreter interp;
    Program pgm;
    boolean updateNeeded;
    boolean autoUpdate = true;
    ImageProcessor defaultIP;
    int imageType;
    boolean colorSet;
    boolean fontSet;
    Color defaultColor;
    double defaultValue = Double.NaN;
    Plot plot;
    static int plotID;
    int justification = 0;
    Font font;
    GenericDialog gd;
    PrintWriter writer;
    boolean altKeyDown;
    boolean shiftKeyDown;
    boolean antialiasedText;
    StringBuffer buffer;
    RoiManager roiManager;
    Properties props;
    CurveFitter fitter;
    boolean showFitDialog;
    boolean logFitResults;
    boolean resultsPending;
    Overlay offscreenOverlay;
    Overlay overlayClipboard;
    GeneralPath overlayPath;
    boolean saveSettingsCalled;
    boolean usePointerCursor;
    boolean hideProcessStackDialog;
    float divideByZeroValue;
    int jpegQuality;
    int saveLineWidth;
    boolean doScaling;
    boolean weightedColor;
    double[] weights;
    boolean interpolateScaledImages;
    boolean open100Percent;
    boolean blackCanvas;
    boolean useJFileChooser;
    boolean debugMode;
    Color foregroundColor;
    Color backgroundColor;
    Color roiColor;
    boolean pointAutoMeasure;
    boolean requireControlKey;
    boolean useInvertingLut;
    boolean disablePopup;
    int measurements;
    int decimalPlaces;
    boolean blackBackground;
    static WaitForUserDialog waitForUserDialog;
    int pasteMode;
    int lineWidth = 1;
    Random ran;

    Functions(Interpreter interpreter, Program program) {
        this.interp = interpreter;
        this.pgm = program;
    }

    void doFunction(int n) {
        switch (n) {
            case 300: {
                this.doRun();
                break;
            }
            case 302: {
                IJ.selectWindow(this.getStringArg());
                this.resetImage();
                break;
            }
            case 303: {
                IJ.wait((int)this.getArg());
                break;
            }
            case 304: {
                this.interp.getParens();
                IJ.beep();
                break;
            }
            case 305: {
                this.interp.getParens();
                IJ.resetMinAndMax();
                this.resetImage();
                break;
            }
            case 306: {
                this.interp.getParens();
                IJ.resetThreshold();
                this.resetImage();
                break;
            }
            case 307: 
            case 308: {
                this.print();
                break;
            }
            case 309: {
                this.doWand();
                break;
            }
            case 310: {
                this.setMinAndMax();
                break;
            }
            case 311: {
                this.setThreshold();
                break;
            }
            case 312: {
                this.setTool();
                break;
            }
            case 313: {
                this.setForegroundColor();
                break;
            }
            case 314: {
                this.setBackgroundColor();
                break;
            }
            case 336: {
                this.setColor();
                break;
            }
            case 315: {
                this.makeLine();
                break;
            }
            case 316: {
                this.makeOval();
                break;
            }
            case 317: {
                this.makeRectangle();
                break;
            }
            case 318: {
                this.interp.dump();
                break;
            }
            case 320: {
                this.lineTo();
                break;
            }
            case 319: {
                this.moveTo();
                break;
            }
            case 321: {
                this.drawLine();
                break;
            }
            case 322: {
                this.requires();
                break;
            }
            case 323: {
                this.autoUpdate = this.getBooleanArg();
                break;
            }
            case 324: {
                this.interp.getParens();
                this.updateDisplay();
                break;
            }
            case 325: {
                this.drawString();
                break;
            }
            case 326: {
                IJ.setPasteMode(this.getStringArg());
                break;
            }
            case 327: {
                this.doCommand();
                break;
            }
            case 328: {
                IJ.showStatus(this.getStringArg());
                this.interp.statusUpdated = true;
                break;
            }
            case 329: {
                this.showProgress();
                break;
            }
            case 330: {
                this.showMessage(false);
                break;
            }
            case 351: {
                this.showMessage(true);
                break;
            }
            case 331: 
            case 332: {
                this.setPixel();
                break;
            }
            case 333: 
            case 334: 
            case 335: {
                this.doIPMethod(n);
                break;
            }
            case 337: {
                this.setLineWidth((int)this.getArg());
                break;
            }
            case 338: {
                this.changeValues();
                break;
            }
            case 339: {
                this.selectImage();
                break;
            }
            case 340: {
                this.exit();
                break;
            }
            case 341: {
                this.setLocation();
                break;
            }
            case 342: {
                this.getCursorLoc();
                break;
            }
            case 343: {
                this.getLine();
                break;
            }
            case 344: {
                this.getVoxelSize();
                break;
            }
            case 345: {
                this.getHistogram();
                break;
            }
            case 347: 
            case 375: {
                this.getBounds();
                break;
            }
            case 348: {
                this.getLut();
                break;
            }
            case 349: {
                this.setLut();
                break;
            }
            case 350: {
                this.getCoordinates();
                break;
            }
            case 352: {
                this.makeSelection();
                break;
            }
            case 353: {
                this.setResult();
                break;
            }
            case 354: {
                this.updateResults();
                break;
            }
            case 355: {
                this.setBatchMode();
                break;
            }
            case 356: {
                this.doPlot();
                break;
            }
            case 357: {
                this.setJustification();
                break;
            }
            case 358: {
                this.setZCoordinate();
                break;
            }
            case 359: {
                this.getThreshold();
                break;
            }
            case 360: {
                this.getPixelSize();
                break;
            }
            case 361: {
                this.interp.getParens();
                Undo.setup(6, this.getImage());
                break;
            }
            case 362: {
                this.saveSettings();
                break;
            }
            case 363: {
                this.restoreSettings();
                break;
            }
            case 364: {
                this.setKeyDown();
                break;
            }
            case 365: {
                this.open();
                break;
            }
            case 366: {
                this.setFont();
                break;
            }
            case 367: {
                this.getMinAndMax();
                break;
            }
            case 368: {
                this.close();
                break;
            }
            case 369: {
                this.setSlice();
                break;
            }
            case 370: {
                this.newImage();
                break;
            }
            case 372: {
                IJ.save(this.getStringArg());
                break;
            }
            case 371: {
                this.saveAs();
                break;
            }
            case 373: {
                this.setAutoThreshold();
                break;
            }
            case 374: {
                this.getImage().setTitle(this.getStringArg());
                break;
            }
            case 346: {
                this.getStatistics(true);
                break;
            }
            case 377: {
                this.getStatistics(false);
                break;
            }
            case 378: {
                this.floodFill();
                break;
            }
            case 379: {
                this.restorePreviousTool();
                break;
            }
            case 380: {
                this.setVoxelSize();
                break;
            }
            case 381: {
                this.getLocationAndSize();
                break;
            }
            case 382: {
                this.getDateAndTime();
                break;
            }
            case 383: {
                this.setMetadata();
                break;
            }
            case 384: {
                this.imageCalculator();
                break;
            }
            case 385: {
                this.setRGBWeights();
                break;
            }
            case 386: {
                this.makePolygon();
                break;
            }
            case 387: {
                this.setSelectionName();
                break;
            }
            case 376: 
            case 388: 
            case 389: 
            case 390: {
                this.drawOrFill(n);
                break;
            }
            case 391: {
                this.setOption();
                break;
            }
            case 392: {
                this.showText();
                break;
            }
            case 393: {
                this.setSelectionLocation();
                break;
            }
            case 394: {
                this.getDimensions();
                break;
            }
            case 395: {
                this.waitForUser();
                break;
            }
            case 396: {
                this.makePoint();
                break;
            }
            case 397: {
                this.makeText();
                break;
            }
            case 398: {
                this.makeEllipse();
                break;
            }
            case 399: {
                this.getDisplayedArea();
                break;
            }
            case 400: {
                this.toScaled();
                break;
            }
            case 401: {
                this.toUnscaled();
            }
        }
    }

    final double getFunctionValue(int n) {
        double d = 0.0;
        switch (n) {
            case 1000: {
                d = this.getPixel();
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1027: 
            case 1046: 
            case 1047: {
                d = this.math(n);
                break;
            }
            case 1006: 
            case 1007: 
            case 1008: 
            case 1036: {
                d = this.math2(n);
                break;
            }
            case 1013: {
                this.interp.getParens();
                d = System.currentTimeMillis();
                break;
            }
            case 1014: {
                this.interp.getParens();
                d = this.getImage().getWidth();
                break;
            }
            case 1015: {
                this.interp.getParens();
                d = this.getImage().getHeight();
                break;
            }
            case 1016: {
                d = this.random();
                break;
            }
            case 1018: 
            case 1023: {
                d = this.getResultsCount();
                break;
            }
            case 1017: {
                d = this.getResult();
                break;
            }
            case 1019: {
                d = this.getNumber();
                break;
            }
            case 1020: {
                d = this.getImageCount();
                break;
            }
            case 1021: {
                d = this.getStackSize();
                break;
            }
            case 1022: {
                d = this.lengthOf();
                break;
            }
            case 1024: {
                this.interp.getParens();
                d = this.getImage().getID();
                break;
            }
            case 1025: {
                this.interp.getParens();
                d = this.getImage().getBitDepth();
                break;
            }
            case 1026: {
                d = this.getSelectionType();
                break;
            }
            case 1028: {
                d = this.isOpen();
                break;
            }
            case 1029: {
                d = this.isActive();
                break;
            }
            case 1030: {
                d = this.indexOf();
                break;
            }
            case 1031: {
                d = this.getFirstString().lastIndexOf(this.getLastString());
                break;
            }
            case 1032: {
                d = this.charCodeAt();
                break;
            }
            case 1033: {
                d = this.getBoolean();
                break;
            }
            case 1034: 
            case 1035: {
                d = this.startsWithEndsWith(n);
                break;
            }
            case 1037: {
                d = Double.isNaN(this.getArg()) ? 1.0 : 0.0;
                break;
            }
            case 1038: {
                d = this.getZoom();
                break;
            }
            case 1040: {
                d = this.parseDouble(this.getStringArg());
                break;
            }
            case 1039: {
                d = this.parseInt();
                break;
            }
            case 1041: {
                d = this.isKeyDown();
                break;
            }
            case 1042: {
                this.interp.getParens();
                d = this.getImage().getCurrentSlice();
                break;
            }
            case 1043: 
            case 1044: {
                d = this.getScreenDimension(n);
                break;
            }
            case 1045: {
                d = this.getImage().getCalibration().getCValue(this.getArg());
                break;
            }
            case 1048: {
                d = this.roiManager();
                break;
            }
            case 1049: {
                this.interp.getParens();
                d = Toolbar.getToolId();
                break;
            }
            case 1050: {
                d = this.is();
                break;
            }
            case 1051: {
                d = this.getValue();
                break;
            }
            case 1052: {
                d = this.doStack();
                break;
            }
            case 1053: {
                d = this.matches();
                break;
            }
            case 1054: {
                d = this.getStringWidth();
                break;
            }
            case 1055: {
                d = this.fit();
                break;
            }
            case 1056: {
                d = this.overlay();
                break;
            }
            case 1057: {
                d = this.selectionContains();
                break;
            }
            default: {
                this.interp.error("Numeric function expected");
            }
        }
        return d;
    }

    String getStringFunction(int n) {
        String string;
        switch (n) {
            case 2000: {
                string = this.d2s();
                break;
            }
            case 2001: {
                string = this.toString(16);
                break;
            }
            case 2002: {
                string = this.toString(2);
                break;
            }
            case 2003: {
                this.interp.getParens();
                string = this.getImage().getTitle();
                break;
            }
            case 2004: {
                string = this.getStringDialog();
                break;
            }
            case 2005: {
                string = this.substring();
                break;
            }
            case 2006: {
                string = this.fromCharCode();
                break;
            }
            case 2007: {
                string = this.getInfo();
                break;
            }
            case 2010: {
                this.interp.getParens();
                string = this.getImageInfo();
                break;
            }
            case 2008: {
                string = this.getDirectory();
                break;
            }
            case 2009: {
                this.interp.getParens();
                string = this.interp.argument != null ? this.interp.argument : "";
                break;
            }
            case 2011: {
                string = this.getStringArg().toLowerCase(Locale.US);
                break;
            }
            case 2012: {
                string = this.getStringArg().toUpperCase(Locale.US);
                break;
            }
            case 2013: {
                string = this.runMacro(false);
                break;
            }
            case 2014: {
                string = this.runMacro(true);
                break;
            }
            case 2015: {
                string = this.doToString();
                break;
            }
            case 2016: {
                string = this.replace();
                break;
            }
            case 2017: {
                string = this.doDialog();
                break;
            }
            case 2018: {
                string = this.getMetadata();
                break;
            }
            case 2019: {
                string = this.doFile();
                break;
            }
            case 2020: {
                string = this.selectionName();
                break;
            }
            case 2021: {
                this.interp.getParens();
                string = IJ.getVersion();
                break;
            }
            case 2022: {
                string = this.getResultLabel();
                break;
            }
            case 2023: {
                string = this.call();
                break;
            }
            case 2024: {
                string = this.doString();
                break;
            }
            case 2025: {
                string = this.doExt();
                break;
            }
            case 2026: {
                string = this.exec();
                break;
            }
            case 2027: {
                string = this.doList();
                break;
            }
            case 2028: {
                string = this.debug();
                break;
            }
            case 2029: {
                string = this.ijCall();
                break;
            }
            default: {
                string = "";
                this.interp.error("String function expected");
            }
        }
        return string;
    }

    private void setLineWidth(int n) {
        this.lineWidth = n;
        this.getProcessor().setLineWidth(n);
    }

    Variable[] getArrayFunction(int n) {
        Variable[] variableArray;
        switch (n) {
            case 3000: {
                variableArray = this.getProfile();
                break;
            }
            case 3001: {
                variableArray = this.newArray();
                break;
            }
            case 3002: {
                variableArray = this.split();
                break;
            }
            case 3003: {
                variableArray = this.getFileList();
                break;
            }
            case 3004: {
                variableArray = this.getFontList();
                break;
            }
            case 3005: {
                variableArray = this.newMenu();
                break;
            }
            case 3006: {
                variableArray = this.getList();
                break;
            }
            case 3007: {
                variableArray = this.doArray();
                break;
            }
            default: {
                variableArray = null;
                this.interp.error("Array function expected");
            }
        }
        return variableArray;
    }

    final double math(int n) {
        double d = this.getArg();
        switch (n) {
            case 1001: {
                return Math.abs(d);
            }
            case 1002: {
                return Math.cos(d);
            }
            case 1003: {
                return Math.exp(d);
            }
            case 1004: {
                return Math.floor(d);
            }
            case 1005: {
                return Math.log(d);
            }
            case 1009: {
                return Math.floor(d + 0.5);
            }
            case 1010: {
                return Math.sin(d);
            }
            case 1011: {
                return Math.sqrt(d);
            }
            case 1012: {
                return Math.tan(d);
            }
            case 1027: {
                return Math.atan(d);
            }
            case 1046: {
                return Math.asin(d);
            }
            case 1047: {
                return Math.acos(d);
            }
        }
        return 0.0;
    }

    final double math2(int n) {
        double d = this.getFirstArg();
        double d2 = this.getLastArg();
        switch (n) {
            case 1007: {
                return Math.min(d, d2);
            }
            case 1006: {
                return Math.max(d, d2);
            }
            case 1008: {
                return Math.pow(d, d2);
            }
            case 1036: {
                return Math.atan2(d, d2);
            }
        }
        return 0.0;
    }

    final String getString() {
        String string = this.interp.getStringTerm();
        while (true) {
            this.interp.getToken();
            if (this.interp.token != 43) break;
            string = string + this.interp.getStringTerm();
        }
        this.interp.putTokenBack();
        return string;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.interp.tokenAddress];
        return symbol.type == 2000;
    }

    final double getArg() {
        this.interp.getLeftParen();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        return d;
    }

    final double getFirstArg() {
        this.interp.getLeftParen();
        return this.interp.getExpression();
    }

    final double getNextArg() {
        this.interp.getComma();
        return this.interp.getExpression();
    }

    final double getLastArg() {
        this.interp.getComma();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        return d;
    }

    String getStringArg() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getRightParen();
        return string;
    }

    final String getFirstString() {
        this.interp.getLeftParen();
        return this.getString();
    }

    final String getNextString() {
        this.interp.getComma();
        return this.getString();
    }

    final String getLastString() {
        this.interp.getComma();
        String string = this.getString();
        this.interp.getRightParen();
        return string;
    }

    boolean getBooleanArg() {
        this.interp.getLeftParen();
        double d = this.interp.getBooleanExpression();
        this.interp.checkBoolean(d);
        this.interp.getRightParen();
        return d != 0.0;
    }

    final Variable getVariableArg() {
        this.interp.getLeftParen();
        Variable variable = this.getVariable();
        this.interp.getRightParen();
        return variable;
    }

    final Variable getFirstVariable() {
        this.interp.getLeftParen();
        return this.getVariable();
    }

    final Variable getNextVariable() {
        this.interp.getComma();
        return this.getVariable();
    }

    final Variable getLastVariable() {
        this.interp.getComma();
        Variable variable = this.getVariable();
        this.interp.getRightParen();
        return variable;
    }

    final Variable getVariable() {
        Variable[] variableArray;
        Variable variable;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((variable = this.interp.lookupLocalVariable(this.interp.tokenAddress)) == null) {
            variable = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        if ((variableArray = variable.getArray()) != null) {
            int n = this.interp.getIndex();
            this.checkIndex(n, 0, variableArray.length - 1);
            variable = variableArray[n];
        }
        return variable;
    }

    final Variable getFirstArrayVariable() {
        this.interp.getLeftParen();
        return this.getArrayVariable();
    }

    final Variable getNextArrayVariable() {
        this.interp.getComma();
        return this.getArrayVariable();
    }

    final Variable getLastArrayVariable() {
        this.interp.getComma();
        Variable variable = this.getArrayVariable();
        this.interp.getRightParen();
        return variable;
    }

    final Variable getArrayVariable() {
        Variable variable;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((variable = this.interp.lookupLocalVariable(this.interp.tokenAddress)) == null) {
            variable = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        return variable;
    }

    final double[] getFirstArray() {
        this.interp.getLeftParen();
        return this.getNumericArray();
    }

    final double[] getNextArray() {
        this.interp.getComma();
        return this.getNumericArray();
    }

    final double[] getLastArray() {
        this.interp.getComma();
        double[] dArray = this.getNumericArray();
        this.interp.getRightParen();
        return dArray;
    }

    double[] getNumericArray() {
        Variable[] variableArray = this.getArray();
        double[] dArray = new double[variableArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            dArray[i] = variableArray[i].getValue();
        }
        return dArray;
    }

    String[] getStringArray() {
        Variable[] variableArray = this.getArray();
        String[] stringArray = new String[variableArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            String string = variableArray[i].getString();
            if (string == null) {
                string = "" + variableArray[i].getValue();
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    Variable[] getArray() {
        Variable[] variableArray;
        boolean bl;
        this.interp.getToken();
        boolean bl2 = bl = this.interp.token == 137 && this.pgm.table[this.interp.tokenAddress].type == 3001;
        if (this.interp.token != 129 && !bl) {
            this.interp.error("Array expected");
        }
        if (bl) {
            variableArray = this.getArrayFunction(3001);
        } else {
            Variable variable = this.interp.lookupVariable();
            variableArray = variable.getArray();
        }
        if (variableArray == null) {
            this.interp.error("Array expected");
        }
        return variableArray;
    }

    Color getColor() {
        String string = this.getString();
        if ((string = string.toLowerCase(Locale.US)).equals("black")) {
            return Color.black;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("darkgray")) {
            return Color.darkGray;
        }
        if (string.equals("gray")) {
            return Color.gray;
        }
        if (string.equals("lightgray")) {
            return Color.lightGray;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("orange")) {
            return Color.orange;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        this.interp.error("'red', 'green', etc. expected");
        return null;
    }

    void checkIndex(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            this.interp.error("Index (" + n + ") is outside of the " + n2 + "-" + n3 + " range");
        }
    }

    void doRun() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getToken();
        if (this.interp.token != 41 && this.interp.token != 44) {
            this.interp.error("',' or ')'  expected");
        }
        String string2 = null;
        if (this.interp.token == 44) {
            string2 = this.getString();
            this.interp.getRightParen();
        }
        if (string2 != null) {
            IJ.run(string, string2);
        } else {
            IJ.run(string);
        }
        this.resetImage();
        IJ.setKeyUp(-1);
        this.altKeyDown = false;
        this.shiftKeyDown = false;
    }

    void setForegroundColor() {
        boolean bl = WindowManager.getCurrentImage() != null;
        int n = 0;
        if (bl) {
            n = this.getProcessor().getLineWidth();
        }
        IJ.setForegroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
        if (bl) {
            this.setLineWidth(n);
        }
        this.defaultColor = null;
        this.defaultValue = Double.NaN;
    }

    void setBackgroundColor() {
        IJ.setBackgroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setColor() {
        this.colorSet = true;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            this.defaultColor = this.getColor();
            this.getProcessor().setColor(this.defaultColor);
            this.defaultValue = Double.NaN;
            this.interp.getRightParen();
            return;
        }
        double d = this.interp.getExpression();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            this.setColor(d);
            return;
        }
        int n = (int)d;
        int n2 = (int)this.getNextArg();
        int n3 = (int)this.getLastArg();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        this.defaultColor = new Color(n, n2, n3);
        this.getProcessor().setColor(this.defaultColor);
        this.defaultValue = Double.NaN;
    }

    void setColor(double d) {
        ImageProcessor imageProcessor = this.getProcessor();
        ImagePlus imagePlus = this.getImage();
        switch (imagePlus.getBitDepth()) {
            case 8: {
                if (d < 0.0 || d > 255.0) {
                    this.interp.error("Argument out of 8-bit range (0-255)");
                }
                imageProcessor.setValue(d);
                break;
            }
            case 16: {
                if (imagePlus.getLocalCalibration().isSigned16Bit()) {
                    d += 32768.0;
                }
                if (d < 0.0 || d > 65535.0) {
                    this.interp.error("Argument out of 16-bit range (0-65535)");
                }
                imageProcessor.setValue(d);
                break;
            }
            default: {
                imageProcessor.setValue(d);
            }
        }
        this.defaultValue = d;
        this.defaultColor = null;
    }

    void makeLine() {
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        double d3 = this.getNextArg();
        this.interp.getComma();
        double d4 = this.interp.getExpression();
        this.interp.getToken();
        if (this.interp.token == 41) {
            IJ.makeLine(d, d2, d3, d4);
        } else {
            int n;
            int n2 = (int)Math.round(d);
            int n3 = (int)Math.round(d2);
            int n4 = (int)Math.round(d3);
            int n5 = (int)Math.round(d4);
            int n6 = 200;
            int[] nArray = new int[n6];
            int[] nArray2 = new int[n6];
            nArray[0] = n2;
            nArray2[0] = n3;
            nArray[1] = n4;
            nArray2[1] = n5;
            for (n = 2; this.interp.token == 44 && n < n6; ++n) {
                nArray[n] = (int)Math.round(this.interp.getExpression());
                if (n == 2 && this.interp.nextToken() == 41) {
                    this.interp.getRightParen();
                    Line line = new Line(n2, n3, n4, n5);
                    line.updateWideLine(nArray[n]);
                    this.getImage().setRoi(line);
                    return;
                }
                this.interp.getComma();
                nArray2[n] = (int)Math.round(this.interp.getExpression());
                this.interp.getToken();
            }
            if (n == n6 && this.interp.token != 41) {
                this.interp.error("More than " + n6 + " points");
            }
            this.getImage().setRoi(new PolygonRoi(nArray, nArray2, n, 6));
        }
        this.resetImage();
    }

    void makeOval() {
        Roi roi = this.getImage().getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            this.getImage().saveRoi();
        }
        IJ.makeOval((int)Math.round(this.getFirstArg()), (int)Math.round(this.getNextArg()), (int)Math.round(this.getNextArg()), (int)Math.round(this.getLastArg()));
        Roi roi2 = this.getImage().getRoi();
        if (roi != null && roi2 != null) {
            this.updateRoi(roi2);
        }
        this.resetImage();
    }

    void makeRectangle() {
        Cloneable cloneable;
        Roi roi = this.getImage().getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            this.getImage().saveRoi();
        }
        int n = (int)Math.round(this.getFirstArg());
        int n2 = (int)Math.round(this.getNextArg());
        int n3 = (int)Math.round(this.getNextArg());
        int n4 = (int)Math.round(this.getNextArg());
        int n5 = 0;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            n5 = (int)this.interp.getExpression();
        }
        this.interp.getRightParen();
        if (n5 < 1) {
            IJ.makeRectangle(n, n2, n3, n4);
        } else {
            cloneable = this.getImage();
            cloneable.setRoi(new Roi(n, n2, n3, n4, n5));
        }
        cloneable = this.getImage().getRoi();
        if (roi != null && cloneable != null) {
            this.updateRoi((Roi)cloneable);
        }
        this.resetImage();
    }

    ImagePlus getImage() {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus.getWindow() == null && IJ.getInstance() != null) {
            Functions functions = this;
            if (!functions.interp.isBatchMode() && WindowManager.getTempCurrentImage() == null) {
                throw new RuntimeException("Macro canceled");
            }
        }
        this.defaultIP = null;
        return imagePlus;
    }

    void resetImage() {
        this.defaultIP = null;
        this.fontSet = false;
        this.colorSet = false;
        this.lineWidth = 1;
    }

    ImageProcessor getProcessor() {
        if (this.defaultIP == null) {
            this.defaultIP = this.getImage().getProcessor();
            if (this.lineWidth != 1) {
                this.defaultIP.setLineWidth(this.lineWidth);
            }
        }
        return this.defaultIP;
    }

    int getType() {
        this.imageType = this.getImage().getType();
        return this.imageType;
    }

    void setPixel() {
        this.interp.getLeftParen();
        int n = (int)this.interp.getExpression();
        this.interp.getComma();
        double d = this.interp.getExpression();
        this.interp.getToken();
        if (this.interp.token == 44) {
            double d2 = this.interp.getExpression();
            this.interp.getRightParen();
            if (this.getType() == 2) {
                this.getProcessor().putPixelValue(n, (int)d, d2);
            } else {
                this.getProcessor().putPixel(n, (int)d, (int)d2);
            }
        } else {
            if (this.interp.token != 41) {
                this.interp.error("')' expected");
            }
            this.getProcessor().setf(n, (float)d);
        }
        this.updateNeeded = true;
    }

    double getPixel() {
        this.interp.getLeftParen();
        double d = this.interp.getExpression();
        ImageProcessor imageProcessor = this.getProcessor();
        double d2 = 0.0;
        this.interp.getToken();
        if (this.interp.token == 44) {
            double d3 = this.interp.getExpression();
            this.interp.getRightParen();
            int n = (int)d;
            int n2 = (int)d3;
            d2 = d == (double)n && d3 == (double)n2 ? (this.getType() == 2 ? (double)imageProcessor.getPixelValue(n, n2) : (double)imageProcessor.getPixel(n, n2)) : (this.getType() == 4 ? (double)imageProcessor.getPixelInterpolated(d, d3) : imageProcessor.getInterpolatedValue(d, d3));
        } else {
            if (this.interp.token != 41) {
                this.interp.error("')' expected");
            }
            d2 = imageProcessor.getf((int)d);
        }
        return d2;
    }

    void setZCoordinate() {
        int n = (int)this.getArg();
        ImagePlus imagePlus = this.getImage();
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imageStack.getSize();
        if (n < 0 || n >= n2) {
            this.interp.error("Z coordinate (" + n + ") is out of 0-" + (n2 - 1) + " range");
        }
        this.defaultIP = imageStack.getProcessor(n + 1);
    }

    void moveTo() {
        this.interp.getLeftParen();
        int n = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int n2 = (int)Math.round(this.interp.getExpression());
        this.interp.getRightParen();
        this.getProcessor().moveTo(n, n2);
    }

    void lineTo() {
        this.interp.getLeftParen();
        int n = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int n2 = (int)Math.round(this.interp.getExpression());
        this.interp.getRightParen();
        ImageProcessor imageProcessor = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(imageProcessor);
        }
        imageProcessor.lineTo(n, n2);
        this.updateAndDraw();
    }

    void drawLine() {
        this.interp.getLeftParen();
        int n = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int n2 = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int n3 = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int n4 = (int)Math.round(this.interp.getExpression());
        this.interp.getRightParen();
        ImageProcessor imageProcessor = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(imageProcessor);
        }
        imageProcessor.drawLine(n, n2, n3, n4);
        this.updateAndDraw();
    }

    void setForegroundColor(ImageProcessor imageProcessor) {
        if (this.defaultColor != null) {
            imageProcessor.setColor(this.defaultColor);
        } else if (!Double.isNaN(this.defaultValue)) {
            imageProcessor.setValue(this.defaultValue);
        } else {
            imageProcessor.setColor(Toolbar.getForegroundColor());
        }
        this.colorSet = true;
    }

    void doIPMethod(int n) {
        this.interp.getParens();
        ImageProcessor imageProcessor = this.getProcessor();
        switch (n) {
            case 333: {
                imageProcessor.snapshot();
                break;
            }
            case 334: {
                imageProcessor.reset();
                this.updateNeeded = true;
                break;
            }
            case 335: {
                ImagePlus imagePlus = this.getImage();
                Roi roi = imagePlus.getRoi();
                if (!this.colorSet) {
                    this.setForegroundColor(imageProcessor);
                }
                if (roi == null) {
                    imageProcessor.resetRoi();
                    imageProcessor.fill();
                } else {
                    imageProcessor.setRoi(roi);
                    imageProcessor.fill(imageProcessor.getMask());
                }
                imagePlus.updateAndDraw();
            }
        }
    }

    void updateAndDraw() {
        if (this.autoUpdate) {
            ImagePlus imagePlus = this.getImage();
            imagePlus.updateChannelAndDraw();
            imagePlus.changes = true;
        } else {
            this.updateNeeded = true;
        }
    }

    void updateDisplay() {
        if (this.updateNeeded && WindowManager.getImageCount() > 0) {
            ImagePlus imagePlus = this.getImage();
            imagePlus.updateAndDraw();
            this.updateNeeded = false;
        }
    }

    void drawString() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        Color color = null;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            color = this.getColor();
        }
        this.interp.getRightParen();
        ImageProcessor imageProcessor = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(imageProcessor);
        }
        this.setFont(imageProcessor);
        imageProcessor.setJustification(this.justification);
        imageProcessor.setAntialiasedText(this.antialiasedText);
        if (color != null) {
            imageProcessor.drawString(string, n, n2, color);
        } else {
            imageProcessor.drawString(string, n, n2);
        }
        this.updateAndDraw();
    }

    void setFont(ImageProcessor imageProcessor) {
        if (this.font != null && !this.fontSet) {
            imageProcessor.setFont(this.font);
        }
        this.fontSet = true;
    }

    void setJustification() {
        String string = this.getStringArg().toLowerCase(Locale.US);
        int n = 0;
        if (string.equals("center")) {
            n = 1;
        } else if (string.equals("right")) {
            n = 2;
        }
        this.justification = n;
    }

    void changeValues() {
        boolean bl;
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        double d3 = this.getLastArg();
        ImagePlus imagePlus = this.getImage();
        ImageProcessor imageProcessor = this.getProcessor();
        Roi roi = imagePlus.getRoi();
        ImageProcessor imageProcessor2 = null;
        if (roi == null || !roi.isArea()) {
            imageProcessor.resetRoi();
            roi = null;
        } else {
            imageProcessor.setRoi(roi);
            imageProcessor2 = imageProcessor.getMask();
            if (imageProcessor2 != null) {
                imageProcessor.snapshot();
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getHeight();
        if (roi != null) {
            Rectangle rectangle = roi.getBounds();
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.x + rectangle.width;
            n4 = rectangle.y + rectangle.height;
        }
        boolean bl2 = bl = this.getType() == 2;
        if (imagePlus.getBitDepth() == 24) {
            d = (int)d & 0xFFFFFF;
            d2 = (int)d2 & 0xFFFFFF;
        }
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                double d4;
                double d5 = d4 = bl ? (double)imageProcessor.getPixelValue(j, i) : (double)(imageProcessor.getPixel(j, i) & 0xFFFFFF);
                if (!(d4 >= d) || !(d4 <= d2)) continue;
                if (bl) {
                    imageProcessor.putPixelValue(j, i, d3);
                    continue;
                }
                imageProcessor.putPixel(j, i, (int)d3);
            }
        }
        if (imageProcessor2 != null) {
            imageProcessor.reset(imageProcessor2);
        }
        if (imagePlus.getType() == 1 || imagePlus.getType() == 2) {
            imageProcessor.resetMinAndMax();
        }
        imagePlus.updateAndDraw();
        this.updateNeeded = false;
    }

    void requires() {
        if (IJ.versionLessThan(this.getStringArg())) {
            this.interp.done = true;
        }
    }

    double random() {
        double d = Double.NaN;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.isStringArg()) {
                String string = this.getString().toLowerCase(Locale.US);
                if (string.indexOf("seed") == -1) {
                    this.interp.error("'seed' expected");
                }
                this.interp.getComma();
                d = this.interp.getExpression();
                long l = (long)d;
                if ((double)l != d) {
                    this.interp.error("Seed not integer");
                }
                this.ran = new Random(l);
            }
            this.interp.getRightParen();
            if (!Double.isNaN(d)) {
                return Double.NaN;
            }
        }
        this.interp.getParens();
        if (this.ran == null) {
            this.ran = new Random();
        }
        return this.ran.nextDouble();
    }

    double getResult() {
        int n;
        this.interp.getLeftParen();
        String string = this.getString();
        int n2 = -1;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            n2 = (int)this.interp.getExpression();
        }
        this.interp.getRightParen();
        ResultsTable resultsTable = Analyzer.getResultsTable();
        int n3 = resultsTable.getCounter();
        if (n3 == 0) {
            this.interp.error("\"Results\" table empty");
        }
        if (n2 == -1) {
            n2 = n3 - 1;
        }
        if (n2 < 0 || n2 >= n3) {
            this.interp.error("Row (" + n2 + ") out of range");
        }
        if (!resultsTable.columnExists(n = resultsTable.getColumnIndex(string))) {
            return Double.NaN;
        }
        return resultsTable.getValueAsDouble(n, n2);
    }

    String getResultLabel() {
        String string;
        int n = (int)this.getArg();
        ResultsTable resultsTable = Analyzer.getResultsTable();
        int n2 = resultsTable.getCounter();
        if (n2 == 0) {
            this.interp.error("\"Results\" table empty");
        }
        if (n < 0 || n >= n2) {
            this.interp.error("Row (" + n + ") out of range");
        }
        return (string = resultsTable.getLabel(n)) != null ? string : "";
    }

    void setResult() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        int n = (int)this.interp.getExpression();
        this.interp.getComma();
        double d = 0.0;
        String string2 = null;
        if (string.equals("Label")) {
            string2 = this.getString();
        } else {
            d = this.interp.getExpression();
        }
        this.interp.getRightParen();
        ResultsTable resultsTable = Analyzer.getResultsTable();
        if (n < 0 || n > resultsTable.getCounter()) {
            this.interp.error("Row (" + n + ") out of range");
        }
        if (n == resultsTable.getCounter()) {
            resultsTable.incrementCounter();
        }
        try {
            if (string2 != null) {
                resultsTable.setLabel(string2, n);
            } else {
                resultsTable.setValue(string, n, d);
            }
            this.resultsPending = true;
        }
        catch (Exception exception) {
            this.interp.error("" + exception.getMessage());
        }
    }

    void updateResults() {
        this.interp.getParens();
        ResultsTable resultsTable = Analyzer.getResultsTable();
        resultsTable.show("Results");
        this.resultsPending = false;
    }

    double getNumber() {
        String string;
        String string2 = this.getFirstString();
        double d = this.getLastArg();
        String string3 = string = this.interp.macroName != null ? this.interp.macroName : "";
        if (string.endsWith(" Options")) {
            string = string.substring(0, string.length() - 8);
        }
        GenericDialog genericDialog = new GenericDialog(string);
        int n = (double)((int)d) == d ? 0 : 2;
        genericDialog.addNumericField(string2, d, n);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.interp.done = true;
            return d;
        }
        double d2 = genericDialog.getNextNumber();
        if (genericDialog.invalidNumber()) {
            return d;
        }
        return d2;
    }

    double getBoolean() {
        YesNoCancelDialog yesNoCancelDialog;
        String string;
        String string2 = this.getStringArg();
        String string3 = string = this.interp.macroName != null ? this.interp.macroName : "";
        if (string.endsWith(" Options")) {
            string = string.substring(0, string.length() - 8);
        }
        if ((yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), string, string2)).cancelPressed()) {
            this.interp.done = true;
            return 0.0;
        }
        if (yesNoCancelDialog.yesPressed()) {
            return 1.0;
        }
        return 0.0;
    }

    double getBoolean2() {
        String string;
        String string2 = this.getFirstString();
        this.interp.getComma();
        double d = this.interp.getBooleanExpression();
        this.interp.checkBoolean(d);
        this.interp.getRightParen();
        String string3 = string = this.interp.macroName != null ? this.interp.macroName : "";
        if (string.endsWith(" Options")) {
            string = string.substring(0, string.length() - 8);
        }
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addCheckbox(string2, d == 1.0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.interp.done = true;
            return 0.0;
        }
        return genericDialog.getNextBoolean() ? 1.0 : 0.0;
    }

    String getStringDialog() {
        String string;
        this.interp.getLeftParen();
        String string2 = this.getString();
        this.interp.getComma();
        String string3 = this.getString();
        this.interp.getRightParen();
        String string4 = string = this.interp.macroName != null ? this.interp.macroName : "";
        if (string.endsWith(" Options")) {
            string = string.substring(0, string.length() - 8);
        }
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addStringField(string2, string3, 20);
        genericDialog.showDialog();
        String string5 = "";
        if (genericDialog.wasCanceled()) {
            this.interp.done = true;
        } else {
            string5 = genericDialog.getNextString();
        }
        return string5;
    }

    String d2s() {
        return IJ.d2s(this.getFirstArg(), (int)this.getLastArg());
    }

    String toString(int n) {
        int n2 = (int)this.getArg();
        if (n == 2) {
            return Integer.toBinaryString(n2);
        }
        return Integer.toHexString(n2);
    }

    double getStackSize() {
        this.interp.getParens();
        return this.getImage().getStackSize();
    }

    double getImageCount() {
        this.interp.getParens();
        return WindowManager.getImageCount();
    }

    double getResultsCount() {
        this.interp.getParens();
        return Analyzer.getResultsTable().getCounter();
    }

    void getCoordinates() {
        Variable[] variableArray;
        Variable[] variableArray2;
        Variable variable = this.getFirstArrayVariable();
        Variable variable2 = this.getLastArrayVariable();
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        if (roi.getType() == 5) {
            variableArray2 = new Variable[2];
            variableArray = new Variable[2];
            Line line = (Line)roi;
            variableArray2[0] = new Variable(line.x1d);
            variableArray[0] = new Variable(line.y1d);
            variableArray2[1] = new Variable(line.x2d);
            variableArray[1] = new Variable(line.y2d);
        } else {
            FloatPolygon floatPolygon = roi.getFloatPolygon();
            if (floatPolygon != null) {
                int n;
                variableArray2 = new Variable[floatPolygon.npoints];
                variableArray = new Variable[floatPolygon.npoints];
                for (n = 0; n < floatPolygon.npoints; ++n) {
                    variableArray2[n] = new Variable(floatPolygon.xpoints[n]);
                }
                for (n = 0; n < floatPolygon.npoints; ++n) {
                    variableArray[n] = new Variable(floatPolygon.ypoints[n]);
                }
            } else {
                int n;
                Polygon polygon = roi.getPolygon();
                variableArray2 = new Variable[polygon.npoints];
                variableArray = new Variable[polygon.npoints];
                for (n = 0; n < polygon.npoints; ++n) {
                    variableArray2[n] = new Variable(polygon.xpoints[n]);
                }
                for (n = 0; n < polygon.npoints; ++n) {
                    variableArray[n] = new Variable(polygon.ypoints[n]);
                }
            }
        }
        variable.setArray(variableArray2);
        variable2.setArray(variableArray);
    }

    Variable[] getProfile() {
        ProfilePlot profilePlot;
        double[] dArray;
        this.interp.getParens();
        ImagePlus imagePlus = this.getImage();
        if (imagePlus.getRoi() == null) {
            this.interp.error("Selection required");
        }
        if ((dArray = (profilePlot = new ProfilePlot(imagePlus, IJ.altKeyDown())).getProfile()) == null) {
            this.interp.done = true;
            return null;
        }
        return new Variable(dArray).getArray();
    }

    Variable[] newArray() {
        this.interp.getLeftParen();
        int n = this.interp.nextToken();
        if (n == 133 || this.interp.nextNextToken() == 44 || n == 45 || n == 211) {
            return this.initNewArray();
        }
        int n2 = (int)this.interp.getExpression();
        if (n2 < 0) {
            this.interp.error("Negative array size");
        }
        this.interp.getRightParen();
        Variable[] variableArray = new Variable[n2];
        for (int i = 0; i < n2; ++i) {
            variableArray[i] = new Variable();
        }
        return variableArray;
    }

    Variable[] split() {
        String string = this.getFirstString();
        String string2 = null;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
        } else {
            string2 = this.getLastString();
        }
        if (string == null) {
            return null;
        }
        String[] stringArray = string2 == null || string2.equals("") ? Tools.split(string) : Tools.split(string, string2);
        Variable[] variableArray = new Variable[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            variableArray[i] = new Variable(0, 0.0, stringArray[i]);
        }
        return variableArray;
    }

    Variable[] getFileList() {
        int n;
        Object[] objectArray;
        int n2;
        String string = this.getStringArg();
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return new Variable[0];
        }
        Object[] objectArray2 = file.list();
        if (objectArray2 == null) {
            return new Variable[0];
        }
        if (System.getProperty("os.name").indexOf("Linux") != -1) {
            StringSorter.sort((String[])objectArray2);
        }
        int n3 = 0;
        for (n2 = 0; n2 < objectArray2.length; ++n2) {
            if (objectArray2[n2].startsWith(".") || objectArray2[n2].equals("Thumbs.db")) {
                objectArray2[n2] = null;
                ++n3;
                continue;
            }
            File file2 = new File(string, objectArray2[n2]);
            if (!file2.isDirectory()) continue;
            objectArray2[n2] = (String)objectArray2[n2] + "/";
        }
        n2 = objectArray2.length - n3;
        if (n2 <= 0) {
            return new Variable[0];
        }
        if (n3 > 0) {
            objectArray = new String[n2];
            n = 0;
            for (int i = 0; i < objectArray2.length; ++i) {
                if (objectArray2[i] == null) continue;
                objectArray[n++] = objectArray2[i];
            }
            objectArray2 = objectArray;
        }
        objectArray = new Variable[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = new Variable(0, 0.0, (String)objectArray2[n]);
        }
        return objectArray;
    }

    Variable[] initNewArray() {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        boolean bl = false;
        do {
            objectArray = new Variable();
            int n2 = this.interp.nextToken();
            if (n2 == 133 || n2 == 136 || n2 == 129 && bl) {
                objectArray.setString(this.getString());
                bl = true;
            } else {
                objectArray.setValue(this.interp.getExpression());
            }
            vector.addElement(objectArray);
            ++n;
            this.interp.getToken();
        } while (this.interp.token == 44);
        if (this.interp.token != 41) {
            this.interp.error("';' expected");
        }
        objectArray = new Variable[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    String fromCharCode() {
        char[] cArray = new char[100];
        int n = 0;
        this.interp.getLeftParen();
        while (this.interp.nextToken() != 41) {
            int n2 = (int)this.interp.getExpression();
            if (n2 < 0 || n2 > 65535) {
                this.interp.error("Value (" + n2 + ") out of 0-65535 range");
            }
            cArray[n++] = (char)n2;
            if (this.interp.nextToken() != 44) continue;
            this.interp.getToken();
        }
        this.interp.getRightParen();
        return new String(cArray, 0, n);
    }

    String getInfo() {
        if (this.interp.nextNextToken() == 133 || this.interp.nextToken() == 40 && this.interp.nextNextToken() != 41) {
            return this.getInfo(this.getStringArg());
        }
        this.interp.getParens();
        return this.getWindowContents();
    }

    String getInfo(String string) {
        int n = string.length();
        if (n == 9 && string.charAt(4) == ',') {
            String string2 = DicomTools.getTag(this.getImage(), string);
            return string2 != null ? string2 : "";
        }
        if (string.equals("overlay")) {
            Overlay overlay = this.getImage().getOverlay();
            if (overlay == null) {
                return "";
            }
            return overlay.toString();
        }
        if (string.equals("log") || string.equals("Log")) {
            String string3 = IJ.getLog();
            return string3 != null ? string3 : "";
        }
        if (string.indexOf(".") == -1) {
            String string4 = this.getMetadataValue(string);
            if (string4 != null) {
                return string4;
            }
        } else {
            if (string.equals("micrometer.abbreviation")) {
                return "\u00b5m";
            }
            if (string.equals("image.subtitle")) {
                ImagePlus imagePlus = this.getImage();
                ImageWindow imageWindow = imagePlus.getWindow();
                return imageWindow != null ? imageWindow.createSubtitle() : "";
            }
            if (string.equals("slice.label")) {
                ImagePlus imagePlus = this.getImage();
                if (imagePlus.getStackSize() == 1) {
                    return "";
                }
                String string5 = imagePlus.getStack().getShortSliceLabel(imagePlus.getCurrentSlice());
                return string5 != null ? string5 : "";
            }
            if (string.equals("window.contents")) {
                return this.getWindowContents();
            }
            if (string.equals("image.description")) {
                String string6 = "";
                FileInfo fileInfo = this.getImage().getOriginalFileInfo();
                if (fileInfo != null) {
                    string6 = fileInfo.description;
                }
                if (string6 == null) {
                    string6 = "";
                }
                return string6;
            }
            if (string.equals("image.filename")) {
                String string7 = "";
                FileInfo fileInfo = this.getImage().getOriginalFileInfo();
                if (fileInfo != null && fileInfo.fileName != null) {
                    string7 = fileInfo.fileName;
                }
                return string7;
            }
            if (string.equals("image.directory")) {
                String string8 = "";
                FileInfo fileInfo = this.getImage().getOriginalFileInfo();
                if (fileInfo != null && fileInfo.directory != null) {
                    string8 = fileInfo.directory;
                }
                return string8;
            }
            if (string.equals("selection.name") || string.equals("roi.name")) {
                ImagePlus imagePlus = this.getImage();
                Roi roi = imagePlus.getRoi();
                String string9 = roi != null ? roi.getName() : null;
                return string9 != null ? string9 : "";
            }
            if (string.equals("font.name")) {
                this.resetImage();
                ImageProcessor imageProcessor = this.getProcessor();
                this.setFont(imageProcessor);
                return imageProcessor.getFont().getName();
            }
            if (string.equals("threshold.method")) {
                return ThresholdAdjuster.getMethod();
            }
            if (string.equals("threshold.mode")) {
                return ThresholdAdjuster.getMode();
            }
            String string10 = "";
            try {
                string10 = System.getProperty(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string10 != null ? string10 : "";
        }
        return "";
    }

    String getMetadataValue(String string) {
        String string2 = this.getMetadataAsString();
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(string + " =");
        if (n != -1) {
            n += string.length() + 2;
        } else {
            n = string2.indexOf(string + ":");
            if (n != -1) {
                n += string.length() + 1;
            } else {
                return null;
            }
        }
        int n2 = string2.indexOf("\n", n);
        if (n2 == -1) {
            return null;
        }
        String string3 = string2.substring(n + 1, n2);
        if (string3.startsWith(" ")) {
            string3 = string3.substring(1, string3.length());
        }
        return string3;
    }

    String getMetadataAsString() {
        ImageStack imageStack;
        String string;
        ImagePlus imagePlus = this.getImage();
        String string2 = null;
        if (imagePlus.getStackSize() > 1 && (string = (imageStack = imagePlus.getStack()).getSliceLabel(imagePlus.getCurrentSlice())) != null && string.indexOf(10) > 0) {
            string2 = string;
        }
        if (string2 == null) {
            string2 = (String)imagePlus.getProperty("Info");
        }
        return string2;
    }

    String getWindowContents() {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextPanel textPanel = ((TextWindow)frame).getTextPanel();
            return textPanel.getText();
        }
        if (frame != null && frame instanceof Editor) {
            return ((Editor)frame).getText();
        }
        if (frame != null && frame instanceof Recorder) {
            return ((Recorder)frame).getText();
        }
        return this.getImageInfo();
    }

    String getImageInfo() {
        ImagePlus imagePlus = this.getImage();
        Info info = new Info();
        return info.getImageInfo(imagePlus, this.getProcessor());
    }

    public String getDirectory() {
        String string = IJ.getDirectory(this.getStringArg());
        if (string == null) {
            string = "";
        }
        return string;
    }

    double getSelectionType() {
        this.interp.getParens();
        double d = -1.0;
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            d = roi.getType();
        }
        return d;
    }

    void showMessage(boolean bl) {
        String string;
        this.interp.getLeftParen();
        String string2 = this.getString();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            string = this.getString();
        } else {
            string = string2;
            string2 = "";
        }
        this.interp.getRightParen();
        if (bl) {
            IJ.showMessageWithCancel(string2, string);
        } else {
            IJ.showMessage(string2, string);
        }
    }

    double lengthOf() {
        int n = 0;
        this.interp.getLeftParen();
        switch (this.interp.nextToken()) {
            case 133: 
            case 136: 
            case 138: {
                n = this.getString().length();
                break;
            }
            case 129: {
                if (this.pgm.code[this.interp.pc + 2] == 91) {
                    n = this.getString().length();
                    break;
                }
                this.interp.getToken();
                Variable variable = this.interp.lookupVariable();
                if (variable == null) {
                    return 0.0;
                }
                String string = variable.getString();
                if (string != null) {
                    n = string.length();
                    break;
                }
                Variable[] variableArray = variable.getArray();
                if (variableArray != null) {
                    n = variableArray.length;
                    break;
                }
                this.interp.error("String or array expected");
                break;
            }
            default: {
                this.interp.error("String or array expected");
            }
        }
        this.interp.getRightParen();
        return n;
    }

    void getCursorLoc() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas == null) {
            return;
        }
        Point point = imageCanvas.getCursorLoc();
        variable.setValue(point.x);
        variable2.setValue(point.y);
        variable3.setValue(imagePlus.getCurrentSlice() - 1);
        Roi roi = imagePlus.getRoi();
        variable4.setValue(imageCanvas.getModifiers() + (roi != null && roi.contains(point.x, point.y) ? 32 : 0));
    }

    void getLine() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getNextVariable();
        Variable variable5 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.getType() == 5) {
            Line line = (Line)roi;
            d = line.x1d;
            d2 = line.y1d;
            d3 = line.x2d;
            d4 = line.y2d;
        }
        variable.setValue(d);
        variable2.setValue(d2);
        variable3.setValue(d3);
        variable4.setValue(d4);
        variable5.setValue(roi != null ? (double)roi.getStrokeWidth() : 1.0);
    }

    void getVoxelSize() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        Calibration calibration = imagePlus.getCalibration();
        variable.setValue(calibration.pixelWidth);
        variable2.setValue(calibration.pixelHeight);
        variable3.setValue(calibration.pixelDepth);
        variable4.setString(calibration.getUnits());
    }

    void getHistogram() {
        Variable[] variableArray;
        this.interp.getLeftParen();
        Variable variable = null;
        if (this.interp.nextToken() == 130) {
            this.interp.getExpression();
        } else {
            variable = this.getArrayVariable();
        }
        Variable variable2 = this.getNextArrayVariable();
        this.interp.getComma();
        int n = (int)this.interp.getExpression();
        ImagePlus imagePlus = this.getImage();
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        int n2 = imagePlus.getBitDepth();
        if (this.interp.nextToken() == 44) {
            d = this.getNextArg();
            d2 = this.getLastArg();
            if (n2 == 8 || n2 == 24) {
                this.interp.error("16 or 32-bit image required to set histMin and histMax");
            }
            bl = true;
        } else {
            this.interp.getRightParen();
        }
        if ((n2 == 8 || n2 == 24) && n != 256) {
            this.interp.error("Bin count (" + n + ") must be 256 for 8-bit and RGB images");
        }
        if (n == 65536 && n2 == 16) {
            Variable[] variableArray2 = variable2.getArray();
            int[] nArray = this.getProcessor().getHistogram();
            if (variableArray2 != null && variableArray2.length == n) {
                for (int i = 0; i < n; ++i) {
                    variableArray2[i].setValue(nArray[i]);
                }
            } else {
                variable2.setArray(new Variable(nArray).getArray());
            }
            return;
        }
        ImageStatistics imageStatistics = bl ? imagePlus.getStatistics(27, n, d, d2) : imagePlus.getStatistics(27, n);
        if (variable != null) {
            variableArray = imagePlus.getCalibration();
            double[] dArray = new double[n];
            double d3 = variableArray.getCValue(imageStatistics.histMin);
            double d4 = 1.0;
            if (n2 == 16 || n2 == 32 || variableArray.calibrated()) {
                d4 = (variableArray.getCValue(imageStatistics.histMax) - variableArray.getCValue(imageStatistics.histMin)) / (double)imageStatistics.nBins;
            }
            for (int i = 0; i < n; ++i) {
                dArray[i] = d3;
                d3 += d4;
            }
            variable.setArray(new Variable(dArray).getArray());
        }
        if ((variableArray = variable2.getArray()) != null && variableArray.length == n) {
            for (int i = 0; i < n; ++i) {
                variableArray[i].setValue(imageStatistics.histogram[i]);
            }
        } else {
            variable2.setArray(new Variable(imageStatistics.histogram).getArray());
        }
    }

    void getLut() {
        Variable variable = this.getFirstArrayVariable();
        Variable variable2 = this.getNextArrayVariable();
        Variable variable3 = this.getLastArrayVariable();
        ImagePlus imagePlus = this.getImage();
        IndexColorModel indexColorModel = null;
        if (imagePlus.isComposite()) {
            indexColorModel = ((CompositeImage)imagePlus).getChannelLut();
        } else {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (imageProcessor instanceof ColorProcessor) {
                this.interp.error("Non-RGB image expected");
            }
            indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        }
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        variable.setArray(new Variable(byArray).getArray());
        variable2.setArray(new Variable(byArray2).getArray());
        variable3.setArray(new Variable(byArray3).getArray());
    }

    void setLut() {
        ImagePlus imagePlus;
        double[] dArray = this.getFirstArray();
        double[] dArray2 = this.getNextArray();
        double[] dArray3 = this.getLastArray();
        int n = dArray.length;
        if (dArray2.length != n || dArray3.length != n) {
            this.interp.error("Arrays are not the same length");
        }
        if ((imagePlus = this.getImage()).getBitDepth() == 24) {
            this.interp.error("Non-RGB image expected");
        }
        ImageProcessor imageProcessor = this.getProcessor();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)dArray[i];
            byArray2[i] = (byte)dArray2[i];
            byArray3[i] = (byte)dArray3[i];
        }
        LUT lUT = new LUT(8, n, byArray, byArray2, byArray3);
        if (imagePlus.isComposite()) {
            ((CompositeImage)imagePlus).setChannelLut(lUT);
        } else {
            imageProcessor.setColorModel(lUT);
        }
        imagePlus.updateAndDraw();
        this.updateNeeded = false;
    }

    void getThreshold() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        ImageProcessor imageProcessor = this.getProcessor();
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        if (d == -808080.0) {
            d = -1.0;
            d2 = -1.0;
        } else {
            Calibration calibration = imagePlus.getCalibration();
            d = calibration.getCValue(d);
            d2 = calibration.getCValue(d2);
        }
        variable.setValue(d);
        variable2.setValue(d2);
    }

    void getPixelSize() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = null;
        if (this.interp.nextToken() == 44) {
            variable4 = this.getNextVariable();
        }
        this.interp.getRightParen();
        Calibration calibration = this.getImage().getCalibration();
        variable.setString(calibration.getUnits());
        variable2.setValue(calibration.pixelWidth);
        variable3.setValue(calibration.pixelHeight);
        if (variable4 != null) {
            variable4.setValue(calibration.pixelDepth);
        }
    }

    void makeSelection() {
        String string = null;
        int n = -1;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            string = this.getString().toLowerCase();
            n = 2;
            if (string.indexOf("free") != -1) {
                n = 3;
            }
            if (string.indexOf("traced") != -1) {
                n = 4;
            }
            if (string.indexOf("line") != -1) {
                n = string.indexOf("free") != -1 ? 7 : 6;
            }
            if (string.indexOf("angle") != -1) {
                n = 8;
            }
            if (string.indexOf("point") != -1) {
                n = 10;
            }
        } else {
            n = (int)this.interp.getExpression();
            if (n < 0 || n == 9) {
                this.interp.error("Invalid selection type (" + n + ")");
            }
            if (n == 0) {
                n = 2;
            }
            if (n == 1) {
                n = 3;
            }
        }
        double[] dArray = this.getNextArray();
        int n2 = dArray.length;
        this.interp.getComma();
        double[] dArray2 = this.getNumericArray();
        if (this.interp.nextToken() == 44) {
            n2 = (int)this.getLastArg();
            if (n2 > dArray.length || n2 > dArray2.length) {
                this.interp.error("Array too short");
            }
        } else {
            this.interp.getRightParen();
            if (dArray2.length != n2) {
                this.interp.error("Arrays are not the same length");
            }
        }
        ImagePlus imagePlus = this.getImage();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = imagePlus.getHeight();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (int)Math.round(dArray[i]);
            nArray2[i] = (int)Math.round(dArray2[i]);
        }
        Roi roi = null;
        if (n == 5) {
            if (nArray.length != 2) {
                this.interp.error("2 element arrays expected");
            }
            roi = new Line(nArray[0], nArray2[0], nArray[1], nArray2[1]);
        } else {
            roi = n == 10 ? new PointRoi(nArray, nArray2, n2) : new PolygonRoi(nArray, nArray2, n2, n);
        }
        Roi roi2 = imagePlus.getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            imagePlus.saveRoi();
        }
        imagePlus.setRoi(roi);
        if (n == 2 || n == 3) {
            roi = imagePlus.getRoi();
            if (roi2 != null && roi != null) {
                this.updateRoi(roi);
            }
        }
        this.updateNeeded = false;
    }

    void doPlot() {
        String string;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((string = this.interp.tokenString).equals("create")) {
            this.newPlot();
            return;
        }
        if (string.equals("getValues")) {
            this.getPlotValues();
            return;
        }
        if (this.plot == null) {
            this.interp.error("No plot defined");
        }
        if (string.equals("show")) {
            this.showPlot();
            return;
        }
        if (string.equals("update")) {
            this.updatePlot();
            return;
        }
        if (string.equals("setFrameSize")) {
            this.plot.setFrameSize((int)this.getFirstArg(), (int)this.getLastArg());
            return;
        }
        if (string.equals("setLimits")) {
            this.plot.setLimits(this.getFirstArg(), this.getNextArg(), this.getNextArg(), this.getLastArg());
            return;
        }
        if (string.equals("addText") || string.equals("drawLabel")) {
            this.addPlotText();
            return;
        }
        if (string.equals("drawLine")) {
            this.drawPlotLine();
            return;
        }
        if (string.equals("setColor")) {
            this.setPlotColor();
            return;
        }
        if (string.equals("add")) {
            String string2 = this.getFirstString();
            string2 = string2.toLowerCase(Locale.US);
            int n = 0;
            if (string2.indexOf("curve") != -1 || string2.indexOf("line") != -1) {
                n = 2;
            } else if (string2.indexOf("box") != -1) {
                n = 3;
            } else if (string2.indexOf("triangle") != -1) {
                n = 4;
            } else if (string2.indexOf("cross") != -1) {
                n = 5;
            } else if (string2.indexOf("dot") != -1) {
                n = 6;
            } else if (string2.indexOf("x") != -1) {
                n = 1;
            } else if (string2.indexOf("error") != -1) {
                n = -1;
            }
            this.addToPlot(n);
            return;
        }
        if (string.startsWith("setLineWidth")) {
            this.plot.setLineWidth((int)this.getArg());
            return;
        }
        if (string.startsWith("setJustification")) {
            this.doFunction(357);
            return;
        }
        this.interp.error("Unrecognized plot function");
    }

    void getPlotValues() {
        int n;
        Object[] objectArray;
        ImageWindow imageWindow;
        Variable variable = this.getFirstArrayVariable();
        Variable variable2 = this.getLastArrayVariable();
        float[] fArray = new float[]{};
        float[] fArray2 = new float[]{};
        ImagePlus imagePlus = this.getImage();
        ImageWindow imageWindow2 = imagePlus.getWindow();
        if (imagePlus.getProperty("XValues") != null) {
            fArray = (float[])imagePlus.getProperty("XValues");
            fArray2 = (float[])imagePlus.getProperty("YValues");
        } else if (imageWindow2 != null && imageWindow2 instanceof PlotWindow) {
            imageWindow = (PlotWindow)imageWindow2;
            fArray = ((PlotWindow)imageWindow).getXValues();
            fArray2 = ((PlotWindow)imageWindow).getYValues();
        } else if (imageWindow2 != null && imageWindow2 instanceof HistogramWindow) {
            imageWindow = (HistogramWindow)imageWindow2;
            objectArray = ((HistogramWindow)imageWindow).getXValues();
            fArray = new float[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                fArray[i] = (float)objectArray[i];
            }
            int[] nArray = ((HistogramWindow)imageWindow).getHistogram();
            fArray2 = new float[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                fArray2[i] = nArray[i];
            }
        } else {
            this.interp.error("No plot or histogram window");
        }
        imageWindow = new Variable[fArray.length];
        objectArray = new Variable[fArray2.length];
        for (n = 0; n < fArray.length; ++n) {
            imageWindow[n] = new Variable(fArray[n]);
        }
        for (n = 0; n < fArray2.length; ++n) {
            objectArray[n] = (double)new Variable(fArray2[n]);
        }
        variable.setArray((Variable[])imageWindow);
        variable2.setArray((Variable[])objectArray);
    }

    void newPlot() {
        double[] dArray;
        double[] dArray2;
        String string = this.getFirstString();
        String string2 = this.getNextString();
        String string3 = this.getNextString();
        if (this.interp.nextToken() == 41) {
            dArray2 = null;
            dArray = null;
        } else {
            dArray = this.getNextArray();
            if (this.interp.nextToken() == 41) {
                dArray2 = dArray;
                dArray = new double[dArray2.length];
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray[i] = i;
                }
            } else {
                dArray2 = this.getNextArray();
            }
        }
        this.interp.getRightParen();
        this.plot = new Plot(string, string2, string3, dArray, dArray2);
    }

    void showPlot() {
        PlotWindow plotWindow;
        if (this.plot != null && (plotWindow = this.plot.show()) != null) {
            plotID = plotWindow.getImagePlus().getID();
        }
        this.plot = null;
        this.interp.getParens();
    }

    void updatePlot() {
        if (this.plot != null) {
            ImageWindow imageWindow;
            ImagePlus imagePlus = WindowManager.getImage(plotID);
            ImageWindow imageWindow2 = imageWindow = imagePlus != null ? imagePlus.getWindow() : null;
            if (imageWindow != null) {
                ((PlotWindow)imageWindow).drawPlot(this.plot);
            } else {
                PlotWindow plotWindow = this.plot.show();
                if (plotWindow != null) {
                    plotID = plotWindow.getImagePlus().getID();
                }
            }
        }
        this.plot = null;
        this.interp.getParens();
    }

    void addPlotText() {
        String string = this.getFirstString();
        double d = this.getNextArg();
        double d2 = this.getLastArg();
        this.plot.setJustification(this.justification);
        this.plot.addLabel(d, d2, string);
    }

    void drawPlotLine() {
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        double d3 = this.getNextArg();
        double d4 = this.getLastArg();
        this.plot.drawLine(d, d2, d3, d4);
    }

    void setPlotColor() {
        this.interp.getLeftParen();
        this.plot.setColor(this.getColor());
        this.interp.getRightParen();
    }

    void addToPlot(int n) {
        double[] dArray;
        double[] dArray2 = this.getNextArray();
        if (this.interp.nextToken() == 41) {
            dArray = dArray2;
            dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = i;
            }
        } else {
            this.interp.getComma();
            dArray = this.getNumericArray();
        }
        this.interp.getRightParen();
        if (n == -1) {
            this.plot.addErrorBars(dArray);
        } else {
            this.plot.addPoints(dArray2, dArray, n);
        }
    }

    void getBounds() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            Rectangle rectangle = roi.getBounds();
            variable.setValue(rectangle.x);
            variable2.setValue(rectangle.y);
            variable3.setValue(rectangle.width);
            variable4.setValue(rectangle.height);
        } else {
            variable.setValue(0.0);
            variable2.setValue(0.0);
            variable3.setValue(imagePlus.getWidth());
            variable4.setValue(imagePlus.getHeight());
        }
    }

    String substring() {
        String string = this.getFirstString();
        int n = (int)this.getNextArg();
        int n2 = string.length();
        if (this.interp.nextToken() == 44) {
            n2 = (int)this.getLastArg();
        } else {
            this.interp.getRightParen();
        }
        if (n > n2) {
            this.interp.error("beginIndex>endIndex");
        }
        this.checkIndex(n, 0, string.length());
        this.checkIndex(n2, 0, string.length());
        return string.substring(n, n2);
    }

    int indexOf() {
        String string = this.getFirstString();
        String string2 = this.getNextString();
        int n = 0;
        if (this.interp.nextToken() == 44) {
            n = (int)this.getLastArg();
            this.checkIndex(n, 0, string.length() - 1);
        } else {
            this.interp.getRightParen();
        }
        if (n == 0) {
            return string.indexOf(string2);
        }
        return string.indexOf(string2, n);
    }

    int startsWithEndsWith(int n) {
        String string = this.getFirstString();
        String string2 = this.getLastString();
        if (n == 1034) {
            return string.startsWith(string2) ? 1 : 0;
        }
        return string.endsWith(string2) ? 1 : 0;
    }

    double isActive() {
        int n = (int)this.getArg();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getID() != n) {
            return 0.0;
        }
        return 1.0;
    }

    double isOpen() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            String string = this.getString();
            this.interp.getRightParen();
            return this.isOpen(string) ? 1.0 : 0.0;
        }
        int n = (int)this.interp.getExpression();
        this.interp.getRightParen();
        return WindowManager.getImage(n) == null ? 0.0 : 1.0;
    }

    boolean isOpen(String string) {
        boolean bl;
        boolean bl2 = bl = WindowManager.getFrame(string) != null;
        if (bl) {
            return true;
        }
        if (Interpreter.isBatchMode() && Interpreter.imageTable != null) {
            Enumeration enumeration = Interpreter.imageTable.elements();
            while (enumeration.hasMoreElements()) {
                ImagePlus imagePlus = (ImagePlus)enumeration.nextElement();
                if (imagePlus == null || !imagePlus.getTitle().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isStringArg() {
        int n = this.pgm.code[this.interp.pc + 1];
        int n2 = n & 0xFF;
        if (n2 == 133 || n2 == 136) {
            return true;
        }
        if (n2 != 129) {
            return false;
        }
        Variable variable = this.interp.lookupVariable(n >> 12);
        if (variable == null) {
            return false;
        }
        int n3 = variable.getType();
        if (n3 != 1) {
            return variable.getType() == 2;
        }
        Variable[] variableArray = variable.getArray();
        if (variableArray.length == 0) {
            return false;
        }
        return variableArray[0].getType() == 2;
    }

    void exit() {
        String string = null;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.isStringArg()) {
                string = this.getString();
            }
            this.interp.getRightParen();
        }
        this.interp.finishUp();
        if (string != null) {
            IJ.showMessage("Macro", string);
        }
        throw new RuntimeException("Macro canceled");
    }

    void showProgress() {
        ImageJ imageJ = IJ.getInstance();
        ProgressBar progressBar = imageJ != null ? imageJ.getProgressBar() : null;
        this.interp.getLeftParen();
        double d = this.interp.getExpression();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double d2 = this.interp.getExpression();
            if (progressBar != null) {
                progressBar.show((d + 1.0) / d2, true);
            }
        } else if (progressBar != null) {
            progressBar.show(d, true);
        }
        this.interp.getRightParen();
        this.interp.showingProgress = true;
    }

    void saveSettings() {
        this.interp.getParens();
        this.usePointerCursor = Prefs.usePointerCursor;
        this.hideProcessStackDialog = IJ.hideProcessStackDialog;
        this.divideByZeroValue = FloatBlitter.divideByZeroValue;
        this.jpegQuality = FileSaver.getJpegQuality();
        this.saveLineWidth = Line.getWidth();
        this.doScaling = ImageConverter.getDoScaling();
        this.weightedColor = Prefs.weightedColor;
        this.weights = ColorProcessor.getWeightingFactors();
        this.interpolateScaledImages = Prefs.interpolateScaledImages;
        this.open100Percent = Prefs.open100Percent;
        this.blackCanvas = Prefs.blackCanvas;
        this.useJFileChooser = Prefs.useJFileChooser;
        this.debugMode = IJ.debugMode;
        this.foregroundColor = Toolbar.getForegroundColor();
        this.backgroundColor = Toolbar.getBackgroundColor();
        this.roiColor = Roi.getColor();
        this.pointAutoMeasure = Prefs.pointAutoMeasure;
        this.requireControlKey = Prefs.requireControlKey;
        this.useInvertingLut = Prefs.useInvertingLut;
        this.saveSettingsCalled = true;
        this.measurements = Analyzer.getMeasurements();
        this.decimalPlaces = Analyzer.getPrecision();
        this.blackBackground = Prefs.blackBackground;
        this.pasteMode = Roi.getCurrentPasteMode();
    }

    void restoreSettings() {
        this.interp.getParens();
        if (!this.saveSettingsCalled) {
            this.interp.error("saveSettings() not called");
        }
        Prefs.usePointerCursor = this.usePointerCursor;
        IJ.hideProcessStackDialog = this.hideProcessStackDialog;
        FloatBlitter.divideByZeroValue = this.divideByZeroValue;
        FileSaver.setJpegQuality(this.jpegQuality);
        Line.setWidth(this.saveLineWidth);
        ImageConverter.setDoScaling(this.doScaling);
        if (this.weightedColor != Prefs.weightedColor) {
            ColorProcessor.setWeightingFactors(this.weights[0], this.weights[1], this.weights[2]);
            Prefs.weightedColor = this.weights[0] != 0.3333333333333333 || this.weights[1] != 0.3333333333333333 || this.weights[2] != 0.3333333333333333;
        }
        Prefs.interpolateScaledImages = this.interpolateScaledImages;
        Prefs.open100Percent = this.open100Percent;
        Prefs.blackCanvas = this.blackCanvas;
        Prefs.useJFileChooser = this.useJFileChooser;
        Prefs.useInvertingLut = this.useInvertingLut;
        IJ.debugMode = this.debugMode;
        Toolbar.setForegroundColor(this.foregroundColor);
        Toolbar.setBackgroundColor(this.backgroundColor);
        Roi.setColor(this.roiColor);
        Analyzer.setMeasurements(this.measurements);
        Analyzer.setPrecision(this.decimalPlaces);
        ColorProcessor.setWeightingFactors(this.weights[0], this.weights[1], this.weights[2]);
        Prefs.blackBackground = this.blackBackground;
        Roi.setPasteMode(this.pasteMode);
    }

    void setKeyDown() {
        String string = this.getStringArg();
        boolean bl = this.altKeyDown = (string = string.toLowerCase(Locale.US)).indexOf("alt") != -1;
        if (this.altKeyDown) {
            IJ.setKeyDown(18);
        } else {
            IJ.setKeyUp(18);
        }
        boolean bl2 = this.shiftKeyDown = string.indexOf("shift") != -1;
        if (this.shiftKeyDown) {
            IJ.setKeyDown(16);
        } else {
            IJ.setKeyUp(16);
        }
        if (string.equals("space")) {
            IJ.setKeyDown(32);
        } else {
            IJ.setKeyUp(32);
        }
        if (string.indexOf("esc") != -1) {
            this.abortPluginOrMacro();
        } else {
            this.interp.keysSet = true;
        }
    }

    void abortPluginOrMacro() {
        ImageWindow imageWindow;
        Interpreter.abortPrevious();
        IJ.setKeyDown(27);
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && (imageWindow = imagePlus.getWindow()) != null) {
            imageWindow.running = false;
            imageWindow.running2 = false;
        }
    }

    void open() {
        this.interp.getLeftParen();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            IJ.open();
        } else {
            String string;
            double d = Double.NaN;
            String string2 = this.getString();
            if (this.interp.nextToken() == 44) {
                this.interp.getComma();
                d = this.interp.getExpression();
            }
            this.interp.getRightParen();
            if (!Double.isNaN(d)) {
                try {
                    IJ.open(string2, (int)d);
                }
                catch (Exception exception) {
                    string = exception.getMessage();
                    if (string != null && string.indexOf("canceled") == -1) {
                        this.interp.error("" + string);
                    }
                }
            } else {
                IJ.open(string2);
            }
            if (string2 != null && !string2.equals("")) {
                int n = string2.lastIndexOf(47);
                if (n == -1) {
                    n = string2.lastIndexOf(92);
                }
                string = n >= 0 && n < string2.length() ? string2.substring(n + 1) : string2;
                OpenDialog.setLastName(string);
            }
        }
        this.resetImage();
    }

    double roiManager() {
        RoiManager roiManager;
        String string = this.getFirstString();
        string = string.toLowerCase();
        String string2 = null;
        String string3 = null;
        double d = 1.0;
        int n = 0;
        double d2 = Double.NaN;
        boolean bl = string.equals("open") || string.equals("save") || string.equals("rename") || string.equals("set color") || string.equals("set fill color") || string.equals("set line width") || string.equals("associate") || string.equals("centered") || string.equals("usenames");
        boolean bl2 = string.equals("select");
        boolean bl3 = false;
        boolean bl4 = string.equals("add");
        if (bl) {
            string2 = this.getLastString();
        } else if (bl4) {
            if (this.interp.nextToken() == 44) {
                this.interp.getComma();
                string3 = this.interp.getString();
            }
            if (this.interp.nextToken() == 44) {
                this.interp.getComma();
                d = this.interp.getExpression();
            }
            this.interp.getRightParen();
        } else if (bl2) {
            this.interp.getComma();
            bl3 = this.isArrayArg();
            if (!bl3) {
                n = (int)this.interp.getExpression();
                this.interp.getRightParen();
            }
        } else {
            this.interp.getRightParen();
        }
        if (RoiManager.getInstance() == null && this.roiManager == null) {
            if (Interpreter.isBatchMode()) {
                this.roiManager = new RoiManager(true);
            } else {
                IJ.run("ROI Manager...");
            }
        }
        RoiManager roiManager2 = roiManager = this.roiManager != null ? this.roiManager : RoiManager.getInstance();
        if (roiManager == null) {
            this.interp.error("ROI Manager not found");
        }
        if (bl3) {
            return this.setMultipleIndexes(roiManager);
        }
        if (bl) {
            roiManager.runCommand(string, string2);
        } else if (bl4) {
            roiManager.runCommand("Add", string3, d);
        } else if (bl2) {
            int n2 = roiManager.getList().getItemCount();
            this.checkIndex(n, 0, n2 - 1);
            if (this.shiftKeyDown || this.altKeyDown) {
                roiManager.select(n, this.shiftKeyDown, this.altKeyDown);
                this.altKeyDown = false;
                this.shiftKeyDown = false;
            } else {
                roiManager.select(n);
            }
        } else if (string.equals("count")) {
            d2 = roiManager.getList().getItemCount();
        } else if (string.equals("index")) {
            d2 = roiManager.getList().getSelectedIndex();
        } else if (!roiManager.runCommand(string)) {
            this.interp.error("Invalid ROI Manager command");
        }
        return d2;
    }

    boolean isArrayArg() {
        int n = this.pgm.code[this.interp.pc + 1];
        int n2 = n & 0xFF;
        if (n2 == 137) {
            return true;
        }
        if (n2 != 129) {
            return false;
        }
        Variable variable = this.interp.lookupVariable(n >> 12);
        if (variable == null) {
            return false;
        }
        return variable.getType() == 1;
    }

    double setMultipleIndexes(RoiManager roiManager) {
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
        }
        double[] dArray = this.getNumericArray();
        this.interp.getRightParen();
        int[] nArray = new int[dArray.length];
        int n = roiManager.getList().getItemCount();
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i];
            if (nArray[i] >= 0 && nArray[i] < n) continue;
            this.interp.error("Invalid index: " + nArray[i]);
        }
        roiManager.setSelectedIndexes(nArray);
        return Double.NaN;
    }

    void setFont() {
        String string = this.getFirstString();
        int n = 0;
        int n2 = 0;
        if (string.equals("user")) {
            string = TextRoi.getFont();
            n = TextRoi.getSize();
            n2 = TextRoi.getStyle();
            this.antialiasedText = TextRoi.isAntialiased();
            this.interp.getRightParen();
        } else {
            n = (int)this.getNextArg();
            this.antialiasedText = false;
            if (this.interp.nextToken() == 44) {
                String string2 = this.getLastString().toLowerCase();
                if (string2.indexOf("bold") != -1) {
                    ++n2;
                }
                if (string2.indexOf("italic") != -1) {
                    n2 += 2;
                }
                if (string2.indexOf("anti") != -1) {
                    this.antialiasedText = true;
                }
            } else {
                this.interp.getRightParen();
            }
        }
        this.font = new Font(string, n2, n);
        this.fontSet = false;
    }

    void getMinAndMax() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        double d = imagePlus.getDisplayRangeMin();
        double d2 = imagePlus.getDisplayRangeMax();
        Calibration calibration = imagePlus.getCalibration();
        d = calibration.getCValue(d);
        d2 = calibration.getCValue(d2);
        variable.setValue(d);
        variable2.setValue(d2);
    }

    void selectImage() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            String string = this.getString();
            if (!this.isOpen(string)) {
                this.interp.error("\"" + string + "\" not found");
            }
            this.selectImage(string);
            this.interp.getRightParen();
        } else {
            int n = (int)this.interp.getExpression();
            if (WindowManager.getImage(n) == null) {
                this.interp.error("Image " + n + " not found");
            }
            IJ.selectWindow(n);
            this.interp.getRightParen();
        }
        this.resetImage();
    }

    void selectImage(String string) {
        if (Interpreter.isBatchMode()) {
            if (Interpreter.imageTable != null) {
                Enumeration enumeration = Interpreter.imageTable.elements();
                while (enumeration.hasMoreElements()) {
                    ImagePlus imagePlus = (ImagePlus)enumeration.nextElement();
                    if (imagePlus == null || !imagePlus.getTitle().equals(string)) continue;
                    ImagePlus imagePlus2 = WindowManager.getCurrentImage();
                    if (imagePlus2 != null && imagePlus2 != imagePlus) {
                        imagePlus2.saveRoi();
                    }
                    WindowManager.setTempCurrentImage(imagePlus);
                    return;
                }
            }
            this.selectWindowManagerImage(string);
        } else {
            this.selectWindowManagerImage(string);
        }
    }

    void notFound(String string) {
        this.interp.error(string + " not found");
    }

    void selectWindowManagerImage(String string) {
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 4000L) {
            int[] nArray = WindowManager.getIDList();
            int n = nArray != null ? nArray.length : 0;
            for (int i = 0; i < n; ++i) {
                ImagePlus imagePlus = WindowManager.getImage(nArray[i]);
                if (imagePlus == null || !imagePlus.getTitle().equals(string)) continue;
                IJ.selectWindow(imagePlus.getID());
                return;
            }
            IJ.wait(10);
        }
        this.notFound(string);
    }

    void close() {
        this.interp.getParens();
        ImagePlus imagePlus = this.getImage();
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            imagePlus.changes = false;
            imageWindow.close();
        } else {
            imagePlus.saveRoi();
            WindowManager.setTempCurrentImage(null);
            Interpreter.removeBatchModeImage(imagePlus);
        }
        this.resetImage();
    }

    void setBatchMode() {
        boolean bl = false;
        String string = null;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            string = this.getString();
        } else {
            double d = this.interp.getBooleanExpression();
            this.interp.checkBoolean(d);
            bl = d == 1.0;
        }
        this.interp.getRightParen();
        Functions functions = this;
        if (!functions.interp.isBatchMode()) {
            this.interp.calledMacro = false;
        }
        this.resetImage();
        if (bl) {
            Functions functions2 = this;
            if (functions2.interp.isBatchMode()) {
                return;
            }
            Interpreter.setBatchMode(true);
            ImagePlus imagePlus = WindowManager.getTempCurrentImage();
            if (imagePlus != null) {
                Interpreter.addBatchModeImage(imagePlus);
            }
            return;
        }
        IJ.showProgress(0, 0);
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        WindowManager.setTempCurrentImage(null);
        this.roiManager = null;
        if (string == null) {
            Interpreter.setBatchMode(false);
            this.displayBatchModeImage(imagePlus);
        } else {
            Vector vector = Interpreter.imageTable;
            if (vector == null) {
                return;
            }
            Interpreter.setBatchMode(false);
            for (int i = 0; i < vector.size(); ++i) {
                imagePlus = (ImagePlus)vector.elementAt(i);
                if (imagePlus == null) continue;
                this.displayBatchModeImage(imagePlus);
            }
        }
    }

    void displayBatchModeImage(ImagePlus imagePlus) {
        if (imagePlus != null) {
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow == null) {
                imagePlus.show();
            } else {
                if (!imageWindow.isVisible()) {
                    imageWindow.show();
                }
                imagePlus.updateAndDraw();
            }
            Roi roi = imagePlus.getRoi();
            if (roi != null) {
                imagePlus.setRoi(roi);
            }
        }
    }

    void setLocation() {
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getNextArg();
        int n3 = 0;
        int n4 = 0;
        if (this.interp.nextToken() == 44) {
            n3 = (int)this.getNextArg();
            n4 = (int)this.getNextArg();
        }
        this.interp.getRightParen();
        if (n3 == 0 && n4 == 0) {
            Frame frame = WindowManager.getFrontWindow();
            if (frame != null) {
                frame.setLocation(n, n2);
            }
        } else {
            ImagePlus imagePlus = this.getImage();
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow != null) {
                imageWindow.setLocationAndSize(n, n2, n3, n4);
            }
        }
    }

    void setSlice() {
        int n = (int)this.getArg();
        ImagePlus imagePlus = this.getImage();
        int n2 = imagePlus.getStackSize();
        if (n == 1 && n2 == 1) {
            return;
        }
        if (n < 1 || n > n2) {
            this.interp.error("Argument must be >=1 and <=" + n2);
        } else if (imagePlus.isHyperStack()) {
            imagePlus.setPosition(n);
        } else {
            imagePlus.setSlice(n);
        }
        this.resetImage();
    }

    void newImage() {
        String string = this.getFirstString();
        String string2 = this.getNextString();
        int n = (int)this.getNextArg();
        int n2 = (int)this.getNextArg();
        int n3 = (int)this.getLastArg();
        if (n < 1 || n2 < 1) {
            this.interp.error("Width or height < 1");
        }
        IJ.newImage(string, string2, n, n2, n3);
        this.resetImage();
    }

    void saveAs() {
        String string = this.getFirstString();
        String string2 = null;
        if (this.interp.nextToken() == 44) {
            string2 = this.getLastString();
        } else {
            this.interp.getRightParen();
        }
        IJ.saveAs(string, string2);
    }

    double getZoom() {
        this.interp.getParens();
        ImagePlus imagePlus = this.getImage();
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas == null) {
            this.interp.error("Image not displayed");
            return 0.0;
        }
        return imageCanvas.getMagnification();
    }

    void setAutoThreshold() {
        ImagePlus imagePlus;
        block8: {
            String string = null;
            if (this.interp.nextToken() == 40) {
                this.interp.getLeftParen();
                if (this.isStringArg()) {
                    string = this.getString();
                }
                this.interp.getRightParen();
            }
            imagePlus = this.getImage();
            ImageProcessor imageProcessor = this.getProcessor();
            if (imageProcessor instanceof ColorProcessor) {
                this.interp.error("Non-RGB image expected");
            }
            imageProcessor.setRoi(imagePlus.getRoi());
            if (string != null) {
                try {
                    if (string.indexOf("stack") != -1) {
                        IJ.setAutoThreshold(imagePlus, string);
                        break block8;
                    }
                    imageProcessor.setAutoThreshold(string);
                }
                catch (Exception exception) {
                    this.interp.error("" + exception.getMessage());
                }
            } else {
                imageProcessor.setAutoThreshold(1, 0);
            }
        }
        imagePlus.updateAndDraw();
        this.resetImage();
    }

    double parseDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        if ((string = string.trim()).indexOf(32) != -1) {
            string = string.substring(0, string.indexOf(32));
        }
        return Tools.parseDouble(string);
    }

    double parseInt() {
        double d;
        String string = this.getFirstString();
        int n = 10;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            n = (int)this.interp.getExpression();
            if (n < 2 || n > 36) {
                n = 10;
            }
        }
        this.interp.getRightParen();
        try {
            if (n == 10) {
                d = this.parseDouble(string);
                if (!Double.isNaN(d)) {
                    d = Math.round(d);
                }
            } else {
                d = Integer.parseInt(string, n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    void print() {
        this.interp.inPrint = true;
        String string = this.getFirstString();
        if (this.interp.nextToken() == 44) {
            if (string.startsWith("[") && string.endsWith("]")) {
                this.printToWindow(string);
                return;
            }
            if (string.equals("~0~")) {
                String string2;
                if (this.writer == null) {
                    this.interp.error("File not open");
                }
                if ((string2 = this.getLastString()).endsWith("\n")) {
                    this.writer.print(string2);
                } else {
                    this.writer.println(string2);
                }
                this.interp.inPrint = false;
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            do {
                stringBuffer.append(" ");
                stringBuffer.append(this.getNextString());
            } while (this.interp.nextToken() == 44);
            string = stringBuffer.toString();
        }
        this.interp.getRightParen();
        IJ.log(string);
        this.interp.inPrint = false;
    }

    void printToWindow(String string) {
        boolean bl;
        String string2 = string.substring(1, string.length() - 1);
        String string3 = this.getLastString();
        boolean bl2 = string3.startsWith("\\");
        Frame frame = WindowManager.getFrame(string2);
        if (frame == null) {
            if (bl2) {
                this.interp.done = true;
                return;
            }
            this.interp.error("Window not found");
        }
        if (!(bl = frame instanceof Editor) && !(frame instanceof TextWindow)) {
            this.interp.error("Window is not text window");
        }
        if (bl) {
            Editor editor = (Editor)frame;
            editor.setIsMacroWindow(true);
            if (bl2) {
                this.handleEditorCommand(editor, string3);
            } else {
                editor.append(string3);
            }
        } else {
            TextWindow textWindow = (TextWindow)frame;
            if (bl2) {
                this.handleTextWindowCommand(textWindow, string3);
            } else {
                textWindow.append(string3);
            }
        }
    }

    void handleEditorCommand(Editor editor, String string) {
        if (string.startsWith("\\Update:")) {
            TextArea textArea = editor.getTextArea();
            textArea.setText(string.substring(8, string.length()));
            textArea.setEditable(false);
        } else if (string.equals("\\Close")) {
            editor.close();
        } else {
            editor.append(string);
        }
    }

    void handleTextWindowCommand(TextWindow textWindow, String string) {
        TextPanel textPanel = textWindow.getTextPanel();
        if (string.startsWith("\\Update:")) {
            int n = textPanel.getLineCount();
            String string2 = string.substring(8, string.length());
            if (n == 0) {
                textPanel.append(string2);
            } else {
                textPanel.setLine(n - 1, string2);
            }
        } else if (string.startsWith("\\Update")) {
            int n = string.indexOf(":");
            if (n == -1) {
                textPanel.append(string);
                return;
            }
            String string3 = string.substring(7, n);
            int n2 = (int)Tools.parseDouble(string3, -1.0);
            if (n2 < 0) {
                this.interp.error("Row index<0 or NaN");
            }
            for (int i = textPanel.getLineCount(); n2 >= i; ++i) {
                textPanel.append("");
            }
            String string4 = string.substring(n + 1, string.length());
            textPanel.setLine(n2, string4);
        } else if (string.equals("\\Clear")) {
            textPanel.clear();
        } else if (string.equals("\\Close")) {
            textWindow.close();
        } else if (string.startsWith("\\Headings:")) {
            textPanel.setColumnHeadings(string.substring(10));
        } else {
            textPanel.append(string);
        }
    }

    double isKeyDown() {
        double d = 0.0;
        String string = this.getStringArg().toLowerCase(Locale.US);
        if (string.indexOf("alt") != -1) {
            d = IJ.altKeyDown() ? 1.0 : 0.0;
        } else if (string.indexOf("shift") != -1) {
            d = IJ.shiftKeyDown() ? 1.0 : 0.0;
        } else if (string.indexOf("space") != -1) {
            d = IJ.spaceBarDown() ? 1.0 : 0.0;
        } else {
            this.interp.error("Invalid key");
        }
        return d;
    }

    String runMacro(boolean bl) {
        this.interp.getLeftParen();
        String string = this.getString();
        String string2 = null;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            string2 = this.getString();
        }
        this.interp.getRightParen();
        if (bl) {
            if (string2 != null && (string.equals("script") || string.equals("js"))) {
                return new Macro_Runner().runJavaScript(string2, "");
            }
            return IJ.runMacro(string, string2);
        }
        return IJ.runMacroFile(string, string2);
    }

    void setThreshold() {
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        String string = null;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            string = this.getString();
        }
        this.interp.getRightParen();
        IJ.setThreshold(d, d2, string);
        this.resetImage();
    }

    void drawOrFill(int n) {
        int n2 = (int)this.getFirstArg();
        int n3 = (int)this.getNextArg();
        int n4 = (int)this.getNextArg();
        int n5 = (int)this.getLastArg();
        ImageProcessor imageProcessor = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(imageProcessor);
        }
        switch (n) {
            case 388: {
                imageProcessor.drawRect(n2, n3, n4, n5);
                break;
            }
            case 376: {
                imageProcessor.setRoi(n2, n3, n4, n5);
                imageProcessor.fill();
                break;
            }
            case 389: {
                imageProcessor.drawOval(n2, n3, n4, n5);
                break;
            }
            case 390: {
                imageProcessor.fillOval(n2, n3, n4, n5);
            }
        }
        this.updateAndDraw();
    }

    double getScreenDimension(int n) {
        this.interp.getParens();
        Dimension dimension = IJ.getScreenSize();
        if (n == 1043) {
            return dimension.width;
        }
        return dimension.height;
    }

    void getStatistics(boolean bl) {
        Variable[] variableArray;
        Object object;
        Object object2;
        Variable variable = this.getFirstVariable();
        Variable variable2 = null;
        Variable variable3 = null;
        Variable variable4 = null;
        Variable variable5 = null;
        Variable variable6 = null;
        int n = 19;
        this.interp.getToken();
        int n2 = 1;
        while (this.interp.token == 44) {
            switch (++n2) {
                case 2: {
                    variable2 = this.getVariable();
                    break;
                }
                case 3: {
                    variable3 = this.getVariable();
                    break;
                }
                case 4: {
                    variable4 = this.getVariable();
                    break;
                }
                case 5: {
                    variable5 = this.getVariable();
                    n += 4;
                    break;
                }
                case 6: {
                    variable6 = this.getArrayVariable();
                    break;
                }
                default: {
                    this.interp.error("')' expected");
                }
            }
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        ImagePlus imagePlus = this.getImage();
        Calibration calibration = bl ? imagePlus.getCalibration() : null;
        ImageProcessor imageProcessor = this.getProcessor();
        ImageStatistics imageStatistics = null;
        Roi roi = imagePlus.getRoi();
        int n3 = Line.getWidth();
        if (roi != null && roi.isLine() && n3 > 1) {
            if (roi.getType() == 5) {
                object2 = imageProcessor;
                object = ((ImageProcessor)object2).getRoi();
                ((ImageProcessor)object2).setRoi(roi.getPolygon());
                imageStatistics = ImageStatistics.getStatistics((ImageProcessor)object2, n, calibration);
                ((ImageProcessor)object2).setRoi((Rectangle)object);
            } else {
                object2 = new Straightener().straightenLine(imagePlus, n3);
                imageStatistics = ImageStatistics.getStatistics((ImageProcessor)object2, n, calibration);
            }
        } else if (roi != null && roi.isLine()) {
            object2 = new ProfilePlot(imagePlus);
            object = ((ProfilePlot)object2).getProfile();
            FloatProcessor floatProcessor = new FloatProcessor(((double[])object).length, 1, (double[])object);
            if (roi instanceof Line) {
                variableArray = (Variable[])roi;
                if ((variableArray.y1 == variableArray.y2 || variableArray.x1 == variableArray.x2) && (double)variableArray.x1 == variableArray.x1d && (double)variableArray.y1 == variableArray.y1d && (double)variableArray.x2 == variableArray.x2d && (double)variableArray.y2 == variableArray.y2d) {
                    floatProcessor.setRoi(0, 0, floatProcessor.getWidth() - 1, 1);
                }
            }
            imageStatistics = ImageStatistics.getStatistics(floatProcessor, n, calibration);
        } else {
            imageProcessor.setRoi(roi);
            imageStatistics = ImageStatistics.getStatistics(imageProcessor, n, calibration);
        }
        if (bl) {
            variable.setValue(imageStatistics.area);
        } else {
            variable.setValue(imageStatistics.pixelCount);
        }
        if (variable2 != null) {
            variable2.setValue(imageStatistics.mean);
        }
        if (variable3 != null) {
            variable3.setValue(imageStatistics.min);
        }
        if (variable4 != null) {
            variable4.setValue(imageStatistics.max);
        }
        if (variable5 != null) {
            variable5.setValue(imageStatistics.stdDev);
        }
        if (variable6 != null) {
            boolean bl2 = !bl && imageProcessor instanceof ShortProcessor && imageStatistics.histogram16 != null;
            object = bl2 ? imageStatistics.histogram16 : imageStatistics.histogram;
            int n4 = bl2 ? (int)(imageStatistics.max + 1.0) : ((double[])object).length;
            variableArray = new Variable[n4];
            int n5 = bl2 ? (int)imageStatistics.max : 255;
            for (int i = 0; i <= n5; ++i) {
                variableArray[i] = new Variable(object[i]);
            }
            variable6.setArray(variableArray);
        }
    }

    String replace() {
        String string = this.getFirstString();
        String string2 = this.getNextString();
        String string3 = this.getLastString();
        if (string2.length() == 1 && string3.length() == 1) {
            return string.replace(string2.charAt(0), string3.charAt(0));
        }
        try {
            return string.replaceAll(string2, string3);
        }
        catch (Exception exception) {
            this.interp.error("" + exception);
            return null;
        }
    }

    void floodFill() {
        Object object;
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getNextArg();
        boolean bl = true;
        if (this.interp.nextToken() == 44) {
            object = this.getLastString();
            if (((String)object).indexOf("8") != -1) {
                bl = false;
            }
        } else {
            this.interp.getRightParen();
        }
        object = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor((ImageProcessor)object);
        }
        FloodFiller floodFiller = new FloodFiller((ImageProcessor)object);
        if (bl) {
            floodFiller.fill(n, n2);
        } else {
            floodFiller.fill8(n, n2);
        }
        this.updateAndDraw();
        if (Recorder.record && this.pgm.hasVars) {
            Recorder.record("floodFill", n, n2);
        }
    }

    void restorePreviousTool() {
        this.interp.getParens();
        Toolbar toolbar = Toolbar.getInstance();
        if (toolbar != null) {
            toolbar.restorePreviousTool();
        }
    }

    void setVoxelSize() {
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        double d3 = this.getNextArg();
        String string = this.getLastString();
        ImagePlus imagePlus = this.getImage();
        Calibration calibration = imagePlus.getCalibration();
        calibration.pixelWidth = d;
        calibration.pixelHeight = d2;
        calibration.pixelDepth = d3;
        calibration.setUnit(string);
        imagePlus.repaintWindow();
    }

    void getLocationAndSize() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            Point point = imageWindow.getLocation();
            Dimension dimension = imageWindow.getSize();
            n = point.x;
            n2 = point.y;
            n3 = dimension.width;
            n4 = dimension.height;
        }
        variable.setValue(n);
        variable2.setValue(n2);
        variable3.setValue(n3);
        variable4.setValue(n4);
    }

    String doDialog() {
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 136 && this.interp.token != 135) {
            this.interp.error("Function name expected: ");
        }
        String string = this.interp.tokenString;
        try {
            if (string.equals("create")) {
                this.gd = new GenericDialog(this.getStringArg());
                return null;
            }
            if (this.gd == null) {
                this.interp.error("No dialog created with Dialog.create()");
                return null;
            }
            if (string.equals("addString")) {
                String string2 = this.getFirstString();
                String string3 = this.getNextString();
                int n = 8;
                if (this.interp.nextToken() == 44) {
                    n = (int)this.getNextArg();
                }
                this.interp.getRightParen();
                this.gd.addStringField(string2, string3, n);
            } else if (string.equals("addNumber")) {
                int n;
                int n2 = 6;
                String string4 = null;
                String string5 = this.getFirstString();
                double d = this.getNextArg();
                int n3 = n = (double)((int)d) == d ? 0 : 3;
                if (this.interp.nextToken() == 44) {
                    n = (int)this.getNextArg();
                    n2 = (int)this.getNextArg();
                    string4 = this.getLastString();
                } else {
                    this.interp.getRightParen();
                }
                this.gd.addNumericField(string5, d, n, n2, string4);
            } else if (string.equals("addSlider")) {
                String string6 = this.getFirstString();
                double d = this.getNextArg();
                double d2 = this.getNextArg();
                double d3 = this.getLastArg();
                this.gd.addSlider(string6, d, d2, d3);
            } else if (string.equals("addCheckbox")) {
                this.gd.addCheckbox(this.getFirstString(), this.getLastArg() == 1.0);
            } else if (string.equals("addCheckboxGroup")) {
                this.addCheckboxGroup(this.gd);
            } else if (string.equals("addMessage")) {
                this.gd.addMessage(this.getStringArg());
            } else if (string.equals("addHelp")) {
                this.gd.addHelp(this.getStringArg());
            } else if (string.equals("addChoice")) {
                String string7 = this.getFirstString();
                this.interp.getComma();
                String[] stringArray = this.getStringArray();
                String string8 = null;
                if (this.interp.nextToken() == 44) {
                    this.interp.getComma();
                    string8 = this.getString();
                } else {
                    string8 = stringArray[0];
                }
                this.interp.getRightParen();
                this.gd.addChoice(string7, stringArray, string8);
            } else if (string.equals("setInsets")) {
                this.gd.setInsets((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
            } else if (string.equals("show")) {
                this.interp.getParens();
                this.gd.showDialog();
                if (this.gd.wasCanceled()) {
                    this.interp.finishUp();
                    throw new RuntimeException("Macro canceled");
                }
            } else {
                if (string.equals("getString")) {
                    this.interp.getParens();
                    return this.gd.getNextString();
                }
                if (string.equals("getNumber")) {
                    this.interp.getParens();
                    return "" + this.gd.getNextNumber();
                }
                if (string.equals("getCheckbox")) {
                    this.interp.getParens();
                    return this.gd.getNextBoolean() ? "1" : "0";
                }
                if (string.equals("getChoice")) {
                    this.interp.getParens();
                    return this.gd.getNextChoice();
                }
                this.interp.error("Unrecognized Dialog function " + string);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.interp.error("Dialog error");
        }
        return null;
    }

    void addCheckboxGroup(GenericDialog genericDialog) {
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getNextArg();
        this.interp.getComma();
        String[] stringArray = this.getStringArray();
        int n3 = stringArray.length;
        double[] dArray = this.getLastArray();
        if (n3 != dArray.length) {
            this.interp.error("labels.length!=states.length");
        }
        boolean[] blArray = new boolean[n3];
        for (int i = 0; i < n3; ++i) {
            blArray[i] = dArray[i] == 1.0;
        }
        genericDialog.addCheckboxGroup(n, n2, stringArray, blArray);
    }

    void getDateAndTime() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getNextVariable();
        Variable variable5 = this.getNextVariable();
        Variable variable6 = this.getNextVariable();
        Variable variable7 = this.getNextVariable();
        Variable variable8 = this.getLastVariable();
        Calendar calendar = Calendar.getInstance();
        variable.setValue(calendar.get(1));
        variable2.setValue(calendar.get(2));
        variable3.setValue(calendar.get(7) - 1);
        variable4.setValue(calendar.get(5));
        variable5.setValue(calendar.get(11));
        variable6.setValue(calendar.get(12));
        variable7.setValue(calendar.get(13));
        variable8.setValue(calendar.get(14));
    }

    void setMetadata() {
        String string = null;
        String string2 = this.getFirstString();
        boolean bl = false;
        if (this.interp.nextToken() == 44) {
            string = this.getLastString();
        } else {
            this.interp.getRightParen();
        }
        boolean bl2 = false;
        if (string == null) {
            string = string2;
            bl = true;
            if (string.startsWith("Info:")) {
                string = string.substring(5);
                bl2 = true;
            }
        } else {
            bl2 = string2.startsWith("info") || string2.startsWith("Info");
        }
        ImagePlus imagePlus = this.getImage();
        if (bl2) {
            imagePlus.setProperty("Info", string);
        } else if (imagePlus.getStackSize() == 1) {
            if (bl) {
                imagePlus.setProperty("Info", string);
            } else {
                imagePlus.setProperty("Label", string);
                if (!Interpreter.isBatchMode()) {
                    imagePlus.repaintWindow();
                }
            }
        } else {
            imagePlus.getStack().setSliceLabel(string, imagePlus.getCurrentSlice());
            if (!Interpreter.isBatchMode()) {
                imagePlus.repaintWindow();
            }
        }
    }

    String getMetadata() {
        String string = "label";
        boolean bl = true;
        if (this.interp.nextToken() == 40 && this.interp.nextNextToken() != 41) {
            string = this.getStringArg().toLowerCase(Locale.US);
            bl = false;
        } else {
            this.interp.getParens();
        }
        ImagePlus imagePlus = this.getImage();
        String string2 = null;
        if (string.indexOf("label") != -1) {
            if (imagePlus.getStackSize() == 1) {
                string2 = (String)imagePlus.getProperty("Label");
                if (string2 == null && bl) {
                    string2 = (String)imagePlus.getProperty("Info");
                }
            } else {
                string2 = imagePlus.getStack().getSliceLabel(imagePlus.getCurrentSlice());
            }
        } else {
            string2 = (String)imagePlus.getProperty("Info");
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    ImagePlus getImageArg() {
        ImagePlus imagePlus = null;
        if (this.isStringArg()) {
            String string = this.getString();
            imagePlus = WindowManager.getImage(string);
        } else {
            int n = (int)this.interp.getExpression();
            imagePlus = WindowManager.getImage(n);
        }
        if (imagePlus == null) {
            this.interp.error("Image not found");
        }
        return imagePlus;
    }

    void imageCalculator() {
        String string = this.getFirstString();
        this.interp.getComma();
        ImagePlus imagePlus = this.getImageArg();
        this.interp.getComma();
        ImagePlus imagePlus2 = this.getImageArg();
        this.interp.getRightParen();
        ImageCalculator imageCalculator = new ImageCalculator();
        imageCalculator.calculate(string, imagePlus, imagePlus2);
        this.resetImage();
    }

    void setRGBWeights() {
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        double d3 = this.getLastArg();
        if (this.interp.rgbWeights == null) {
            this.interp.rgbWeights = ColorProcessor.getWeightingFactors();
        }
        ColorProcessor.setWeightingFactors(d, d2, d3);
    }

    void makePolygon() {
        int n;
        int n2 = 200;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        nArray[0] = (int)Math.round(this.getFirstArg());
        nArray2[0] = (int)Math.round(this.getNextArg());
        this.interp.getToken();
        for (n = 1; this.interp.token == 44 && n < n2; ++n) {
            nArray[n] = (int)Math.round(this.interp.getExpression());
            this.interp.getComma();
            nArray2[n] = (int)Math.round(this.interp.getExpression());
            this.interp.getToken();
        }
        if (n < 3) {
            this.interp.error("Fewer than 3 points");
        }
        if (n == n2 && this.interp.token != 41) {
            this.interp.error("More than " + n2 + " points");
        }
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            imagePlus.saveRoi();
        }
        imagePlus.setRoi(new PolygonRoi(nArray, nArray2, n, 2));
        Roi roi2 = imagePlus.getRoi();
        if (roi != null && roi2 != null) {
            this.updateRoi(roi2);
        }
        this.resetImage();
    }

    void updateRoi(Roi roi) {
        if (this.shiftKeyDown || this.altKeyDown) {
            roi.update(this.shiftKeyDown, this.altKeyDown);
        }
        this.altKeyDown = false;
        this.shiftKeyDown = false;
    }

    String doFile() {
        String string;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 136 && this.interp.token != 135 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((string = this.interp.tokenString).equals("open")) {
            return this.openFile();
        }
        if (string.equals("openAsString")) {
            return this.openAsString(false);
        }
        if (string.equals("openAsRawString")) {
            return this.openAsString(true);
        }
        if (string.equals("openUrlAsString")) {
            return IJ.openUrlAsString(this.getStringArg());
        }
        if (string.equals("openDialog")) {
            return this.openDialog();
        }
        if (string.equals("close")) {
            return this.closeFile();
        }
        if (string.equals("separator")) {
            this.interp.getParens();
            return File.separator;
        }
        if (string.equals("directory")) {
            this.interp.getParens();
            String string2 = OpenDialog.getLastDirectory();
            return string2 != null ? string2 : "";
        }
        if (string.equals("name")) {
            this.interp.getParens();
            String string3 = OpenDialog.getLastName();
            return string3 != null ? string3 : "";
        }
        if (string.equals("nameWithoutExtension")) {
            this.interp.getParens();
            return this.nameWithoutExtension();
        }
        if (string.equals("rename")) {
            File file = new File(this.getFirstString());
            File file2 = new File(this.getLastString());
            if (this.checkPath(file) && this.checkPath(file2)) {
                return file.renameTo(file2) ? "1" : "0";
            }
            return "0";
        }
        if (string.equals("append")) {
            String string4 = IJ.append(this.getFirstString(), this.getLastString());
            if (string4 != null) {
                this.interp.error(string4);
            }
            return null;
        }
        if (string.equals("saveString")) {
            String string5 = IJ.saveString(this.getFirstString(), this.getLastString());
            if (string5 != null) {
                this.interp.error(string5);
            }
            return null;
        }
        File file = new File(this.getStringArg());
        if (string.equals("getLength") || string.equals("length")) {
            return "" + file.length();
        }
        if (string.equals("getName")) {
            return file.getName();
        }
        if (string.equals("getAbsolutePath")) {
            return file.getAbsolutePath();
        }
        if (string.equals("getParent")) {
            return file.getParent();
        }
        if (string.equals("exists")) {
            return file.exists() ? "1" : "0";
        }
        if (string.equals("isDirectory")) {
            return file.isDirectory() ? "1" : "0";
        }
        if (string.equals("makeDirectory") || string.equals("mkdir")) {
            file.mkdir();
            return null;
        }
        if (string.equals("lastModified")) {
            return "" + file.lastModified();
        }
        if (string.equals("dateLastModified")) {
            return new Date(file.lastModified()).toString();
        }
        if (string.equals("delete")) {
            return file.delete() ? "1" : "0";
        }
        this.interp.error("Unrecognized File function " + string);
        return null;
    }

    String nameWithoutExtension() {
        String string = OpenDialog.getLastName();
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(".");
        if (n >= 0 && string.length() - n <= 5) {
            string = string.substring(0, n);
        }
        return string;
    }

    boolean checkPath(File file) {
        String string = file.getPath();
        if (string.equals("0") || string.equals("NaN")) {
            this.interp.error("Invalid path");
            return false;
        }
        return true;
    }

    String openDialog() {
        String string = this.getStringArg();
        OpenDialog openDialog = new OpenDialog(string, null);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return "";
        }
        return string2 + string3;
    }

    void setSelectionName() {
        Roi roi = this.getImage().getRoi();
        if (roi == null) {
            this.interp.error("No selection");
        } else {
            roi.setName(this.getStringArg());
        }
    }

    String selectionName() {
        Roi roi = this.getImage().getRoi();
        String string = null;
        if (roi == null) {
            this.interp.error("No selection");
        } else {
            string = roi.getName();
        }
        return string != null ? string : "";
    }

    String openFile() {
        Object object;
        Object object2;
        if (this.writer != null) {
            this.interp.error("Currently, only one file can be open at a time");
            return "";
        }
        String string = this.getFirstString();
        String string2 = null;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
        } else {
            string2 = this.getLastString();
        }
        if (string.equals("") || string2 != null) {
            object2 = string2 != null ? string : "openFile";
            object = new SaveDialog((String)object2, string2 = string2 != null ? string2 : "log.txt", ".txt");
            if (((SaveDialog)object).getFileName() == null) {
                return "";
            }
            string = ((SaveDialog)object).getDirectory() + ((SaveDialog)object).getFileName();
        } else {
            object2 = new File(string);
            if (!(!((File)object2).exists() || string.endsWith(".txt") || string.endsWith(".java") || string.endsWith(".xls") || string.endsWith(".ijm") || string.endsWith(".html") || string.endsWith(".htm"))) {
                this.interp.error("File exists and suffix is not '.txt', '.java', etc.");
            }
        }
        try {
            object2 = new FileOutputStream(string);
            object = new BufferedOutputStream((OutputStream)object2);
            this.writer = new PrintWriter((OutputStream)object);
        }
        catch (IOException iOException) {
            this.interp.error("File open error \n\"" + iOException.getMessage() + "\"\n");
            return "";
        }
        return "~0~";
    }

    String openAsString(boolean bl) {
        CharSequence charSequence;
        Object object;
        Object object2;
        int n = 5000;
        String string = this.getFirstString();
        boolean bl2 = false;
        if (bl && this.interp.nextToken() == 44) {
            n = (int)this.getNextArg();
            bl2 = true;
        }
        this.interp.getRightParen();
        if (string.equals("")) {
            object2 = new OpenDialog("Open As String", "");
            object = ((OpenDialog)object2).getDirectory();
            charSequence = ((OpenDialog)object2).getFileName();
            if (charSequence == null) {
                return "";
            }
            string = (String)object + (String)charSequence;
        }
        object2 = "";
        object = new File(string);
        if (!((File)object).exists()) {
            this.interp.error("File not found");
        }
        try {
            charSequence = new StringBuffer(5000);
            if (bl) {
                int n2 = (int)((File)object).length();
                if (n > n2 || string.endsWith(".txt") && !bl2) {
                    n = n2;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray);
                dataInputStream.close();
                char[] cArray = new char[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    cArray[i] = (char)(byArray[i] & 0xFF);
                }
                object2 = new String(cArray);
            } else {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object));
                while ((string2 = bufferedReader.readLine()) != null) {
                    ((StringBuffer)charSequence).append(string2 + "\n");
                }
                bufferedReader.close();
                object2 = new String((StringBuffer)charSequence);
            }
        }
        catch (Exception exception) {
            this.interp.error("File open error \n\"" + exception.getMessage() + "\"\n");
        }
        return object2;
    }

    String closeFile() {
        String string = this.getStringArg();
        if (!string.equals("~0~")) {
            this.interp.error("Invalid file variable");
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        return null;
    }

    String call() {
        Method method;
        int n;
        Object object;
        Serializable serializable;
        String string = this.getFirstString();
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            this.interp.error("'classname.methodname' expected");
            return null;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        Object[] objectArray = null;
        if (this.interp.nextToken() == 44) {
            serializable = new Vector<String>();
            do {
                ((Vector)serializable).add(this.getNextString());
            } while (this.interp.nextToken() == 44);
            objectArray = ((Vector)serializable).toArray();
        }
        this.interp.getRightParen();
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        try {
            serializable = IJ.getClassLoader().loadClass(string2);
        }
        catch (Exception exception) {
            this.interp.error("Could not load class " + string2);
            return null;
        }
        try {
            object = null;
            if (objectArray.length > 0) {
                object = new Class[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    object[n] = objectArray[n].getClass();
                }
            }
            method = ((Class)serializable).getMethod(string3, (Class<?>)object);
        }
        catch (Exception exception) {
            method = null;
        }
        if (method == null && objectArray.length > 0) {
            try {
                object = new Class[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    double d = Tools.parseDouble((String)objectArray[n]);
                    if (!Double.isNaN(d)) {
                        objectArray[n] = new Integer((int)d);
                        object[n] = Integer.TYPE;
                        continue;
                    }
                    object[n] = objectArray[n].getClass();
                }
                method = ((Class)serializable).getMethod(string3, (Class<?>)object);
            }
            catch (Exception exception) {
                method = null;
            }
        }
        if (method == null) {
            this.interp.error("Could not find the method " + string3 + " with " + objectArray.length + " parameter(s) in class " + string2);
        }
        try {
            object = method.invoke(null, objectArray);
            return object != null ? object.toString() : null;
        }
        catch (InvocationTargetException invocationTargetException) {
            IJ.handleException(invocationTargetException);
            return null;
        }
        catch (Exception exception) {
            IJ.log("Call error (" + exception + ")");
            return null;
        }
    }

    Variable[] getFontList() {
        this.interp.getParens();
        String[] stringArray = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        if (stringArray == null) {
            return null;
        }
        Variable[] variableArray = new Variable[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            variableArray[i] = new Variable(0, 0.0, stringArray[i]);
        }
        return variableArray;
    }

    void setOption() {
        String string = this.getFirstString();
        boolean bl = true;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double d = this.interp.getBooleanExpression();
            this.interp.checkBoolean(d);
            bl = d != 0.0;
        }
        this.interp.getRightParen();
        string = string.toLowerCase(Locale.US);
        if (string.equals("disablepopupmenu")) {
            ImageCanvas imageCanvas = this.getImage().getCanvas();
            if (imageCanvas != null) {
                imageCanvas.disablePopupMenu(bl);
            }
        } else if (string.startsWith("show all")) {
            ImagePlus imagePlus = this.getImage();
            ImageCanvas imageCanvas = imagePlus.getCanvas();
            if (imageCanvas != null) {
                boolean bl2 = imageCanvas.getShowAllROIs();
                imageCanvas.setShowAllROIs(bl);
                if (bl != bl2) {
                    imagePlus.draw();
                }
            }
        } else if (string.equals("changes")) {
            this.getImage().changes = bl;
        } else if (string.equals("debugmode")) {
            IJ.debugMode = bl;
        } else if (string.equals("openusingplugins")) {
            Opener.setOpenUsingPlugins(bl);
        } else if (string.equals("queuemacros")) {
            this.pgm.queueCommands = bl;
        } else if (string.equals("disableundo")) {
            Prefs.disableUndo = bl;
        } else if (string.startsWith("openashyper")) {
            this.getImage().setOpenAsHyperStack(true);
        } else if (string.startsWith("black")) {
            Prefs.blackBackground = bl;
        } else if (string.startsWith("display lab")) {
            Analyzer.setMeasurement(1024, bl);
        } else if (string.startsWith("limit to")) {
            Analyzer.setMeasurement(256, bl);
        } else if (string.equals("area")) {
            Analyzer.setMeasurement(1, bl);
        } else if (string.equals("mean")) {
            Analyzer.setMeasurement(2, bl);
        } else if (string.startsWith("std")) {
            Analyzer.setMeasurement(4, bl);
        } else if (string.equals("showrownumbers")) {
            ResultsTable.getResultsTable().showRowNumbers(bl);
        } else if (string.startsWith("show")) {
            Analyzer.setOption(string, bl);
        } else if (string.startsWith("bicubic")) {
            ImageProcessor.setUseBicubic(bl);
        } else if (string.startsWith("wand") || string.indexOf("points") != -1) {
            Wand.setAllPoints(bl);
        } else if (string.startsWith("loop")) {
            Calibration.setLoopBackAndForth(bl);
        } else {
            this.interp.error("Invalid option");
        }
    }

    void setMeasurementOption(String string) {
    }

    void showText() {
        String string = this.getFirstString();
        String string2 = this.getLastString();
        Editor editor = new Editor();
        editor.setSize(350, 300);
        editor.create(string, string2);
    }

    Variable[] newMenu() {
        String string = this.getFirstString();
        this.interp.getComma();
        String[] stringArray = this.getStringArray();
        this.interp.getRightParen();
        if (this.pgm.menus == null) {
            this.pgm.menus = new Hashtable();
        }
        this.pgm.menus.put(string, stringArray);
        Variable[] variableArray = new Variable[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            variableArray[i] = new Variable(0, 0.0, stringArray[i]);
        }
        return variableArray;
    }

    void setSelectionLocation() {
        int n = (int)Math.round(this.getFirstArg());
        int n2 = (int)Math.round(this.getLastArg());
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        roi.setLocation(n, n2);
        imagePlus.draw();
    }

    double is() {
        boolean bl = false;
        String string = this.getStringArg();
        if ((string = string.toLowerCase(Locale.US)).equals("locked")) {
            bl = this.getImage().isLocked();
        } else if (string.indexOf("invert") != -1) {
            bl = this.getImage().isInvertedLut();
        } else if (string.indexOf("hyper") != -1) {
            bl = this.getImage().isHyperStack();
        } else if (string.indexOf("batch") != -1) {
            bl = Interpreter.isBatchMode();
        } else if (string.indexOf("applet") != -1) {
            bl = IJ.getApplet() != null;
        } else if (string.indexOf("virtual") != -1) {
            bl = this.getImage().getStack().isVirtual();
        } else if (string.indexOf("composite") != -1) {
            bl = this.getImage().isComposite();
        } else if (string.indexOf("caps") != -1) {
            bl = this.getCapsLockState();
        } else if (string.indexOf("changes") != -1) {
            bl = this.getImage().changes;
        } else if (string.indexOf("binary") != -1) {
            bl = this.getProcessor().isBinary();
        } else if (string.indexOf("animated") != -1) {
            ImageWindow imageWindow = this.getImage().getWindow();
            bl = imageWindow != null && imageWindow instanceof StackWindow && ((StackWindow)imageWindow).getAnimate();
        } else {
            this.interp.error("Invalid argument");
        }
        return bl ? 1.0 : 0.0;
    }

    final boolean getCapsLockState() {
        boolean bl = false;
        try {
            bl = Toolkit.getDefaultToolkit().getLockingKeyState(20);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    Variable[] getList() {
        String string = this.getStringArg();
        if (string.equals("java.properties")) {
            Properties properties = System.getProperties();
            Vector<String> vector = new Vector<String>();
            Variable[] variableArray = properties.keys();
            while (variableArray.hasMoreElements()) {
                vector.addElement((String)variableArray.nextElement());
            }
            variableArray = new Variable[vector.size()];
            for (int i = 0; i < variableArray.length; ++i) {
                variableArray[i] = new Variable(0, 0.0, (String)vector.elementAt(i));
            }
            return variableArray;
        }
        if (string.equals("window.titles")) {
            Frame[] frameArray = WindowManager.getNonImageWindows();
            Variable[] variableArray = new Variable[frameArray.length];
            for (int i = 0; i < frameArray.length; ++i) {
                Frame frame = frameArray[i];
                variableArray[i] = new Variable(0, 0.0, frame.getTitle());
            }
            return variableArray;
        }
        if (string.equals("threshold.methods")) {
            String[] stringArray = AutoThresholder.getMethods();
            Variable[] variableArray = new Variable[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                variableArray[i] = new Variable(0, 0.0, stringArray[i]);
            }
            return variableArray;
        }
        this.interp.error("Unvalid key");
        return null;
    }

    String doString() {
        String string;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Function name expected: ");
        }
        if ((string = this.interp.tokenString).equals("append")) {
            return this.appendToBuffer();
        }
        if (string.equals("copy")) {
            return this.copyStringToClipboard();
        }
        if (string.equals("copyResults")) {
            return this.copyResults();
        }
        if (string.equals("paste")) {
            return this.getClipboardContents();
        }
        if (string.equals("resetBuffer")) {
            return this.resetBuffer();
        }
        if (string.equals("buffer")) {
            return this.getBuffer();
        }
        this.interp.error("Unrecognized String function");
        return null;
    }

    String appendToBuffer() {
        String string = this.getStringArg();
        if (this.buffer == null) {
            this.buffer = new StringBuffer(256);
        }
        this.buffer.append(string);
        return null;
    }

    String copyStringToClipboard() {
        String string = this.getStringArg();
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
        return null;
    }

    String getClipboardContents() {
        this.interp.getParens();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        String string = null;
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            string = transferable.toString();
        }
        return string;
    }

    String copyResults() {
        TextPanel textPanel;
        this.interp.getParens();
        if (!IJ.isResultsWindow()) {
            this.interp.error("No results");
        }
        if ((textPanel = IJ.getTextPanel()) == null) {
            return null;
        }
        StringSelection stringSelection = new StringSelection(textPanel.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
        return null;
    }

    String resetBuffer() {
        this.interp.getParens();
        this.buffer = new StringBuffer(256);
        return null;
    }

    String getBuffer() {
        this.interp.getParens();
        if (this.buffer == null) {
            this.buffer = new StringBuffer(256);
        }
        return this.buffer.toString();
    }

    void doCommand() {
        String string = this.getStringArg();
        if (string.equals("Start Animation")) {
            string = "Start Animation [\\]";
        }
        IJ.doCommand(string);
    }

    void getDimensions() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getNextVariable();
        Variable variable5 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        int[] nArray = imagePlus.getDimensions();
        variable.setValue(nArray[0]);
        variable2.setValue(nArray[1]);
        variable3.setValue(nArray[2]);
        variable4.setValue(nArray[3]);
        variable5.setValue(nArray[4]);
    }

    public static void registerExtensions(MacroExtension macroExtension) {
        Interpreter interpreter = Interpreter.getInstance();
        if (interpreter == null) {
            IJ.error("Macro must be running to install macro extensions");
            return;
        }
        interpreter.pgm.extensionRegistry = new Hashtable();
        ExtensionDescriptor[] extensionDescriptorArray = macroExtension.getExtensionFunctions();
        for (int i = 0; i < extensionDescriptorArray.length; ++i) {
            interpreter.pgm.extensionRegistry.put(extensionDescriptorArray[i].name, extensionDescriptorArray[i]);
        }
    }

    String doExt() {
        String string;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 136 && this.interp.token != 135 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((string = this.interp.tokenString).equals("install")) {
            Object object = IJ.runPlugIn(this.getStringArg(), "");
            if (object == null) {
                this.interp.error("Plugin not found");
            }
            return null;
        }
        ExtensionDescriptor extensionDescriptor = null;
        if (this.pgm.extensionRegistry != null) {
            extensionDescriptor = (ExtensionDescriptor)this.pgm.extensionRegistry.get(string);
        }
        if (extensionDescriptor == null) {
            this.interp.error("Unrecognized Ext function");
            return null;
        }
        return extensionDescriptor.dispatch(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String exec() {
        Object object;
        boolean bl;
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = this.getFirstString();
        if (this.interp.nextToken() == 44) {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            do {
                vector.add(this.getNextString());
            } while (this.interp.nextToken() == 44);
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = Tools.split(string);
        }
        this.interp.getRightParen();
        boolean bl2 = bl = objectArray.length == 2 && objectArray[0].equals("open") || objectArray.length == 5 && objectArray[3].equals("excel.exe");
        if (bl && IJ.isWindows()) {
            object = objectArray[1];
            if (((String)object).startsWith("http://") || ((String)object).startsWith("HTTP://") || ((String)object).startsWith("https://")) {
                objectArray = new String[4];
                objectArray[2] = "start";
                objectArray[3] = object;
            } else {
                objectArray = new String[3];
                objectArray[2] = object;
            }
            objectArray[0] = "cmd";
            objectArray[1] = "/c";
        }
        object = null;
        try {
            String string2;
            Process process = Runtime.getRuntime().exec((String[])objectArray);
            if (bl) {
                String string3 = null;
                return string3;
            }
            object = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int n = 1;
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                stringBuffer.append(string2 + "\n");
                if (n++ != 1 || !string2.startsWith("Microsoft Windows")) continue;
                break;
            }
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage() + "\n");
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuffer.toString();
    }

    double getValue() {
        String string = this.getStringArg();
        if (string.indexOf("foreground") != -1) {
            return Toolbar.getForegroundColor().getRGB() & 0xFFFFFF;
        }
        if (string.indexOf("background") != -1) {
            return Toolbar.getBackgroundColor().getRGB() & 0xFFFFFF;
        }
        if (string.equals("font.size")) {
            this.resetImage();
            ImageProcessor imageProcessor = this.getProcessor();
            this.setFont(imageProcessor);
            return imageProcessor.getFont().getSize();
        }
        if (string.equals("font.height")) {
            this.resetImage();
            ImageProcessor imageProcessor = this.getProcessor();
            this.setFont(imageProcessor);
            return imageProcessor.getFontMetrics().getHeight();
        }
        this.interp.error("Invalid key");
        return 0.0;
    }

    double doStack() {
        String string;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((string = this.interp.tokenString).equals("isHyperstack") || string.equals("isHyperStack")) {
            return this.getImage().isHyperStack() ? 1.0 : 0.0;
        }
        if (string.equals("getDimensions")) {
            this.getDimensions();
            return Double.NaN;
        }
        ImagePlus imagePlus = this.getImage();
        if (string.equals("setPosition")) {
            this.setPosition(imagePlus);
            return Double.NaN;
        }
        if (string.equals("getPosition")) {
            this.getPosition(imagePlus);
            return Double.NaN;
        }
        Calibration calibration = imagePlus.getCalibration();
        if (string.equals("getFrameRate")) {
            this.interp.getParens();
            return calibration.fps;
        }
        if (string.equals("setFrameRate")) {
            calibration.fps = this.getArg();
            return Double.NaN;
        }
        if (string.equals("getFrameInterval")) {
            this.interp.getParens();
            return calibration.frameInterval;
        }
        if (string.equals("setFrameInterval")) {
            calibration.frameInterval = this.getArg();
            return Double.NaN;
        }
        if (string.equals("setTUnit")) {
            calibration.setTimeUnit(this.getStringArg());
            return Double.NaN;
        }
        if (string.equals("setZUnit")) {
            calibration.setZUnit(this.getStringArg());
            return Double.NaN;
        }
        if (string.equals("getUnits")) {
            this.getStackUnits(calibration);
            return Double.NaN;
        }
        if (imagePlus.getStackSize() == 1) {
            this.interp.error("Stack required");
        }
        if (string.equals("setDimensions")) {
            this.setDimensions(imagePlus);
        } else if (string.equals("setChannel")) {
            imagePlus.setPosition((int)this.getArg(), imagePlus.getSlice(), imagePlus.getFrame());
        } else if (string.equals("setSlice")) {
            imagePlus.setPosition(imagePlus.getChannel(), (int)this.getArg(), imagePlus.getFrame());
        } else if (string.equals("setFrame")) {
            imagePlus.setPosition(imagePlus.getChannel(), imagePlus.getSlice(), (int)this.getArg());
        } else if (string.equals("setDisplayMode")) {
            this.setDisplayMode(imagePlus, this.getStringArg());
        } else if (string.equals("getDisplayMode")) {
            this.getDisplayMode(imagePlus);
        } else if (string.equals("setActiveChannels")) {
            this.setActiveChannels(imagePlus, this.getStringArg());
        } else if (string.equals("getActiveChannels")) {
            this.getActiveChannels(imagePlus);
        } else if (string.equals("swap")) {
            this.swapStackImages(imagePlus);
        } else if (string.equals("getStatistics")) {
            this.getStackStatistics(imagePlus, true);
        } else {
            this.interp.error("Unrecognized Stack function");
        }
        return Double.NaN;
    }

    void getStackUnits(Calibration calibration) {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getNextVariable();
        Variable variable5 = this.getLastVariable();
        variable.setString(calibration.getXUnit());
        variable2.setString(calibration.getYUnit());
        variable3.setString(calibration.getZUnit());
        variable4.setString(calibration.getTimeUnit());
        variable5.setString(calibration.getValueUnit());
    }

    void getStackStatistics(ImagePlus imagePlus, boolean bl) {
        Variable variable = this.getFirstVariable();
        Variable variable2 = null;
        Variable variable3 = null;
        Variable variable4 = null;
        Variable variable5 = null;
        Variable variable6 = null;
        int n = 19;
        this.interp.getToken();
        int n2 = 1;
        while (this.interp.token == 44) {
            switch (++n2) {
                case 2: {
                    variable2 = this.getVariable();
                    break;
                }
                case 3: {
                    variable3 = this.getVariable();
                    break;
                }
                case 4: {
                    variable4 = this.getVariable();
                    break;
                }
                case 5: {
                    variable5 = this.getVariable();
                    n += 4;
                    break;
                }
                case 6: {
                    variable6 = this.getArrayVariable();
                    break;
                }
                default: {
                    this.interp.error("')' expected");
                }
            }
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        StackStatistics stackStatistics = new StackStatistics(imagePlus);
        variable.setValue(stackStatistics.pixelCount);
        if (variable2 != null) {
            variable2.setValue(stackStatistics.mean);
        }
        if (variable3 != null) {
            variable3.setValue(stackStatistics.min);
        }
        if (variable4 != null) {
            variable4.setValue(stackStatistics.max);
        }
        if (variable5 != null) {
            variable5.setValue(stackStatistics.stdDev);
        }
        if (variable6 != null) {
            int[] nArray = stackStatistics.histogram;
            int n3 = nArray.length;
            Variable[] variableArray = new Variable[n3];
            int n4 = 255;
            for (int i = 0; i <= n4; ++i) {
                variableArray[i] = new Variable(nArray[i]);
            }
            variable6.setArray(variableArray);
        }
    }

    void setActiveChannels(ImagePlus imagePlus, String string) {
        if (!imagePlus.isComposite()) {
            this.interp.error("Composite image required");
        }
        boolean[] blArray = ((CompositeImage)imagePlus).getActiveChannels();
        for (int i = 0; i < blArray.length; ++i) {
            boolean bl = false;
            if (string.length() > i && string.charAt(i) == '1') {
                bl = true;
            }
            blArray[i] = bl;
        }
        imagePlus.updateAndDraw();
    }

    void getActiveChannels(ImagePlus imagePlus) {
        if (!imagePlus.isComposite()) {
            this.interp.error("Composite image required");
        }
        boolean[] blArray = ((CompositeImage)imagePlus).getActiveChannels();
        int n = blArray.length;
        char[] cArray = new char[n];
        int n2 = imagePlus.getNChannels();
        for (int i = 0; i < n; ++i) {
            cArray[i] = i < n2 ? (blArray[i] ? 49 : 48) : 48;
        }
        Variable variable = this.getVariableArg();
        variable.setString(new String(cArray));
    }

    void setDisplayMode(ImagePlus imagePlus, String string) {
        string = string.toLowerCase(Locale.US);
        if (!imagePlus.isComposite()) {
            this.interp.error("Composite image required");
        }
        int n = -1;
        if (string.equals("composite")) {
            n = 1;
        } else if (string.equals("color")) {
            n = 2;
        } else if (string.startsWith("gray")) {
            n = 3;
        }
        if (n == -1) {
            this.interp.error("Invalid mode");
        }
        ((CompositeImage)imagePlus).setMode(n);
        imagePlus.updateAndDraw();
    }

    void swapStackImages(ImagePlus imagePlus) {
        CompositeImage compositeImage;
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getLastArg();
        ImageStack imageStack = imagePlus.getStack();
        int n3 = imageStack.getSize();
        if (n < 1 || n > n3 || n2 < 1 || n2 > n3) {
            this.interp.error("Argument out of range");
        }
        Object object = imageStack.getPixels(n);
        String string = imageStack.getSliceLabel(n);
        imageStack.setPixels(imageStack.getPixels(n2), n);
        imageStack.setSliceLabel(imageStack.getSliceLabel(n2), n);
        imageStack.setPixels(object, n2);
        imageStack.setSliceLabel(string, n2);
        int n4 = imagePlus.getCurrentSlice();
        if (imagePlus.isComposite() && (compositeImage = (CompositeImage)imagePlus).getMode() == 1) {
            compositeImage.reset();
            imagePlus.updateAndDraw();
            imagePlus.repaintWindow();
            return;
        }
        if (n == n4 || n2 == n4) {
            imagePlus.setStack(null, imageStack);
        }
    }

    void getDisplayMode(ImagePlus imagePlus) {
        Variable variable = this.getVariableArg();
        String string = "";
        if (imagePlus.isComposite()) {
            string = ((CompositeImage)imagePlus).getModeAsString();
        }
        variable.setString(string);
    }

    void getPosition(ImagePlus imagePlus) {
        int n;
        int n2;
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getLastVariable();
        int n3 = imagePlus.getChannel();
        if (n3 * (n2 = imagePlus.getSlice()) * (n = imagePlus.getFrame()) > imagePlus.getStackSize()) {
            n3 = 1;
            n2 = imagePlus.getCurrentSlice();
            n = 1;
        }
        variable.setValue(n3);
        variable2.setValue(n2);
        variable3.setValue(n);
    }

    void setPosition(ImagePlus imagePlus) {
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getNextArg();
        int n3 = (int)this.getLastArg();
        Functions functions = this;
        if (functions.interp.isBatchMode()) {
            imagePlus.setPositionWithoutUpdate(n, n2, n3);
        } else {
            imagePlus.setPosition(n, n2, n3);
        }
    }

    void setDimensions(ImagePlus imagePlus) {
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getNextArg();
        int n3 = (int)this.getLastArg();
        imagePlus.setDimensions(n, n2, n3);
        if (imagePlus.getWindow() == null) {
            imagePlus.setOpenAsHyperStack(true);
        }
    }

    void setTool() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            boolean bl = IJ.setTool(this.getString());
            if (!bl) {
                this.interp.error("Unrecognized tool name");
            }
        } else {
            IJ.setTool((int)this.interp.getExpression());
        }
        this.interp.getRightParen();
    }

    String doToString() {
        String string = this.getFirstString();
        this.interp.getToken();
        if (this.interp.token == 44) {
            double d = Tools.parseDouble(string);
            string = IJ.d2s(d, (int)this.interp.getExpression());
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        return string;
    }

    double matches() {
        String string;
        String string2 = this.getFirstString();
        boolean bl = string2.matches(string = this.getLastString());
        return bl ? 1.0 : 0.0;
    }

    void waitForUser() {
        if (waitForUserDialog != null && waitForUserDialog.isVisible()) {
            this.interp.error("Duplicate call");
        }
        String string = "Action Required";
        String string2 = "   Click \"OK\" to continue     ";
        if (this.interp.nextToken() == 40) {
            string = this.getFirstString();
            if (this.interp.nextToken() == 44) {
                string2 = this.getLastString();
            } else {
                string2 = string;
                string = "Action Required";
                this.interp.getRightParen();
            }
        }
        waitForUserDialog = new WaitForUserDialog(string, string2);
        waitForUserDialog.show();
        if (waitForUserDialog.escPressed()) {
            throw new RuntimeException("Macro canceled");
        }
    }

    void abortDialog() {
        if (waitForUserDialog != null && waitForUserDialog.isVisible()) {
            waitForUserDialog.close();
        }
    }

    double getStringWidth() {
        this.resetImage();
        ImageProcessor imageProcessor = this.getProcessor();
        this.setFont(imageProcessor);
        return imageProcessor.getStringWidth(this.getStringArg());
    }

    String doList() {
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 137 && this.interp.token != 135) {
            this.interp.error("Function name expected: ");
        }
        if (this.props == null) {
            this.props = new Properties();
        }
        String string = null;
        String string2 = this.interp.tokenString;
        if (string2.equals("get")) {
            string = this.props.getProperty(this.getStringArg());
            string = string != null ? string : "";
        } else if (string2.equals("getValue")) {
            string = this.props.getProperty(this.getStringArg());
            if (string == null) {
                this.interp.error("Value not found");
            }
        } else if (string2.equals("set") || string2.equals("add") || string2.equals("put")) {
            this.props.setProperty(this.getFirstString(), this.getLastString());
        } else if (string2.equals("clear") || string2.equals("reset")) {
            this.interp.getParens();
            this.props.clear();
        } else if (string2.equals("setList")) {
            this.setProperties();
        } else if (string2.equals("getList")) {
            string = this.getProperties();
        } else if (string2.equals("size") || string2.equals("getSize")) {
            this.interp.getParens();
            string = "" + this.props.size();
        } else if (string2.equals("setMeasurements")) {
            this.setMeasurements();
        } else if (string2.equals("setCommands")) {
            this.setCommands();
        } else {
            this.interp.error("Unrecognized List function");
        }
        return string;
    }

    void setCommands() {
        this.interp.getParens();
        Hashtable hashtable = Menus.getCommands();
        this.props = new Properties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.props.setProperty(string, (String)hashtable.get(string));
        }
    }

    void setMeasurements() {
        this.interp.getParens();
        this.props.clear();
        ImagePlus imagePlus = this.getImage();
        int n = 1043199;
        ImageStatistics imageStatistics = imagePlus.getStatistics(n);
        ResultsTable resultsTable = new ResultsTable();
        Analyzer analyzer = new Analyzer(imagePlus, n, resultsTable);
        analyzer.saveResults(imageStatistics, imagePlus.getRoi());
        for (int i = 0; i <= resultsTable.getLastColumn(); ++i) {
            if (!resultsTable.columnExists(i)) continue;
            String string = resultsTable.getColumnHeading(i);
            String string2 = "" + resultsTable.getValueAsDouble(i, 0);
            this.props.setProperty(string, string2);
        }
    }

    void setProperties() {
        String string = this.getStringArg();
        this.props.clear();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("utf-8"));
            this.props.load(byteArrayInputStream);
        }
        catch (Exception exception) {
            this.interp.error("" + exception);
        }
    }

    String getProperties() {
        this.interp.getParens();
        String string = this.props.toString();
        string = string.substring(1, string.length() - 1);
        string = string.replaceAll(", ", "\n");
        return string;
    }

    void makePoint() {
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getLastArg();
        IJ.makePoint(n, n2);
        this.resetImage();
    }

    void makeText() {
        boolean bl;
        String string = this.getFirstString();
        int n = (int)this.getNextArg();
        int n2 = (int)this.getLastArg();
        ImagePlus imagePlus = this.getImage();
        Font font = this.font;
        boolean bl2 = bl = font == null;
        if (bl) {
            font = imagePlus.getProcessor().getFont();
        }
        TextRoi textRoi = new TextRoi(n, n2, string, font);
        if (!bl) {
            textRoi.setAntialiased(this.antialiasedText);
        }
        imagePlus.setRoi(textRoi);
    }

    void makeEllipse() {
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            imagePlus.saveRoi();
        }
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        double d3 = this.getNextArg();
        double d4 = this.getNextArg();
        double d5 = this.getLastArg();
        EllipseRoi ellipseRoi = new EllipseRoi(d, d2, d3, d4, d5);
        imagePlus.setRoi(ellipseRoi);
        if (roi != null && ellipseRoi != null) {
            this.updateRoi(ellipseRoi);
        }
        this.resetImage();
    }

    double fit() {
        String string;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 137) {
            this.interp.error("Function name expected: ");
        }
        if (this.props == null) {
            this.props = new Properties();
        }
        if ((string = this.interp.tokenString).equals("doFit")) {
            return this.fitCurve();
        }
        if (string.equals("getEquation")) {
            return this.getEquation();
        }
        if (string.equals("nEquations")) {
            this.interp.getParens();
            return CurveFitter.fitList.length;
        }
        if (string.equals("showDialog")) {
            this.showFitDialog = true;
            return Double.NaN;
        }
        if (string.equals("logResults")) {
            this.logFitResults = true;
            return Double.NaN;
        }
        if (this.fitter == null) {
            this.interp.error("No fit");
        }
        if (string.equals("f")) {
            return this.fitter.f(this.fitter.getParams(), this.getArg());
        }
        if (string.equals("plot")) {
            this.interp.getParens();
            Fitter.plot(this.fitter);
            return Double.NaN;
        }
        if (string.equals("nParams")) {
            this.interp.getParens();
            return this.fitter.getNumParams();
        }
        if (string.equals("p")) {
            int n = (int)this.getArg();
            this.checkIndex(n, 0, this.fitter.getNumParams() - 1);
            double[] dArray = this.fitter.getParams();
            return dArray[n];
        }
        if (string.equals("rSquared")) {
            this.interp.getParens();
            return this.fitter.getRSquared();
        }
        return Double.NaN;
    }

    double fitCurve() {
        Object[] objectArray;
        this.interp.getLeftParen();
        int n = -1;
        String string = null;
        double[] dArray = null;
        if (this.isStringArg()) {
            int n2;
            string = this.getString().toLowerCase(Locale.US);
            objectArray = CurveFitter.fitList;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (!string.equals(objectArray[n2].toLowerCase(Locale.US))) continue;
                n = n2;
                break;
            }
            int n3 = n2 = string.indexOf("y=") != -1 || string.indexOf("y =") != -1 ? 1 : 0;
            if (n == -1 && n2 == 0) {
                this.interp.error("Unrecognized fit");
            }
        } else {
            n = (int)this.interp.getExpression();
        }
        objectArray = this.getNextArray();
        this.interp.getComma();
        double[] dArray2 = this.getNumericArray();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            dArray = this.getNumericArray();
        }
        this.interp.getRightParen();
        if (objectArray.length != dArray2.length) {
            this.interp.error("Arrays not same length");
        }
        if (objectArray.length == 0) {
            this.interp.error("Zero length array");
        }
        this.fitter = new CurveFitter((double[])objectArray, dArray2);
        if (n == -1 && string != null) {
            Interpreter interpreter = Interpreter.getInstance();
            int n4 = this.fitter.doCustomFit(string, dArray, this.showFitDialog);
            Interpreter.instance = interpreter;
            if (n4 == 0) {
                this.interp.error("Invalid custom function");
            }
        } else {
            this.fitter.doFit(n, this.showFitDialog);
        }
        if (this.logFitResults) {
            IJ.log(this.fitter.getResultString());
            this.logFitResults = false;
        }
        this.showFitDialog = false;
        return Double.NaN;
    }

    double getEquation() {
        int n = (int)this.getFirstArg();
        Variable variable = this.getNextVariable();
        Variable variable2 = this.getLastVariable();
        this.checkIndex(n, 0, CurveFitter.fitList.length - 1);
        variable.setString(CurveFitter.fitList[n]);
        variable2.setString(CurveFitter.fList[n]);
        return Double.NaN;
    }

    void setMinAndMax() {
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        int n = 7;
        if (this.interp.nextToken() == 44) {
            n = (int)this.getLastArg();
            if (this.getImage().getBitDepth() != 24) {
                this.interp.error("RGB image required");
            }
        } else {
            this.interp.getRightParen();
        }
        IJ.setMinAndMax(d, d2, n);
        this.resetImage();
    }

    String debug() {
        String string = "break";
        if (this.interp.nextToken() == 40) {
            string = this.getStringArg().toLowerCase(Locale.US);
        } else {
            this.interp.getParens();
        }
        if (this.interp.editor == null && !string.equals("throw") && !string.equals("dump")) {
            Editor editor = Editor.getInstance();
            if (editor == null) {
                this.interp.error("Macro editor not available");
            } else {
                this.interp.setEditor(editor);
            }
        }
        if (string.equals("run")) {
            this.interp.setDebugMode(4);
        } else if (string.equals("break")) {
            this.interp.setDebugMode(1);
        } else if (string.equals("trace")) {
            this.interp.setDebugMode(2);
        } else if (string.indexOf("fast") != -1) {
            this.interp.setDebugMode(3);
        } else if (string.equals("dump")) {
            this.interp.dump();
        } else {
            if (string.indexOf("throw") != -1) {
                throw new IllegalArgumentException();
            }
            this.interp.error("Argument must be 'run', 'break', 'trace', 'fast-trace' or 'dump'");
        }
        IJ.setKeyUp(-1);
        return null;
    }

    Variable[] doArray() {
        String string;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((string = this.interp.tokenString).equals("copy")) {
            return this.copyArray();
        }
        if (string.equals("trim")) {
            return this.trimArray();
        }
        if (string.equals("sort")) {
            return this.sortArray();
        }
        if (string.equals("rankPositions")) {
            return this.getRankPositions();
        }
        if (string.equals("getStatistics")) {
            return this.getArrayStatistics();
        }
        if (string.equals("fill")) {
            return this.fillArray();
        }
        if (string.equals("invert")) {
            return this.invertArray();
        }
        this.interp.error("Unrecognized Array function");
        return null;
    }

    Variable[] copyArray() {
        this.interp.getLeftParen();
        Variable[] variableArray = this.getArray();
        this.interp.getRightParen();
        return this.duplicate(variableArray);
    }

    Variable[] duplicate(Variable[] variableArray) {
        Variable[] variableArray2 = new Variable[variableArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            variableArray2[i] = (Variable)variableArray[i].clone();
        }
        return variableArray2;
    }

    Variable[] trimArray() {
        this.interp.getLeftParen();
        Variable[] variableArray = this.getArray();
        int n = variableArray.length;
        int n2 = (int)this.getLastArg();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n) {
            n2 = n;
        }
        Variable[] variableArray2 = new Variable[n2];
        for (int i = 0; i < n2; ++i) {
            variableArray2[i] = (Variable)variableArray[i].clone();
        }
        return variableArray2;
    }

    Variable[] sortArray() {
        this.interp.getLeftParen();
        Variable[] variableArray = this.getArray();
        this.interp.getRightParen();
        int n = variableArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (variableArray[i].getString() != null) continue;
            ++n2;
        }
        if (n2 == n) {
            int n3;
            double[] dArray = new double[n];
            for (n3 = 0; n3 < n; ++n3) {
                dArray[n3] = variableArray[n3].getValue();
            }
            Arrays.sort(dArray);
            for (n3 = 0; n3 < n; ++n3) {
                variableArray[n3].setValue(dArray[n3]);
            }
        } else if (n2 == 0) {
            int n4;
            String[] stringArray = new String[n];
            for (n4 = 0; n4 < n; ++n4) {
                stringArray[n4] = variableArray[n4].getString();
            }
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            for (n4 = 0; n4 < n; ++n4) {
                variableArray[n4].setString(stringArray[n4]);
            }
        } else {
            this.interp.error("Mixed strings and numbers");
        }
        return variableArray;
    }

    Variable[] getRankPositions() {
        int n;
        Object[] objectArray;
        this.interp.getLeftParen();
        Variable[] variableArray = this.getArray();
        this.interp.getRightParen();
        int n2 = variableArray.length;
        int n3 = 0;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
            if (variableArray[i].getString() != null) continue;
            ++n3;
        }
        if (n3 != n2 && n3 != 0) {
            this.interp.error("Mixed strings and numbers");
            return variableArray;
        }
        Variable[] variableArray2 = new Variable[n2];
        if (n3 == n2) {
            objectArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                objectArray[n] = variableArray[n].getValue();
            }
            Tools.quicksort(objectArray, nArray);
        } else if (n3 == 0) {
            objectArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                objectArray[n] = (double)variableArray[n].getString();
            }
            Tools.quicksort((String[])objectArray, nArray);
        }
        for (int i = 0; i < n2; ++i) {
            variableArray2[i] = new Variable(nArray[i]);
        }
        return variableArray2;
    }

    Variable[] getArrayStatistics() {
        this.interp.getLeftParen();
        Variable[] variableArray = this.getArray();
        Variable variable = this.getNextVariable();
        Variable variable2 = null;
        Variable variable3 = null;
        Variable variable4 = null;
        this.interp.getToken();
        int n = 1;
        while (this.interp.token == 44) {
            switch (++n) {
                case 2: {
                    variable2 = this.getVariable();
                    break;
                }
                case 3: {
                    variable3 = this.getVariable();
                    break;
                }
                case 4: {
                    variable4 = this.getVariable();
                    break;
                }
                default: {
                    this.interp.error("')' expected");
                }
            }
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        int n2 = variableArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n2; ++i) {
            double d5 = variableArray[i].getValue();
            d += d5;
            d2 += d5 * d5;
            if (d5 < d3) {
                d3 = d5;
            }
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        variable.setValue(d3);
        if (variable2 != null) {
            variable2.setValue(d4);
        }
        if (variable3 != null) {
            variable3.setValue(d / (double)n2);
        }
        if (variable4 != null) {
            double d6 = ((double)n2 * d2 - d * d) / (double)n2;
            d6 = Math.sqrt(d6 / ((double)n2 - 1.0));
            variable4.setValue(d6);
        }
        return variableArray;
    }

    Variable[] fillArray() {
        this.interp.getLeftParen();
        Variable[] variableArray = this.getArray();
        double d = this.getLastArg();
        for (int i = 0; i < variableArray.length; ++i) {
            variableArray[i].setValue(d);
        }
        return variableArray;
    }

    Variable[] invertArray() {
        this.interp.getLeftParen();
        Variable[] variableArray = this.getArray();
        this.interp.getRightParen();
        int n = variableArray.length;
        for (int i = 0; i < n / 2; ++i) {
            Variable variable = variableArray[i];
            variableArray[i] = variableArray[n - i - 1];
            variableArray[n - i - 1] = variable;
        }
        return variableArray;
    }

    double charCodeAt() {
        String string = this.getFirstString();
        int n = (int)this.getLastArg();
        this.checkIndex(n, 0, string.length() - 1);
        return string.charAt(n);
    }

    void doWand() {
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getNextArg();
        double d = 0.0;
        String string = null;
        if (this.interp.nextToken() == 44) {
            d = this.getNextArg();
            string = this.getNextString();
        }
        this.interp.getRightParen();
        IJ.doWand(n, n2, d, string);
        this.resetImage();
    }

    String ijCall() {
        String string;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 135) {
            this.interp.error("Function name expected: ");
        }
        if ((string = this.interp.tokenString).equals("pad")) {
            return IJ.pad((int)this.getFirstArg(), (int)this.getLastArg());
        }
        if (string.equals("deleteRows")) {
            IJ.deleteRows((int)this.getFirstArg(), (int)this.getLastArg());
        } else if (string.equals("log")) {
            IJ.log(this.getStringArg());
        } else {
            if (string.equals("freeMemory")) {
                this.interp.getParens();
                return IJ.freeMemory();
            }
            if (string.equals("currentMemory")) {
                this.interp.getParens();
                return "" + IJ.currentMemory();
            }
            if (string.equals("maxMemory")) {
                this.interp.getParens();
                return "" + IJ.maxMemory();
            }
            if (string.equals("getToolName")) {
                this.interp.getParens();
                return "" + IJ.getToolName();
            }
            if (string.equals("redirectErrorMessages")) {
                this.interp.getParens();
                IJ.redirectErrorMessages();
                return null;
            }
            if (string.equals("renameResults")) {
                IJ.renameResults(this.getStringArg());
            } else {
                this.interp.error("Unrecognized IJ function name");
            }
        }
        return null;
    }

    double overlay() {
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 137 && this.interp.token != 134 && this.interp.token != 138) {
            this.interp.error("Function name expected: ");
        }
        String string = this.interp.tokenString;
        ImagePlus imagePlus = this.getImage();
        if (string.equals("lineTo")) {
            return this.overlayLineTo();
        }
        if (string.equals("moveTo")) {
            return this.overlayMoveTo();
        }
        if (string.equals("drawLine")) {
            return this.overlayDrawLine();
        }
        if (string.equals("drawRect")) {
            return this.overlayDrawRectOrEllipse(imagePlus, false);
        }
        if (string.equals("drawEllipse")) {
            return this.overlayDrawRectOrEllipse(imagePlus, true);
        }
        if (string.equals("drawString")) {
            return this.overlayDrawString(imagePlus);
        }
        if (string.equals("add")) {
            return this.addDrawing(imagePlus);
        }
        if (string.equals("show")) {
            return this.showOverlay(imagePlus);
        }
        if (string.equals("hide")) {
            return this.hideOverlay(imagePlus);
        }
        if (string.equals("remove")) {
            return this.removeOverlay(imagePlus);
        }
        if (string.equals("paste")) {
            this.interp.getParens();
            if (this.overlayClipboard == null) {
                this.interp.error("Overlay clipboard empty");
            }
            this.getImage().setOverlay(this.overlayClipboard);
            return Double.NaN;
        }
        Overlay overlay = imagePlus.getOverlay();
        if (overlay == null && string.equals("size")) {
            return 0.0;
        }
        if (overlay == null) {
            this.interp.error("No overlay");
        }
        int n = overlay.size();
        if (string.equals("size") || string.equals("getSize")) {
            return n;
        }
        if (string.equals("copy")) {
            this.interp.getParens();
            this.overlayClipboard = this.getImage().getOverlay();
            return Double.NaN;
        }
        if (string.equals("removeSelection") || string.equals("removeRoi")) {
            int n2 = (int)this.getArg();
            this.checkIndex(n2, 0, n - 1);
            overlay.remove(n2);
            imagePlus.draw();
            return Double.NaN;
        }
        if (string.equals("setPosition")) {
            int n3 = (int)this.getArg();
            if (n > 0) {
                overlay.get(n - 1).setPosition(n3);
            }
            return Double.NaN;
        }
        this.interp.error("Unrecognized function name");
        return Double.NaN;
    }

    double overlayMoveTo() {
        if (this.overlayPath == null) {
            this.overlayPath = new GeneralPath();
        }
        this.interp.getLeftParen();
        float f = (float)this.interp.getExpression();
        this.interp.getComma();
        float f2 = (float)this.interp.getExpression();
        this.interp.getRightParen();
        this.overlayPath.moveTo(f, f2);
        return Double.NaN;
    }

    double overlayLineTo() {
        if (this.overlayPath == null) {
            this.overlayPath = new GeneralPath();
        }
        this.interp.getLeftParen();
        float f = (float)this.interp.getExpression();
        this.interp.getComma();
        float f2 = (float)this.interp.getExpression();
        this.interp.getRightParen();
        this.overlayPath.lineTo(f, f2);
        return Double.NaN;
    }

    double overlayDrawLine() {
        if (this.overlayPath == null) {
            this.overlayPath = new GeneralPath();
        }
        this.interp.getLeftParen();
        float f = (float)this.interp.getExpression();
        this.interp.getComma();
        float f2 = (float)this.interp.getExpression();
        this.interp.getComma();
        float f3 = (float)this.interp.getExpression();
        this.interp.getComma();
        float f4 = (float)this.interp.getExpression();
        this.interp.getRightParen();
        this.overlayPath.moveTo(f, f2);
        this.overlayPath.lineTo(f3, f4);
        return Double.NaN;
    }

    double overlayDrawRectOrEllipse(ImagePlus imagePlus, boolean bl) {
        this.addDrawingToOverlay(imagePlus);
        float f = Math.round(this.getFirstArg());
        float f2 = Math.round(this.getNextArg());
        float f3 = Math.round(this.getNextArg());
        float f4 = Math.round(this.getLastArg());
        RectangularShape rectangularShape = null;
        rectangularShape = bl ? new Ellipse2D.Float(f, f2, f3, f4) : new Rectangle2D.Float(f, f2, f3, f4);
        ShapeRoi shapeRoi = new ShapeRoi(rectangularShape);
        this.addRoi(imagePlus, shapeRoi);
        return Double.NaN;
    }

    double overlayDrawString(ImagePlus imagePlus) {
        boolean bl;
        this.addDrawingToOverlay(imagePlus);
        String string = this.getFirstString();
        int n = (int)this.getNextArg();
        int n2 = (int)this.getLastArg();
        Font font = this.font;
        boolean bl2 = bl = font == null;
        if (bl) {
            font = imagePlus.getProcessor().getFont();
        }
        TextRoi textRoi = new TextRoi(n, n2 - font.getSize(), string, font);
        if (!bl) {
            textRoi.setAntialiased(this.antialiasedText);
        }
        this.addRoi(imagePlus, textRoi);
        return Double.NaN;
    }

    double addDrawing(ImagePlus imagePlus) {
        this.interp.getParens();
        this.addDrawingToOverlay(imagePlus);
        return Double.NaN;
    }

    void addDrawingToOverlay(ImagePlus imagePlus) {
        if (this.overlayPath == null) {
            return;
        }
        ShapeRoi shapeRoi = new ShapeRoi(this.overlayPath);
        this.overlayPath = null;
        this.addRoi(imagePlus, shapeRoi);
    }

    void addRoi(ImagePlus imagePlus, Roi roi) {
        Overlay overlay = imagePlus.getOverlay();
        if (overlay == null) {
            if (this.offscreenOverlay == null) {
                this.offscreenOverlay = new Overlay();
            }
            overlay = this.offscreenOverlay;
        }
        if (this.defaultColor != null) {
            roi.setStrokeColor(this.defaultColor);
        }
        roi.setLineWidth(this.getProcessor().getLineWidth());
        overlay.add(roi);
    }

    double showOverlay(ImagePlus imagePlus) {
        this.interp.getParens();
        this.addDrawingToOverlay(imagePlus);
        if (this.offscreenOverlay != null) {
            imagePlus.setOverlay(this.offscreenOverlay);
            this.offscreenOverlay = null;
        } else {
            IJ.run(imagePlus, "Show Overlay", "");
        }
        return Double.NaN;
    }

    double hideOverlay(ImagePlus imagePlus) {
        this.interp.getParens();
        IJ.run(imagePlus, "Hide Overlay", "");
        return Double.NaN;
    }

    double removeOverlay(ImagePlus imagePlus) {
        this.interp.getParens();
        imagePlus.setOverlay(null);
        this.offscreenOverlay = null;
        return Double.NaN;
    }

    final double selectionContains() {
        int n = (int)Math.round(this.getFirstArg());
        int n2 = (int)Math.round(this.getLastArg());
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        return roi.contains(n, n2) ? 1.0 : 0.0;
    }

    void getDisplayedArea() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas == null) {
            return;
        }
        Rectangle rectangle = imageCanvas.getSrcRect();
        variable.setValue(rectangle.x);
        variable2.setValue(rectangle.y);
        variable3.setValue(rectangle.width);
        variable4.setValue(rectangle.height);
    }

    void toScaled() {
        ImagePlus imagePlus = this.getImage();
        int n = imagePlus.getHeight();
        Calibration calibration = imagePlus.getCalibration();
        this.interp.getLeftParen();
        if (this.isArrayArg()) {
            int n2;
            Variable[] variableArray = this.getArray();
            this.interp.getComma();
            Variable[] variableArray2 = this.getArray();
            this.interp.getRightParen();
            for (n2 = 0; n2 < variableArray.length; ++n2) {
                variableArray[n2].setValue(calibration.getX(variableArray[n2].getValue()));
            }
            for (n2 = 0; n2 < variableArray2.length; ++n2) {
                variableArray2[n2].setValue(calibration.getY(variableArray2[n2].getValue(), n));
            }
        } else {
            boolean bl;
            Variable variable = this.getVariable();
            Variable variable2 = null;
            boolean bl2 = bl = this.interp.nextToken() == 44;
            if (bl) {
                this.interp.getComma();
                variable2 = this.getVariable();
            }
            this.interp.getRightParen();
            double d = variable.getValue();
            if (bl) {
                double d2 = variable2.getValue();
                variable.setValue(calibration.getX(d));
                variable2.setValue(calibration.getY(d2, n));
            } else {
                variable.setValue(d * calibration.pixelWidth);
            }
        }
    }

    void toUnscaled() {
        ImagePlus imagePlus = this.getImage();
        int n = imagePlus.getHeight();
        Calibration calibration = imagePlus.getCalibration();
        this.interp.getLeftParen();
        if (this.isArrayArg()) {
            int n2;
            Variable[] variableArray = this.getArray();
            this.interp.getComma();
            Variable[] variableArray2 = this.getArray();
            this.interp.getRightParen();
            for (n2 = 0; n2 < variableArray.length; ++n2) {
                variableArray[n2].setValue(calibration.getRawX(variableArray[n2].getValue()));
            }
            for (n2 = 0; n2 < variableArray2.length; ++n2) {
                variableArray2[n2].setValue(calibration.getRawY(variableArray2[n2].getValue(), n));
            }
        } else {
            boolean bl;
            Variable variable = this.getVariable();
            Variable variable2 = null;
            boolean bl2 = bl = this.interp.nextToken() == 44;
            if (bl) {
                this.interp.getComma();
                variable2 = this.getVariable();
            }
            this.interp.getRightParen();
            double d = variable.getValue();
            if (bl) {
                double d2 = variable2.getValue();
                variable.setValue(calibration.getRawX(d));
                variable2.setValue(calibration.getRawY(d2, n));
            } else {
                variable.setValue(d / calibration.pixelWidth);
            }
        }
    }
}

