/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.gui.Arrow;
import ij.gui.EllipseRoi;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RoiEncoder {
    static final int HEADER_SIZE = 64;
    static final int HEADER2_SIZE = 64;
    static final int VERSION = 220;
    private String path;
    private OutputStream f;
    private final int polygon = 0;
    private final int rect = 1;
    private final int oval = 2;
    private final int line = 3;
    private final int freeline = 4;
    private final int polyline = 5;
    private final int noRoi = 6;
    private final int freehand = 7;
    private final int traced = 8;
    private final int angle = 9;
    private final int point = 10;
    private byte[] data;
    private String roiName;
    private int roiNameSize;

    public RoiEncoder(String string) {
        this.path = string;
    }

    public RoiEncoder(OutputStream outputStream) {
        this.f = outputStream;
    }

    public void write(Roi roi) throws IOException {
        if (this.f != null) {
            this.write(roi, this.f);
        } else {
            this.f = new FileOutputStream(this.path);
            this.write(roi, this.f);
            this.f.close();
        }
    }

    public static byte[] saveAsByteArray(Roi roi) {
        if (roi == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            RoiEncoder roiEncoder = new RoiEncoder(byteArrayOutputStream);
            roiEncoder.write(roi);
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
        return byArray;
    }

    void write(Roi roi, OutputStream outputStream) throws IOException {
        int n;
        Shape shape;
        int n2 = roi.getType();
        int n3 = 1;
        int n4 = 0;
        this.roiName = roi.getName();
        this.roiNameSize = this.roiName != null ? this.roiName.length() * 2 : 0;
        switch (n2) {
            case 2: {
                n3 = 0;
                break;
            }
            case 3: {
                n3 = 7;
                break;
            }
            case 4: {
                n3 = 8;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            case 5: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 5;
                break;
            }
            case 7: {
                n3 = 4;
                break;
            }
            case 8: {
                n3 = 9;
                break;
            }
            case 9: {
                n3 = 1;
                break;
            }
            case 10: {
                n3 = 10;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        if (n2 == 9) {
            this.saveShapeRoi(roi, n3, outputStream, n4);
            return;
        }
        int n5 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        if (roi instanceof PolygonRoi) {
            shape = ((PolygonRoi)roi).getNonSplineCoordinates();
            n5 = shape.npoints;
            nArray = shape.xpoints;
            nArray2 = shape.ypoints;
        }
        this.data = new byte[128 + n5 * 4 + this.roiNameSize];
        shape = roi.getBounds();
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 220);
        this.data[6] = (byte)n3;
        this.putShort(8, ((Rectangle)shape).y);
        this.putShort(10, ((Rectangle)shape).x);
        this.putShort(12, ((Rectangle)shape).y + ((Rectangle)shape).height);
        this.putShort(14, ((Rectangle)shape).x + ((Rectangle)shape).width);
        this.putShort(16, n5);
        this.putInt(56, roi.getPosition());
        if (n3 == 1 && (n = roi.getCornerDiameter()) > 0) {
            this.putShort(54, n);
        }
        if (roi instanceof Line) {
            Line line = (Line)roi;
            this.putFloat(18, line.x1);
            this.putFloat(22, line.y1);
            this.putFloat(26, line.x2);
            this.putFloat(30, line.y2);
            if (roi instanceof Arrow) {
                this.putShort(48, 2);
                if (((Arrow)roi).getDoubleHeaded()) {
                    n4 |= 2;
                }
                if (((Arrow)roi).getOutline()) {
                    n4 |= 4;
                }
                this.putShort(50, n4);
                this.putByte(52, ((Arrow)roi).getStyle());
                this.putByte(53, (int)((Arrow)roi).getHeadSize());
            }
        }
        if (roi instanceof EllipseRoi) {
            this.putShort(48, 3);
            double[] dArray = ((EllipseRoi)roi).getParams();
            this.putFloat(18, (float)dArray[0]);
            this.putFloat(22, (float)dArray[1]);
            this.putFloat(26, (float)dArray[2]);
            this.putFloat(30, (float)dArray[3]);
            this.putFloat(52, (float)dArray[4]);
        }
        this.saveStrokeWidthAndColor(roi);
        if (roi instanceof PolygonRoi && ((PolygonRoi)roi).isSplineFit()) {
            this.putShort(50, n4 |= 1);
        }
        if (n5 == 0 && roi instanceof TextRoi) {
            this.saveTextRoi((TextRoi)roi);
        } else {
            this.putHeader2(roi, 64 + n5 * 4);
        }
        if (n5 > 0) {
            n = 64;
            int n6 = n + 2 * n5;
            for (int i = 0; i < n5; ++i) {
                this.putShort(n + i * 2, nArray[i]);
                this.putShort(n6 + i * 2, nArray2[i]);
            }
        }
        this.saveOverlayOptions(roi, n4);
        outputStream.write(this.data);
    }

    void saveStrokeWidthAndColor(Roi roi) {
        Color color;
        Color color2;
        BasicStroke basicStroke = roi.getStroke();
        if (basicStroke != null) {
            this.putShort(34, (int)basicStroke.getLineWidth());
        }
        if ((color2 = roi.getStrokeColor()) != null) {
            this.putInt(40, color2.getRGB());
        }
        if ((color = roi.getFillColor()) != null) {
            this.putInt(44, color.getRGB());
        }
    }

    void saveShapeRoi(Roi roi, int n, OutputStream outputStream, int n2) throws IOException {
        int n3;
        float[] fArray = ((ShapeRoi)roi).getShapeAsArray();
        if (fArray == null) {
            return;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        Rectangle rectangle = roi.getBounds();
        this.data = new byte[128 + fArray.length * 4 + this.roiNameSize];
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 220);
        this.data[6] = (byte)n;
        this.putShort(8, rectangle.y);
        this.putShort(10, rectangle.x);
        this.putShort(12, rectangle.y + rectangle.height);
        this.putShort(14, rectangle.x + rectangle.width);
        this.putInt(56, roi.getPosition());
        this.putInt(36, fArray.length);
        this.saveStrokeWidthAndColor(roi);
        this.saveOverlayOptions(roi, n2);
        int n4 = 64;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            this.putFloat(n4, fArray[n3]);
            n4 += 4;
        }
        n3 = 64 + fArray.length * 4;
        this.putHeader2(roi, n3);
        bufferedOutputStream.write(this.data, 0, this.data.length);
        bufferedOutputStream.flush();
    }

    void saveOverlayOptions(Roi roi, int n) {
        Font font;
        Overlay overlay = roi.getPrototypeOverlay();
        if (overlay.getDrawLabels()) {
            n |= 8;
        }
        if (overlay.getDrawNames()) {
            n |= 0x10;
        }
        if (overlay.getDrawBackgrounds()) {
            n |= 0x20;
        }
        if ((font = overlay.getLabelFont()) != null && font.getStyle() == 1) {
            n |= 0x40;
        }
        this.putShort(50, n);
    }

    void saveTextRoi(TextRoi textRoi) {
        int n;
        Font font = textRoi.getCurrentFont();
        String string = font.getName();
        int n2 = font.getSize();
        int n3 = font.getStyle();
        String string2 = textRoi.getText();
        int n4 = string.length();
        int n5 = string2.length();
        int n6 = 16 + n4 * 2 + n5 * 2;
        byte[] byArray = new byte[128 + n6 + this.roiNameSize];
        System.arraycopy(this.data, 0, byArray, 0, 64);
        this.data = byArray;
        this.putShort(48, 1);
        this.putInt(64, n2);
        this.putInt(68, n3);
        this.putInt(72, n4);
        this.putInt(76, n5);
        for (n = 0; n < n4; ++n) {
            this.putShort(80 + n * 2, string.charAt(n));
        }
        for (n = 0; n < n5; ++n) {
            this.putShort(80 + n4 * 2 + n * 2, string2.charAt(n));
        }
        n = 64 + n6;
        this.putHeader2(textRoi, n);
    }

    void putHeader2(Roi roi, int n) {
        Font font;
        this.putInt(60, n);
        this.putInt(n + 4, roi.getCPosition());
        this.putInt(n + 8, roi.getZPosition());
        this.putInt(n + 12, roi.getTPosition());
        Overlay overlay = roi.getPrototypeOverlay();
        Color color = overlay.getLabelColor();
        if (color != null) {
            this.putInt(n + 24, color.getRGB());
        }
        if ((font = overlay.getLabelFont()) != null) {
            this.putShort(n + 28, font.getSize());
        }
        if (this.roiNameSize > 0) {
            this.putName(roi, n);
        }
    }

    void putName(Roi roi, int n) {
        int n2 = n + 64;
        int n3 = this.roiNameSize / 2;
        this.putInt(n + 16, n2);
        this.putInt(n + 20, n3);
        for (int i = 0; i < n3; ++i) {
            this.putShort(n2 + i * 2, this.roiName.charAt(i));
        }
    }

    void putByte(int n, int n2) {
        this.data[n] = (byte)n2;
    }

    void putShort(int n, int n2) {
        this.data[n] = (byte)(n2 >>> 8);
        this.data[n + 1] = (byte)n2;
    }

    void putFloat(int n, float f) {
        int n2 = Float.floatToIntBits(f);
        this.data[n] = (byte)(n2 >> 24);
        this.data[n + 1] = (byte)(n2 >> 16);
        this.data[n + 2] = (byte)(n2 >> 8);
        this.data[n + 3] = (byte)n2;
    }

    void putInt(int n, int n2) {
        this.data[n] = (byte)(n2 >> 24);
        this.data[n + 1] = (byte)(n2 >> 16);
        this.data[n + 2] = (byte)(n2 >> 8);
        this.data[n + 3] = (byte)n2;
    }
}

