/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.ImageReader;
import ij.io.OpenDialog;
import ij.io.PluginInstaller;
import ij.io.RandomAccessStream;
import ij.io.RoiDecoder;
import ij.io.TiffDecoder;
import ij.measure.ResultsTable;
import ij.plugin.AVI_Reader;
import ij.plugin.DICOM;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;

public class Opener {
    public static final int UNKNOWN = 0;
    public static final int TIFF = 1;
    public static final int DICOM = 2;
    public static final int FITS = 3;
    public static final int PGM = 4;
    public static final int JPEG = 5;
    public static final int GIF = 6;
    public static final int LUT = 7;
    public static final int BMP = 8;
    public static final int ZIP = 9;
    public static final int JAVA_OR_TEXT = 10;
    public static final int ROI = 11;
    public static final int TEXT = 12;
    public static final int PNG = 13;
    public static final int TIFF_AND_DICOM = 14;
    public static final int CUSTOM = 15;
    public static final int AVI = 16;
    public static final int OJJ = 17;
    public static final int TABLE = 18;
    public static final String[] types = new String[]{"unknown", "tif", "dcm", "fits", "pgm", "jpg", "gif", "lut", "bmp", "zip", "java/txt", "roi", "txt", "png", "t&d", "custom", "ojj", "table"};
    private static String defaultDirectory = null;
    private static int fileType;
    private boolean error;
    private boolean isRGB48;
    private boolean silentMode;
    private String omDirectory;
    private File[] omFiles;
    private static boolean openUsingPlugins;
    private static boolean bioformats;

    public void open() {
        OpenDialog openDialog = new OpenDialog("Open", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 != null) {
            String string3 = string + string2;
            this.error = false;
            this.open(string3);
            if (!this.error) {
                Menus.addOpenRecentItem(string3);
            }
        }
    }

    public void openMultiple() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    int n;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setMultiSelectionEnabled(true);
                    File file = null;
                    String string = OpenDialog.getDefaultDirectory();
                    if (string != null) {
                        file = new File(string);
                    }
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    if ((n = jFileChooser.showOpenDialog(IJ.getInstance())) != 0) {
                        return;
                    }
                    Opener.access$002(Opener.this, jFileChooser.getSelectedFiles());
                    if (Opener.this.omFiles.length == 0) {
                        Opener.access$002(Opener.this, new File[1]);
                        ((Opener)Opener.this).omFiles[0] = jFileChooser.getSelectedFile();
                    }
                    Opener.this.omDirectory = jFileChooser.getCurrentDirectory().getPath() + File.separator;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.omDirectory == null) {
            return;
        }
        OpenDialog.setDefaultDirectory(this.omDirectory);
        for (int i = 0; i < this.omFiles.length; ++i) {
            String string = this.omDirectory + this.omFiles[i].getName();
            this.open(string);
            if (i == 0 && Recorder.record) {
                Recorder.recordPath("open", string);
            }
            if (i != 0 || this.error) continue;
            Menus.addOpenRecentItem(string);
        }
    }

    public void open(String string) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = string.indexOf("://") > 0;
        if (bl2 && this.isText(string)) {
            this.openTextURL(string);
            return;
        }
        if (string.endsWith(".jar") || string.endsWith(".class")) {
            new PluginInstaller().install(string);
            return;
        }
        boolean bl4 = bl = string.startsWith("/") || string.startsWith("\\") || string.indexOf(":\\") == 1 || bl2;
        if (!bl) {
            String string2 = OpenDialog.getDefaultDirectory();
            string = string2 != null ? string2 + string : new File(string).getAbsolutePath();
        }
        if (!this.silentMode) {
            IJ.showStatus("Opening: " + string);
        }
        long l = System.currentTimeMillis();
        ImagePlus imagePlus = this.openImage(string);
        if (imagePlus == null && bl2) {
            return;
        }
        if (imagePlus != null) {
            WindowManager.checkForDuplicateName = true;
            if (this.isRGB48) {
                this.openRGB48(imagePlus);
            } else {
                imagePlus.show(IJ.d2s((double)(System.currentTimeMillis() - l) / 1000.0, 3) + " seconds");
            }
        } else {
            switch (fileType) {
                case 7: {
                    imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.LutLoader", string);
                    if (imagePlus.getWidth() == 0) break;
                    imagePlus.show();
                    break;
                }
                case 11: {
                    IJ.runPlugIn("ij.plugin.RoiReader", string);
                    break;
                }
                case 10: 
                case 12: {
                    Object object;
                    if (IJ.altKeyDown()) {
                        new TextWindow(string, 400, 450);
                        IJ.setKeyUp(18);
                        break;
                    }
                    if (IJ.runPlugIn("fiji.scripting.Script_Editor", string) != null) break;
                    File file = new File(string);
                    int n = 250000;
                    long l2 = file.length();
                    if (l2 >= 28000L && (((String)(object = System.getProperty("os.name"))).equals("Windows 95") || ((String)object).equals("Windows 98") || ((String)object).equals("Windows Me"))) {
                        n = 60000;
                    }
                    if (l2 < (long)n) {
                        object = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
                        if (object == null) break;
                        ((Editor)object).open(this.getDir(string), this.getName(string));
                        break;
                    }
                    new TextWindow(string, 400, 450);
                    break;
                }
                case 17: {
                    IJ.runPlugIn("ObjectJ_", string);
                    break;
                }
                case 18: {
                    Opener.openResultsTable(string);
                    break;
                }
                case 0: {
                    String string3 = "File is not in a supported format, a reader\nplugin is not available, or it was not found.";
                    if (string != null) {
                        if (string.length() > 64) {
                            string = new File(string).getName();
                        }
                        if (string.length() <= 64) {
                            string3 = IJ.redirectingErrorMessages() ? string3 + " \n   " + string : string3 + " \n\t \n" + string;
                        }
                    }
                    if (openUsingPlugins) {
                        string3 = string3 + "\n \nNOTE: The \"OpenUsingPlugins\" option is set.";
                    }
                    IJ.wait(IJ.isMacro() ? 500 : 100);
                    IJ.error("Opener", string3);
                    this.error = true;
                }
            }
        }
    }

    private boolean isText(String string) {
        int n;
        if (string.endsWith(".txt") || string.endsWith(".ijm") || string.endsWith(".java") || string.endsWith(".js") || string.endsWith(".html") || string.endsWith(".htm") || string.endsWith("/")) {
            return true;
        }
        int n2 = string.lastIndexOf("/");
        if (n2 == -1) {
            n2 = 0;
        }
        return (n = string.lastIndexOf(".")) == -1 || n < n2 || string.length() - n > 6;
    }

    public boolean openAndAddToRecent(String string) {
        this.open(string);
        if (!this.error) {
            Menus.addOpenRecentItem(string);
        }
        return this.error;
    }

    public ImagePlus openImage(String string, String string2) {
        FileOpener.setSilentMode(this.silentMode);
        if (string.length() > 0 && !string.endsWith("/") && !string.endsWith("\\")) {
            string = string + Prefs.separator;
        }
        String string3 = string + string2;
        fileType = this.getFileType(string3);
        if (IJ.debugMode) {
            IJ.log("openImage: \"" + types[fileType] + "\", " + string3);
        }
        switch (fileType) {
            case 1: {
                ImagePlus imagePlus = this.openTiff(string, string2);
                return imagePlus;
            }
            case 2: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 14: {
                ImagePlus imagePlus = this.openTiff(string, string2);
                ImagePlus imagePlus2 = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", string3);
                if (imagePlus != null) {
                    imagePlus.setProperty("Info", imagePlus2.getProperty("Info"));
                }
                return imagePlus;
            }
            case 3: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.FITS_Reader", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 4: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.PGM_Reader", string3);
                if (imagePlus.getWidth() != 0) {
                    if (imagePlus.getStackSize() == 3 && imagePlus.getBitDepth() == 16) {
                        imagePlus = new CompositeImage(imagePlus, 1);
                    }
                    return imagePlus;
                }
                return null;
            }
            case 5: 
            case 6: {
                ImagePlus imagePlus = this.openJpegOrGif(string, string2);
                if (imagePlus != null && imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 13: {
                ImagePlus imagePlus = this.openUsingImageIO(string + string2);
                if (imagePlus != null && imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 8: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP_Reader", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 9: {
                return this.openZip(string3);
            }
            case 16: {
                AVI_Reader aVI_Reader = (AVI_Reader)IJ.runPlugIn("ij.plugin.AVI_Reader", string3);
                return aVI_Reader.getImagePlus();
            }
            case 0: 
            case 12: {
                int[] nArray = new int[]{fileType};
                ImagePlus imagePlus = this.openWithHandleExtraFileTypes(string3, nArray);
                fileType = nArray[0];
                return imagePlus;
            }
        }
        return null;
    }

    public ImagePlus openImage(String string) {
        if (string == null || string.equals("")) {
            string = this.getPath();
        }
        if (string == null) {
            return null;
        }
        ImagePlus imagePlus = null;
        imagePlus = string.indexOf("://") > 0 ? this.openURL(string) : this.openImage(this.getDir(string), this.getName(string));
        return imagePlus;
    }

    public ImagePlus openImage(String string, int n) {
        if (string == null || string.equals("")) {
            string = this.getPath();
        }
        if (string == null) {
            return null;
        }
        int n2 = this.getFileType(string);
        if (n2 != 1) {
            throw new IllegalArgumentException("TIFF file require");
        }
        return this.openTiff(string, n);
    }

    String getPath() {
        OpenDialog openDialog = new OpenDialog("Open", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return null;
        }
        return string + string2;
    }

    public ImagePlus openURL(String string) {
        try {
            String string2 = "";
            int n = string.lastIndexOf(47);
            if (n == -1) {
                n = string.lastIndexOf(92);
            }
            if (n <= 0) {
                throw new MalformedURLException("Invalid URL: " + string);
            }
            string2 = string.substring(n + 1);
            if (string.indexOf(" ") != -1) {
                string = string.replaceAll(" ", "%20");
            }
            URL uRL = new URL(string);
            IJ.showStatus("" + string);
            String string3 = string.toLowerCase(Locale.US);
            ImagePlus imagePlus = null;
            if (string3.endsWith(".tif")) {
                imagePlus = this.openTiff(uRL.openStream(), string2);
            } else if (string3.endsWith(".zip")) {
                imagePlus = this.openZipUsingUrl(uRL);
            } else if (string3.endsWith(".jpg") || string3.endsWith(".gif")) {
                imagePlus = this.openJpegOrGifUsingURL(string2, uRL);
            } else if (string3.endsWith(".dcm") || string3.endsWith(".ima")) {
                imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", string);
                if (imagePlus != null && imagePlus.getWidth() == 0) {
                    imagePlus = null;
                }
            } else {
                URLConnection uRLConnection;
                String string4;
                imagePlus = string3.endsWith(".png") ? this.openPngUsingURL(string2, uRL) : ((string4 = (uRLConnection = uRL.openConnection()).getContentType()) != null && (string4.equals("image/jpeg") || string4.equals("image/gif")) ? this.openJpegOrGifUsingURL(string2, uRL) : (string4 != null && string4.equals("image/png") ? this.openPngUsingURL(string2, uRL) : this.openWithHandleExtraFileTypes(string, new int[]{0})));
            }
            IJ.showStatus("");
            return imagePlus;
        }
        catch (Exception exception) {
            String string5 = exception.getMessage();
            if (string5 == null || string5.equals("")) {
                string5 = "" + exception;
            }
            IJ.error("Open URL", string5 + "\n \n" + string);
            return null;
        }
    }

    void openTextURL(String string) {
        int n;
        if (string.endsWith(".pdf") || string.endsWith(".zip")) {
            return;
        }
        String string2 = IJ.openUrlAsString(string);
        String string3 = string.substring(7);
        int n2 = string3.lastIndexOf("/");
        if (n2 == (n = string3.length()) - 1) {
            string3 = string3.substring(0, n - 1);
        } else if (n2 != -1 && n2 < n - 1) {
            string3 = string3.substring(n2 + 1);
        }
        string3 = string3.replaceAll("%20", " ");
        Editor editor = new Editor();
        editor.setSize(600, 300);
        editor.create(string3, string2);
        IJ.showStatus("");
    }

    public ImagePlus openWithHandleExtraFileTypes(String string, int[] nArray) {
        ImagePlus imagePlus = null;
        if (string.endsWith(".db")) {
            nArray[0] = 15;
            return null;
        }
        imagePlus = (ImagePlus)IJ.runPlugIn("HandleExtraFileTypes", string);
        if (imagePlus == null) {
            return null;
        }
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        if (fileInfo == null) {
            fileInfo = new FileInfo();
            fileInfo.width = imagePlus.getWidth();
            fileInfo.height = imagePlus.getHeight();
            fileInfo.directory = this.getDir(string);
            fileInfo.fileName = this.getName(string);
            imagePlus.setFileInfo(fileInfo);
        }
        if (imagePlus.getWidth() > 0 && imagePlus.getHeight() > 0) {
            nArray[0] = 15;
            return imagePlus;
        }
        if (imagePlus.getWidth() == -1) {
            nArray[0] = 15;
        }
        return null;
    }

    ImagePlus openZipUsingUrl(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null) {
            return null;
        }
        String string = zipEntry.getName();
        if (!string.endsWith(".tif") && !string.endsWith(".dcm")) {
            throw new IOException("This ZIP archive does not appear to contain a .tif or .dcm file\n" + string);
        }
        if (string.endsWith(".dcm")) {
            return this.openDicomStack(zipInputStream, zipEntry);
        }
        return this.openTiff(zipInputStream, string);
    }

    ImagePlus openDicomStack(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        ImagePlus imagePlus = null;
        int n = 0;
        ImageStack imageStack = null;
        while (true) {
            Object object;
            Object object2;
            if (n > 0) {
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry == null) break;
            String string = zipEntry.getName();
            ImagePlus imagePlus2 = null;
            if (string.endsWith(".dcm")) {
                int n2;
                object2 = new ByteArrayOutputStream();
                object = new byte[4096];
                int n3 = 0;
                boolean bl = false;
                while ((n2 = zipInputStream.read((byte[])object)) >= 0) {
                    ((ByteArrayOutputStream)object2).write((byte[])object, 0, n2);
                    n3 += n2;
                }
                byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
                ((ByteArrayOutputStream)object2).close();
                DICOM dICOM = new DICOM(new ByteArrayInputStream(byArray));
                dICOM.run(string);
                imagePlus2 = dICOM;
            }
            zipInputStream.closeEntry();
            if (imagePlus2 == null) continue;
            ++n;
            object2 = imagePlus2.getTitle();
            object = (String)imagePlus2.getProperty("Info");
            if (object != null) {
                object2 = (String)object2 + "\n" + (String)object;
            }
            if (n == 1) {
                imagePlus = imagePlus2;
                imagePlus.getStack().setSliceLabel((String)object2, 1);
                continue;
            }
            imageStack = imagePlus.getStack();
            imageStack.addSlice((String)object2, imagePlus2.getProcessor());
            imagePlus.setStack(imageStack);
        }
        zipInputStream.close();
        IJ.showProgress(1.0);
        if (n == 0) {
            throw new IOException("This ZIP archive does not appear to contain any .dcm files");
        }
        return imagePlus;
    }

    ImagePlus openJpegOrGifUsingURL(String string, URL uRL) {
        if (uRL == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        if (image != null) {
            ImagePlus imagePlus = new ImagePlus(string, image);
            return imagePlus;
        }
        return null;
    }

    ImagePlus openPngUsingURL(String string, URL uRL) {
        if (uRL == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            IJ.log("" + iOException);
        }
        if (bufferedImage != null) {
            ImagePlus imagePlus = new ImagePlus(string, bufferedImage);
            return imagePlus;
        }
        return null;
    }

    ImagePlus openJpegOrGif(String string, String string2) {
        ImagePlus imagePlus = null;
        Image image = Toolkit.getDefaultToolkit().createImage(string + string2);
        if (image != null) {
            try {
                imagePlus = new ImagePlus(string2, image);
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
            if (imagePlus.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imagePlus);
            }
            FileInfo fileInfo = new FileInfo();
            fileInfo.fileFormat = 3;
            fileInfo.fileName = string2;
            fileInfo.directory = string;
            imagePlus.setFileInfo(fileInfo);
        }
        return imagePlus;
    }

    ImagePlus openUsingImageIO(String string) {
        ImagePlus imagePlus = null;
        BufferedImage bufferedImage = null;
        File file = new File(string);
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (Exception exception) {
            IJ.error("Open Using ImageIO", "" + exception);
        }
        if (bufferedImage == null) {
            return null;
        }
        imagePlus = new ImagePlus(file.getName(), bufferedImage);
        FileInfo fileInfo = new FileInfo();
        fileInfo.fileFormat = 9;
        fileInfo.fileName = file.getName();
        fileInfo.directory = file.getParent() + File.separator;
        imagePlus.setFileInfo(fileInfo);
        return imagePlus;
    }

    public static void convertGrayJpegTo8Bits(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int[] nArray = (int[])imageProcessor.getPixels();
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[n3 + j];
                int n5 = (n4 & 0xFF0000) >> 16;
                int n6 = (n4 & 0xFF00) >> 8;
                int n7 = n4 & 0xFF;
                if (n5 == n6 && n6 == n7) continue;
                return;
            }
        }
        IJ.showStatus("Converting to 8-bit grayscale");
        new ImageConverter(imagePlus).convertToGray8();
    }

    boolean allSameSizeAndType(FileInfo[] fileInfoArray) {
        boolean bl = true;
        boolean bl2 = true;
        long l = fileInfoArray[0].getOffset();
        int n = fileInfoArray[0].width * fileInfoArray[0].height * fileInfoArray[0].getBytesPerPixel();
        for (int i = 1; i < fileInfoArray.length; ++i) {
            bl &= fileInfoArray[i].fileType == fileInfoArray[0].fileType && fileInfoArray[i].width == fileInfoArray[0].width && fileInfoArray[i].height == fileInfoArray[0].height;
            bl2 &= fileInfoArray[i].getOffset() == l + (long)(i * n);
        }
        if (bl2 && fileInfoArray[0].fileType != 12) {
            fileInfoArray[0].nImages = fileInfoArray.length;
        }
        return bl;
    }

    public ImagePlus openTiffStack(FileInfo[] fileInfoArray) {
        Object object;
        if (fileInfoArray.length > 1 && !this.allSameSizeAndType(fileInfoArray)) {
            return null;
        }
        FileInfo fileInfo = fileInfoArray[0];
        if (fileInfo.nImages > 1) {
            return new FileOpener(fileInfo).open(false);
        }
        ColorModel colorModel = this.createColorModel(fileInfo);
        ImageStack imageStack = new ImageStack(fileInfo.width, fileInfo.height, colorModel);
        Object object2 = null;
        long l = fileInfo.getOffset();
        int n = fileInfo.width * fileInfo.height * fileInfo.getBytesPerPixel();
        if (fileInfoArray[0].fileType == 13 && ((n = (int)((double)(fileInfo.width * fileInfo.height) * 1.5)) & 1) == 1) {
            ++n;
        }
        if (fileInfoArray[0].fileType == 8) {
            int n2 = (int)Math.ceil((double)fileInfo.width / 8.0);
            n = n2 * fileInfo.height;
        }
        long l2 = 0L;
        int n3 = 1;
        try {
            object = this.createInputStream(fileInfo);
            ImageReader imageReader = new ImageReader(fileInfo);
            IJ.resetEscape();
            for (int i = 0; i < fileInfoArray.length; ++i) {
                int n4;
                n3 = 1;
                Object[] objectArray = null;
                if (!this.silentMode) {
                    IJ.showStatus("Reading: " + (i + 1) + "/" + fileInfoArray.length);
                }
                if (IJ.escapePressed()) {
                    IJ.beep();
                    IJ.showProgress(1.0);
                    return null;
                }
                if (fileInfoArray[i].compression >= 2) {
                    fileInfo.stripOffsets = fileInfoArray[i].stripOffsets;
                    fileInfo.stripLengths = fileInfoArray[i].stripLengths;
                }
                if (fileInfoArray[i].samplesPerPixel > 1 && fileInfoArray[i].getBytesPerPixel() != 3 && fileInfoArray[i].getBytesPerPixel() != 6) {
                    n3 = fileInfo.samplesPerPixel;
                    objectArray = new Object[n3];
                    for (n4 = 0; n4 < n3; ++n4) {
                        objectArray[n4] = object2 = imageReader.readPixels((InputStream)object, n4 == 0 ? l : 0L);
                    }
                } else {
                    object2 = imageReader.readPixels((InputStream)object, l);
                }
                if (object2 == null && objectArray == null) break;
                l2 += (long)(n * n3) + l;
                if (i < fileInfoArray.length - 1) {
                    l = fileInfoArray[i + 1].getOffset() - l2;
                    if (fileInfoArray[i + 1].compression >= 2) {
                        l = 0L;
                    }
                    if (l < 0L) {
                        IJ.error("Opener", "Unexpected image offset");
                        break;
                    }
                }
                if (fileInfo.fileType == 12) {
                    Object[] objectArray2 = (Object[])object2;
                    imageStack.addSlice(null, objectArray2[0]);
                    imageStack.addSlice(null, objectArray2[1]);
                    imageStack.addSlice(null, objectArray2[2]);
                    this.isRGB48 = true;
                } else if (n3 > 1) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (objectArray[n4] == null) continue;
                        imageStack.addSlice(null, objectArray[n4]);
                    }
                } else {
                    imageStack.addSlice(null, object2);
                }
                IJ.showProgress(i, fileInfoArray.length);
            }
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            IJ.handleException(exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory(fileInfo.fileName);
            imageStack.deleteLastSlice();
            imageStack.deleteLastSlice();
        }
        IJ.showProgress(1.0);
        if (imageStack.getSize() == 0) {
            return null;
        }
        if (fileInfo.fileType == 2 || fileInfo.fileType == 13 || fileInfo.fileType == 4 || fileInfo.fileType == 12) {
            object = imageStack.getProcessor(1);
            ((ImageProcessor)object).resetMinAndMax();
            imageStack.update((ImageProcessor)object);
        }
        object = new ImagePlus(fileInfo.fileName, imageStack);
        new FileOpener(fileInfo).setCalibration((ImagePlus)object);
        ((ImagePlus)object).setFileInfo(fileInfo);
        int n5 = imageStack.getSize();
        if (n3 > 1 && n5 % n3 == 0) {
            ((ImagePlus)object).setDimensions(n3, n5 / n3, 1);
            object = new CompositeImage((ImagePlus)object, 1);
            ((ImagePlus)object).setOpenAsHyperStack(true);
        }
        IJ.showProgress(1.0);
        return object;
    }

    public ImagePlus openTiff(String string, String string2) {
        TiffDecoder tiffDecoder = new TiffDecoder(string, string2);
        if (IJ.debugMode) {
            tiffDecoder.enableDebugging();
        }
        FileInfo[] fileInfoArray = null;
        try {
            fileInfoArray = tiffDecoder.getTiffInfo();
        }
        catch (IOException iOException) {
            String string3 = iOException.getMessage();
            if (string3 == null || string3.equals("")) {
                string3 = "" + iOException;
            }
            IJ.error("TiffDecoder", string3);
            return null;
        }
        if (fileInfoArray == null) {
            return null;
        }
        return this.openTiff2(fileInfoArray);
    }

    public ImagePlus openTiff(String string, int n) {
        TiffDecoder tiffDecoder = new TiffDecoder(this.getDir(string), this.getName(string));
        if (IJ.debugMode) {
            tiffDecoder.enableDebugging();
        }
        FileInfo[] fileInfoArray = null;
        try {
            fileInfoArray = tiffDecoder.getTiffInfo();
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            if (string2 == null || string2.equals("")) {
                string2 = "" + iOException;
            }
            IJ.error("TiffDecoder", string2);
            return null;
        }
        if (fileInfoArray == null) {
            return null;
        }
        FileInfo fileInfo = fileInfoArray[0];
        if (fileInfoArray.length == 1 && fileInfo.nImages > 1) {
            if (n < 1 || n > fileInfo.nImages) {
                throw new IllegalArgumentException("N out of 1-" + fileInfo.nImages + " range");
            }
            long l = fileInfo.width * fileInfo.height * fileInfo.getBytesPerPixel();
            fileInfo.longOffset = fileInfo.getOffset() + (long)(n - 1) * (l + (long)fileInfo.gapBetweenImages);
            fileInfo.offset = 0;
            fileInfo.nImages = 1;
        } else {
            if (n < 1 || n > fileInfoArray.length) {
                throw new IllegalArgumentException("N out of 1-" + fileInfoArray.length + " range");
            }
            fileInfo.longOffset = fileInfoArray[n - 1].getOffset();
            fileInfo.offset = 0;
            fileInfo.stripOffsets = fileInfoArray[n - 1].stripOffsets;
            fileInfo.stripLengths = fileInfoArray[n - 1].stripLengths;
        }
        FileOpener fileOpener = new FileOpener(fileInfo);
        return fileOpener.open(false);
    }

    public ImagePlus openTiff(InputStream inputStream, String string) {
        FileInfo[] fileInfoArray = null;
        try {
            TiffDecoder tiffDecoder = new TiffDecoder(inputStream, string);
            if (IJ.debugMode) {
                tiffDecoder.enableDebugging();
            }
            fileInfoArray = tiffDecoder.getTiffInfo();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IJ.error("TiffDecoder", "File not found: " + fileNotFoundException.getMessage());
            return null;
        }
        catch (Exception exception) {
            IJ.error("TiffDecoder", "" + exception);
            return null;
        }
        return this.openTiff2(fileInfoArray);
    }

    public ImagePlus openZip(String string) {
        Cloneable cloneable;
        Object object;
        ImagePlus imagePlus;
        block8: {
            imagePlus = null;
            try {
                object = new ZipInputStream(new FileInputStream(string));
                if (object == null) {
                    return null;
                }
                cloneable = ((ZipInputStream)object).getNextEntry();
                if (cloneable == null) {
                    return null;
                }
                String string2 = cloneable.getName();
                if (string2.endsWith(".roi")) {
                    ((ZipInputStream)object).close();
                    if (!this.silentMode) {
                        IJ.runMacro("roiManager(\"Open\", getArgument());", string);
                    }
                    return null;
                }
                if (string2.endsWith(".tif")) {
                    imagePlus = this.openTiff((InputStream)object, string2);
                    break block8;
                }
                if (string2.endsWith(".dcm")) {
                    DICOM dICOM = new DICOM((InputStream)object);
                    dICOM.run(string2);
                    imagePlus = dICOM;
                    break block8;
                }
                ((ZipInputStream)object).close();
                IJ.error("This ZIP archive does not appear to contain a \nTIFF (\".tif\") or DICOM (\".dcm\") file, or ROIs (\".roi\").");
                return null;
            }
            catch (Exception exception) {
                IJ.error("ZipDecoder", "" + exception);
                return null;
            }
        }
        object = new File(string);
        cloneable = imagePlus.getOriginalFileInfo();
        ((FileInfo)cloneable).fileFormat = 7;
        ((FileInfo)cloneable).fileName = ((File)object).getName();
        ((FileInfo)cloneable).directory = ((File)object).getParent() + File.separator;
        return imagePlus;
    }

    public ImagePlus deserialize(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        TiffDecoder tiffDecoder = new TiffDecoder(byteArrayInputStream, "Untitled");
        if (IJ.debugMode) {
            tiffDecoder.enableDebugging();
        }
        FileInfo[] fileInfoArray = null;
        try {
            fileInfoArray = tiffDecoder.getTiffInfo();
        }
        catch (IOException iOException) {
            return null;
        }
        FileOpener fileOpener = new FileOpener(fileInfoArray[0]);
        ImagePlus imagePlus = fileOpener.open(false);
        if (imagePlus == null) {
            return null;
        }
        imagePlus.setTitle(fileInfoArray[0].fileName);
        imagePlus = this.makeComposite(imagePlus, fileInfoArray[0]);
        return imagePlus;
    }

    private ImagePlus makeComposite(ImagePlus imagePlus, FileInfo fileInfo) {
        boolean bl;
        int n = imagePlus.getNChannels();
        boolean bl2 = bl = n > 1 && fileInfo.description != null && fileInfo.description.indexOf("mode=") != -1;
        if (n > 1 && (imagePlus.getOpenAsHyperStack() || bl) && !imagePlus.isComposite() && imagePlus.getType() != 4) {
            int n2 = 2;
            if (fileInfo.description != null) {
                if (fileInfo.description.indexOf("mode=composite") != -1) {
                    n2 = 1;
                } else if (fileInfo.description.indexOf("mode=gray") != -1) {
                    n2 = 3;
                }
            }
            imagePlus = new CompositeImage(imagePlus, n2);
        }
        return imagePlus;
    }

    public String getName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getDir(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(0, n + 1);
        }
        return "";
    }

    ImagePlus openTiff2(FileInfo[] fileInfoArray) {
        if (fileInfoArray == null) {
            return null;
        }
        ImagePlus imagePlus = null;
        if (IJ.debugMode) {
            IJ.log(fileInfoArray[0].debugInfo);
        }
        if (fileInfoArray.length > 1 && (imagePlus = this.openTiffStack(fileInfoArray)) != null) {
            return imagePlus;
        }
        FileOpener fileOpener = new FileOpener(fileInfoArray[0]);
        imagePlus = fileOpener.open(false);
        if (imagePlus == null) {
            return null;
        }
        int[] nArray = fileInfoArray[0].stripOffsets;
        if (nArray != null && nArray.length > 1 && nArray[nArray.length - 1] < nArray[0]) {
            IJ.run(imagePlus, "Flip Vertically", "stack");
        }
        imagePlus = this.makeComposite(imagePlus, fileInfoArray[0]);
        return imagePlus;
    }

    public Roi openRoi(String string) {
        Roi roi = null;
        RoiDecoder roiDecoder = new RoiDecoder(string);
        try {
            roi = roiDecoder.getRoi();
        }
        catch (IOException iOException) {
            IJ.error("RoiDecoder", iOException.getMessage());
            return null;
        }
        return roi;
    }

    public static void openResultsTable(String string) {
        try {
            ResultsTable resultsTable = ResultsTable.open(string);
            if (resultsTable != null) {
                resultsTable.show("Results");
            }
        }
        catch (IOException iOException) {
            IJ.error("Open Results", iOException.getMessage());
        }
    }

    public static String getFileFormat(String string) {
        if (!new File(string).exists()) {
            return "not found";
        }
        return types[new Opener().getFileType(string)];
    }

    public int getFileType(String string) {
        if (openUsingPlugins && !string.endsWith(".txt") && !string.endsWith(".java")) {
            return 0;
        }
        File file = new File(string);
        String string2 = file.getName();
        byte[] byArray = new byte[132];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ((InputStream)fileInputStream).read(byArray, 0, 132);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            return 0;
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        if (byArray[128] == 68 && byArray[129] == 73 && byArray[130] == 67 && byArray[131] == 77 && (n == 73 && n2 == 73 || n == 77 && n2 == 77)) {
            return 14;
        }
        if (string2.endsWith(".lsm")) {
            return 0;
        }
        if (!(n != 73 || n2 != 73 || n3 != 42 || n4 != 0 || bioformats && string2.endsWith(".flex"))) {
            return 1;
        }
        if (n == 77 && n2 == 77 && n3 == 0 && n4 == 42) {
            return 1;
        }
        if (n == 255 && n2 == 216 && n3 == 255) {
            return 5;
        }
        if (n == 71 && n2 == 73 && n3 == 70 && n4 == 56) {
            return 6;
        }
        string2 = string2.toLowerCase(Locale.US);
        if (byArray[128] == 68 && byArray[129] == 73 && byArray[130] == 67 && byArray[131] == 77 || string2.endsWith(".dcm")) {
            return 2;
        }
        if (!(n != 8 && n != 2 || n2 != 0 || n4 != 0 || string2.endsWith(".spe") || string2.equals("fid"))) {
            return 2;
        }
        if (!(n != 80 || n2 != 49 && n2 != 52 && n2 != 50 && n2 != 53 && n2 != 51 && n2 != 54 || n3 != 10 && n3 != 13 && n3 != 32 && n3 != 9)) {
            return 4;
        }
        if (string2.endsWith(".lut")) {
            return 7;
        }
        if (n == 137 && n2 == 80 && n3 == 78 && n4 == 71) {
            return 13;
        }
        if (string2.endsWith(".zip")) {
            return 9;
        }
        if (n == 83 && n2 == 73 && n3 == 77 && n4 == 80 || string2.endsWith(".fts.gz") || string2.endsWith(".fits.gz")) {
            return 3;
        }
        if (string2.endsWith(".java") || string2.endsWith(".txt") || string2.endsWith(".ijm") || string2.endsWith(".js") || string2.endsWith(".html")) {
            return 10;
        }
        if (n == 73 && n2 == 111) {
            return 11;
        }
        if (n == 111 && n2 == 106 && n3 == 106 && n4 == 0 || string2.endsWith(".ojj")) {
            return 17;
        }
        if (string2.endsWith(".xls") || string2.endsWith(".csv")) {
            return 18;
        }
        boolean bl = true;
        for (int i = 0; i < 10; ++i) {
            int n5 = byArray[i] & 0xFF;
            if ((n5 >= 32 || n5 == 9 || n5 == 10 || n5 == 13) && n5 <= 126) continue;
            bl = false;
            break;
        }
        if (bl) {
            return 12;
        }
        if (n == 66 && n2 == 77 || string2.endsWith(".dib")) {
            return 8;
        }
        if (string2.endsWith(".avi")) {
            return 16;
        }
        return 0;
    }

    ColorModel createColorModel(FileInfo fileInfo) {
        if (fileInfo.fileType == 5 && fileInfo.lutSize > 0) {
            return new IndexColorModel(8, fileInfo.lutSize, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fileInfo.whiteIsZero);
    }

    InputStream createInputStream(FileInfo fileInfo) throws IOException, MalformedURLException {
        if (fileInfo.inputStream != null) {
            return fileInfo.inputStream;
        }
        if (fileInfo.url != null && !fileInfo.url.equals("")) {
            return new URL(fileInfo.url + fileInfo.fileName).openStream();
        }
        File file = new File(fileInfo.directory + fileInfo.fileName);
        if (file == null || file.isDirectory()) {
            return null;
        }
        InputStream inputStream = new FileInputStream(file);
        if (fileInfo.compression >= 2) {
            inputStream = new RandomAccessStream(inputStream);
        }
        return inputStream;
    }

    void openRGB48(ImagePlus imagePlus) {
        this.isRGB48 = false;
        int n = imagePlus.getStackSize();
        imagePlus.setDimensions(3, n / 3, 1);
        imagePlus = new CompositeImage(imagePlus, 1);
        imagePlus.show();
    }

    public void setSilentMode(boolean bl) {
        this.silentMode = bl;
    }

    public static void setOpenUsingPlugins(boolean bl) {
        openUsingPlugins = bl;
    }

    public static boolean getOpenUsingPlugins() {
        return openUsingPlugins;
    }

    static /* synthetic */ File[] access$002(Opener opener, File[] fileArray) {
        opener.omFiles = fileArray;
        return fileArray;
    }

    static {
        try {
            Hashtable hashtable = Menus.getCommands();
            bioformats = hashtable != null && hashtable.get("Bio-Formats Importer") != null;
        }
        catch (Exception exception) {
            bioformats = false;
        }
    }
}

