/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.macro.Interpreter;
import ij.plugin.frame.Recorder;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;

public class OpenDialog {
    private String dir;
    private String name;
    private boolean recordPath;
    private static String defaultDirectory;
    private static Frame sharedFrame;
    private String title;
    private static String lastDir;
    private static String lastName;

    public OpenDialog(String string, String string2) {
        String string3 = Macro.getOptions();
        if (string3 != null && (string2 == null || string2.equals(""))) {
            if ((string2 = Macro.getValue(string3, string, string2)) == null || string2.equals("")) {
                string2 = Macro.getValue(string3, "path", string2);
            }
            if ((string2 == null || string2.equals("")) && string != null && string.equals("Open As String")) {
                string2 = Macro.getValue(string3, "OpenAsString", string2);
            }
            string2 = OpenDialog.lookupPathVariable(string2);
        }
        if (string2 == null || string2.equals("")) {
            if (Prefs.useJFileChooser) {
                this.jOpen(string, OpenDialog.getDefaultDirectory(), null);
            } else {
                this.open(string, OpenDialog.getDefaultDirectory(), null);
            }
            if (this.name != null) {
                defaultDirectory = this.dir;
            }
            this.title = string;
            this.recordPath = true;
        } else {
            this.decodePath(string2);
            this.recordPath = IJ.macroRunning();
        }
        IJ.register(OpenDialog.class);
    }

    public OpenDialog(String string, String string2, String string3) {
        String string4 = null;
        String string5 = Macro.getOptions();
        if (string5 != null) {
            string4 = Macro.getValue(string5, string, string4);
        }
        if (string4 != null) {
            this.decodePath(string4);
        } else {
            if (Prefs.useJFileChooser) {
                this.jOpen(string, string2, string3);
            } else {
                this.open(string, string2, string3);
            }
            this.title = string;
            this.recordPath = true;
        }
    }

    public static String lookupPathVariable(String string) {
        if (string != null && string.indexOf(".") == -1 && !new File(string).exists()) {
            Interpreter interpreter;
            String string2;
            if (string.startsWith("&")) {
                string = string.substring(1);
            }
            String string3 = string2 = (interpreter = Interpreter.getInstance()) != null ? interpreter.getStringVariable(string) : null;
            if (string2 != null) {
                string = string2;
            }
        }
        return string;
    }

    void jOpen(String string, String string2, String string3) {
        if (EventQueue.isDispatchThread()) {
            this.jOpenDispatchThread(string, string2, string3);
        } else {
            this.jOpenInvokeAndWait(string, string2, string3);
        }
    }

    void jOpenDispatchThread(String string, String string2, String string3) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        File file = null;
        if (string2 != null) {
            file = new File(string2);
        }
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (string3 != null) {
            jFileChooser.setSelectedFile(new File(string3));
        }
        if ((n = jFileChooser.showOpenDialog(IJ.getInstance())) != 0) {
            Macro.abort();
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null) {
            Macro.abort();
            return;
        }
        this.name = file2.getName();
        this.dir = jFileChooser.getCurrentDirectory().getPath() + File.separator;
    }

    void jOpenInvokeAndWait(final String string, final String string2, final String string3) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    int n;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle(string);
                    File file = null;
                    if (string2 != null) {
                        file = new File(string2);
                    }
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    if (string3 != null) {
                        jFileChooser.setSelectedFile(new File(string3));
                    }
                    if ((n = jFileChooser.showOpenDialog(IJ.getInstance())) != 0) {
                        Macro.abort();
                        return;
                    }
                    File file2 = jFileChooser.getSelectedFile();
                    if (file2 == null) {
                        Macro.abort();
                        return;
                    }
                    OpenDialog.this.name = file2.getName();
                    OpenDialog.this.dir = jFileChooser.getCurrentDirectory().getPath() + File.separator;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void open(String string, String string2, String string3) {
        Frame frame = IJ.getInstance();
        if (frame == null) {
            if (sharedFrame == null) {
                sharedFrame = new Frame();
            }
            frame = sharedFrame;
        }
        FileDialog fileDialog = new FileDialog(frame, string);
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        if (string3 != null) {
            fileDialog.setFile(string3);
        }
        fileDialog.show();
        this.name = fileDialog.getFile();
        if (this.name == null) {
            if (IJ.isMacOSX()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            Macro.abort();
        } else {
            this.dir = fileDialog.getDirectory();
        }
    }

    void decodePath(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            this.dir = string.substring(0, n + 1);
            this.name = string.substring(n + 1);
        } else {
            this.dir = "";
            this.name = string;
        }
    }

    public String getDirectory() {
        lastDir = this.dir;
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record && this.recordPath) {
            Recorder.recordPath(this.title, this.dir + this.name);
        }
        lastName = this.name;
        return this.name;
    }

    public static String getDefaultDirectory() {
        if (defaultDirectory == null) {
            defaultDirectory = Prefs.getDefaultDirectory();
        }
        return defaultDirectory;
    }

    public static void setDefaultDirectory(String string) {
        defaultDirectory = string;
        if (!defaultDirectory.endsWith(File.separator)) {
            defaultDirectory = defaultDirectory + File.separator;
        }
    }

    public static String getLastDirectory() {
        return lastDir;
    }

    public static void setLastDirectory(String string) {
        lastDir = string;
    }

    public static String getLastName() {
        return lastName;
    }

    public static void setLastName(String string) {
        lastName = string;
    }
}

