/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.JFileChooser;

public class DirectoryChooser {
    private String directory;
    private String title;

    public DirectoryChooser(String string) {
        this.title = string;
        if (IJ.isMacOSX()) {
            this.getDirectoryUsingFileDialog(string);
        } else {
            String string2 = Macro.getOptions();
            if (string2 != null) {
                this.directory = Macro.getValue(string2, string, null);
            }
            if (this.directory == null) {
                if (EventQueue.isDispatchThread()) {
                    this.getDirectoryUsingJFileChooserOnThisThread(string);
                } else {
                    this.getDirectoryUsingJFileChooser(string);
                }
            }
        }
    }

    void getDirectoryUsingJFileChooser(final String string) {
        Java2.setSystemLookAndFeel();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    File file;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle(string);
                    jFileChooser.setFileSelectionMode(1);
                    String string2 = OpenDialog.getDefaultDirectory();
                    if (string2 != null) {
                        file = new File(string2);
                        if (IJ.debugMode) {
                            IJ.log("DirectoryChooser,setSelectedFile: " + file);
                        }
                        jFileChooser.setSelectedFile(file);
                    }
                    jFileChooser.setApproveButtonText("Select");
                    if (jFileChooser.showOpenDialog(null) == 0) {
                        file = jFileChooser.getSelectedFile();
                        DirectoryChooser.this.directory = file.getAbsolutePath();
                        if (!DirectoryChooser.this.directory.endsWith(File.separator)) {
                            DirectoryChooser.this.directory = DirectoryChooser.this.directory + File.separator;
                        }
                        OpenDialog.setDefaultDirectory(DirectoryChooser.this.directory);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getDirectoryUsingJFileChooserOnThisThread(String string) {
        Java2.setSystemLookAndFeel();
        try {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(1);
            String string2 = OpenDialog.getDefaultDirectory();
            if (string2 != null) {
                file = new File(string2);
                if (IJ.debugMode) {
                    IJ.log("DirectoryChooser,setSelectedFile: " + file);
                }
                jFileChooser.setSelectedFile(file);
            }
            jFileChooser.setApproveButtonText("Select");
            if (jFileChooser.showOpenDialog(null) == 0) {
                file = jFileChooser.getSelectedFile();
                this.directory = file.getAbsolutePath();
                if (!this.directory.endsWith(File.separator)) {
                    this.directory = this.directory + File.separator;
                }
                OpenDialog.setDefaultDirectory(this.directory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getDirectoryUsingFileDialog(String string) {
        Object object;
        boolean bl = Prefs.useJFileChooser;
        Prefs.useJFileChooser = false;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        String string2 = null;
        String string3 = null;
        String string4 = OpenDialog.getDefaultDirectory();
        if (string4 != null) {
            object = new File(string4);
            string2 = ((File)object).getParent();
            string3 = ((File)object).getName();
        }
        if (IJ.debugMode) {
            IJ.log("DirectoryChooser: dir=\"" + string2 + "\",  file=\"" + string3 + "\"");
        }
        this.directory = ((OpenDialog)(object = new OpenDialog(string, string2, string3))).getDirectory() == null ? null : ((OpenDialog)object).getDirectory() + ((OpenDialog)object).getFileName() + "/";
        if (this.directory != null) {
            OpenDialog.setDefaultDirectory(this.directory);
        }
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        Prefs.useJFileChooser = bl;
    }

    public String getDirectory() {
        if (IJ.debugMode) {
            IJ.log("DirectoryChooser.getDirectory: " + this.directory);
        }
        if (Recorder.record && !IJ.isMacOSX()) {
            Recorder.recordPath(this.title, this.directory);
        }
        return this.directory;
    }

    public static void setDefaultDirectory(String string) {
        if (string == null || new File(string).isDirectory()) {
            OpenDialog.setDefaultDirectory(string);
        }
    }
}

