/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.macro.Program;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;

public class Toolbar
extends Canvas
implements MouseListener,
MouseMotionListener,
ItemListener,
ActionListener {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int LINE = 4;
    public static final int POLYLINE = 5;
    public static final int FREELINE = 6;
    public static final int POINT = 7;
    public static final int CROSSHAIR = 7;
    public static final int WAND = 8;
    public static final int TEXT = 9;
    public static final int SPARE1 = 10;
    public static final int MAGNIFIER = 11;
    public static final int HAND = 12;
    public static final int DROPPER = 13;
    public static final int ANGLE = 14;
    public static final int SPARE2 = 15;
    public static final int SPARE3 = 16;
    public static final int SPARE4 = 17;
    public static final int SPARE5 = 18;
    public static final int SPARE6 = 19;
    public static final int SPARE7 = 20;
    public static final int SPARE8 = 21;
    public static final int SPARE9 = 22;
    public static final int DOUBLE_CLICK_THRESHOLD = 650;
    public static final int OVAL_ROI = 0;
    public static final int ELLIPSE_ROI = 1;
    public static final int BRUSH_ROI = 2;
    private static final int NUM_TOOLS = 23;
    private static final int NUM_BUTTONS = 21;
    private static final int SIZE = 26;
    private static final int OFFSET = 5;
    private static final String BRUSH_SIZE = "toolbar.brush.size";
    public static final String CORNER_DIAMETER = "toolbar.arc.size";
    private Dimension ps = new Dimension(546, 26);
    private boolean[] down;
    private static int current;
    private int previous;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private static Toolbar instance;
    private int mpPrevious = 0;
    private String[] names = new String[23];
    private String[] icons = new String[23];
    private PopupMenu[] menus = new PopupMenu[23];
    private int pc;
    private String icon;
    private MacroInstaller macroInstaller;
    private int startupTime;
    private PopupMenu rectPopup;
    private PopupMenu ovalPopup;
    private PopupMenu pointPopup;
    private PopupMenu linePopup;
    private PopupMenu switchPopup;
    private CheckboxMenuItem rectItem;
    private CheckboxMenuItem roundRectItem;
    private CheckboxMenuItem ovalItem;
    private CheckboxMenuItem ellipseItem;
    private CheckboxMenuItem brushItem;
    private CheckboxMenuItem pointItem;
    private CheckboxMenuItem multiPointItem;
    private CheckboxMenuItem straightLineItem;
    private CheckboxMenuItem polyLineItem;
    private CheckboxMenuItem freeLineItem;
    private CheckboxMenuItem arrowItem;
    private String currentSet = "Startup Macros";
    private static Color foregroundColor;
    private static Color backgroundColor;
    private static int ovalType;
    private static boolean multiPointMode;
    private static boolean roundRectMode;
    private static boolean arrowMode;
    private static int brushSize;
    private static int arcSize;
    private int lineType = 4;
    private Color gray = ImageJ.backgroundColor;
    private Color brighter = this.gray.brighter();
    private Color darker = new Color(175, 175, 175);
    private Color evenDarker = new Color(110, 110, 110);
    private Color triangleColor = new Color(150, 0, 0);
    private Color toolColor = new Color(0, 25, 45);

    public Toolbar() {
        this.down = new boolean[23];
        this.resetButtons();
        this.down[0] = true;
        this.setForeground(Color.black);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        instance = this;
        this.names[22] = "Switch to alternate macro tool sets";
        this.icons[22] = "C900T1c12>T7c12>";
        this.addPopupMenus();
        if (IJ.isMacOSX() || IJ.isVista()) {
            Prefs.antialiasedTools = true;
        }
    }

    void addPopupMenus() {
        this.rectPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.rectPopup.setFont(Menus.getFont());
        }
        this.rectItem = new CheckboxMenuItem("Rectangle Tool", !roundRectMode);
        this.rectItem.addItemListener(this);
        this.rectPopup.add(this.rectItem);
        this.roundRectItem = new CheckboxMenuItem("Rounded Rectangle Tool", roundRectMode);
        this.roundRectItem.addItemListener(this);
        this.rectPopup.add(this.roundRectItem);
        this.add(this.rectPopup);
        this.ovalPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.ovalPopup.setFont(Menus.getFont());
        }
        this.ovalItem = new CheckboxMenuItem("Oval selections", ovalType == 0);
        this.ovalItem.addItemListener(this);
        this.ovalPopup.add(this.ovalItem);
        this.ellipseItem = new CheckboxMenuItem("Elliptical selections", ovalType == 1);
        this.ellipseItem.addItemListener(this);
        this.ovalPopup.add(this.ellipseItem);
        this.brushItem = new CheckboxMenuItem("Selection Brush Tool", ovalType == 2);
        this.brushItem.addItemListener(this);
        this.ovalPopup.add(this.brushItem);
        this.add(this.ovalPopup);
        this.pointPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.pointPopup.setFont(Menus.getFont());
        }
        this.pointItem = new CheckboxMenuItem("Point Tool", !multiPointMode);
        this.pointItem.addItemListener(this);
        this.pointPopup.add(this.pointItem);
        this.multiPointItem = new CheckboxMenuItem("Multi-point Tool", multiPointMode);
        this.multiPointItem.addItemListener(this);
        this.pointPopup.add(this.multiPointItem);
        this.add(this.pointPopup);
        this.linePopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.linePopup.setFont(Menus.getFont());
        }
        this.straightLineItem = new CheckboxMenuItem("Straight Line", this.lineType == 4 && !arrowMode);
        this.straightLineItem.addItemListener(this);
        this.linePopup.add(this.straightLineItem);
        this.polyLineItem = new CheckboxMenuItem("Segmented Line", this.lineType == 5);
        this.polyLineItem.addItemListener(this);
        this.linePopup.add(this.polyLineItem);
        this.freeLineItem = new CheckboxMenuItem("Freehand Line", this.lineType == 6);
        this.freeLineItem.addItemListener(this);
        this.linePopup.add(this.freeLineItem);
        this.arrowItem = new CheckboxMenuItem("Arrow tool", this.lineType == 4 && !arrowMode);
        this.arrowItem.addItemListener(this);
        this.linePopup.add(this.arrowItem);
        this.add(this.linePopup);
        this.switchPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.switchPopup.setFont(Menus.getFont());
        }
        this.add(this.switchPopup);
    }

    public static int getToolId() {
        return current;
    }

    public int getToolId(String string) {
        int n = -1;
        for (int i = 0; i <= 22; ++i) {
            if (this.names[i] == null || !this.names[i].equals(string) && !this.names[i].startsWith(string + "-") && !this.names[i].startsWith(string + " -")) continue;
            n = i;
            break;
        }
        return n;
    }

    public static Toolbar getInstance() {
        return instance;
    }

    private void drawButtons(Graphics graphics) {
        int n;
        if (Prefs.antialiasedTools) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        for (n = 0; n < 4; ++n) {
            this.drawButton(graphics, n);
        }
        this.drawButton(graphics, this.lineType);
        for (n = 7; n < 23; ++n) {
            this.drawButton(graphics, n);
        }
    }

    private void fill3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (null == graphics) {
            return;
        }
        if (bl) {
            graphics.setColor(this.gray);
        } else {
            graphics.setColor(this.darker);
        }
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(bl ? this.brighter : this.evenDarker);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
        graphics.setColor(bl ? this.evenDarker : this.brighter);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 2);
    }

    private void drawButton(Graphics graphics, int n) {
        if (graphics == null) {
            return;
        }
        int n2 = this.toolIndex(n);
        this.fill3DRect(graphics, n2 * 26 + 1, 1, 26, 25, !this.down[n]);
        graphics.setColor(this.toolColor);
        int n3 = n2 * 26 + 5;
        int n4 = 5;
        if (this.down[n]) {
            ++n3;
            ++n4;
        }
        this.g = graphics;
        if (n >= 10 && n <= 22 && this.icons[n] != null) {
            this.drawIcon(graphics, n, n3, n4);
            return;
        }
        switch (n) {
            case 0: {
                this.xOffset = n3;
                this.yOffset = n4;
                if (roundRectMode) {
                    graphics.drawRoundRect(n3 + 1, n4 + 2, 15, 12, 8, 8);
                } else {
                    graphics.drawRect(n3 + 1, n4 + 2, 15, 12);
                }
                this.drawTriangle(15, 14);
                return;
            }
            case 1: {
                this.xOffset = n3;
                this.yOffset = n4;
                if (ovalType == 2) {
                    this.m(9, 2);
                    this.d(13, 2);
                    this.d(13, 2);
                    this.d(15, 5);
                    this.d(15, 8);
                    this.d(13, 10);
                    this.d(10, 10);
                    this.d(8, 13);
                    this.d(4, 13);
                    this.d(2, 11);
                    this.d(2, 7);
                    this.d(4, 5);
                    this.d(7, 5);
                    this.d(9, 2);
                } else if (ovalType == 1) {
                    this.yOffset = n4 + 1;
                    this.m(11, 0);
                    this.d(13, 0);
                    this.d(14, 1);
                    this.d(15, 1);
                    this.d(16, 2);
                    this.d(17, 3);
                    this.d(17, 7);
                    this.d(12, 12);
                    this.d(11, 12);
                    this.d(10, 13);
                    this.d(8, 13);
                    this.d(7, 14);
                    this.d(4, 14);
                    this.d(3, 13);
                    this.d(2, 13);
                    this.d(1, 12);
                    this.d(1, 11);
                    this.d(0, 10);
                    this.d(0, 9);
                    this.d(1, 8);
                    this.d(1, 7);
                    this.d(6, 2);
                    this.d(7, 2);
                    this.d(8, 1);
                    this.d(10, 1);
                    this.d(11, 0);
                } else {
                    graphics.drawOval(n3 + 1, n4 + 2, 15, 12);
                }
                this.drawTriangle(15, 14);
                return;
            }
            case 2: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 3;
                this.m(4, 0);
                this.d(14, 0);
                this.d(14, 1);
                this.d(10, 5);
                this.d(10, 6);
                this.d(13, 9);
                this.d(13, 10);
                this.d(0, 10);
                this.d(0, 4);
                this.d(4, 0);
                return;
            }
            case 3: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 3;
                this.m(3, 0);
                this.d(5, 0);
                this.d(7, 2);
                this.d(9, 2);
                this.d(11, 0);
                this.d(13, 0);
                this.d(14, 1);
                this.d(15, 2);
                this.d(15, 4);
                this.d(14, 5);
                this.d(14, 6);
                this.d(12, 8);
                this.d(11, 8);
                this.d(10, 9);
                this.d(9, 9);
                this.d(8, 10);
                this.d(5, 10);
                this.d(3, 8);
                this.d(2, 8);
                this.d(1, 7);
                this.d(1, 6);
                this.d(0, 5);
                this.d(0, 2);
                this.d(1, 1);
                this.d(2, 1);
                return;
            }
            case 4: {
                this.xOffset = n3;
                this.yOffset = n4;
                if (arrowMode) {
                    this.m(1, 14);
                    this.d(14, 1);
                    this.m(6, 5);
                    this.d(14, 1);
                    this.m(10, 9);
                    this.d(14, 1);
                    this.m(6, 5);
                    this.d(10, 9);
                } else {
                    this.m(0, 12);
                    this.d(17, 3);
                }
                this.drawTriangle(12, 14);
                return;
            }
            case 5: {
                this.xOffset = n3;
                this.yOffset = n4;
                this.m(14, 6);
                this.d(11, 3);
                this.d(1, 3);
                this.d(1, 4);
                this.d(6, 9);
                this.d(2, 13);
                this.drawTriangle(12, 14);
                return;
            }
            case 6: {
                this.xOffset = n3;
                this.yOffset = n4;
                this.m(16, 4);
                this.d(14, 6);
                this.d(12, 6);
                this.d(9, 3);
                this.d(8, 3);
                this.d(6, 7);
                this.d(2, 11);
                this.d(1, 11);
                this.drawTriangle(12, 14);
                return;
            }
            case 7: {
                this.xOffset = n3;
                this.yOffset = n4;
                if (multiPointMode) {
                    this.drawPoint(1, 3);
                    this.drawPoint(9, 1);
                    this.drawPoint(15, 5);
                    this.drawPoint(10, 11);
                    this.drawPoint(2, 12);
                } else {
                    this.m(1, 8);
                    this.d(6, 8);
                    this.d(6, 6);
                    this.d(10, 6);
                    this.d(10, 10);
                    this.d(6, 10);
                    this.d(6, 9);
                    this.m(8, 1);
                    this.d(8, 5);
                    this.m(11, 8);
                    this.d(15, 8);
                    this.m(8, 11);
                    this.d(8, 15);
                    this.m(8, 8);
                    this.d(8, 8);
                    graphics.setColor(Roi.getColor());
                    graphics.fillRect(n3 + 7, n4 + 7, 3, 3);
                }
                this.drawTriangle(14, 14);
                return;
            }
            case 8: {
                this.xOffset = n3 + 2;
                this.yOffset = n4 + 2;
                this.dot(4, 0);
                this.m(2, 0);
                this.d(3, 1);
                this.d(4, 2);
                this.m(0, 0);
                this.d(1, 1);
                this.m(0, 2);
                this.d(1, 3);
                this.d(2, 4);
                this.dot(0, 4);
                this.m(3, 3);
                this.d(12, 12);
                return;
            }
            case 9: {
                this.xOffset = n3 + 2;
                this.yOffset = n4 + 1;
                this.m(0, 13);
                this.d(3, 13);
                this.m(1, 12);
                this.d(7, 0);
                this.d(12, 13);
                this.m(11, 13);
                this.d(14, 13);
                this.m(3, 8);
                this.d(10, 8);
                return;
            }
            case 11: {
                this.xOffset = n3 + 2;
                this.yOffset = n4 + 2;
                this.m(3, 0);
                this.d(3, 0);
                this.d(5, 0);
                this.d(8, 3);
                this.d(8, 5);
                this.d(7, 6);
                this.d(7, 7);
                this.d(6, 7);
                this.d(5, 8);
                this.d(3, 8);
                this.d(0, 5);
                this.d(0, 3);
                this.d(3, 0);
                this.m(8, 8);
                this.d(9, 8);
                this.d(13, 12);
                this.d(13, 13);
                this.d(12, 13);
                this.d(8, 9);
                this.d(8, 8);
                return;
            }
            case 12: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 1;
                this.m(5, 14);
                this.d(2, 11);
                this.d(2, 10);
                this.d(0, 8);
                this.d(0, 7);
                this.d(1, 6);
                this.d(2, 6);
                this.d(4, 8);
                this.d(4, 6);
                this.d(3, 5);
                this.d(3, 4);
                this.d(2, 3);
                this.d(2, 2);
                this.d(3, 1);
                this.d(4, 1);
                this.d(5, 2);
                this.d(5, 3);
                this.m(6, 5);
                this.d(6, 1);
                this.d(7, 0);
                this.d(8, 0);
                this.d(9, 1);
                this.d(9, 5);
                this.m(9, 1);
                this.d(11, 1);
                this.d(12, 2);
                this.d(12, 6);
                this.m(13, 4);
                this.d(14, 3);
                this.d(15, 4);
                this.d(15, 7);
                this.d(14, 8);
                this.d(14, 10);
                this.d(13, 11);
                this.d(13, 12);
                this.d(12, 13);
                this.d(12, 14);
                return;
            }
            case 13: {
                this.xOffset = n3;
                this.yOffset = n4;
                graphics.setColor(foregroundColor);
                this.m(12, 2);
                this.d(14, 2);
                this.m(11, 3);
                this.d(15, 3);
                this.m(11, 4);
                this.d(15, 4);
                this.m(8, 5);
                this.d(15, 5);
                this.m(9, 6);
                this.d(14, 6);
                this.m(10, 7);
                this.d(12, 7);
                this.d(12, 9);
                this.m(8, 7);
                this.d(2, 13);
                this.d(2, 15);
                this.d(4, 15);
                this.d(11, 8);
                graphics.setColor(backgroundColor);
                this.m(0, 0);
                this.d(16, 0);
                this.d(16, 16);
                this.d(0, 16);
                this.d(0, 0);
                return;
            }
            case 14: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 2;
                this.m(0, 11);
                this.d(11, 0);
                this.m(0, 11);
                this.d(15, 11);
                this.m(10, 11);
                this.d(10, 8);
                this.m(9, 7);
                this.d(9, 6);
                this.dot(8, 5);
                return;
            }
        }
    }

    void drawTriangle(int n, int n2) {
        this.g.setColor(this.triangleColor);
        this.xOffset += n;
        this.yOffset += n2;
        this.m(0, 0);
        this.d(4, 0);
        this.m(1, 1);
        this.d(3, 1);
        this.dot(2, 2);
    }

    void drawPoint(int n, int n2) {
        this.g.setColor(this.toolColor);
        this.m(n - 2, n2);
        this.d(n + 2, n2);
        this.m(n, n2 - 2);
        this.d(n, n2 + 2);
        this.g.setColor(Roi.getColor());
        this.dot(n, n2);
    }

    void drawIcon(Graphics graphics, int n, int n2, int n3) {
        if (null == graphics) {
            return;
        }
        this.icon = this.icons[n];
        if (this.icon == null) {
            return;
        }
        this.icon = this.icon;
        int n4 = this.icon.length();
        this.pc = 0;
        block12: do {
            char c = this.icon.charAt(this.pc++);
            if (this.pc >= n4) break;
            switch (c) {
                case 'B': {
                    n2 += this.v();
                    n3 += this.v();
                    break;
                }
                case 'R': {
                    graphics.drawRect(n2 + this.v(), n3 + this.v(), this.v(), this.v());
                    break;
                }
                case 'F': {
                    graphics.fillRect(n2 + this.v(), n3 + this.v(), this.v(), this.v());
                    break;
                }
                case 'O': {
                    graphics.drawOval(n2 + this.v(), n3 + this.v(), this.v(), this.v());
                    break;
                }
                case 'o': {
                    graphics.fillOval(n2 + this.v(), n3 + this.v(), this.v(), this.v());
                    break;
                }
                case 'C': {
                    graphics.setColor(new Color(this.v() * 16, this.v() * 16, this.v() * 16));
                    break;
                }
                case 'L': {
                    graphics.drawLine(n2 + this.v(), n3 + this.v(), n2 + this.v(), n3 + this.v());
                    break;
                }
                case 'D': {
                    graphics.fillRect(n2 + this.v(), n3 + this.v(), 1, 1);
                    break;
                }
                case 'P': {
                    int n5;
                    int n6;
                    int n7 = n2 + this.v();
                    int n8 = n3 + this.v();
                    while ((n6 = this.v()) != 0 && (n5 = this.v()) != 0) {
                        graphics.drawLine(n7, n8, n6 += n2, n5 += n3);
                        n7 = n6;
                        n8 = n5;
                    }
                    continue block12;
                }
                case 'T': {
                    int n6 = n2 + this.v();
                    int n5 = n3 + this.v();
                    int n9 = this.v() * 10 + this.v();
                    char[] cArray = new char[]{this.pc < this.icon.length() ? (char)this.icon.charAt(this.pc++) : (char)'e'};
                    graphics.setFont(new Font("SansSerif", 1, n9));
                    graphics.drawString(new String(cArray), n6, n5);
                    break;
                }
            }
        } while (this.pc < n4);
        if (this.menus[n] != null && this.menus[n].getItemCount() > 0) {
            this.xOffset = n2;
            this.yOffset = n3;
            this.drawTriangle(14, 14);
        }
    }

    int v() {
        if (this.pc >= this.icon.length()) {
            return 0;
        }
        char c = this.icon.charAt(this.pc++);
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    private void showMessage(int n) {
        if (n >= 10 && n <= 22 && this.names[n] != null) {
            String string = this.names[n];
            int n2 = string.indexOf("Action Tool");
            if (n2 != -1) {
                string = string.substring(0, n2);
            } else {
                n2 = string.indexOf("Menu Tool");
                if (n2 != -1) {
                    string = string.substring(0, n2 + 4);
                }
            }
            IJ.showStatus(string);
            return;
        }
        String string = " (right click to switch)";
        switch (n) {
            case 0: {
                if (roundRectMode) {
                    IJ.showStatus("Rectangular or *rounded rectangular* selections" + string);
                } else {
                    IJ.showStatus("*Rectangular* or rounded rectangular selections" + string);
                }
                return;
            }
            case 1: {
                if (ovalType == 2) {
                    IJ.showStatus("Oval, elliptical or *brush* selections" + string);
                } else if (ovalType == 1) {
                    IJ.showStatus("Oval, *elliptical* or brush selections" + string);
                } else {
                    IJ.showStatus("*Oval*, elliptical or brush selections" + string);
                }
                return;
            }
            case 2: {
                IJ.showStatus("Polygon selections");
                return;
            }
            case 3: {
                IJ.showStatus("Freehand selections");
                return;
            }
            case 4: {
                if (arrowMode) {
                    IJ.showStatus("Straight, segmented or freehand lines, or *arrows*" + string);
                } else {
                    IJ.showStatus("*Straight*, segmented or freehand lines, or arrows" + string);
                }
                return;
            }
            case 5: {
                IJ.showStatus("Straight, *segmented* or freehand lines, or arrows" + string);
                return;
            }
            case 6: {
                IJ.showStatus("Straight, segmented or *freehand* lines, or arrows" + string);
                return;
            }
            case 7: {
                if (multiPointMode) {
                    IJ.showStatus("Point or *multi-point* selections" + string);
                } else {
                    IJ.showStatus("*Point* or multi-point selections" + string);
                }
                return;
            }
            case 8: {
                IJ.showStatus("Wand (tracing) tool");
                return;
            }
            case 9: {
                IJ.showStatus("Text tool");
                TextRoi.recordSetFont();
                return;
            }
            case 11: {
                IJ.showStatus("Magnifying glass (or use \"+\" and \"-\" keys)");
                return;
            }
            case 12: {
                IJ.showStatus("Scrolling tool (or press space bar and drag)");
                return;
            }
            case 13: {
                IJ.showStatus("Color picker (" + foregroundColor.getRed() + "," + foregroundColor.getGreen() + "," + foregroundColor.getBlue() + ")");
                return;
            }
            case 14: {
                IJ.showStatus("Angle tool");
                return;
            }
        }
        IJ.showStatus("ImageJ " + IJ.getVersion() + " / Java " + System.getProperty("java.version") + (IJ.is64Bit() ? " (64-bit)" : " (32-bit)"));
    }

    private void m(int n, int n2) {
        this.x = this.xOffset + n;
        this.y = this.yOffset + n2;
    }

    private void d(int n, int n2) {
        this.g.drawLine(this.x, this.y, n += this.xOffset, n2 += this.yOffset);
        this.x = n;
        this.y = n2;
    }

    private void dot(int n, int n2) {
        this.g.fillRect(n + this.xOffset, n2 + this.yOffset, 1, 1);
    }

    private void resetButtons() {
        for (int i = 0; i < 23; ++i) {
            this.down[i] = false;
        }
    }

    public void paint(Graphics graphics) {
        if (null == graphics) {
            return;
        }
        this.drawButtons(graphics);
    }

    public boolean setTool(String string) {
        int n;
        if (string == null) {
            return false;
        }
        if (string.indexOf(" Tool") != -1) {
            for (n = 10; n <= 22; n += 1) {
                if (!string.equals(this.names[n])) continue;
                this.setTool(n);
                return true;
            }
        }
        string = string.toLowerCase(Locale.US);
        n = 1;
        if (string.indexOf("round") != -1) {
            roundRectMode = true;
            this.setTool(0);
        } else if (string.indexOf("rect") != -1) {
            roundRectMode = false;
            this.setTool(0);
        } else if (string.indexOf("oval") != -1) {
            ovalType = 0;
            this.setTool(1);
        } else if (string.indexOf("ellip") != -1) {
            ovalType = 1;
            this.setTool(1);
        } else if (string.indexOf("brush") != -1) {
            ovalType = 2;
            this.setTool(1);
        } else if (string.indexOf("polygon") != -1) {
            this.setTool(2);
        } else if (string.indexOf("polyline") != -1) {
            this.setTool(5);
        } else if (string.indexOf("freeline") != -1) {
            this.setTool(6);
        } else if (string.indexOf("line") != -1) {
            arrowMode = false;
            this.setTool(4);
        } else if (string.indexOf("arrow") != -1) {
            arrowMode = true;
            this.setTool(4);
        } else if (string.indexOf("free") != -1) {
            this.setTool(3);
        } else if (string.indexOf("multi") != -1) {
            multiPointMode = true;
            Prefs.multiPointMode = true;
            this.setTool(7);
        } else if (string.indexOf("point") != -1) {
            multiPointMode = false;
            Prefs.multiPointMode = false;
            this.setTool(7);
        } else if (string.indexOf("wand") != -1) {
            this.setTool(8);
        } else if (string.indexOf("text") != -1) {
            this.setTool(9);
        } else if (string.indexOf("hand") != -1) {
            this.setTool(12);
        } else if (string.indexOf("zoom") != -1) {
            this.setTool(11);
        } else if (string.indexOf("dropper") != -1 || string.indexOf("color") != -1) {
            this.setTool(13);
        } else if (string.indexOf("angle") != -1) {
            this.setTool(14);
        } else {
            n = 0;
        }
        return n != 0;
    }

    public static String getToolName() {
        String string = instance.getName(current);
        if (current >= 10 && current <= 22 && Toolbar.instance.names[current] != null) {
            string = Toolbar.instance.names[current];
        }
        return string != null ? string : "";
    }

    String getName(int n) {
        switch (n) {
            case 0: {
                return roundRectMode ? "roundrect" : "rectangle";
            }
            case 1: {
                switch (ovalType) {
                    case 0: {
                        return "oval";
                    }
                    case 1: {
                        return "ellipse";
                    }
                    case 2: {
                        return "brush";
                    }
                }
            }
            case 2: {
                return "polygon";
            }
            case 3: {
                return "freehand";
            }
            case 4: {
                return arrowMode ? "arrow" : "line";
            }
            case 5: {
                return "polyline";
            }
            case 6: {
                return "freeline";
            }
            case 14: {
                return "angle";
            }
            case 7: {
                return Prefs.multiPointMode ? "multipoint" : "point";
            }
            case 8: {
                return "wand";
            }
            case 9: {
                return "text";
            }
            case 12: {
                return "hand";
            }
            case 11: {
                return "zoom";
            }
            case 13: {
                return "dropper";
            }
        }
        return null;
    }

    public void setTool(int n) {
        if (n == current && n != 0 && n != 1 && n != 7 || n < 0 || n >= 22) {
            return;
        }
        if (n == 10 || n >= 15 && n <= 21) {
            if (this.names[n] == null) {
                this.names[n] = "Spare tool";
            }
            if (this.names[n].indexOf("Action Tool") != -1) {
                return;
            }
        }
        if (this.isLine(n)) {
            this.lineType = n;
        }
        this.setTool2(n);
    }

    private void setTool2(int n) {
        Object object;
        Graphics graphics;
        if (!this.isValidTool(n)) {
            return;
        }
        String string = Toolbar.getToolName();
        current = n;
        this.down[Toolbar.current] = true;
        if (current != this.previous) {
            this.down[this.previous] = false;
        }
        if ((graphics = this.getGraphics()) == null) {
            return;
        }
        if (Prefs.antialiasedTools) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawButton(graphics, this.previous);
        this.drawButton(graphics, current);
        if (null == graphics) {
            return;
        }
        graphics.dispose();
        this.showMessage(current);
        this.previous = current;
        if (Recorder.record && (object = this.getName(current)) != null) {
            Recorder.record("setTool", (String)object);
        }
        if (IJ.isMacOSX()) {
            this.repaint();
        }
        if (!string.equals(Toolbar.getToolName())) {
            IJ.notifyEventListeners(4);
        }
    }

    boolean isValidTool(int n) {
        if (n < 0 || n >= 23) {
            return false;
        }
        return n != 10 && (n < 15 || n > 22) || this.names[n] != null;
    }

    public Color getColor() {
        return foregroundColor;
    }

    public void setColor(Color color) {
        if (color != null) {
            foregroundColor = color;
            this.drawButton(this.getGraphics(), 13);
        }
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    public static void setForegroundColor(Color color) {
        if (color != null) {
            foregroundColor = color;
            Toolbar.repaintTool(13);
            if (!IJ.isMacro()) {
                Toolbar.setRoiColor(color);
            }
            IJ.notifyEventListeners(0);
        }
    }

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static void setBackgroundColor(Color color) {
        if (color != null) {
            backgroundColor = color;
            Toolbar.repaintTool(13);
            IJ.notifyEventListeners(1);
        }
    }

    private static void setRoiColor(Color color) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isDrawingTool()) {
            roi.setStrokeColor(color);
            imagePlus.draw();
        }
    }

    public static int getBrushSize() {
        if (ovalType == 2) {
            return brushSize;
        }
        return 0;
    }

    public static void setBrushSize(int n) {
        brushSize = n;
        if (brushSize < 1) {
            brushSize = 1;
        }
        Prefs.set(BRUSH_SIZE, brushSize);
    }

    public static int getRoundRectArcSize() {
        if (!roundRectMode) {
            return 0;
        }
        return arcSize;
    }

    public static void setRoundRectArcSize(int n) {
        Roi roi;
        if (n <= 0) {
            roundRectMode = false;
        } else {
            arcSize = n;
            Prefs.set(CORNER_DIAMETER, arcSize);
        }
        Toolbar.repaintTool(0);
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Roi roi2 = roi = imagePlus != null ? imagePlus.getRoi() : null;
        if (roi != null && roi.getType() == 0) {
            roi.setCornerDiameter(roundRectMode ? arcSize : 0);
        }
    }

    public static boolean getMultiPointMode() {
        return multiPointMode;
    }

    public static int getOvalToolType() {
        return ovalType;
    }

    public static int getButtonSize() {
        return 26;
    }

    static void repaintTool(int n) {
        if (IJ.getInstance() != null) {
            Toolbar toolbar = Toolbar.getInstance();
            Graphics graphics = toolbar.getGraphics();
            if (graphics == null) {
                return;
            }
            if (Prefs.antialiasedTools) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            toolbar.drawButton(graphics, n);
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    int toolIndex(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 9;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 11;
            }
            case 14: {
                return 5;
            }
            case 10: {
                return 12;
            }
        }
        return n - 2;
    }

    int toolID(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return this.lineType;
            }
            case 5: {
                return 14;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 11;
            }
            case 10: {
                return 12;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 10;
            }
        }
        return n + 2;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = 0;
        for (n = 0; n < 21; ++n) {
            if (n2 <= n * 26 || n2 >= n * 26 + 26) continue;
            n3 = this.toolID(n);
        }
        if (n3 == 22) {
            this.showSwitchPopupMenu(mouseEvent);
            return;
        }
        if (!this.isValidTool(n3)) {
            return;
        }
        if (this.menus[n3] != null && this.menus[n3].getItemCount() > 0) {
            this.menus[n3].show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        n = n3 == current && System.currentTimeMillis() - this.mouseDownTime <= 650L ? 1 : 0;
        this.mouseDownTime = System.currentTimeMillis();
        if (n == 0) {
            boolean bl;
            this.mpPrevious = current;
            if (this.isMacroTool(n3)) {
                String string = this.names[n3];
                if (string.indexOf("Unused Tool") != -1) {
                    return;
                }
                if (string.indexOf("Action Tool") != -1) {
                    if (mouseEvent.isPopupTrigger() && mouseEvent.getButton() != 0 || mouseEvent.isMetaDown()) {
                        string = string.endsWith(" ") ? string : string + " ";
                        this.macroInstaller.runMacroTool(string + "Options");
                    } else {
                        this.drawTool(n3, true);
                        IJ.wait(50);
                        this.drawTool(n3, false);
                        this.runMacroTool(n3);
                    }
                    return;
                }
                string = string.endsWith(" ") ? string : string + " ";
                this.macroInstaller.runMacroTool(string + "Selected");
            }
            this.setTool2(n3);
            boolean bl2 = bl = mouseEvent.isPopupTrigger() && mouseEvent.getButton() != 0 || mouseEvent.isMetaDown();
            if (current == 0 && bl) {
                this.rectItem.setState(!roundRectMode);
                this.roundRectItem.setState(roundRectMode);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.rectPopup.show(mouseEvent.getComponent(), n2, this.y);
                this.mouseDownTime = 0L;
            }
            if (current == 1 && bl) {
                this.ovalItem.setState(ovalType == 0);
                this.ellipseItem.setState(ovalType == 1);
                this.brushItem.setState(ovalType == 2);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.ovalPopup.show(mouseEvent.getComponent(), n2, this.y);
                this.mouseDownTime = 0L;
            }
            if (current == 7 && bl) {
                this.pointItem.setState(!multiPointMode);
                this.multiPointItem.setState(multiPointMode);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.pointPopup.show(mouseEvent.getComponent(), n2, this.y);
                this.mouseDownTime = 0L;
            }
            if (this.isLine(current) && bl) {
                this.straightLineItem.setState(this.lineType == 4 && !arrowMode);
                this.polyLineItem.setState(this.lineType == 5);
                this.freeLineItem.setState(this.lineType == 6);
                this.arrowItem.setState(this.lineType == 4 && arrowMode);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.linePopup.show(mouseEvent.getComponent(), n2, this.y);
                this.mouseDownTime = 0L;
            }
            if (this.isMacroTool(current) && bl) {
                String string = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
                this.macroInstaller.runMacroTool(string + "Options");
            }
        } else {
            if (this.isMacroTool(current)) {
                String string = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
                this.macroInstaller.runMacroTool(string + "Options");
                return;
            }
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            switch (current) {
                case 0: {
                    if (!roundRectMode) break;
                    IJ.doCommand("Rounded Rect Tool...");
                    break;
                }
                case 1: {
                    this.showBrushDialog();
                    break;
                }
                case 11: {
                    ImageCanvas imageCanvas;
                    if (imagePlus == null || (imageCanvas = imagePlus.getCanvas()) == null) break;
                    imageCanvas.unzoom();
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (current == 4 && arrowMode) {
                        IJ.doCommand("Arrow Tool...");
                        break;
                    }
                    IJ.runPlugIn("ij.plugin.frame.LineWidthAdjuster", "");
                    break;
                }
                case 14: {
                    this.showAngleDialog();
                    break;
                }
                case 7: {
                    if (multiPointMode) {
                        if (imagePlus == null || imagePlus.getRoi() == null) break;
                        IJ.doCommand("Add Selection...");
                        break;
                    }
                    IJ.doCommand("Point Tool...");
                    break;
                }
                case 8: {
                    IJ.doCommand("Wand Tool...");
                    break;
                }
                case 9: {
                    IJ.doCommand("Fonts...");
                    break;
                }
                case 13: {
                    IJ.doCommand("Color Picker...");
                    this.setTool2(this.mpPrevious);
                    break;
                }
            }
        }
    }

    void showSwitchPopupMenu(MouseEvent mouseEvent) {
        int n;
        String[] stringArray;
        String string = IJ.getDirectory("macros") + "toolsets/";
        if (string == null) {
            return;
        }
        boolean bl = IJ.getApplet() != null;
        File file = new File(string);
        if (!bl && file.exists() && file.isDirectory()) {
            stringArray = file.list();
            if (stringArray == null) {
                return;
            }
        } else {
            stringArray = new String[]{};
        }
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("Stack Tools.txt")) continue;
            bl2 = true;
            break;
        }
        this.switchPopup.removeAll();
        string = IJ.getDirectory("macros") + "StartupMacros.txt";
        file = new File(string);
        if (!bl && file.exists()) {
            this.addItem("Startup Macros");
        } else {
            this.addItem("StartupMacros*");
        }
        if (!bl2) {
            this.addItem("Stack Tools*");
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string2.endsWith(".txt")) {
                string2 = string2.substring(0, string2.length() - 4);
                this.addItem(string2);
                continue;
            }
            if (!string2.endsWith(".ijm")) continue;
            string2 = string2.substring(0, string2.length() - 4) + " ";
            this.addItem(string2);
        }
        this.addItem("Help...");
        this.add(this.ovalPopup);
        if (IJ.isMacOSX()) {
            IJ.wait(10);
        }
        this.switchPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    void addItem(String string) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string, string.equals(this.currentSet));
        checkboxMenuItem.addItemListener(this);
        this.switchPopup.add(checkboxMenuItem);
    }

    void drawTool(int n, boolean bl) {
        this.down[n] = bl;
        Graphics graphics = this.getGraphics();
        if (!bl && Prefs.antialiasedTools) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawButton(graphics, n);
        if (null == graphics) {
            return;
        }
        graphics.dispose();
    }

    boolean isLine(int n) {
        return n == 4 || n == 5 || n == 6;
    }

    public void restorePreviousTool() {
        this.setTool2(this.mpPrevious);
    }

    boolean isMacroTool(int n) {
        return n >= 10 && n <= 22 && this.names[n] != null && this.macroInstaller != null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
        String string = Toolbar.getToolName();
        if (checkboxMenuItem == this.rectItem || checkboxMenuItem == this.roundRectItem) {
            Roi roi;
            roundRectMode = checkboxMenuItem == this.roundRectItem;
            Toolbar.repaintTool(0);
            this.showMessage(0);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            Roi roi2 = roi = imagePlus != null ? imagePlus.getRoi() : null;
            if (roi != null && roi.getType() == 0) {
                roi.setCornerDiameter(roundRectMode ? arcSize : 0);
            }
            if (!string.equals(Toolbar.getToolName())) {
                IJ.notifyEventListeners(4);
            }
        } else if (checkboxMenuItem == this.ovalItem || checkboxMenuItem == this.ellipseItem || checkboxMenuItem == this.brushItem) {
            ovalType = checkboxMenuItem == this.brushItem ? 2 : (checkboxMenuItem == this.ellipseItem ? 1 : 0);
            Toolbar.repaintTool(1);
            this.showMessage(1);
            if (!string.equals(Toolbar.getToolName())) {
                IJ.notifyEventListeners(4);
            }
        } else if (checkboxMenuItem == this.pointItem || checkboxMenuItem == this.multiPointItem) {
            Prefs.multiPointMode = multiPointMode = checkboxMenuItem == this.multiPointItem;
            Toolbar.repaintTool(7);
            this.showMessage(7);
            if (!string.equals(Toolbar.getToolName())) {
                IJ.notifyEventListeners(4);
            }
        } else if (checkboxMenuItem == this.straightLineItem) {
            this.lineType = 4;
            arrowMode = false;
            this.setTool2(4);
            this.showMessage(4);
        } else if (checkboxMenuItem == this.polyLineItem) {
            this.lineType = 5;
            this.setTool2(5);
            this.showMessage(5);
        } else if (checkboxMenuItem == this.freeLineItem) {
            this.lineType = 6;
            this.setTool2(6);
            this.showMessage(6);
        } else if (checkboxMenuItem == this.arrowItem) {
            this.lineType = 4;
            arrowMode = true;
            this.setTool2(4);
            this.showMessage(4);
        } else {
            String string2 = checkboxMenuItem.getActionCommand();
            if (!string2.equals("Help...")) {
                this.currentSet = string2;
            }
            if (string2.equals("Help...")) {
                IJ.showMessage("Tool Switcher", "Use this drop down menu to switch to macro tool\nsets located in the ImageJ/macros/toolsets folder,\nor to revert to the ImageJ/macros/StartupMacros\nset. The default tool sets, which have names\nending in '*', are loaded from ij.jar.\n \nHold the shift key down while selecting a tool\nset to view its source code.\n \nSeveral example tool sets are available at\n<http://imagej.nih.gov/ij/macros/toolsets/>.");
                return;
            }
            if (string2.endsWith("*")) {
                MacroInstaller macroInstaller = new MacroInstaller();
                string2 = string2.substring(0, string2.length() - 1) + ".txt";
                String string3 = "/macros/" + string2;
                if (IJ.shiftKeyDown()) {
                    String string4 = macroInstaller.openFromIJJar(string3);
                    Editor editor = new Editor();
                    editor.setSize(350, 300);
                    editor.create(string2, string4);
                    IJ.setKeyUp(16);
                } else {
                    macroInstaller.installFromIJJar(string3);
                }
            } else {
                String string5 = string2.equals("Startup Macros") ? IJ.getDirectory("macros") + "StartupMacros.txt" : (string2.endsWith(" ") ? IJ.getDirectory("macros") + "toolsets/" + string2.substring(0, string2.length() - 1) + ".ijm" : IJ.getDirectory("macros") + "toolsets/" + string2 + ".txt");
                try {
                    if (IJ.shiftKeyDown()) {
                        IJ.open(string5);
                        IJ.setKeyUp(16);
                    } else {
                        new MacroInstaller().run(string5);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        PopupMenu popupMenu = (PopupMenu)menuItem.getParent();
        int n = -1;
        for (int i = 10; i < 23; ++i) {
            if (popupMenu != this.menus[i]) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return;
        }
        if (this.macroInstaller != null) {
            this.macroInstaller.runMenuTool(this.names[n], string);
        }
    }

    public Dimension getPreferredSize() {
        return this.ps;
    }

    public Dimension getMinimumSize() {
        return this.ps;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        n = this.toolID(n / 26);
        this.showMessage(n);
    }

    public int addTool(String string) {
        int n = string.indexOf(45);
        boolean bl = n >= 0 && string.length() - n > 4;
        int n2 = -1;
        if (this.names[10] == null) {
            n2 = 10;
        }
        if (n2 == -1) {
            for (int i = 15; i <= 21; ++i) {
                if (this.names[i] != null) continue;
                n2 = i;
                break;
            }
        }
        if (n2 == -1) {
            return -1;
        }
        if (bl) {
            this.icons[n2] = string.substring(n + 1);
            this.names[n2] = n > 0 && string.charAt(n - 1) == ' ' ? string.substring(0, n - 1) : string.substring(0, n);
        } else {
            if (string.endsWith("-")) {
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("- ")) {
                string = string.substring(0, string.length() - 2);
            }
            this.names[n2] = string;
        }
        if (n2 == current && (this.names[n2].indexOf("Action Tool") != -1 || this.names[n2].indexOf("Unused Tool") != -1)) {
            this.setTool(0);
        }
        if (this.names[n2].endsWith(" Menu Tool")) {
            this.installMenu(n2);
        }
        return n2;
    }

    void installMenu(int n) {
        Program program = this.macroInstaller.getProgram();
        Hashtable hashtable = program.getMenus();
        if (hashtable == null) {
            return;
        }
        String[] stringArray = (String[])hashtable.get(this.names[n]);
        if (stringArray == null) {
            return;
        }
        if (this.menus[n] == null) {
            this.menus[n] = new PopupMenu("");
            if (Menus.getFontSize() != 0) {
                this.menus[n].setFont(Menus.getFont());
            }
            this.add(this.menus[n]);
        } else {
            this.menus[n].removeAll();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                this.menus[n].addSeparator();
                continue;
            }
            MenuItem menuItem = new MenuItem(stringArray[i]);
            menuItem.addActionListener(this);
            this.menus[n].add(menuItem);
        }
        if (n == current) {
            this.setTool(0);
        }
    }

    public void addMacroTool(String string, MacroInstaller macroInstaller, int n) {
        if (n == 0) {
            for (int i = 10; i < 22; ++i) {
                this.names[i] = null;
                this.icons[i] = null;
                if (this.menus[i] == null) continue;
                this.menus[i].removeAll();
            }
        }
        this.macroInstaller = macroInstaller;
        this.addTool(string);
    }

    void runMacroTool(int n) {
        if (this.macroInstaller != null) {
            this.macroInstaller.runMacroTool(this.names[n]);
        }
    }

    void showBrushDialog() {
        Roi roi;
        GenericDialog genericDialog = new GenericDialog("Selection Brush");
        genericDialog.addCheckbox("Enable selection brush", ovalType == 2);
        genericDialog.addNumericField("           Size:", brushSize, 0, 4, "pixels");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        if (genericDialog.getNextBoolean()) {
            ovalType = 2;
        }
        if ((brushSize = (int)genericDialog.getNextNumber()) < 1) {
            brushSize = 1;
        }
        Toolbar.repaintTool(1);
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Roi roi2 = roi = imagePlus != null ? imagePlus.getRoi() : null;
        if (roi != null && roi.getType() == 1 && ovalType == 2) {
            imagePlus.killRoi();
        }
        Prefs.set(BRUSH_SIZE, brushSize);
    }

    void showAngleDialog() {
        GenericDialog genericDialog = new GenericDialog("Angle Tool");
        genericDialog.addCheckbox("Measure reflex angle", Prefs.reflexAngle);
        genericDialog.showDialog();
        if (!genericDialog.wasCanceled()) {
            Prefs.reflexAngle = genericDialog.getNextBoolean();
        }
    }

    static {
        foregroundColor = Prefs.getColor("fcolor", Color.black);
        backgroundColor = Prefs.getColor("bcolor", Color.white);
        ovalType = 0;
        multiPointMode = Prefs.multiPointMode;
        brushSize = (int)Prefs.get(BRUSH_SIZE, 15.0);
        arcSize = (int)Prefs.get(CORNER_DIAMETER, 20.0);
    }
}

