/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class ShapeRoi
extends Roi {
    static final int NO_TYPE = 128;
    static final double MAXERROR = 0.001;
    static final double FLATNESS = 0.1;
    private static final int MAXPOLY = 10;
    private static final int OR = 0;
    private static final int AND = 1;
    private static final int XOR = 2;
    private static final int NOT = 3;
    private static final double SHAPE_TO_ROI = -1.0;
    private Shape shape;
    private double maxerror = 0.001;
    private double flatness = 0.1;
    private int maxPoly = 10;
    private boolean flatten;
    private boolean forceTrace = false;
    private boolean forceAngle = false;
    private Vector savedRois;
    private static Stroke defaultStroke = new BasicStroke();

    public ShapeRoi(Roi roi) {
        this(roi, 0.1, 0.001, false, false, false, 10);
    }

    public ShapeRoi(Shape shape) {
        super(shape.getBounds());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-this.x, -this.y);
        this.shape = new GeneralPath(affineTransform.createTransformedShape(shape));
        this.type = 9;
    }

    public ShapeRoi(int n, int n2, Shape shape) {
        super(n, n2, shape.getBounds().width, shape.getBounds().height);
        this.shape = new GeneralPath(shape);
        this.type = 9;
    }

    ShapeRoi(Roi roi, double d, double d2, boolean bl, boolean bl2, boolean bl3, int n) {
        super(roi.startX, roi.startY, roi.width, roi.height);
        this.type = 9;
        this.flatness = d;
        this.maxerror = d2;
        this.forceAngle = bl;
        this.forceTrace = bl2;
        this.maxPoly = n;
        this.flatten = bl3;
        this.shape = this.roiToShape((Roi)roi.clone());
    }

    public ShapeRoi(float[] fArray) {
        super(0, 0, null);
        this.shape = this.makeShapeFromArray(fArray);
        Rectangle rectangle = this.shape.getBounds();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        this.state = 3;
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-this.x, -this.y);
        this.shape = new GeneralPath(affineTransform.createTransformedShape(this.shape));
        this.flatness = 0.1;
        this.maxerror = 0.001;
        this.maxPoly = 10;
        this.flatten = false;
        this.type = 9;
    }

    public synchronized Object clone() {
        ShapeRoi shapeRoi = (ShapeRoi)super.clone();
        shapeRoi.type = 9;
        shapeRoi.flatness = this.flatness;
        shapeRoi.maxerror = this.maxerror;
        shapeRoi.forceAngle = this.forceAngle;
        shapeRoi.forceTrace = this.forceTrace;
        shapeRoi.setShape(ShapeRoi.cloneShape(this.shape));
        return shapeRoi;
    }

    static Shape cloneShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Rectangle2D.Double) {
            return (Rectangle2D.Double)((Rectangle2D.Double)shape).clone();
        }
        if (shape instanceof Ellipse2D.Double) {
            return (Ellipse2D.Double)((Ellipse2D.Double)shape).clone();
        }
        if (shape instanceof Line2D.Double) {
            return (Line2D.Double)((Line2D.Double)shape).clone();
        }
        if (shape instanceof Polygon) {
            return new Polygon(((Polygon)shape).xpoints, ((Polygon)shape).ypoints, ((Polygon)shape).npoints);
        }
        if (shape instanceof GeneralPath) {
            return (GeneralPath)((GeneralPath)shape).clone();
        }
        return new GeneralPath();
    }

    public ShapeRoi or(ShapeRoi shapeRoi) {
        return this.unaryOp(shapeRoi, 0);
    }

    public ShapeRoi and(ShapeRoi shapeRoi) {
        return this.unaryOp(shapeRoi, 1);
    }

    public ShapeRoi xor(ShapeRoi shapeRoi) {
        return this.unaryOp(shapeRoi, 2);
    }

    public ShapeRoi not(ShapeRoi shapeRoi) {
        return this.unaryOp(shapeRoi, 3);
    }

    ShapeRoi unaryOp(ShapeRoi shapeRoi, int n) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.x, this.y);
        Area area = new Area(affineTransform.createTransformedShape(this.getShape()));
        affineTransform = new AffineTransform();
        affineTransform.translate(shapeRoi.x, shapeRoi.y);
        Area area2 = new Area(affineTransform.createTransformedShape(shapeRoi.getShape()));
        try {
            switch (n) {
                case 0: {
                    area.add(area2);
                    break;
                }
                case 1: {
                    area.intersect(area2);
                    break;
                }
                case 2: {
                    area.exclusiveOr(area2);
                    break;
                }
                case 3: {
                    area.subtract(area2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle rectangle = area.getBounds();
        affineTransform = new AffineTransform();
        affineTransform.translate(-rectangle.x, -rectangle.y);
        this.setShape(new GeneralPath(affineTransform.createTransformedShape(area)));
        this.x = rectangle.x;
        this.y = rectangle.y;
        return this;
    }

    private Shape roiToShape(Roi roi) {
        Cloneable cloneable;
        Shape shape = null;
        Rectangle rectangle = roi.getBounds();
        int[] nArray = null;
        int[] nArray2 = null;
        int n = 0;
        switch (roi.getType()) {
            case 5: {
                cloneable = (Line)roi;
                shape = new Line2D.Double(cloneable.x1 - rectangle.x, cloneable.y1 - rectangle.y, cloneable.x2 - rectangle.x, cloneable.y2 - rectangle.y);
                break;
            }
            case 0: {
                int n2 = roi.getCornerDiameter();
                if (n2 > 0) {
                    shape = new RoundRectangle2D.Float(0.0f, 0.0f, rectangle.width, rectangle.height, n2, n2);
                    break;
                }
                shape = new Rectangle2D.Double(0.0, 0.0, rectangle.width, rectangle.height);
                break;
            }
            case 1: {
                Polygon polygon = roi.getPolygon();
                int n3 = 0;
                while (n3 < polygon.npoints) {
                    int n4 = n3;
                    polygon.xpoints[n4] = polygon.xpoints[n4] - rectangle.x;
                    int n5 = n3++;
                    polygon.ypoints[n5] = polygon.ypoints[n5] - rectangle.y;
                }
                shape = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
                break;
            }
            case 2: {
                n = ((PolygonRoi)roi).getNCoordinates();
                nArray = ((PolygonRoi)roi).getXCoordinates();
                nArray2 = ((PolygonRoi)roi).getYCoordinates();
                shape = new Polygon(nArray, nArray2, n);
                break;
            }
            case 3: 
            case 4: {
                n = ((PolygonRoi)roi).getNCoordinates();
                nArray = ((PolygonRoi)roi).getXCoordinates();
                nArray2 = ((PolygonRoi)roi).getYCoordinates();
                shape = new GeneralPath(0, n);
                ((GeneralPath)shape).moveTo(nArray[0], nArray2[0]);
                for (int i = 1; i < n; ++i) {
                    ((GeneralPath)shape).lineTo(nArray[i], nArray2[i]);
                }
                ((GeneralPath)shape).closePath();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n = ((PolygonRoi)roi).getNCoordinates();
                nArray = ((PolygonRoi)roi).getXCoordinates();
                nArray2 = ((PolygonRoi)roi).getYCoordinates();
                shape = new GeneralPath(1, n);
                ((GeneralPath)shape).moveTo(nArray[0], nArray2[0]);
                for (int i = 1; i < n; ++i) {
                    ((GeneralPath)shape).lineTo(nArray[i], nArray2[i]);
                }
                break;
            }
            case 10: {
                ImageProcessor imageProcessor = roi.getMask();
                byte[] byArray = (byte[])imageProcessor.getPixels();
                Rectangle rectangle2 = roi.getBounds();
                int n6 = imageProcessor.getWidth();
                Area area = new Area();
                for (int i = 0; i < imageProcessor.getHeight(); ++i) {
                    int n7 = i * n6;
                    for (int j = 0; j < n6; ++j) {
                        if (byArray[j + n7] == 0) continue;
                        area.add(new Area(new Rectangle(j + rectangle2.x, i + rectangle2.y, 1, 1)));
                    }
                }
                shape = area;
                break;
            }
            case 9: {
                shape = ShapeRoi.cloneShape(((ShapeRoi)roi).getShape());
                break;
            }
            default: {
                throw new IllegalArgumentException("Roi type not supported");
            }
        }
        if (shape != null) {
            this.x = roi.x;
            this.y = roi.y;
            cloneable = shape.getBounds();
            this.width = ((Rectangle)cloneable).width;
            this.height = ((Rectangle)cloneable).height;
            this.startX = this.x;
            this.startY = this.y;
        }
        return shape;
    }

    Shape makeShapeFromArray(float[] fArray) {
        int n;
        if (fArray == null) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(0);
        int n2 = 0;
        float[] fArray2 = new float[7];
        block7: while ((n = this.getSegment(fArray, fArray2, n2)) >= 0) {
            n2 += n;
            int n3 = (int)fArray2[0];
            switch (n3) {
                case 0: {
                    generalPath.moveTo(fArray2[1], fArray2[2]);
                    continue block7;
                }
                case 1: {
                    generalPath.lineTo(fArray2[1], fArray2[2]);
                    continue block7;
                }
                case 2: {
                    generalPath.quadTo(fArray2[1], fArray2[2], fArray2[3], fArray2[4]);
                    continue block7;
                }
                case 3: {
                    generalPath.curveTo(fArray2[1], fArray2[2], fArray2[3], fArray2[4], fArray2[5], fArray2[6]);
                    continue block7;
                }
                case 4: {
                    generalPath.closePath();
                    continue block7;
                }
            }
        }
        return generalPath;
    }

    private int getSegment(float[] fArray, float[] fArray2, int n) {
        int n2 = fArray.length;
        if (n >= n2) {
            return -1;
        }
        fArray2[0] = fArray[n++];
        int n3 = (int)fArray2[0];
        if (n3 == 4) {
            return 1;
        }
        if (n >= n2) {
            return -1;
        }
        fArray2[1] = fArray[n++];
        if (n >= n2) {
            return -1;
        }
        fArray2[2] = fArray[n++];
        if (n3 == 0 || n3 == 1) {
            return 3;
        }
        if (n >= n2) {
            return -1;
        }
        fArray2[3] = fArray[n++];
        if (n >= n2) {
            return -1;
        }
        fArray2[4] = fArray[n++];
        if (n3 == 2) {
            return 5;
        }
        if (n >= n2) {
            return -1;
        }
        fArray2[5] = fArray[n++];
        if (n >= n2) {
            return -1;
        }
        fArray2[6] = fArray[n++];
        if (n3 == 3) {
            return 7;
        }
        return -1;
    }

    void saveRoi(Roi roi) {
        if (this.savedRois == null) {
            this.savedRois = new Vector();
        }
        this.savedRois.addElement(roi);
    }

    public Roi[] getRois() {
        Object object;
        if (this.shape == null) {
            return new Roi[0];
        }
        if (this.savedRois != null) {
            return this.getSavedRois();
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        if (this.shape instanceof Rectangle2D.Double) {
            object = new Roi((int)((Rectangle2D.Double)this.shape).getX(), (int)((Rectangle2D.Double)this.shape).getY(), (int)((Rectangle2D.Double)this.shape).getWidth(), (int)((Rectangle2D.Double)this.shape).getHeight());
            vector.addElement((Object[])object);
        } else if (this.shape instanceof Ellipse2D.Double) {
            object = new OvalRoi((int)((Ellipse2D.Double)this.shape).getX(), (int)((Ellipse2D.Double)this.shape).getY(), (int)((Ellipse2D.Double)this.shape).getWidth(), (int)((Ellipse2D.Double)this.shape).getHeight());
            vector.addElement((Object[])object);
        } else if (this.shape instanceof Line2D.Double) {
            object = new Line((int)((Line2D.Double)this.shape).getX1(), (int)((Line2D.Double)this.shape).getY1(), (int)((Line2D.Double)this.shape).getX2(), (int)((Line2D.Double)this.shape).getY2());
            vector.addElement((Object[])object);
        } else if (this.shape instanceof Polygon) {
            object = new PolygonRoi(((Polygon)this.shape).xpoints, ((Polygon)this.shape).ypoints, ((Polygon)this.shape).npoints, 2);
            vector.addElement((Object[])object);
        } else if (this.shape instanceof GeneralPath) {
            object = this.flatten ? this.getFlatteningPathIterator(this.shape, this.flatness) : this.shape.getPathIterator(new AffineTransform());
            this.parsePath((PathIterator)object, null, null, vector, null);
        }
        object = new Roi[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    Roi[] getSavedRois() {
        Object[] objectArray = new Roi[this.savedRois.size()];
        this.savedRois.copyInto(objectArray);
        return objectArray;
    }

    public Roi shapeToRoi() {
        Vector vector;
        double[] dArray;
        if (this.shape == null || !(this.shape instanceof GeneralPath)) {
            return null;
        }
        PathIterator pathIterator = this.shape.getPathIterator(new AffineTransform());
        if (!this.parsePath(pathIterator, dArray = new double[]{-1.0}, null, vector = new Vector(), null)) {
            return null;
        }
        if (vector.size() == 1) {
            return (Roi)vector.elementAt(0);
        }
        return null;
    }

    private int guessType(int n, boolean bl, boolean bl2, boolean bl3) {
        bl3 = true;
        int n2 = 0;
        if (bl) {
            switch (n) {
                case 0: {
                    n2 = 128;
                    break;
                }
                case 1: {
                    n2 = 128;
                    break;
                }
                case 2: {
                    n2 = bl3 ? 128 : 5;
                    break;
                }
                case 3: {
                    n2 = bl3 ? 2 : (this.forceAngle ? 8 : 6);
                    break;
                }
                case 4: {
                    n2 = bl3 ? 0 : 6;
                    break;
                }
                default: {
                    if (n <= 10) {
                        n2 = bl3 ? 2 : 6;
                        break;
                    }
                    n2 = bl3 ? (this.forceTrace ? 4 : 3) : 7;
                    break;
                }
            }
        } else {
            n2 = n >= 2 ? 9 : 128;
        }
        return n2;
    }

    private Roi createRoi(Vector vector, Vector vector2, int n) {
        int n2;
        if (n == 128) {
            return null;
        }
        Roi roi = null;
        if (vector.size() != vector2.size() || vector.size() == 0) {
            return null;
        }
        int[] nArray = new int[vector.size()];
        int[] nArray2 = new int[vector2.size()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = (Integer)vector.elementAt(n2) + this.x;
            nArray2[n2] = (Integer)vector2.elementAt(n2) + this.y;
        }
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        switch (n) {
            case 9: {
                roi = this;
                break;
            }
            case 1: {
                n2 = nArray[nArray.length - 4];
                n3 = nArray2[nArray2.length - 3];
                n4 = this.max(nArray) - this.min(nArray);
                n5 = this.max(nArray2) - this.min(nArray2);
                roi = new OvalRoi(n2, n3, n4, n5);
                break;
            }
            case 0: {
                n2 = nArray[0];
                n3 = nArray2[0];
                n4 = this.max(nArray) - this.min(nArray);
                n5 = this.max(nArray2) - this.min(nArray2);
                roi = new Roi(n2, n3, n4, n5);
                break;
            }
            case 5: {
                roi = new Line(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                break;
            }
            default: {
                int n6 = nArray.length;
                roi = new PolygonRoi(nArray, nArray2, n6, n);
                if (n != 3) break;
                double d = ((Roi)roi).getLength();
                double d2 = this.ic != null ? this.ic.getMagnification() : 1.0;
                if (!((d *= d2) / (double)n6 >= 15.0)) break;
                roi = new PolygonRoi(nArray, nArray2, n6, 2);
            }
        }
        return roi;
    }

    public boolean contains(int n, int n2) {
        if (this.shape == null) {
            return false;
        }
        return this.shape.contains(n - this.x, n2 - this.y);
    }

    public double[] getFeretValues() {
        Object object;
        Roi[] roiArray = this.getRois();
        if (roiArray != null && roiArray.length == 1) {
            return roiArray[0].getFeretValues();
        }
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        double d4 = 1.0;
        double d5 = 1.0;
        if (this.imp != null) {
            object = this.imp.getCalibration();
            d4 = ((Calibration)object).pixelWidth;
            d5 = ((Calibration)object).pixelHeight;
        }
        object = this.getShape();
        Shape shape = null;
        Rectangle2D rectangle2D = object.getBounds2D();
        double d6 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
        double d7 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d6, d7);
        for (int i = 0; i < 181; ++i) {
            affineTransform.rotate(Math.PI / 180);
            shape = affineTransform.createTransformedShape((Shape)object);
            rectangle2D = shape.getBounds2D();
            double d8 = Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
            if (d8 > d2) {
                d2 = d8 * d4;
            }
            double d9 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
            d = Math.min(d, d9);
        }
        if (d4 != d5) {
            d2 = 0.0;
            d3 = 0.0;
        }
        if (d4 == d5) {
            d *= d4;
        } else {
            d = 0.0;
            d3 = 0.0;
        }
        double[] dArray = new double[]{d2, d3, d, 0.0, 0.0};
        return dArray;
    }

    public double getLength() {
        double d = 0.0;
        Roi[] roiArray = this.getRois();
        if (roiArray != null) {
            for (int i = 0; i < roiArray.length; ++i) {
                d += roiArray[i].getLength();
            }
        }
        return d;
    }

    FlatteningPathIterator getFlatteningPathIterator(Shape shape, double d) {
        return (FlatteningPathIterator)shape.getPathIterator(new AffineTransform(), d);
    }

    double cplength(CubicCurve2D.Double double_) {
        double d = Math.sqrt(Math.pow(double_.ctrlx1 - double_.x1, 2.0) + Math.pow(double_.ctrly1 - double_.y1, 2.0));
        d += Math.sqrt(Math.pow(double_.ctrlx2 - double_.ctrlx1, 2.0) + Math.pow(double_.ctrly2 - double_.ctrly1, 2.0));
        return d += Math.sqrt(Math.pow(double_.x2 - double_.ctrlx2, 2.0) + Math.pow(double_.y2 - double_.ctrly2, 2.0));
    }

    double qplength(QuadCurve2D.Double double_) {
        double d = Math.sqrt(Math.pow(double_.ctrlx - double_.x1, 2.0) + Math.pow(double_.ctrly - double_.y1, 2.0));
        return d += Math.sqrt(Math.pow(double_.x2 - double_.ctrlx, 2.0) + Math.pow(double_.y2 - double_.ctrly, 2.0));
    }

    double cclength(CubicCurve2D.Double double_) {
        return Math.sqrt(Math.pow(double_.x2 - double_.x1, 2.0) + Math.pow(double_.y2 - double_.y1, 2.0));
    }

    double qclength(QuadCurve2D.Double double_) {
        return Math.sqrt(Math.pow(double_.x2 - double_.x1, 2.0) + Math.pow(double_.y2 - double_.y1, 2.0));
    }

    double cBezLength(CubicCurve2D.Double double_) {
        double d = 0.0;
        double d2 = this.cclength(double_);
        double d3 = this.cplength(double_);
        if ((d3 - d2) / 2.0 > this.maxerror) {
            CubicCurve2D.Double[] doubleArray = this.cBezSplit(double_);
            for (int i = 0; i < 2; ++i) {
                d += this.cBezLength(doubleArray[i]);
            }
            return d;
        }
        d = 0.5 * d3 + 0.5 * d2;
        return d;
    }

    double qBezLength(QuadCurve2D.Double double_) {
        double d = 0.0;
        double d2 = this.qclength(double_);
        double d3 = this.qplength(double_);
        if ((d3 - d2) / 2.0 > this.maxerror) {
            QuadCurve2D.Double[] doubleArray = this.qBezSplit(double_);
            for (int i = 0; i < 2; ++i) {
                d += this.qBezLength(doubleArray[i]);
            }
            return d;
        }
        d = (2.0 * d3 + d2) / 3.0;
        return d;
    }

    CubicCurve2D.Double[] cBezSplit(CubicCurve2D.Double double_) {
        CubicCurve2D.Double[] doubleArray = new CubicCurve2D.Double[2];
        for (int i = 0; i < 2; ++i) {
            doubleArray[i] = new CubicCurve2D.Double();
        }
        double_.subdivide(doubleArray[0], doubleArray[1]);
        return doubleArray;
    }

    QuadCurve2D.Double[] qBezSplit(QuadCurve2D.Double double_) {
        QuadCurve2D.Double[] doubleArray = new QuadCurve2D.Double[2];
        for (int i = 0; i < 2; ++i) {
            doubleArray[i] = new QuadCurve2D.Double();
        }
        double_.subdivide(doubleArray[0], doubleArray[1]);
        return doubleArray;
    }

    void scaleCoords(double[] dArray, double d, double d2) {
        int n = dArray.length / 2;
        if (2 * n != dArray.length) {
            return;
        }
        for (int i = 0; i < dArray.length; i += 2) {
            int n2 = i;
            dArray[n2] = dArray[n2] * d;
            int n3 = i + 1;
            dArray[n3] = dArray[n3] * d2;
        }
    }

    Vector parseSegments(PathIterator pathIterator) {
        Vector vector = new Vector();
        if (this.parsePath(pathIterator, null, vector, null, null)) {
            return vector;
        }
        return null;
    }

    public float[] getShapeAsArray() {
        Vector vector;
        Vector vector2;
        if (this.shape == null) {
            return null;
        }
        PathIterator pathIterator = this.shape.getPathIterator(new AffineTransform());
        if (!this.parsePath(pathIterator, null, vector2 = new Vector(), null, vector = new Vector())) {
            return null;
        }
        float[] fArray = new float[7 * vector2.size()];
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        block6: for (int i = 0; i < vector2.size(); ++i) {
            int n3 = (Integer)vector2.elementAt(i);
            switch (n3) {
                case 0: 
                case 1: {
                    fArray[n2++] = n3;
                    Point2D.Double double_ = (Point2D.Double)vector.elementAt(n++);
                    fArray[n2++] = (float)double_.getX() + (float)this.x;
                    fArray[n2++] = (float)double_.getY() + (float)this.y;
                    continue block6;
                }
                case 2: {
                    fArray[n2++] = n3;
                    Point2D.Double double_ = (Point2D.Double)vector.elementAt(n++);
                    fArray[n2++] = (float)double_.getX() + (float)this.x;
                    fArray[n2++] = (float)double_.getY() + (float)this.y;
                    double_ = (Point2D.Double)vector.elementAt(n++);
                    fArray[n2++] = (float)double_.getX() + (float)this.x;
                    fArray[n2++] = (float)double_.getY() + (float)this.y;
                    continue block6;
                }
                case 3: {
                    fArray[n2++] = n3;
                    Point2D.Double double_ = (Point2D.Double)vector.elementAt(n++);
                    fArray[n2++] = (float)double_.getX() + (float)this.x;
                    fArray[n2++] = (float)double_.getY() + (float)this.y;
                    double_ = (Point2D.Double)vector.elementAt(n++);
                    fArray[n2++] = (float)double_.getX() + (float)this.x;
                    fArray[n2++] = (float)double_.getY() + (float)this.y;
                    double_ = (Point2D.Double)vector.elementAt(n++);
                    fArray[n2++] = (float)double_.getX() + (float)this.x;
                    fArray[n2++] = (float)double_.getY() + (float)this.y;
                    continue block6;
                }
                case 4: {
                    fArray[n2++] = n3;
                    continue block6;
                }
            }
        }
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
        return fArray2;
    }

    boolean parsePath(PathIterator pathIterator, double[] dArray, Vector vector, Vector vector2, Vector vector3) {
        Cloneable cloneable;
        boolean bl = true;
        if (pathIterator == null) {
            return false;
        }
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            cloneable = this.imp.getCalibration();
            d = ((Calibration)cloneable).pixelWidth;
            d2 = ((Calibration)cloneable).pixelHeight;
        }
        cloneable = new Vector();
        Vector<Integer> vector4 = new Vector<Integer>();
        if (vector == null) {
            vector = new Vector<Integer>();
        }
        if (vector3 == null) {
            vector3 = new Vector<Point2D.Double>();
        }
        if (dArray == null) {
            dArray = new double[1];
        }
        boolean bl2 = dArray[0] == -1.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = true;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        double d6 = Double.NaN;
        double d7 = Double.NaN;
        double d8 = Double.NaN;
        double d9 = Double.NaN;
        double d10 = Double.NaN;
        double d11 = 0.0;
        boolean bl6 = false;
        while (!bl6) {
            Roi roi;
            double[] dArray2 = new double[6];
            double[] dArray3 = new double[6];
            int n4 = pathIterator.currentSegment(dArray2);
            vector.add(new Integer(n4));
            ++n2;
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            this.scaleCoords(dArray2, d, d2);
            switch (n4) {
                case 0: {
                    if (n > 0) {
                        boolean bl7 = bl3 = (int)d9 == (int)d7 && (int)d10 == (int)d8;
                        if (bl3 && (int)d9 != (int)d7 && (int)d10 != (int)d8) {
                            ((Vector)cloneable).add(new Integer((Integer)((Vector)cloneable).elementAt(0)));
                            vector4.add(new Integer((Integer)vector4.elementAt(0)));
                        }
                        if (vector2 != null && (roi = this.createRoi((Vector)cloneable, vector4, n3 = this.guessType(n2, bl4, bl5, bl3))) != null) {
                            vector2.addElement(roi);
                        }
                        cloneable = new Vector();
                        vector4 = new Vector();
                        n2 = 1;
                    }
                    ++n;
                    d7 = dArray3[0];
                    d8 = dArray3[1];
                    d9 = dArray3[0];
                    d10 = dArray3[1];
                    d3 = dArray2[0];
                    d4 = dArray2[1];
                    d5 = dArray2[0];
                    d6 = dArray2[1];
                    vector3.add(new Point2D.Double(dArray3[0], dArray3[1]));
                    ((Vector)cloneable).add(new Integer((int)dArray3[0]));
                    vector4.add(new Integer((int)dArray3[1]));
                    bl3 = false;
                    break;
                }
                case 1: {
                    bl4 &= true;
                    bl5 &= false;
                    d11 += Math.sqrt(Math.pow(d6 - dArray2[1], 2.0) + Math.pow(d5 - dArray2[0], 2.0));
                    d9 = dArray3[0];
                    d10 = dArray3[1];
                    d5 = dArray2[0];
                    d6 = dArray2[1];
                    vector3.add(new Point2D.Double(dArray3[0], dArray3[1]));
                    ((Vector)cloneable).add(new Integer((int)dArray3[0]));
                    vector4.add(new Integer((int)dArray3[1]));
                    bl3 = (int)d9 == (int)d7 && (int)d10 == (int)d8;
                    break;
                }
                case 2: {
                    bl4 &= false;
                    bl5 &= true;
                    Shape shape = new QuadCurve2D.Double(d5, d6, dArray2[0], dArray2[2], dArray2[2], dArray2[3]);
                    d11 += this.qBezLength((QuadCurve2D.Double)shape);
                    d9 = dArray3[2];
                    d10 = dArray3[3];
                    d5 = dArray2[2];
                    d6 = dArray2[3];
                    vector3.add(new Point2D.Double(dArray3[0], dArray3[1]));
                    vector3.add(new Point2D.Double(dArray3[2], dArray3[3]));
                    ((Vector)cloneable).add(new Integer((int)dArray3[2]));
                    vector4.add(new Integer((int)dArray3[3]));
                    bl3 = (int)d9 == (int)d7 && (int)d10 == (int)d8;
                    break;
                }
                case 3: {
                    bl4 &= false;
                    bl5 &= true;
                    Shape shape = new CubicCurve2D.Double(d5, d6, dArray2[0], dArray2[1], dArray2[2], dArray2[3], dArray2[4], dArray2[5]);
                    d11 += this.cBezLength((CubicCurve2D.Double)shape);
                    d9 = dArray3[4];
                    d10 = dArray3[5];
                    d5 = dArray2[4];
                    d6 = dArray2[5];
                    vector3.add(new Point2D.Double(dArray3[0], dArray3[1]));
                    vector3.add(new Point2D.Double(dArray3[2], dArray3[3]));
                    vector3.add(new Point2D.Double(dArray3[4], dArray3[5]));
                    ((Vector)cloneable).add(new Integer((int)dArray3[4]));
                    vector4.add(new Integer((int)dArray3[5]));
                    bl3 = (int)d9 == (int)d7 && (int)d10 == (int)d8;
                    break;
                }
                case 4: {
                    if ((int)d9 != (int)d7 && (int)d10 != (int)d8) {
                        d11 += Math.sqrt(Math.pow(d5 - d3, 2.0) + Math.pow(d6 - d4, 2.0));
                    }
                    bl3 = true;
                    break;
                }
            }
            pathIterator.next();
            bl6 = pathIterator.isDone() || bl2 && vector2 != null && vector2.size() == 1;
            if (!bl6) continue;
            if (bl3 && (int)d5 != (int)d3 && (int)d6 != (int)d4) {
                ((Vector)cloneable).add(new Integer((Integer)((Vector)cloneable).elementAt(0)));
                vector4.add(new Integer((Integer)vector4.elementAt(0)));
            }
            if (vector2 == null || (roi = this.createRoi((Vector)cloneable, vector4, n3 = bl2 ? 4 : this.guessType(n2 + 1, bl4, bl5, bl3))) == null) continue;
            vector2.addElement(roi);
        }
        dArray[0] = d11;
        return bl;
    }

    public void draw(Graphics graphics) {
        Color color;
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        graphics.setColor(color);
        AffineTransform affineTransform = ((Graphics2D)graphics).getDeviceConfiguration().getDefaultTransform();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.stroke != null) {
            graphics2D.setStroke(this.ic != null && this.ic.getCustomRoi() ? this.stroke : this.getScaledStroke());
        }
        this.mag = this.getMagnification();
        int n = 0;
        int n2 = 0;
        if (this.ic != null) {
            Rectangle rectangle = this.ic.getSrcRect();
            n = rectangle.x;
            n2 = rectangle.y;
        }
        affineTransform.setTransform(this.mag, 0.0, 0.0, this.mag, (double)(-n) * this.mag, (double)(-n2) * this.mag);
        affineTransform.translate(this.x, this.y);
        if (this.fillColor != null) {
            graphics2D.fill(affineTransform.createTransformedShape(this.shape));
        } else {
            graphics2D.draw(affineTransform.createTransformedShape(this.shape));
        }
        if (this.stroke != null) {
            graphics2D.setStroke(defaultStroke);
        }
        if (Toolbar.getToolId() == 1) {
            this.drawRoiBrush(graphics);
        }
        if (this.imp != null && this.imp.getRoi() != null) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public void drawRoiBrush(Graphics graphics) {
        graphics.setColor(ROIColor);
        int n = Toolbar.getBrushSize();
        if (n == 0) {
            return;
        }
        int n2 = this.ic.getModifiers();
        if ((n2 & 0x10) == 0) {
            return;
        }
        n = (int)((double)n * this.mag);
        Point point = this.ic.getCursorLoc();
        int n3 = this.ic.screenX(point.x);
        int n4 = this.ic.screenY(point.y);
        graphics.drawOval(n3 - n / 2, n4 - n / 2, n, n);
    }

    public void drawPixels(ImageProcessor imageProcessor) {
        PathIterator pathIterator = this.shape.getPathIterator(new AffineTransform(), this.flatness);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    imageProcessor.moveTo(this.x + (int)f, this.y + (int)f2);
                    break;
                }
                case 1: {
                    imageProcessor.lineTo(this.x + (int)fArray[0], this.y + (int)fArray[1]);
                    break;
                }
                case 4: {
                    imageProcessor.lineTo(this.x + (int)f, this.y + (int)f2);
                    break;
                }
            }
            pathIterator.next();
        }
    }

    public ImageProcessor getMask() {
        if (this.shape == null) {
            return null;
        }
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fill(this.shape);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        this.cachedMask = new ByteProcessor(this.width, this.height, byArray, null);
        return this.cachedMask;
    }

    public Shape getShape() {
        return this.shape;
    }

    boolean setShape(Shape shape) {
        boolean bl = true;
        if (shape == null) {
            return false;
        }
        if (this.shape.equals(shape)) {
            return false;
        }
        this.shape = shape;
        this.type = 9;
        Rectangle rectangle = this.shape.getBounds();
        this.width = rectangle.width;
        this.height = rectangle.height;
        return true;
    }

    private int min(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = Math.min(n, nArray[i]);
        }
        return n;
    }

    private int max(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = Math.max(n, nArray[i]);
        }
        return n;
    }

    static ShapeRoi getCircularRoi(int n, int n2, int n3) {
        return new ShapeRoi(new OvalRoi(n - n3 / 2, n2 - n3 / 2, n3, n3));
    }

    public int isHandle(int n, int n2) {
        return -1;
    }

    public Polygon getConvexHull() {
        Roi[] roiArray = this.getRois();
        if (roiArray != null && roiArray.length == 1) {
            return roiArray[0].getConvexHull();
        }
        return null;
    }
}

