/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.EllipseRoi;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.SplineFitter;
import ij.plugin.frame.LineWidthAdjuster;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.process.PolygonFiller;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class PolygonRoi
extends Roi {
    protected int maxPoints = 1000;
    protected int[] xp;
    protected int[] yp;
    protected float[] xpf;
    protected float[] ypf;
    protected int[] xp2;
    protected int[] yp2;
    protected int nPoints;
    protected float[] xSpline;
    protected float[] ySpline;
    protected int splinePoints = 200;
    Rectangle clip;
    private double angle1;
    private double degrees = Double.NaN;
    private int xClipMin;
    private int yClipMin;
    private int xClipMax;
    private int yClipMax;
    private boolean userCreated;
    long mouseUpTime = 0L;

    public PolygonRoi(int[] nArray, int[] nArray2, int n, int n2) {
        super(0, 0, null);
        this.init1(n, n2);
        this.xp = nArray;
        this.yp = nArray2;
        if (n2 != 4) {
            this.xp = new int[n];
            this.yp = new int[n];
            for (int i = 0; i < n; ++i) {
                this.xp[i] = nArray[i];
                this.yp[i] = nArray2[i];
            }
        }
        this.xp2 = new int[n];
        this.yp2 = new int[n];
        this.init2(n2);
    }

    public PolygonRoi(float[] fArray, float[] fArray2, int n, int n2) {
        super(0, 0, null);
        this.init1(n, n2);
        this.xpf = fArray;
        this.ypf = fArray2;
        this.xp2 = new int[n];
        this.yp2 = new int[n];
        this.init2(n2);
    }

    private void init1(int n, int n2) throws IllegalArgumentException {
        this.maxPoints = n;
        this.nPoints = n;
        if (n2 == 2) {
            this.type = 2;
        } else if (n2 == 3) {
            this.type = 3;
        } else if (n2 == 4) {
            this.type = 4;
        } else if (n2 == 6) {
            this.type = 6;
        } else if (n2 == 7) {
            this.type = 7;
        } else if (n2 == 8) {
            this.type = 8;
        } else if (n2 == 10) {
            this.type = 10;
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
    }

    private void init2(int n) {
        if (n == 8 && this.nPoints == 3) {
            this.getAngleAsString();
        }
        if (n == 10 && Toolbar.getMultiPointMode()) {
            Prefs.pointAutoMeasure = false;
            Prefs.pointAutoNextSlice = false;
            Prefs.pointAddToManager = false;
            this.userCreated = true;
        }
        if (lineWidth > 1 && this.isLine()) {
            this.updateWideLine(lineWidth);
        }
        this.finishPolygon();
    }

    public PolygonRoi(Polygon polygon, int n) {
        this(polygon.xpoints, polygon.ypoints, polygon.npoints, n);
    }

    public PolygonRoi(int[] nArray, int[] nArray2, int n, ImagePlus imagePlus, int n2) {
        this(nArray, nArray2, n, n2);
        this.setImage(imagePlus);
    }

    public PolygonRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        int n3 = Toolbar.getToolId();
        switch (n3) {
            case 2: {
                this.type = 2;
                break;
            }
            case 3: {
                this.type = 3;
                break;
            }
            case 6: {
                this.type = 7;
                break;
            }
            case 14: {
                this.type = 8;
                break;
            }
            default: {
                this.type = 6;
            }
        }
        if (this instanceof EllipseRoi) {
            this.xpf = new float[this.maxPoints];
            this.ypf = new float[this.maxPoints];
        } else {
            this.xp = new int[this.maxPoints];
            this.yp = new int[this.maxPoints];
        }
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = 2;
        this.x = this.ic.offScreenX(n);
        this.y = this.ic.offScreenY(n2);
        this.width = 1;
        this.height = 1;
        this.clipX = this.x;
        this.clipY = this.y;
        this.clipWidth = 1;
        this.clipHeight = 1;
        this.state = 0;
        this.userCreated = true;
        if (lineWidth > 1 && this.isLine()) {
            this.updateWideLine(lineWidth);
        }
    }

    private void drawStartBox(Graphics graphics) {
        if (this.type != 8) {
            graphics.drawRect(this.ic.screenX(this.startX) - 4, this.ic.screenY(this.startY) - 4, 8, 8);
        }
    }

    public void draw(Graphics graphics) {
        this.updatePolygon();
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        boolean bl = false;
        if (this.fillColor != null && !this.isLine() && this.state != 0) {
            color = this.fillColor;
            bl = true;
        }
        graphics.setColor(color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.stroke != null) {
            graphics2D.setStroke(this.getScaledStroke());
        }
        if (this.xSpline != null) {
            if (this.type == 6 || this.type == 7) {
                this.drawSpline(graphics, this.xSpline, this.ySpline, this.splinePoints, false, bl);
                if (this.wideLine && !this.overlay) {
                    graphics2D.setStroke(onePixelWide);
                    graphics.setColor(PolygonRoi.getColor());
                    this.drawSpline(graphics, this.xSpline, this.ySpline, this.splinePoints, false, bl);
                }
            } else {
                this.drawSpline(graphics, this.xSpline, this.ySpline, this.splinePoints, true, bl);
            }
        } else {
            if (this.type == 6 || this.type == 7 || this.type == 8 || this.state == 0) {
                graphics.drawPolyline(this.xp2, this.yp2, this.nPoints);
                if (this.wideLine && !this.overlay) {
                    graphics2D.setStroke(onePixelWide);
                    graphics.setColor(PolygonRoi.getColor());
                    graphics.drawPolyline(this.xp2, this.yp2, this.nPoints);
                }
            } else if (bl) {
                graphics.fillPolygon(this.xp2, this.yp2, this.nPoints);
            } else {
                graphics.drawPolygon(this.xp2, this.yp2, this.nPoints);
            }
            if (this.state == 0 && this.type != 3 && this.type != 7) {
                this.drawStartBox(graphics);
            }
        }
        if (!(this.xSpline == null && this.type != 2 && this.type != 6 && this.type != 8 || this.state == 0 || this.clipboard != null || this.overlay)) {
            this.mag = this.getMagnification();
            int n = 2;
            if (this.activeHandle > 0) {
                this.drawHandle(graphics, this.xp2[this.activeHandle - 1] - n, this.yp2[this.activeHandle - 1] - n);
            }
            if (this.activeHandle < this.nPoints - 1) {
                this.drawHandle(graphics, this.xp2[this.activeHandle + 1] - n, this.yp2[this.activeHandle + 1] - n);
            }
            this.handleColor = this.strokeColor != null ? this.strokeColor : ROIColor;
            this.drawHandle(graphics, this.xp2[0] - n, this.yp2[0] - n);
            this.handleColor = Color.white;
            for (int i = 1; i < this.nPoints; ++i) {
                this.drawHandle(graphics, this.xp2[i] - n, this.yp2[i] - n);
            }
        }
        this.drawPreviousRoi(graphics);
        if (this.state != 4 && this.state != 0 && this.state != 3) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    private void drawSpline(Graphics graphics, float[] fArray, float[] fArray2, int n, boolean bl, boolean bl2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        if (this.ic != null) {
            Rectangle rectangle = this.ic.getSrcRect();
            f = rectangle.x;
            f2 = rectangle.y;
            f3 = (float)this.ic.getMagnification();
        }
        float f4 = this.x;
        float f5 = this.y;
        Graphics2D graphics2D = (Graphics2D)graphics;
        GeneralPath generalPath = new GeneralPath();
        if (f3 == 1.0f && f == 0.0f && f2 == 0.0f) {
            generalPath.moveTo(fArray[0] + f4, fArray2[0] + f5);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(fArray[i] + f4, fArray2[i] + f5);
            }
        } else {
            generalPath.moveTo((fArray[0] - f + f4) * f3, (fArray2[0] - f2 + f5) * f3);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo((fArray[i] - f + f4) * f3, (fArray2[i] - f2 + f5) * f3);
            }
        }
        if (bl) {
            generalPath.lineTo((fArray[0] - f + f4) * f3, (fArray2[0] - f2 + f5) * f3);
        }
        if (bl2) {
            graphics2D.fill(generalPath);
        } else {
            graphics2D.draw(generalPath);
        }
    }

    public void drawPixels(ImageProcessor imageProcessor) {
        int n = imageProcessor.getLineWidth();
        if (this.getStrokeWidth() > 1.0f) {
            imageProcessor.setLineWidth(Math.round(this.getStrokeWidth()));
        }
        if (this.xSpline != null) {
            imageProcessor.moveTo(this.x + (int)(Math.floor(this.xSpline[0]) + 0.5), this.y + (int)Math.floor((double)this.ySpline[0] + 0.5));
            for (int i = 1; i < this.splinePoints; ++i) {
                imageProcessor.lineTo(this.x + (int)(Math.floor(this.xSpline[i]) + 0.5), this.y + (int)Math.floor((double)this.ySpline[i] + 0.5));
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                imageProcessor.lineTo(this.x + (int)(Math.floor(this.xSpline[0]) + 0.5), this.y + (int)Math.floor((double)this.ySpline[0] + 0.5));
            }
        } else if (this.xpf != null) {
            imageProcessor.moveTo(this.x + (int)(Math.floor(this.xpf[0]) + 0.5), this.y + (int)Math.floor((double)this.ypf[0] + 0.5));
            for (int i = 1; i < this.nPoints; ++i) {
                imageProcessor.lineTo(this.x + (int)(Math.floor(this.xpf[i]) + 0.5), this.y + (int)Math.floor((double)this.ypf[i] + 0.5));
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                imageProcessor.lineTo(this.x + (int)(Math.floor(this.xpf[0]) + 0.5), this.y + (int)Math.floor((double)this.ypf[0] + 0.5));
            }
        } else {
            imageProcessor.moveTo(this.x + this.xp[0], this.y + this.yp[0]);
            for (int i = 1; i < this.nPoints; ++i) {
                imageProcessor.lineTo(this.x + this.xp[i], this.y + this.yp[i]);
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                imageProcessor.lineTo(this.x + this.xp[0], this.y + this.yp[0]);
            }
        }
        imageProcessor.setLineWidth(n);
        this.updateFullWindow = true;
    }

    protected void grow(int n, int n2) {
    }

    protected void updatePolygon() {
        int n = 0;
        int n2 = 0;
        if (this.ic != null) {
            Rectangle rectangle = this.ic.getSrcRect();
            n = rectangle.x;
            n2 = rectangle.y;
        }
        if (this.getMagnification() == 1.0 && n == 0 && n2 == 0) {
            if (this.xpf != null) {
                for (int i = 0; i < this.nPoints; ++i) {
                    this.xp2[i] = (int)(this.xpf[i] + (float)this.x);
                    this.yp2[i] = (int)(this.ypf[i] + (float)this.y);
                }
            } else {
                for (int i = 0; i < this.nPoints; ++i) {
                    this.xp2[i] = this.xp[i] + this.x;
                    this.yp2[i] = this.yp[i] + this.y;
                }
            }
        } else if (this.xpf != null) {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp2[i] = this.ic.screenXD(this.xpf[i] + (float)this.x);
                this.yp2[i] = this.ic.screenYD(this.ypf[i] + (float)this.y);
            }
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp2[i] = this.ic.screenX(this.xp[i] + this.x);
                this.yp2[i] = this.ic.screenY(this.yp[i] + this.y);
            }
        }
    }

    void handleMouseMove(int n, int n2) {
        int n3 = Toolbar.getToolId();
        if (n3 != 2 && n3 != 5 && n3 != 14) {
            this.imp.killRoi();
            this.imp.draw();
            return;
        }
        this.drawRubberBand(n, n2);
        this.degrees = Double.NaN;
        double d = -1.0;
        if (this.nPoints > 1) {
            int n4 = this.xp[this.nPoints - 2];
            int n5 = this.yp[this.nPoints - 2];
            int n6 = this.xp[this.nPoints - 1];
            int n7 = this.yp[this.nPoints - 1];
            this.degrees = this.getAngle(n4, n5, n6, n7);
            if (n3 != 14) {
                Calibration calibration = this.imp.getCalibration();
                double d2 = calibration.pixelWidth;
                double d3 = calibration.pixelHeight;
                if (IJ.altKeyDown()) {
                    d2 = 1.0;
                    d3 = 1.0;
                }
                d = Math.sqrt((double)(n6 - n4) * d2 * (double)(n6 - n4) * d2 + (double)(n7 - n5) * d3 * (double)(n7 - n5) * d3);
            }
        }
        if (n3 == 14) {
            if (this.nPoints == 2) {
                this.angle1 = this.degrees;
            } else if (this.nPoints == 3) {
                double d4 = this.getAngle(this.xp[1], this.yp[1], this.xp[2], this.yp[2]);
                this.degrees = Math.abs(180.0 - Math.abs(this.angle1 - d4));
                if (this.degrees > 180.0) {
                    this.degrees = 360.0 - this.degrees;
                }
            }
        }
        String string = d != -1.0 ? ", length=" + IJ.d2s(d) : "";
        double d5 = n3 == 14 && this.nPoints == 3 && Prefs.reflexAngle ? 360.0 - this.degrees : this.degrees;
        String string2 = !Double.isNaN(this.degrees) ? ", angle=" + IJ.d2s(d5) : "";
        IJ.showStatus(this.imp.getLocationAsString(n, n2) + string + string2);
    }

    void drawRubberBand(int n, int n2) {
        double d;
        int n3 = this.xp[this.nPoints - 2] + this.x;
        int n4 = this.yp[this.nPoints - 2] + this.y;
        int n5 = this.xp[this.nPoints - 1] + this.x;
        int n6 = this.yp[this.nPoints - 1] + this.y;
        int n7 = 9999;
        int n8 = 9999;
        int n9 = 0;
        int n10 = 0;
        if (n3 < n7) {
            n7 = n3;
        }
        if (n5 < n7) {
            n7 = n5;
        }
        if (n < n7) {
            n7 = n;
        }
        if (n3 > n9) {
            n9 = n3;
        }
        if (n5 > n9) {
            n9 = n5;
        }
        if (n > n9) {
            n9 = n;
        }
        if (n4 < n8) {
            n8 = n4;
        }
        if (n6 < n8) {
            n8 = n6;
        }
        if (n2 < n8) {
            n8 = n2;
        }
        if (n4 > n10) {
            n10 = n4;
        }
        if (n6 > n10) {
            n10 = n6;
        }
        if (n2 > n10) {
            n10 = n2;
        }
        int n11 = 4;
        if (this.ic != null && (d = this.ic.getMagnification()) < 1.0) {
            n11 = (int)((double)n11 / d);
        }
        n11 = (int)((float)n11 + this.getStrokeWidth());
        this.xp[this.nPoints - 1] = n - this.x;
        this.yp[this.nPoints - 1] = n2 - this.y;
        this.imp.draw(n7 - n11, n8 - n11, n9 - n7 + n11 * 2, n10 - n8 + n11 * 2);
    }

    void finishPolygon() {
        Rectangle rectangle;
        Object object;
        if (this.xpf != null) {
            object = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
            rectangle = ((FloatPolygon)object).getBounds();
        } else {
            object = new Polygon(this.xp, this.yp, this.nPoints);
            rectangle = ((Polygon)object).getBounds();
        }
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        if (this.xpf != null) {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xpf[i] = this.xpf[i] - (float)this.x;
                this.ypf[i] = this.ypf[i] - (float)this.y;
            }
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp[i] = this.xp[i] - this.x;
                this.yp[i] = this.yp[i] - this.y;
            }
        }
        if (this.nPoints < 2 || this.type != 7 && this.type != 6 && this.type != 8 && (this.nPoints < 3 || this.width == 0 || this.height == 0)) {
            if (this.imp != null) {
                this.imp.killRoi();
            }
            if (this.type != 10) {
                return;
            }
        }
        this.state = 3;
        if (this.imp != null && this.type != 4) {
            this.imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        if (Recorder.record && this.userCreated && (this.type == 2 || this.type == 6 || this.type == 8 || this.type == 10 && Recorder.scriptMode() && this.nPoints == 3)) {
            Recorder.recordRoi(this.getPolygon(), this.type);
        }
        if (this.type != 10) {
            this.modifyRoi();
        }
        LineWidthAdjuster.update();
    }

    public void exitConstructingMode() {
        if (this.type == 6 && this.state == 0) {
            this.addOffset();
            this.finishPolygon();
        }
    }

    protected void moveHandle(int n, int n2) {
        if (this.clipboard != null) {
            return;
        }
        int n3 = this.ic.offScreenX(n);
        int n4 = this.ic.offScreenY(n2);
        this.xp[this.activeHandle] = n3 - this.x;
        this.yp[this.activeHandle] = n4 - this.y;
        if (this.xSpline != null) {
            this.fitSpline(this.splinePoints);
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
        } else {
            this.resetBoundingRect();
            if (this.type == 10 && this.width == 0 && this.height == 0) {
                this.width = 1;
                this.height = 1;
            }
            this.updateClipRectAndDraw();
        }
        String string = this.type == 8 ? this.getAngleAsString() : "";
        IJ.showStatus(this.imp.getLocationAsString(n3, n4) + string);
    }

    void updateClipRectAndDraw() {
        int n;
        int n2;
        int n3;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = 0;
        if (this.activeHandle > 0) {
            n3 = this.x + this.xp[this.activeHandle - 1];
            n2 = this.y + this.yp[this.activeHandle - 1];
        } else {
            n3 = this.x + this.xp[this.nPoints - 1];
            n2 = this.y + this.yp[this.nPoints - 1];
        }
        if (n3 < n4) {
            n4 = n3;
        }
        if (n2 < n5) {
            n5 = n2;
        }
        if (n3 > n6) {
            n6 = n3;
        }
        if (n2 > n7) {
            n7 = n2;
        }
        n3 = this.x + this.xp[this.activeHandle];
        n2 = this.y + this.yp[this.activeHandle];
        if (n3 < n4) {
            n4 = n3;
        }
        if (n2 < n5) {
            n5 = n2;
        }
        if (n3 > n6) {
            n6 = n3;
        }
        if (n2 > n7) {
            n7 = n2;
        }
        if (this.activeHandle < this.nPoints - 1) {
            n3 = this.x + this.xp[this.activeHandle + 1];
            n2 = this.y + this.yp[this.activeHandle + 1];
        } else {
            n3 = this.x + this.xp[0];
            n2 = this.y + this.yp[0];
        }
        if (n3 < n4) {
            n4 = n3;
        }
        if (n2 < n5) {
            n5 = n2;
        }
        if (n3 > n6) {
            n6 = n3;
        }
        if (n2 > n7) {
            n7 = n2;
        }
        int n8 = n4;
        int n9 = n5;
        int n10 = n6;
        int n11 = n7;
        if (this.xClipMin < n8) {
            n8 = this.xClipMin;
        }
        if (this.yClipMin < n9) {
            n9 = this.yClipMin;
        }
        if (this.xClipMax > n10) {
            n10 = this.xClipMax;
        }
        if (this.yClipMax > n11) {
            n11 = this.yClipMax;
        }
        this.xClipMin = n4;
        this.yClipMin = n5;
        this.xClipMax = n6;
        this.yClipMax = n7;
        double d = this.ic.getMagnification();
        int n12 = n = this.type == 10 ? 13 : 5;
        if ((float)n < this.getStrokeWidth() && this.isLine()) {
            n = (int)this.getStrokeWidth();
        }
        int n13 = d < 1.0 ? (int)((double)n / d) : n;
        n13 = (int)((float)n13 * this.getStrokeWidth());
        this.imp.draw(n8 - n13, n9 - n13, n10 - n8 + n13 * 2, n11 - n9 + n13 * 2);
    }

    void resetBoundingRect() {
        int n;
        int n2 = Integer.MAX_VALUE;
        int n3 = -n2;
        int n4 = n2;
        int n5 = n3;
        for (n = 0; n < this.nPoints; ++n) {
            int n6;
            int n7 = this.xp[n];
            if (n7 < n2) {
                n2 = n7;
            }
            if (n7 > n3) {
                n3 = n7;
            }
            if ((n6 = this.yp[n]) < n4) {
                n4 = n6;
            }
            if (n6 <= n5) continue;
            n5 = n6;
        }
        if (n2 != 0) {
            n = 0;
            while (n < this.nPoints) {
                int n8 = n++;
                this.xp[n8] = this.xp[n8] - n2;
            }
        }
        if (n4 != 0) {
            n = 0;
            while (n < this.nPoints) {
                int n9 = n++;
                this.yp[n9] = this.yp[n9] - n4;
            }
        }
        this.x += n2;
        this.y += n4;
        this.width = n3 - n2;
        this.height = n5 - n4;
    }

    String getAngleAsString() {
        double d = this.getAngle(this.xp[0], this.yp[0], this.xp[1], this.yp[1]);
        double d2 = this.getAngle(this.xp[1], this.yp[1], this.xp[2], this.yp[2]);
        this.degrees = Math.abs(180.0 - Math.abs(d - d2));
        if (this.degrees > 180.0) {
            this.degrees = 360.0 - this.degrees;
        }
        double d3 = Prefs.reflexAngle && this.type == 8 ? 360.0 - this.degrees : this.degrees;
        return ", angle=" + IJ.d2s(d3);
    }

    protected void mouseDownInHandle(int n, int n2, int n3) {
        if (this.state == 0) {
            return;
        }
        int n4 = this.ic.offScreenX(n2);
        int n5 = this.ic.offScreenY(n3);
        if (IJ.altKeyDown() && (this.nPoints > 3 || this.type == 10)) {
            this.deleteHandle(n4, n5);
            return;
        }
        if (IJ.shiftKeyDown() && this.type != 10) {
            this.addHandle(n4, n5);
            return;
        }
        this.state = 4;
        this.activeHandle = n;
        int n6 = (int)(10.0 / this.ic.getMagnification());
        this.xClipMin = n4 - n6;
        this.yClipMin = n5 - n6;
        this.xClipMax = n4 + n6;
        this.yClipMax = n5 + n6;
    }

    public void deleteHandle(int n, int n2) {
        if (this.imp == null) {
            return;
        }
        if (this.nPoints <= 1) {
            this.imp.killRoi();
            return;
        }
        boolean bl = this.xSpline != null;
        this.xSpline = null;
        Polygon polygon = this.getPolygon();
        this.modState = 0;
        if (previousRoi != null) {
            PolygonRoi.previousRoi.modState = 0;
        }
        int n3 = this.getClosestPoint(n, n2, polygon);
        Polygon polygon2 = new Polygon();
        for (int i = 0; i < polygon.npoints; ++i) {
            if (i == n3) continue;
            polygon2.addPoint(polygon.xpoints[i], polygon.ypoints[i]);
        }
        if (this.type == 10) {
            this.imp.setRoi(new PointRoi(polygon2.xpoints, polygon2.ypoints, polygon2.npoints));
        } else {
            this.imp.setRoi(new PolygonRoi(polygon2, this.type));
            if (bl) {
                ((PolygonRoi)this.imp.getRoi()).fitSpline(this.splinePoints);
            }
        }
    }

    void addHandle(int n, int n2) {
        if (this.imp == null || this.type == 8) {
            return;
        }
        boolean bl = this.xSpline != null;
        this.xSpline = null;
        Polygon polygon = this.getPolygon();
        int n3 = polygon.npoints;
        this.modState = 0;
        if (previousRoi != null) {
            PolygonRoi.previousRoi.modState = 0;
        }
        int n4 = this.getClosestPoint(n, n2, polygon);
        Polygon polygon2 = new Polygon();
        for (int i = 0; i < n3; ++i) {
            if (i == n4) {
                int n5;
                int n6 = i - 1;
                if (n6 == -1) {
                    int n7 = n6 = this.isLine() ? i : n3 - 1;
                }
                if ((n5 = i + 1) == n3) {
                    n5 = this.isLine() ? i : 0;
                }
                int n8 = polygon.xpoints[n6] + 2 * (polygon.xpoints[i] - polygon.xpoints[n6]) / 3;
                int n9 = polygon.ypoints[n6] + 2 * (polygon.ypoints[i] - polygon.ypoints[n6]) / 3;
                int n10 = polygon.xpoints[i] + (polygon.xpoints[n5] - polygon.xpoints[i]) / 3;
                int n11 = polygon.ypoints[i] + (polygon.ypoints[n5] - polygon.ypoints[i]) / 3;
                polygon2.addPoint(n8, n9);
                polygon2.addPoint(n10, n11);
                continue;
            }
            polygon2.addPoint(polygon.xpoints[i], polygon.ypoints[i]);
        }
        if (this.type == 10) {
            this.imp.setRoi(new PointRoi(polygon2.xpoints, polygon2.ypoints, polygon2.npoints));
        } else {
            this.imp.setRoi(new PolygonRoi(polygon2, this.type));
            if (bl) {
                ((PolygonRoi)this.imp.getRoi()).fitSpline(this.splinePoints);
            }
        }
    }

    int getClosestPoint(int n, int n2, Polygon polygon) {
        int n3 = 0;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < polygon.npoints; ++i) {
            double d2 = polygon.xpoints[i] - n;
            double d3 = polygon.ypoints[i] - n2;
            double d4 = d2 * d2 + d3 * d3;
            if (!(d4 < d)) continue;
            d = d4;
            n3 = i;
        }
        return n3;
    }

    public void fitSpline(int n) {
        int n2;
        int n3;
        if (this.xSpline == null || this.splinePoints != n) {
            this.splinePoints = n;
            this.xSpline = new float[this.splinePoints];
            this.ySpline = new float[this.splinePoints];
        }
        int n4 = this.nPoints;
        if (this.type == 2) {
            if (++n4 >= this.xp.length) {
                this.enlargeArrays();
            }
            this.xp[n4 - 1] = this.xp[0];
            this.yp[n4 - 1] = this.yp[0];
        }
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = i;
        }
        SplineFitter splineFitter = new SplineFitter(nArray, this.xp, n4);
        SplineFitter splineFitter2 = new SplineFitter(nArray, this.yp, n4);
        double d = (double)(n4 - 1) / (double)(this.splinePoints - 1);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = Float.MAX_VALUE;
        float f4 = -f3;
        float f5 = f3;
        float f6 = f4;
        for (n3 = 0; n3 < this.splinePoints; ++n3) {
            double d2 = (double)n3 * d;
            f = (float)splineFitter.evalSpline(nArray, this.xp, n4, d2);
            if (f < f3) {
                f3 = f;
            }
            if (f > f4) {
                f4 = f;
            }
            this.xSpline[n3] = f;
            f2 = (float)splineFitter2.evalSpline(nArray, this.yp, n4, d2);
            if (f2 < f5) {
                f5 = f2;
            }
            if (f2 > f6) {
                f6 = f2;
            }
            this.ySpline[n3] = f2;
        }
        n3 = (int)Math.floor(f3 + 0.5f);
        int n5 = (int)Math.floor(f4 + 0.5f);
        int n6 = (int)Math.floor(f5 + 0.5f);
        int n7 = (int)Math.floor(f6 + 0.5f);
        if (n3 != 0) {
            n2 = 0;
            while (n2 < this.nPoints) {
                int n8 = n2++;
                this.xp[n8] = this.xp[n8] - n3;
            }
            n2 = 0;
            while (n2 < this.splinePoints) {
                int n9 = n2++;
                this.xSpline[n9] = this.xSpline[n9] - (float)n3;
            }
        }
        if (n6 != 0) {
            n2 = 0;
            while (n2 < this.nPoints) {
                int n10 = n2++;
                this.yp[n10] = this.yp[n10] - n6;
            }
            n2 = 0;
            while (n2 < this.splinePoints) {
                int n11 = n2++;
                this.ySpline[n11] = this.ySpline[n11] - (float)n6;
            }
        }
        this.x += n3;
        this.y += n6;
        this.width = n5 - n3;
        this.height = n7 - n6;
        this.cachedMask = null;
    }

    public void fitSpline() {
        double d;
        double d2 = this.getUncalibratedLength();
        int n = (int)(d2 / 2.0);
        if (this.ic != null && (d = this.ic.getMagnification()) < 1.0) {
            n = (int)((double)n * d);
        }
        if (n < 100) {
            n = 100;
        }
        this.fitSpline(n);
    }

    public void removeSplineFit() {
        this.xSpline = null;
        this.ySpline = null;
    }

    public boolean isSplineFit() {
        return this.xSpline != null;
    }

    public void fitSplineForStraightening() {
        this.fitSpline((int)this.getUncalibratedLength() * 2);
        if (this.splinePoints == 0) {
            return;
        }
        float[] fArray = new float[this.splinePoints * 2];
        float[] fArray2 = new float[this.splinePoints * 2];
        fArray[0] = this.xSpline[0];
        fArray2[0] = this.ySpline[0];
        int n = 1;
        double d = 0.01;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.xSpline[0];
        double d7 = this.ySpline[0];
        for (int i = 1; i < this.splinePoints; ++i) {
            double d8 = d6;
            double d9 = d7;
            double d10 = d8;
            double d11 = d9;
            d6 = this.xSpline[i];
            d7 = this.ySpline[i];
            d4 = d6 - d8;
            d5 = d7 - d9;
            d2 = Math.sqrt(d4 * d4 + d5 * d5);
            double d12 = d4 * d / d2;
            double d13 = d5 * d / d2;
            double d14 = fArray[n - 1];
            double d15 = fArray2[n - 1];
            int n2 = (int)(d2 / d);
            if (this.splinePoints == 2) {
                ++n2;
            }
            do {
                if ((d3 = Math.sqrt((d4 = d10 - d14) * d4 + (d5 = d11 - d15) * d5)) >= 1.0 - d / 2.0 && n < fArray.length - 1) {
                    fArray[n] = (float)d10;
                    fArray2[n] = (float)d11;
                    ++n;
                    d14 = d10;
                    d15 = d11;
                }
                d10 += d12;
                d11 += d13;
            } while (--n2 > 0);
        }
        this.xSpline = fArray;
        this.ySpline = fArray2;
        this.splinePoints = n;
    }

    public double getUncalibratedLength() {
        ImagePlus imagePlus = this.imp;
        this.imp = null;
        double d = this.getLength();
        this.imp = imagePlus;
        return d;
    }

    protected void handleMouseUp(int n, int n2) {
        if (this.state == 1) {
            this.state = 3;
            return;
        }
        if (this.state == 4) {
            this.cachedMask = null;
            this.state = 3;
            this.updateClipRect();
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
            return;
        }
        if (this.state != 0) {
            return;
        }
        if (IJ.spaceBarDown()) {
            return;
        }
        boolean bl = this.xp[this.nPoints - 2] == this.xp[this.nPoints - 1] && this.yp[this.nPoints - 2] == this.yp[this.nPoints - 1];
        Rectangle rectangle = new Rectangle(this.ic.screenX(this.startX) - 5, this.ic.screenY(this.startY) - 5, 10, 10);
        if (this.nPoints > 2 && (rectangle.contains(n, n2) || this.ic.offScreenX(n) == this.startX && this.ic.offScreenY(n2) == this.startY || bl && System.currentTimeMillis() - this.mouseUpTime <= 500L)) {
            --this.nPoints;
            this.addOffset();
            this.finishPolygon();
            return;
        }
        if (!bl) {
            this.mouseUpTime = System.currentTimeMillis();
            if (this.type == 8 && this.nPoints == 3) {
                this.addOffset();
                this.finishPolygon();
                return;
            }
            this.xp[this.nPoints] = this.xp[this.nPoints - 1];
            this.yp[this.nPoints] = this.yp[this.nPoints - 1];
            ++this.nPoints;
            if (this.nPoints == this.xp.length) {
                this.enlargeArrays();
            }
        }
    }

    protected void addOffset() {
        if (this.xpf != null) {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xpf[i] = this.xpf[i] + (float)this.x;
                this.ypf[i] = this.ypf[i] + (float)this.y;
            }
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp[i] = this.xp[i] + this.x;
                this.yp[i] = this.yp[i] + this.y;
            }
        }
    }

    public boolean contains(int n, int n2) {
        if (!super.contains(n, n2)) {
            return false;
        }
        if (this.xSpline != null) {
            FloatPolygon floatPolygon = new FloatPolygon(this.xSpline, this.ySpline, this.splinePoints);
            return floatPolygon.contains(n - this.x, n2 - this.y);
        }
        if (this.xpf != null) {
            FloatPolygon floatPolygon = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
            return floatPolygon.contains(n - this.x, n2 - this.y);
        }
        Polygon polygon = new Polygon(this.xp, this.yp, this.nPoints);
        return polygon.contains(n - this.x, n2 - this.y);
    }

    public int isHandle(int n, int n2) {
        if (this.xSpline == null && this.type != 2 && this.type != 6 && this.type != 8 && this.type != 10 || this.clipboard != null) {
            return -1;
        }
        int n3 = 10;
        int n4 = n3 / 2;
        int n5 = -1;
        for (int i = 0; i < this.nPoints; ++i) {
            int n6 = this.xp2[i] - n4;
            int n7 = this.yp2[i] - n4;
            if (n < n6 || n > n6 + n3 || n2 < n7 || n2 > n7 + n3) continue;
            n5 = i;
            break;
        }
        return n5;
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        PolygonFiller polygonFiller = new PolygonFiller();
        if (this.xSpline != null) {
            polygonFiller.setPolygon(this.toInt(this.xSpline), this.toInt(this.ySpline), this.splinePoints);
        } else if (this.xpf != null) {
            polygonFiller.setPolygon(this.toInt(this.xpf), this.toInt(this.ypf), this.nPoints);
        } else {
            polygonFiller.setPolygon(this.xp, this.yp, this.nPoints);
        }
        this.cachedMask = polygonFiller.getMask(this.width, this.height);
        return this.cachedMask;
    }

    double getSmoothedLineLength() {
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d2 = calibration.pixelWidth * calibration.pixelWidth;
            d3 = calibration.pixelHeight * calibration.pixelHeight;
        }
        double d4 = (double)(this.xp[0] + this.xp[1] + this.xp[2]) / 3.0 - (double)this.xp[0];
        double d5 = (double)(this.yp[0] + this.yp[1] + this.yp[2]) / 3.0 - (double)this.yp[0];
        d += Math.sqrt(d4 * d4 * d2 + d5 * d5 * d3);
        for (int i = 1; i < this.nPoints - 2; ++i) {
            d4 = (double)(this.xp[i + 2] - this.xp[i - 1]) / 3.0;
            d5 = (double)(this.yp[i + 2] - this.yp[i - 1]) / 3.0;
            d += Math.sqrt(d4 * d4 * d2 + d5 * d5 * d3);
        }
        d4 = (double)this.xp[this.nPoints - 1] - (double)(this.xp[this.nPoints - 3] + this.xp[this.nPoints - 2] + this.xp[this.nPoints - 1]) / 3.0;
        d5 = (double)this.yp[this.nPoints - 1] - (double)(this.yp[this.nPoints - 3] + this.yp[this.nPoints - 2] + this.yp[this.nPoints - 1]) / 3.0;
        return d += Math.sqrt(d4 * d4 * d2 + d5 * d5 * d3);
    }

    double getSmoothedPerimeter() {
        double d = this.getSmoothedLineLength();
        double d2 = 1.0;
        double d3 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d2 = calibration.pixelWidth * calibration.pixelWidth;
            d3 = calibration.pixelHeight * calibration.pixelHeight;
        }
        double d4 = this.xp[this.nPoints - 1] - this.xp[0];
        double d5 = this.yp[this.nPoints - 1] - this.yp[0];
        return d += Math.sqrt(d4 * d4 * d2 + d5 * d5 * d3);
    }

    double getTracedPerimeter() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.xp[0] - this.xp[this.nPoints - 1];
        int n5 = this.yp[0] - this.yp[this.nPoints - 1];
        int n6 = Math.abs(n4) + Math.abs(n5);
        boolean bl = false;
        for (int i = 0; i < this.nPoints; ++i) {
            int n7 = i + 1;
            if (n7 == this.nPoints) {
                n7 = 0;
            }
            int n8 = this.xp[n7] - this.xp[i];
            int n9 = this.yp[n7] - this.yp[i];
            n += Math.abs(n4);
            n2 += Math.abs(n5);
            int n10 = Math.abs(n8) + Math.abs(n9);
            if (n6 > 1 || !bl) {
                bl = true;
                ++n3;
            } else {
                bl = false;
            }
            n4 = n8;
            n5 = n9;
            n6 = n10;
        }
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
        }
        return (double)n * d + (double)n2 * d2 - (double)n3 * (d + d2 - Math.sqrt(d * d + d2 * d2));
    }

    public double getLength() {
        if (this.type == 4) {
            return this.getTracedPerimeter();
        }
        if (this.nPoints > 2) {
            if (this.type == 3) {
                return this.getSmoothedPerimeter();
            }
            if (this.type == 7 && this.width != 0 && this.height != 0) {
                return this.getSmoothedLineLength();
            }
        }
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d2 = calibration.pixelWidth * calibration.pixelWidth;
            d3 = calibration.pixelHeight * calibration.pixelHeight;
        }
        if (this.xSpline != null) {
            double d4;
            for (int i = 0; i < this.splinePoints - 1; ++i) {
                double d5 = this.xSpline[i + 1] - this.xSpline[i];
                d4 = this.ySpline[i + 1] - this.ySpline[i];
                d += Math.sqrt(d5 * d5 * d2 + d4 * d4 * d3);
            }
            if (this.type == 2) {
                double d6 = this.xSpline[0] - this.xSpline[this.splinePoints - 1];
                d4 = this.ySpline[0] - this.ySpline[this.splinePoints - 1];
                d += Math.sqrt(d6 * d6 * d2 + d4 * d4 * d3);
            }
        } else {
            int n;
            int n2;
            for (int i = 0; i < this.nPoints - 1; ++i) {
                n2 = this.xp[i + 1] - this.xp[i];
                n = this.yp[i + 1] - this.yp[i];
                d += Math.sqrt((double)(n2 * n2) * d2 + (double)(n * n) * d3);
            }
            if (this.type == 2) {
                n2 = this.xp[0] - this.xp[this.nPoints - 1];
                n = this.yp[0] - this.yp[this.nPoints - 1];
                d += Math.sqrt((double)(n2 * n2) * d2 + (double)(n * n) * d3);
            }
        }
        return d;
    }

    public double getAngle() {
        return this.degrees;
    }

    public int getNCoordinates() {
        if (this.xSpline != null) {
            return this.splinePoints;
        }
        return this.nPoints;
    }

    public int[] getXCoordinates() {
        if (this.xSpline != null) {
            return this.toInt(this.xSpline);
        }
        if (this.xpf != null) {
            return this.toInt(this.xpf);
        }
        return this.xp;
    }

    public int[] getYCoordinates() {
        if (this.xSpline != null) {
            return this.toInt(this.ySpline);
        }
        if (this.xpf != null) {
            return this.toInt(this.ypf);
        }
        return this.yp;
    }

    public Polygon getNonSplineCoordinates() {
        if (this.xpf != null) {
            return new Polygon(this.toInt(this.xpf), this.toInt(this.ypf), this.nPoints);
        }
        return new Polygon(this.xp, this.yp, this.nPoints);
    }

    public Polygon getPolygon() {
        int[] nArray;
        int[] nArray2;
        int n;
        if (this.xSpline != null) {
            n = this.splinePoints;
            nArray2 = this.toInt(this.xSpline);
            nArray = this.toInt(this.ySpline);
        } else if (this.xpf != null) {
            n = this.nPoints;
            nArray2 = this.toInt(this.xpf);
            nArray = this.toInt(this.xpf);
        } else {
            n = this.nPoints;
            nArray2 = this.xp;
            nArray = this.yp;
        }
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray2[i] + this.x;
            nArray4[i] = nArray[i] + this.y;
        }
        return new Polygon(nArray3, nArray4, n);
    }

    public FloatPolygon getFloatPolygon() {
        int n = this.xSpline != null ? this.splinePoints : this.nPoints;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        if (this.xSpline != null) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = this.xSpline[i] + (float)this.x;
                fArray2[i] = this.ySpline[i] + (float)this.y;
            }
        } else if (this.xpf != null) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = this.xpf[i] + (float)this.x;
                fArray2[i] = this.ypf[i] + (float)this.y;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray[i] = this.xp[i] + this.x;
                fArray2[i] = this.yp[i] + this.y;
            }
        }
        return new FloatPolygon(fArray, fArray2, n);
    }

    public Polygon getConvexHull() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getNCoordinates();
        int[] nArray = this.getXCoordinates();
        int[] nArray2 = this.getYCoordinates();
        Rectangle rectangle = this.getBounds();
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        int n8 = 0;
        int n9 = Integer.MAX_VALUE;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray2[n4];
            if (n3 >= n9) continue;
            n9 = n3;
        }
        n4 = Integer.MAX_VALUE;
        int n10 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            int n11 = nArray[n2];
            n3 = nArray2[n2];
            if (n3 != n9 || n11 >= n4) continue;
            n4 = n11;
            n10 = n2;
        }
        n2 = n10;
        int n12 = 0;
        do {
            int n13 = nArray[n10];
            int n14 = nArray2[n10];
            n = n10 + 1;
            if (n == n5) {
                n = 0;
            }
            int n15 = nArray[n];
            int n16 = nArray2[n];
            int n17 = n + 1;
            if (n17 == n5) {
                n17 = 0;
            }
            do {
                int n18;
                int n19;
                int n20;
                if ((n20 = n13 * (n16 - (n19 = nArray2[n17])) - n14 * (n15 - (n18 = nArray[n17])) + (n19 * n15 - n16 * n18)) > 0) {
                    n15 = n18;
                    n16 = n19;
                    n = n17;
                }
                if (++n17 != n5) continue;
                n17 = 0;
            } while (n17 != n10);
            if (n8 < n5) {
                nArray3[n8] = n6 + n13;
                nArray4[n8] = n7 + n14;
                ++n8;
                continue;
            }
            if (++n12 <= 10) continue;
            return null;
        } while ((n10 = n) != n2);
        return new Polygon(nArray3, nArray4, n8);
    }

    protected int clipRectMargin() {
        return this.type == 10 ? 4 : 0;
    }

    public synchronized Object clone() {
        int n;
        PolygonRoi polygonRoi = (PolygonRoi)super.clone();
        if (this.xpf != null) {
            polygonRoi.xpf = new float[this.maxPoints];
            polygonRoi.ypf = new float[this.maxPoints];
        } else {
            polygonRoi.xp = new int[this.maxPoints];
            polygonRoi.yp = new int[this.maxPoints];
        }
        polygonRoi.xp2 = new int[this.maxPoints];
        polygonRoi.yp2 = new int[this.maxPoints];
        for (n = 0; n < this.nPoints; ++n) {
            if (this.xpf != null) {
                polygonRoi.xpf[n] = this.xpf[n];
                polygonRoi.ypf[n] = this.ypf[n];
            } else {
                polygonRoi.xp[n] = this.xp[n];
                polygonRoi.yp[n] = this.yp[n];
            }
            polygonRoi.xp2[n] = this.xp2[n];
            polygonRoi.yp2[n] = this.yp2[n];
        }
        if (this.xSpline != null) {
            polygonRoi.xSpline = new float[this.splinePoints];
            polygonRoi.ySpline = new float[this.splinePoints];
            polygonRoi.splinePoints = this.splinePoints;
            for (n = 0; n < this.splinePoints; ++n) {
                polygonRoi.xSpline[n] = this.xSpline[n];
                polygonRoi.ySpline[n] = this.ySpline[n];
            }
        }
        return polygonRoi;
    }

    void enlargeArrays() {
        int[] nArray = new int[this.maxPoints * 2];
        int[] nArray2 = new int[this.maxPoints * 2];
        int[] nArray3 = new int[this.maxPoints * 2];
        int[] nArray4 = new int[this.maxPoints * 2];
        System.arraycopy(this.xp, 0, nArray, 0, this.maxPoints);
        System.arraycopy(this.yp, 0, nArray2, 0, this.maxPoints);
        System.arraycopy(this.xp2, 0, nArray3, 0, this.maxPoints);
        System.arraycopy(this.yp2, 0, nArray4, 0, this.maxPoints);
        this.xp = nArray;
        this.yp = nArray2;
        this.xp2 = nArray3;
        this.yp2 = nArray4;
        if (IJ.debugMode) {
            IJ.log("PolygonRoi: " + this.maxPoints + " points");
        }
        this.maxPoints *= 2;
    }

    private int[] toInt(float[] fArray) {
        int n = fArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)Math.floor((double)fArray[i] + 0.5);
        }
        return nArray;
    }

    private float[] toFloat(int[] nArray) {
        int n = nArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = nArray[i];
        }
        return fArray;
    }
}

