/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.util.Java2;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;

public class PointRoi
extends PolygonRoi {
    private static Font font;
    private static int fontSize;
    private double saveMag;
    private boolean hideLabels;

    public PointRoi(int[] nArray, int[] nArray2, int n) {
        super(nArray, nArray2, n, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(Polygon polygon) {
        this(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public PointRoi(int n, int n2) {
        super(PointRoi.makeXArray(n, null), PointRoi.makeYArray(n2, null), 1, 10);
        this.width = 1;
        this.height = 1;
    }

    public PointRoi(int n, int n2, ImagePlus imagePlus) {
        super(PointRoi.makeXArray(n, imagePlus), PointRoi.makeYArray(n2, imagePlus), 1, 10);
        this.setImage(imagePlus);
        this.width = 1;
        this.height = 1;
        if (imagePlus != null) {
            imagePlus.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        if (Recorder.record && !Recorder.scriptMode()) {
            Recorder.record("makePoint", this.x, this.y);
        }
    }

    static int[] makeXArray(int n, ImagePlus imagePlus) {
        int[] nArray = new int[]{imagePlus != null ? imagePlus.getCanvas().offScreenX(n) : n};
        return nArray;
    }

    static int[] makeYArray(int n, ImagePlus imagePlus) {
        int[] nArray = new int[]{imagePlus != null ? imagePlus.getCanvas().offScreenY(n) : n};
        return nArray;
    }

    void handleMouseMove(int n, int n2) {
    }

    protected void handleMouseUp(int n, int n2) {
        super.handleMouseUp(n, n2);
        this.modifyRoi();
    }

    public void draw(Graphics graphics) {
        this.updatePolygon();
        if (this.ic != null) {
            this.mag = this.ic.getMagnification();
        }
        int n = 2;
        if (!Prefs.noPointLabels && !this.hideLabels && this.nPoints > 1) {
            fontSize = 9;
            if (this.mag > 1.0) {
                fontSize = (int)(((this.mag - 1.0) / 3.0 + 1.0) * 9.0);
            }
            if (fontSize > 18) {
                fontSize = 18;
            }
            if (font == null || this.mag != this.saveMag) {
                font = new Font("SansSerif", 0, fontSize);
            }
            graphics.setFont(font);
            if (fontSize > 9) {
                Java2.setAntialiasedText(graphics, true);
            }
            this.saveMag = this.mag;
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.drawPoint(graphics, this.xp2[i] - n, this.yp2[i] - n, i + 1);
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawPoint(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.fillColor != null ? this.fillColor : Color.white);
        graphics.drawLine(n - 4, n2 + 2, n + 8, n2 + 2);
        graphics.drawLine(n + 2, n2 - 4, n + 2, n2 + 8);
        graphics.setColor(this.strokeColor != null ? this.strokeColor : ROIColor);
        graphics.fillRect(n + 1, n2 + 1, 3, 3);
        if (!Prefs.noPointLabels && !this.hideLabels && this.nPoints > 1) {
            graphics.drawString("" + n3, n + 6, n2 + fontSize + 4);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, 4, 4);
    }

    public void drawPixels(ImageProcessor imageProcessor) {
        imageProcessor.setLineWidth(Analyzer.markWidth);
        for (int i = 0; i < this.nPoints; ++i) {
            imageProcessor.moveTo(this.x + this.xp[i], this.y + this.yp[i]);
            imageProcessor.lineTo(this.x + this.xp[i], this.y + this.yp[i]);
        }
    }

    public PointRoi addPoint(int n, int n2) {
        Polygon polygon = this.getPolygon();
        polygon.addPoint(n, n2);
        PointRoi pointRoi = new PointRoi(polygon.xpoints, polygon.ypoints, polygon.npoints);
        pointRoi.setHideLabels(this.hideLabels);
        IJ.showStatus("count=" + polygon.npoints);
        return pointRoi;
    }

    public PointRoi subtractPoints(Roi roi) {
        Polygon polygon = this.getPolygon();
        Polygon polygon2 = roi.getPolygon();
        Polygon polygon3 = new Polygon();
        for (int i = 0; i < polygon.npoints; ++i) {
            if (polygon2.contains(polygon.xpoints[i], polygon.ypoints[i])) continue;
            polygon3.addPoint(polygon.xpoints[i], polygon.ypoints[i]);
        }
        if (polygon3.npoints == 0) {
            return null;
        }
        return new PointRoi(polygon3.xpoints, polygon3.ypoints, polygon3.npoints);
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
        for (int i = 0; i < this.nPoints; ++i) {
            ((ImageProcessor)byteProcessor).putPixel(this.xp[i], this.yp[i], 255);
        }
        this.cachedMask = byteProcessor;
        return byteProcessor;
    }

    public boolean contains(int n, int n2) {
        for (int i = 0; i < this.nPoints; ++i) {
            if (n != this.x + this.xp[i] || n2 != this.y + this.yp[i]) continue;
            return true;
        }
        return false;
    }

    public void setHideLabels(boolean bl) {
        this.hideLabels = bl;
    }

    public String toString() {
        if (this.nPoints > 1) {
            return "Roi[Points, count=" + this.nPoints + "]";
        }
        return "Roi[Point, x=" + this.x + ", y=" + this.y + "]";
    }

    static {
        fontSize = 9;
    }
}

