/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class OvalRoi
extends Roi {
    public OvalRoi(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.type = 1;
    }

    public OvalRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.type = 1;
    }

    public OvalRoi(int n, int n2, int n3, int n4, ImagePlus imagePlus) {
        this(n, n2, n3, n4);
        this.setImage(imagePlus);
    }

    protected void moveHandle(int n, int n2) {
        double d;
        if (this.clipboard != null) {
            return;
        }
        int n3 = this.ic.offScreenX(n);
        int n4 = this.ic.offScreenY(n2);
        int n5 = this.x;
        int n6 = this.y;
        int n7 = this.x + this.width;
        int n8 = this.y + this.height;
        int n9 = this.x + this.width / 2;
        int n10 = this.y + this.height / 2;
        int n11 = (int)(0.14645 * (double)this.width);
        int n12 = (int)(0.14645 * (double)this.height);
        if (this.width > 7 && this.height > 7) {
            this.asp_bk = d = (double)this.width / (double)this.height;
        } else {
            d = this.asp_bk;
        }
        switch (this.activeHandle) {
            case 0: {
                this.x = n3 - n11;
                this.y = n4 - n12;
                break;
            }
            case 1: {
                this.y = n4;
                break;
            }
            case 2: {
                n7 = n3 + n11;
                this.y = n4 - n12;
                break;
            }
            case 3: {
                n7 = n3;
                break;
            }
            case 4: {
                n7 = n3 + n11;
                n8 = n4 + n12;
                break;
            }
            case 5: {
                n8 = n4;
                break;
            }
            case 6: {
                this.x = n3 - n11;
                n8 = n4 + n12;
                break;
            }
            case 7: {
                this.x = n3;
            }
        }
        if (this.x < n7) {
            this.width = n7 - this.x;
        } else {
            this.width = 1;
            this.x = n7;
        }
        if (this.y < n8) {
            this.height = n8 - this.y;
        } else {
            this.height = 1;
            this.y = n8;
        }
        if (this.center) {
            switch (this.activeHandle) {
                case 0: {
                    this.width = (n9 - this.x) * 2;
                    this.height = (n10 - this.y) * 2;
                    break;
                }
                case 1: {
                    this.height = (n10 - this.y) * 2;
                    break;
                }
                case 2: {
                    this.width = (n7 - n9) * 2;
                    this.x = n7 - this.width;
                    this.height = (n10 - this.y) * 2;
                    break;
                }
                case 3: {
                    this.width = (n7 - n9) * 2;
                    this.x = n7 - this.width;
                    break;
                }
                case 4: {
                    this.width = (n7 - n9) * 2;
                    this.x = n7 - this.width;
                    this.height = (n8 - n10) * 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 5: {
                    this.height = (n8 - n10) * 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 6: {
                    this.width = (n9 - this.x) * 2;
                    this.height = (n8 - n10) * 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 7: {
                    this.width = (n9 - this.x) * 2;
                }
            }
            if (this.x >= n7) {
                this.width = 1;
                this.x = n7 = n9;
            }
            if (this.y >= n8) {
                this.height = 1;
                this.y = n8 = n10;
            }
        }
        if (this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = this.height;
            } else {
                this.height = this.width;
            }
            if (this.x >= n7) {
                this.width = 1;
                this.x = n7 = n9;
            }
            if (this.y >= n8) {
                this.height = 1;
                this.y = n8 = n10;
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = n7 - this.width;
                    this.y = n8 - this.height;
                    break;
                }
                case 1: {
                    this.x = n9 - this.width / 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 2: {
                    this.y = n8 - this.height;
                    break;
                }
                case 3: {
                    this.y = n10 - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = n9 - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = n7 - this.width;
                    break;
                }
                case 7: {
                    this.y = n10 - this.height / 2;
                    this.x = n7 - this.width;
                }
            }
            if (this.center) {
                this.x = n9 - this.width / 2;
                this.y = n10 - this.height / 2;
            }
        }
        if (this.aspect && !this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = (int)Math.rint((double)this.height * d);
            } else {
                this.height = (int)Math.rint((double)this.width / d);
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = n7 - this.width;
                    this.y = n8 - this.height;
                    break;
                }
                case 1: {
                    this.x = n9 - this.width / 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 2: {
                    this.y = n8 - this.height;
                    break;
                }
                case 3: {
                    this.y = n10 - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = n9 - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = n7 - this.width;
                    break;
                }
                case 7: {
                    this.y = n10 - this.height / 2;
                    this.x = n7 - this.width;
                }
            }
            if (this.center) {
                this.x = n9 - this.width / 2;
                this.y = n10 - this.height / 2;
            }
            if (this.width < 8) {
                if (this.width < 1) {
                    this.width = 1;
                }
                this.height = (int)Math.rint((double)this.width / this.asp_bk);
            }
            if (this.height < 8) {
                if (this.height < 1) {
                    this.height = 1;
                }
                this.width = (int)Math.rint((double)this.height * this.asp_bk);
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.cachedMask = null;
    }

    public void draw(Graphics graphics) {
        Color color;
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        graphics.setColor(color);
        this.mag = this.getMagnification();
        int n = (int)((double)this.width * this.mag);
        int n2 = (int)((double)this.height * this.mag);
        int n3 = (int)(0.14645 * (double)this.width * this.mag);
        int n4 = (int)(0.14645 * (double)this.height * this.mag);
        int n5 = this.screenX(this.x);
        int n6 = this.screenY(this.y);
        int n7 = n5 + n / 2;
        int n8 = n6 + n2 / 2;
        int n9 = n5 + n;
        int n10 = n6 + n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.stroke != null) {
            graphics2D.setStroke(this.getScaledStroke());
        }
        if (this.fillColor != null) {
            graphics.fillOval(n5, n6, n, n2);
        } else {
            graphics.drawOval(n5, n6, n, n2);
        }
        if (this.state != 0 && this.clipboard == null && !this.overlay) {
            int n11 = 2;
            this.drawHandle(graphics, n5 + n3 - n11, n6 + n4 - n11);
            this.drawHandle(graphics, n9 - n3 - n11, n6 + n4 - n11);
            this.drawHandle(graphics, n9 - n3 - n11, n10 - n4 - n11);
            this.drawHandle(graphics, n5 + n3 - n11, n10 - n4 - n11);
            this.drawHandle(graphics, n7 - n11, n6 - n11);
            this.drawHandle(graphics, n9 - n11, n8 - n11);
            this.drawHandle(graphics, n7 - n11, n10 - n11);
            this.drawHandle(graphics, n5 - n11, n8 - n11);
        }
        this.drawPreviousRoi(graphics);
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        if (this.state != 3) {
            this.showStatus();
        }
    }

    public void drawPixels(ImageProcessor imageProcessor) {
        Polygon polygon = this.getPolygon();
        if (polygon.npoints > 0) {
            int n = imageProcessor.getLineWidth();
            if (this.getStrokeWidth() > 1.0f) {
                imageProcessor.setLineWidth(Math.round(this.getStrokeWidth()));
            }
            imageProcessor.drawPolygon(polygon);
            imageProcessor.setLineWidth(n);
        }
        if (Line.getWidth() > 1 || this.getStrokeWidth() > 1.0f) {
            this.updateFullWindow = true;
        }
    }

    public Polygon getPolygon() {
        ImageProcessor imageProcessor = this.getMask();
        Wand wand = new Wand(imageProcessor);
        wand.autoOutline(this.width / 2, this.height / 2, 255, 255);
        int n = 0;
        while (n < wand.npoints) {
            int n2 = n;
            wand.xpoints[n2] = wand.xpoints[n2] + this.x;
            int n3 = n++;
            wand.ypoints[n3] = wand.ypoints[n3] + this.y;
        }
        return new Polygon(wand.xpoints, wand.ypoints, wand.npoints);
    }

    public boolean contains(int n, int n2) {
        double d = (double)this.width * 0.5;
        double d2 = (double)this.x + d - 0.5;
        double d3 = (double)n - d2;
        double d4 = (double)this.height * 0.5;
        double d5 = (double)this.y + d4 - 0.5;
        double d6 = (double)n2 - d5;
        return d3 * d3 / (d * d) + d6 * d6 / (d4 * d4) <= 1.0;
    }

    public int isHandle(int n, int n2) {
        if (this.clipboard != null || this.ic == null) {
            return -1;
        }
        double d = this.ic.getMagnification();
        int n3 = 8;
        int n4 = n3 / 2;
        int n5 = this.ic.screenX(this.x) - n4;
        int n6 = this.ic.screenY(this.y) - n4;
        int n7 = this.ic.screenX(this.x + this.width) - n4;
        int n8 = this.ic.screenY(this.y + this.height) - n4;
        int n9 = n5 + (n7 - n5) / 2;
        int n10 = n6 + (n8 - n6) / 2;
        int n11 = (int)(0.14645 * (double)(n7 - n5));
        int n12 = (int)(0.14645 * (double)(n8 - n6));
        if (n >= n5 + n11 && n <= n5 + n11 + n3 && n2 >= n6 + n12 && n2 <= n6 + n12 + n3) {
            return 0;
        }
        if (n >= n9 && n <= n9 + n3 && n2 >= n6 && n2 <= n6 + n3) {
            return 1;
        }
        if (n >= n7 - n11 && n <= n7 - n11 + n3 && n2 >= n6 + n12 && n2 <= n6 + n12 + n3) {
            return 2;
        }
        if (n >= n7 && n <= n7 + n3 && n2 >= n10 && n2 <= n10 + n3) {
            return 3;
        }
        if (n >= n7 - n11 && n <= n7 - n11 + n3 && n2 >= n8 - n12 && n2 <= n8 - n12 + n3) {
            return 4;
        }
        if (n >= n9 && n <= n9 + n3 && n2 >= n8 && n2 <= n8 + n3) {
            return 5;
        }
        if (n >= n5 + n11 && n <= n5 + n11 + n3 && n2 >= n8 - n12 && n2 <= n8 - n12 + n3) {
            return 6;
        }
        if (n >= n5 && n <= n5 + n3 && n2 >= n10 && n2 <= n10 + n3) {
            return 7;
        }
        return -1;
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
        double d = (double)this.width / 2.0;
        double d2 = (double)this.height / 2.0;
        double d3 = d * d;
        double d4 = d2 * d2;
        d -= 0.5;
        d2 -= 0.5;
        byte[] byArray = (byte[])((ImageProcessor)byteProcessor).getPixels();
        for (int i = 0; i < this.height; ++i) {
            int n = i * this.width;
            for (int j = 0; j < this.width; ++j) {
                double d5 = (double)j - d;
                double d6 = (double)i - d2;
                if (!(d5 * d5 / d3 + d6 * d6 / d4 <= 1.0)) continue;
                byArray[n + j] = -1;
            }
        }
        this.cachedMask = byteProcessor;
        return byteProcessor;
    }

    public double getLength() {
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
        }
        return Math.PI * ((double)this.width * d + (double)this.height * d2) / 2.0;
    }
}

