/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.plugin.frame.Editor;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.MenuItem;
import java.util.Hashtable;
import java.util.Vector;

public class WindowManager {
    public static boolean checkForDuplicateName;
    private static Vector imageList;
    private static Vector nonImageList;
    private static ImageWindow currentWindow;
    private static Frame frontWindow;
    private static Hashtable tempImageTable;

    private WindowManager() {
    }

    public static void setCurrentWindow(ImageWindow imageWindow) {
        WindowManager.setCurrentWindow(imageWindow, false);
    }

    public static void setCurrentWindow(ImageWindow imageWindow, boolean bl) {
        ImagePlus imagePlus;
        if (imageWindow == null || imageWindow.isClosed() || imageWindow.getImagePlus() == null) {
            return;
        }
        WindowManager.setWindow(imageWindow);
        tempImageTable.remove(Thread.currentThread());
        if (imageWindow == currentWindow || imageList.size() == 0) {
            return;
        }
        if (currentWindow != null && (imagePlus = currentWindow.getImagePlus()) != null) {
            if (!Prefs.keepUndoBuffers) {
                imagePlus.trimProcessor();
            }
            imagePlus.saveRoi();
        }
        Undo.reset();
        currentWindow = imageWindow;
        Menus.updateMenus();
        if (!bl && Recorder.record && !IJ.isMacro()) {
            Recorder.record("selectWindow", imageWindow.getImagePlus().getTitle());
        }
    }

    public static ImageWindow getCurrentWindow() {
        return currentWindow;
    }

    static int getCurrentIndex() {
        return imageList.indexOf(currentWindow);
    }

    public static ImagePlus getCurrentImage() {
        ImagePlus imagePlus = (ImagePlus)tempImageTable.get(Thread.currentThread());
        if (imagePlus == null) {
            imagePlus = WindowManager.getActiveImage();
        }
        return imagePlus;
    }

    public static void setTempCurrentImage(ImagePlus imagePlus) {
        if (imagePlus == null) {
            tempImageTable.remove(Thread.currentThread());
        } else {
            tempImageTable.put(Thread.currentThread(), imagePlus);
        }
    }

    public static void setTempCurrentImage(Thread thread, ImagePlus imagePlus) {
        if (thread == null) {
            throw new RuntimeException("thread==null");
        }
        if (imagePlus == null) {
            tempImageTable.remove(thread);
        } else {
            tempImageTable.put(thread, imagePlus);
        }
    }

    private static ImagePlus getActiveImage() {
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        if (frontWindow != null && frontWindow instanceof ImageWindow) {
            return ((ImageWindow)frontWindow).getImagePlus();
        }
        if (imageList.size() > 0) {
            ImageWindow imageWindow = (ImageWindow)imageList.elementAt(imageList.size() - 1);
            return imageWindow.getImagePlus();
        }
        return Interpreter.getLastBatchModeImage();
    }

    public static int getWindowCount() {
        int n = imageList.size();
        return n;
    }

    public static int getImageCount() {
        int n = imageList.size();
        if ((n += Interpreter.getBatchModeImageCount()) == 0 && WindowManager.getCurrentImage() != null) {
            n = 1;
        }
        return n;
    }

    public static Frame getFrontWindow() {
        return frontWindow;
    }

    public static synchronized int[] getIDList() {
        int n;
        int[] nArray;
        int n2;
        int n3 = imageList.size();
        if (n3 + (n2 = (nArray = Interpreter.getBatchModeImageIDs()).length) == 0) {
            return null;
        }
        int[] nArray2 = new int[n3 + n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray[n];
        }
        n = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            ImageWindow imageWindow = (ImageWindow)imageList.elementAt(n++);
            nArray2[i] = imageWindow.getImagePlus().getID();
        }
        return nArray2;
    }

    public static synchronized Frame[] getNonImageWindows() {
        Object[] objectArray = new Frame[nonImageList.size()];
        nonImageList.copyInto(objectArray);
        return objectArray;
    }

    public static synchronized ImagePlus getImage(int n) {
        if (n > 0) {
            n = WindowManager.getNthImageID(n);
        }
        if (n == 0 || WindowManager.getImageCount() == 0) {
            return null;
        }
        ImagePlus imagePlus = Interpreter.getBatchModeImage(n);
        if (imagePlus != null) {
            return imagePlus;
        }
        ImagePlus imagePlus2 = null;
        for (int i = 0; i < imageList.size(); ++i) {
            ImageWindow imageWindow = (ImageWindow)imageList.elementAt(i);
            imagePlus = imageWindow.getImagePlus();
            if (n != imagePlus.getID()) continue;
            imagePlus2 = imagePlus;
            break;
        }
        imagePlus = WindowManager.getCurrentImage();
        if (imagePlus2 == null && imagePlus != null && imagePlus.getID() == n) {
            return imagePlus;
        }
        return imagePlus2;
    }

    public static synchronized int getNthImageID(int n) {
        if (n <= 0) {
            return 0;
        }
        if (Interpreter.isBatchMode()) {
            int[] nArray = WindowManager.getIDList();
            if (n > nArray.length) {
                return 0;
            }
            return nArray[n - 1];
        }
        if (n > imageList.size()) {
            return 0;
        }
        ImageWindow imageWindow = (ImageWindow)imageList.elementAt(n - 1);
        if (imageWindow != null) {
            return imageWindow.getImagePlus().getID();
        }
        return 0;
    }

    public static synchronized ImagePlus getImage(String string) {
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ImagePlus imagePlus = WindowManager.getImage(nArray[i]);
            if (imagePlus == null || !imagePlus.getTitle().equals(string)) continue;
            return imagePlus;
        }
        return null;
    }

    public static synchronized void addWindow(Frame frame) {
        if (frame == null) {
            return;
        }
        if (frame instanceof ImageWindow) {
            WindowManager.addImageWindow((ImageWindow)frame);
        } else {
            Menus.insertWindowMenuItem(frame);
            nonImageList.addElement(frame);
        }
    }

    private static void addImageWindow(ImageWindow imageWindow) {
        ImagePlus imagePlus = imageWindow.getImagePlus();
        if (imagePlus == null) {
            return;
        }
        WindowManager.checkForDuplicateName(imagePlus);
        imageList.addElement(imageWindow);
        Menus.addWindowMenuItem(imagePlus);
        WindowManager.setCurrentWindow(imageWindow, true);
    }

    static void checkForDuplicateName(ImagePlus imagePlus) {
        String string;
        if (checkForDuplicateName && WindowManager.isDuplicateName(string = imagePlus.getTitle())) {
            imagePlus.setTitle(WindowManager.getUniqueName(string));
        }
        checkForDuplicateName = false;
    }

    static boolean isDuplicateName(String string) {
        int n = imageList.size();
        for (int i = 0; i < n; ++i) {
            ImageWindow imageWindow = (ImageWindow)imageList.elementAt(i);
            String string2 = imageWindow.getImagePlus().getTitle();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getUniqueName(String string) {
        String string2 = string;
        String string3 = "";
        int n = string2.length();
        int n2 = string2.lastIndexOf(".");
        if (n2 != -1 && n - n2 < 6 && n2 != n - 1) {
            string3 = string2.substring(n2, n);
            string2 = string2.substring(0, n2);
        }
        int n3 = string2.lastIndexOf("-");
        n = string2.length();
        if (n3 != -1 && n - n3 < 4 && n3 < n - 1 && Character.isDigit(string2.charAt(n3 + 1)) && string2.charAt(n3 + 1) != '0') {
            string2 = string2.substring(0, n3);
        }
        for (int i = 1; i <= 99; ++i) {
            String string4 = string2 + "-" + i + string3;
            if (WindowManager.isDuplicateName(string4)) continue;
            return string4;
        }
        return string;
    }

    public static String makeUniqueName(String string) {
        return WindowManager.isDuplicateName(string) ? WindowManager.getUniqueName(string) : string;
    }

    public static synchronized void removeWindow(Frame frame) {
        if (frame instanceof ImageWindow) {
            WindowManager.removeImageWindow((ImageWindow)frame);
        } else {
            int n = nonImageList.indexOf(frame);
            ImageJ imageJ = IJ.getInstance();
            if (n >= 0) {
                Menus.removeWindowMenuItem(n);
                nonImageList.removeElement(frame);
            }
        }
        WindowManager.setWindow(null);
    }

    private static void removeImageWindow(ImageWindow imageWindow) {
        int n;
        int n2 = imageList.indexOf(imageWindow);
        if (n2 == -1) {
            return;
        }
        if (imageList.size() > 1) {
            n = n2 - 1;
            if (n < 0) {
                n = imageList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)imageList.elementAt(n));
        } else {
            currentWindow = null;
        }
        imageList.removeElementAt(n2);
        WindowManager.setTempCurrentImage(null);
        n = nonImageList.size();
        if (n > 0) {
            ++n;
        }
        Menus.removeWindowMenuItem(n + n2);
        Menus.updateMenus();
        Undo.reset();
    }

    public static void setWindow(Frame frame) {
        frontWindow = frame;
        if (IJ.getApplet() != null && frame instanceof ImageWindow) {
            currentWindow = (ImageWindow)frame;
            tempImageTable.remove(Thread.currentThread());
            ImagePlus imagePlus = currentWindow.getImagePlus();
            if (imagePlus != null) {
                imagePlus.setActivated();
            }
        }
    }

    public static synchronized boolean closeAllWindows() {
        while (imageList.size() > 0) {
            if (!((ImageWindow)imageList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        Frame[] frameArray = WindowManager.getNonImageWindows();
        for (int i = 0; i < frameArray.length; ++i) {
            Frame frame = frameArray[i];
            if (frame == null || !(frame instanceof Editor)) continue;
            ((Editor)frame).close();
            if (((Editor)frame).fileChanged()) {
                return false;
            }
            IJ.wait(100);
        }
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null && imageJ.quitting() && IJ.getApplet() == null) {
            return true;
        }
        for (int i = 0; i < frameArray.length; ++i) {
            Frame frame = frameArray[i];
            if (frame instanceof PlugInFrame && !(frame instanceof Editor)) {
                ((PlugInFrame)frame).close();
                continue;
            }
            if (frame instanceof TextWindow) {
                ((TextWindow)frame).close();
                continue;
            }
            frame.dispose();
        }
        return true;
    }

    public static void putBehind() {
        ImageWindow imageWindow;
        if (IJ.debugMode) {
            IJ.log("putBehind");
        }
        if (imageList.size() < 1 || currentWindow == null) {
            return;
        }
        int n = imageList.indexOf(currentWindow);
        int n2 = 0;
        do {
            if (--n < 0) {
                n = imageList.size() - 1;
            }
            imageWindow = (ImageWindow)imageList.elementAt(n);
            if (++n2 != imageList.size()) continue;
            return;
        } while (imageWindow instanceof HistogramWindow || imageWindow instanceof PlotWindow);
        WindowManager.setCurrentWindow(imageWindow);
        WindowManager.toFront(imageWindow);
        Menus.updateMenus();
    }

    public static ImagePlus getTempCurrentImage() {
        return (ImagePlus)tempImageTable.get(Thread.currentThread());
    }

    public static Frame getFrame(String string) {
        for (int i = 0; i < nonImageList.size(); ++i) {
            Frame frame = (Frame)nonImageList.elementAt(i);
            if (!string.equals(frame.getTitle())) continue;
            return frame;
        }
        int[] nArray = WindowManager.getIDList();
        int n = nArray != null ? nArray.length : 0;
        for (int i = 0; i < n; ++i) {
            ImagePlus imagePlus = WindowManager.getImage(nArray[i]);
            if (imagePlus == null || !imagePlus.getTitle().equals(string)) continue;
            return imagePlus.getWindow();
        }
        return null;
    }

    static synchronized void activateWindow(String string, MenuItem menuItem) {
        Object object;
        int n;
        for (n = 0; n < nonImageList.size(); ++n) {
            Frame frame = (Frame)nonImageList.elementAt(n);
            object = frame.getTitle();
            if (menuItem != Menus.window.getItem(n + 5) && !string.equals(object)) continue;
            WindowManager.toFront(frame);
            ((CheckboxMenuItem)menuItem).setState(false);
            if (Recorder.record && !IJ.isMacro()) {
                Recorder.record("selectWindow", (String)object);
            }
            return;
        }
        n = string.lastIndexOf(32);
        if (n > 0) {
            string = string.substring(0, n);
        }
        for (int i = 0; i < imageList.size(); ++i) {
            int n2;
            object = (ImageWindow)imageList.elementAt(i);
            String string2 = ((ImageWindow)object).getImagePlus().getTitle();
            if (!string.equals(string2)) continue;
            WindowManager.setCurrentWindow((ImageWindow)object);
            WindowManager.toFront((Frame)object);
            int n3 = imageList.indexOf(object);
            int n4 = Menus.window.getItemCount();
            for (int j = n2 = 5 + Menus.windowMenuItems2; j < n4; ++j) {
                MenuItem menuItem2 = Menus.window.getItem(j);
                ((CheckboxMenuItem)menuItem2).setState(j - n2 == n3);
            }
            break;
        }
    }

    public static synchronized void repaintImageWindows() {
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ImagePlus imagePlus = WindowManager.getImage(nArray[i]);
            if (imagePlus == null) continue;
            imagePlus.setTitle(imagePlus.getTitle());
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow == null) continue;
            imageWindow.repaint();
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            for (int i = 0; i < imageList.size(); ++i) {
                ImageWindow imageWindow = (ImageWindow)imageList.elementAt(i);
                ImagePlus imagePlus = imageWindow.getImagePlus();
                IJ.log(i + " " + imagePlus.getTitle() + (imageWindow == currentWindow ? "*" : ""));
            }
            IJ.log(" ");
        }
    }

    public static void toFront(Frame frame) {
        if (frame == null) {
            return;
        }
        if (frame.getState() == 1) {
            frame.setState(0);
        }
        frame.toFront();
    }

    static {
        imageList = new Vector();
        nonImageList = new Vector();
        tempImageTable = new Hashtable();
    }
}

