/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Font;
import java.awt.image.ColorModel;
import java.io.File;

public class VirtualStack
extends ImageStack {
    private static final int INITIAL_SIZE = 100;
    private String path;
    private int nSlices;
    private String[] names;
    private String[] labels;
    private int bitDepth;

    public VirtualStack() {
    }

    public VirtualStack(int n, int n2, ColorModel colorModel, String string) {
        super(n, n2, colorModel);
        this.path = string;
        this.names = new String[100];
        this.labels = new String[100];
    }

    public void addSlice(String string) {
        if (string == null) {
            throw new IllegalArgumentException("'name' is null!");
        }
        ++this.nSlices;
        if (this.nSlices == this.names.length) {
            String[] stringArray = new String[this.nSlices * 2];
            System.arraycopy(this.names, 0, stringArray, 0, this.nSlices);
            this.names = stringArray;
            stringArray = new String[this.nSlices * 2];
            System.arraycopy(this.labels, 0, stringArray, 0, this.nSlices);
            this.labels = stringArray;
        }
        this.names[this.nSlices - 1] = string;
    }

    public void addSlice(String string, Object object) {
    }

    public void addSlice(String string, ImageProcessor imageProcessor) {
    }

    public void addSlice(String string, ImageProcessor imageProcessor, int n) {
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        for (int i = n; i < this.nSlices; ++i) {
            this.names[i - 1] = this.names[i];
        }
        this.names[this.nSlices - 1] = null;
        --this.nSlices;
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public Object getPixels(int n) {
        ImageProcessor imageProcessor = this.getProcessor(n);
        if (imageProcessor != null) {
            return imageProcessor.getPixels();
        }
        return null;
    }

    public void setPixels(Object object, int n) {
    }

    public ImageProcessor getProcessor(int n) {
        Opener opener = new Opener();
        opener.setSilentMode(true);
        IJ.redirectErrorMessages(true);
        ImagePlus imagePlus = opener.openImage(this.path, this.names[n - 1]);
        IJ.redirectErrorMessages(false);
        ImageProcessor imageProcessor = null;
        int n2 = 0;
        if (imagePlus != null) {
            int n3 = imagePlus.getWidth();
            int n4 = imagePlus.getHeight();
            int n5 = imagePlus.getType();
            ColorModel colorModel = imagePlus.getProcessor().getColorModel();
            this.labels[n - 1] = (String)imagePlus.getProperty("Info");
            n2 = imagePlus.getBitDepth();
            imageProcessor = imagePlus.getProcessor();
        } else {
            File file = new File(this.path, this.names[n - 1]);
            String string = file.exists() ? "Error opening " : "File not found: ";
            imageProcessor = new ByteProcessor(this.getWidth(), this.getHeight());
            imageProcessor.invert();
            int n6 = this.getHeight() / 20;
            if (n6 < 9) {
                n6 = 9;
            }
            Font font = new Font("Helvetica", 0, n6);
            imageProcessor.setFont(font);
            imageProcessor.setAntialiasedText(true);
            imageProcessor.setColor(0);
            imageProcessor.drawString(string + this.names[n - 1], n6, n6 * 2);
            n2 = 8;
        }
        if (n2 != this.bitDepth) {
            switch (this.bitDepth) {
                case 8: {
                    imageProcessor = imageProcessor.convertToByte(true);
                    break;
                }
                case 16: {
                    imageProcessor = imageProcessor.convertToShort(true);
                    break;
                }
                case 24: {
                    imageProcessor = imageProcessor.convertToRGB();
                    break;
                }
                case 32: {
                    imageProcessor = imageProcessor.convertToFloat();
                }
            }
        }
        if (imageProcessor.getWidth() != this.getWidth() || imageProcessor.getHeight() != this.getHeight()) {
            ImageProcessor imageProcessor2 = imageProcessor.createProcessor(this.getWidth(), this.getHeight());
            imageProcessor2.insert(imageProcessor, 0, 0);
            imageProcessor = imageProcessor2;
        }
        return imageProcessor;
    }

    public int saveChanges(int n) {
        return -1;
    }

    public int getSize() {
        return this.nSlices;
    }

    public String getSliceLabel(int n) {
        String string = this.labels[n - 1];
        if (string == null) {
            return this.names[n - 1];
        }
        if (string.length() <= 60) {
            return string;
        }
        return this.names[n - 1] + "\n" + string;
    }

    public Object[] getImageArray() {
        return null;
    }

    public void setSliceLabel(String string, int n) {
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    public String getDirectory() {
        return this.path;
    }

    public String getFileName(int n) {
        return this.names[n - 1];
    }

    public void setBitDepth(int n) {
        this.bitDepth = n;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public ImageStack sortDicom(String[] stringArray, String[] stringArray2, int n) {
        int n2;
        int n3 = this.getSize();
        String[] stringArray3 = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray3[n2] = this.names[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = (int)Tools.parseDouble(stringArray[n2].substring(stringArray[n2].length() - n), 0.0);
            if (n4 == 0) {
                return null;
            }
            this.names[n2] = stringArray3[n4 - 1];
            this.labels[n2] = stringArray2[n4 - 1];
        }
        return this;
    }
}

