/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.Menus;
import ij.gui.ImageCanvas;
import ij.gui.NewImage;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.io.FileSaver;
import ij.io.ImportDialog;
import ij.io.OpenDialog;
import ij.plugin.Animator;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Filters;
import ij.plugin.filter.ParticleAnalyzer;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.text.TextWindow;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class Prefs {
    public static final String PROPS_NAME = "IJ_Props.txt";
    public static final String PREFS_NAME = "IJ_Prefs.txt";
    public static final String DIR_IMAGE = "dir.image";
    public static final String FCOLOR = "fcolor";
    public static final String BCOLOR = "bcolor";
    public static final String ROICOLOR = "roicolor";
    public static final String SHOW_ALL_COLOR = "showcolor";
    public static final String JPEG = "jpeg";
    public static final String FPS = "fps";
    public static final String DIV_BY_ZERO_VALUE = "div-by-zero";
    public static final String NOISE_SD = "noise.sd";
    public static final String MENU_SIZE = "menu.size";
    public static final String THREADS = "threads";
    public static final String ENABLE_RMI = "enable.rmi.listener";
    public static final String KEY_PREFIX = ".";
    private static final int USE_POINTER = 1;
    private static final int ANTIALIASING = 2;
    private static final int INTERPOLATE = 4;
    private static final int ONE_HUNDRED_PERCENT = 8;
    private static final int BLACK_BACKGROUND = 16;
    private static final int JFILE_CHOOSER = 32;
    private static final int UNUSED = 64;
    private static final int BLACK_CANVAS = 128;
    private static final int WEIGHTED = 256;
    private static final int AUTO_MEASURE = 512;
    private static final int REQUIRE_CONTROL = 1024;
    private static final int USE_INVERTING_LUT = 2048;
    private static final int ANTIALIASED_TOOLS = 4096;
    private static final int INTEL_BYTE_ORDER = 8192;
    private static final int DOUBLE_BUFFER = 16384;
    private static final int NO_POINT_LABELS = 32768;
    private static final int NO_BORDER = 65536;
    private static final int SHOW_ALL_SLICE_ONLY = 131072;
    private static final int COPY_HEADERS = 262144;
    private static final int NO_ROW_NUMBERS = 524288;
    private static final int MOVE_TO_MISC = 0x100000;
    private static final int ADD_TO_MANAGER = 0x200000;
    private static final int RUN_SOCKET_LISTENER = 0x400000;
    private static final int MULTI_POINT_MODE = 0x800000;
    private static final int ROTATE_YZ = 0x1000000;
    private static final int FLIP_XZ = 0x2000000;
    private static final int DONT_SAVE_HEADERS = 0x4000000;
    private static final int DONT_SAVE_ROW_NUMBERS = 0x8000000;
    private static final int NO_CLICK_TO_GC = 0x10000000;
    private static final int AVOID_RESLICE_INTERPOLATION = 0x20000000;
    private static final int KEEP_UNDO_BUFFERS = 0x40000000;
    public static final String OPTIONS = "prefs.options";
    private static final int USE_SYSTEM_PROXIES = 1;
    private static final int USE_FILE_CHOOSER = 2;
    public static final String OPTIONS2 = "prefs.options2";
    public static final String vistaHint = "\n \nOn Windows Vista, ImageJ must be installed in a directory that\nthe user can write to, such as \"Desktop\" or \"Documents\"";
    public static String separator = System.getProperty("file.separator");
    public static boolean usePointerCursor;
    public static boolean antialiasedText;
    public static boolean interpolateScaledImages;
    public static boolean open100Percent;
    public static boolean blackBackground;
    public static boolean useJFileChooser;
    public static boolean weightedColor;
    public static boolean blackCanvas;
    public static boolean pointAutoMeasure;
    public static boolean pointAutoNextSlice;
    public static boolean requireControlKey;
    public static boolean useInvertingLut;
    public static boolean antialiasedTools;
    public static boolean intelByteOrder;
    public static boolean doubleBuffer;
    public static boolean noPointLabels;
    public static boolean disableUndo;
    public static boolean noBorder;
    public static boolean showAllSliceOnly;
    public static boolean copyColumnHeaders;
    public static boolean noRowNumbers;
    public static boolean moveToMisc;
    public static boolean pointAddToManager;
    public static boolean padEdges;
    public static int enableRMIListener;
    public static boolean runSocketListener;
    public static boolean multiPointMode;
    public static boolean openDicomsAsFloat;
    public static boolean verticalProfile;
    public static boolean rotateYZ;
    public static boolean flipXZ;
    public static boolean dontSaveHeaders;
    public static boolean dontSaveRowNumbers;
    public static boolean noClickToGC;
    public static boolean reflexAngle;
    public static boolean avoidResliceInterpolation;
    public static boolean keepUndoBuffers;
    public static boolean useNamesAsLabels;
    public static boolean useSystemProxies;
    public static boolean useFileChooser;
    static Properties ijPrefs;
    static Properties props;
    static String prefsDir;
    static String imagesURL;
    static String homeDir;
    static int threads;
    static int transparentIndex;
    static boolean commandLineMacro;

    public static String load(Object object, Applet applet) {
        String string;
        InputStream inputStream = (object instanceof Class ? (Class<?>)object : object.getClass()).getResourceAsStream("/IJ_Props.txt");
        if (applet != null) {
            return Prefs.loadAppletProps(inputStream, applet);
        }
        if (homeDir == null) {
            homeDir = System.getProperty("user.dir");
        }
        if ((string = System.getenv("IJ_PREFS_DIR")) != null && !string.equals("")) {
            prefsDir = string;
        } else {
            String string2;
            prefsDir = string2 = System.getProperty("user.home");
            if (!IJ.isWindows()) {
                prefsDir = IJ.isMacOSX() ? prefsDir + "/Library/Preferences" : prefsDir + "/.imagej";
            }
        }
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(homeDir + "/" + PROPS_NAME);
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = null;
            }
        }
        if (inputStream == null) {
            return "IJ_Props.txt not found in ij.jar or in " + homeDir;
        }
        inputStream = new BufferedInputStream(inputStream);
        try {
            props.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            return "Error loading IJ_Props.txt";
        }
        imagesURL = props.getProperty("images.location");
        Prefs.loadPreferences();
        Prefs.loadOptions();
        return null;
    }

    static String loadAppletProps(InputStream inputStream, Applet applet) {
        if (inputStream == null) {
            return "IJ_Props.txt not found in ij.jar";
        }
        try {
            props.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            return "Error loading IJ_Props.txt";
        }
        try {
            URL uRL = new URL(applet.getDocumentBase(), "images/");
            imagesURL = uRL.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getImagesURL() {
        return imagesURL;
    }

    public static void setImagesURL(String string) {
        imagesURL = string;
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static String getPrefsDir() {
        return prefsDir;
    }

    static void setHomeDir(String string) {
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        homeDir = string;
    }

    public static String getDefaultDirectory() {
        if (commandLineMacro) {
            return null;
        }
        return Prefs.getString(DIR_IMAGE);
    }

    public static String getString(String string) {
        return props.getProperty(string);
    }

    public static String getString(String string, String string2) {
        if (props == null) {
            return string2;
        }
        String string3 = props.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static boolean getBoolean(String string, boolean bl) {
        if (props == null) {
            return bl;
        }
        String string2 = props.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    public static int getInt(String string, int n) {
        if (props == null) {
            return n;
        }
        String string2 = props.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                IJ.write("" + numberFormatException);
            }
        }
        return n;
    }

    public static double getDouble(String string, double d) {
        if (props == null) {
            return d;
        }
        String string2 = props.getProperty(string);
        Double d2 = null;
        if (string2 != null) {
            try {
                d2 = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = null;
            }
            if (d2 != null) {
                return d2;
            }
        }
        return d;
    }

    public static Color getColor(String string, Color color) {
        int n = Prefs.getInt(string, 2730);
        if (n == 2730) {
            return color;
        }
        return new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static String getFileSeparator() {
        return separator;
    }

    static void loadPreferences() {
        String string = prefsDir + separator + PREFS_NAME;
        boolean bl = Prefs.loadPrefs(string);
        if (!bl && !IJ.isWindows() && (bl = Prefs.loadPrefs(string = System.getProperty("user.home") + separator + PREFS_NAME))) {
            new File(string).delete();
        }
    }

    static boolean loadPrefs(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            ijPrefs.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void savePreferences() {
        try {
            File file;
            Properties properties = new Properties();
            String string = OpenDialog.getDefaultDirectory();
            if (string != null) {
                properties.put(DIR_IMAGE, string);
            }
            properties.put(ROICOLOR, Tools.c2hex(Roi.getColor()));
            properties.put(SHOW_ALL_COLOR, Tools.c2hex(ImageCanvas.getShowAllColor()));
            properties.put(FCOLOR, Tools.c2hex(Toolbar.getForegroundColor()));
            properties.put(BCOLOR, Tools.c2hex(Toolbar.getBackgroundColor()));
            properties.put(JPEG, Integer.toString(FileSaver.getJpegQuality()));
            properties.put(FPS, Double.toString(Animator.getFrameRate()));
            properties.put(DIV_BY_ZERO_VALUE, Double.toString(FloatBlitter.divideByZeroValue));
            properties.put(NOISE_SD, Double.toString(Filters.getSD()));
            if (threads > 1) {
                properties.put(THREADS, Integer.toString(threads));
            }
            if (IJ.isMacOSX()) {
                useJFileChooser = false;
            }
            Prefs.saveOptions(properties);
            Prefs.savePluginPrefs(properties);
            IJ.getInstance().savePreferences(properties);
            Menus.savePreferences(properties);
            ParticleAnalyzer.savePreferences(properties);
            Analyzer.savePreferences(properties);
            ImportDialog.savePreferences(properties);
            PlotWindow.savePreferences(properties);
            NewImage.savePreferences(properties);
            String string2 = prefsDir + separator + PREFS_NAME;
            if (prefsDir.endsWith(".imagej") && !(file = new File(prefsDir)).exists()) {
                file.mkdir();
            }
            Prefs.savePrefs(properties, string2);
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            if (string == null) {
                string = "" + throwable;
            }
            int n = 4000;
            if (IJ.isVista()) {
                string = string + vistaHint;
                n = 8000;
            }
            try {
                new TextWindow("Error Saving Preferences", string, 500, 200);
                IJ.wait(n);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    static void loadOptions() {
        int n = 0x20000002 + (!IJ.isMacOSX() ? 0x400000 : 0);
        int n2 = Prefs.getInt(OPTIONS, n);
        usePointerCursor = (n2 & 1) != 0;
        antialiasedText = false;
        interpolateScaledImages = (n2 & 4) != 0;
        open100Percent = (n2 & 8) != 0;
        open100Percent = (n2 & 8) != 0;
        blackBackground = (n2 & 0x10) != 0;
        useJFileChooser = (n2 & 0x20) != 0;
        boolean bl = weightedColor = (n2 & 0x100) != 0;
        if (weightedColor) {
            ColorProcessor.setWeightingFactors(0.299, 0.587, 0.114);
        }
        blackCanvas = (n2 & 0x80) != 0;
        pointAutoMeasure = (n2 & 0x200) != 0;
        requireControlKey = (n2 & 0x400) != 0;
        useInvertingLut = (n2 & 0x800) != 0;
        antialiasedTools = (n2 & 0x1000) != 0;
        intelByteOrder = (n2 & 0x2000) != 0;
        noBorder = (n2 & 0x10000) != 0;
        showAllSliceOnly = (n2 & 0x20000) != 0;
        copyColumnHeaders = (n2 & 0x40000) != 0;
        noRowNumbers = (n2 & 0x80000) != 0;
        moveToMisc = (n2 & 0x100000) != 0;
        pointAddToManager = (n2 & 0x200000) != 0;
        enableRMIListener = Prefs.getInt(ENABLE_RMI, -1);
        multiPointMode = (n2 & 0x800000) != 0;
        rotateYZ = (n2 & 0x1000000) != 0;
        flipXZ = (n2 & 0x2000000) != 0;
        dontSaveHeaders = (n2 & 0x4000000) != 0;
        dontSaveRowNumbers = (n2 & 0x8000000) != 0;
        noClickToGC = (n2 & 0x10000000) != 0;
        avoidResliceInterpolation = (n2 & 0x20000000) != 0;
        keepUndoBuffers = (n2 & 0x40000000) != 0;
        n = !IJ.isMacOSX() ? 2 : 0;
        int n3 = Prefs.getInt(OPTIONS2, n);
        useSystemProxies = (n3 & 1) != 0;
        useFileChooser = (n3 & 2) != 0;
    }

    static void saveOptions(Properties properties) {
        int n = (usePointerCursor ? 1 : 0) + (antialiasedText ? 2 : 0) + (interpolateScaledImages ? 4 : 0) + (open100Percent ? 8 : 0) + (blackBackground ? 16 : 0) + (useJFileChooser ? 32 : 0) + (blackCanvas ? 128 : 0) + (weightedColor ? 256 : 0) + (pointAutoMeasure ? 512 : 0) + (requireControlKey ? 1024 : 0) + (useInvertingLut ? 2048 : 0) + (antialiasedTools ? 4096 : 0) + (intelByteOrder ? 8192 : 0) + (doubleBuffer ? 16384 : 0) + (noPointLabels ? 32768 : 0) + (noBorder ? 65536 : 0) + (showAllSliceOnly ? 131072 : 0) + (copyColumnHeaders ? 262144 : 0) + (noRowNumbers ? 524288 : 0) + (moveToMisc ? 0x100000 : 0) + (pointAddToManager ? 0x200000 : 0) + (multiPointMode ? 0x800000 : 0) + (rotateYZ ? 0x1000000 : 0) + (flipXZ ? 0x2000000 : 0) + (dontSaveHeaders ? 0x4000000 : 0) + (dontSaveRowNumbers ? 0x8000000 : 0) + (noClickToGC ? 0x10000000 : 0) + (avoidResliceInterpolation ? 0x20000000 : 0) + (keepUndoBuffers ? 0x40000000 : 0);
        properties.put(OPTIONS, Integer.toString(n));
        if (enableRMIListener >= 0) {
            properties.put(ENABLE_RMI, Integer.toString(enableRMIListener));
        }
        int n2 = (useSystemProxies ? 1 : 0) + (useFileChooser ? 2 : 0);
        properties.put(OPTIONS2, Integer.toString(n2));
    }

    public static void set(String string, String string2) {
        if (string.indexOf(46) < 1) {
            throw new IllegalArgumentException("Key must have a prefix");
        }
        ijPrefs.put(KEY_PREFIX + string, string2);
    }

    public static void set(String string, int n) {
        Prefs.set(string, Integer.toString(n));
    }

    public static void set(String string, double d) {
        Prefs.set(string, "" + d);
    }

    public static void set(String string, boolean bl) {
        Prefs.set(string, "" + bl);
    }

    public static String get(String string, String string2) {
        String string3 = ijPrefs.getProperty(KEY_PREFIX + string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static double get(String string, double d) {
        String string2 = ijPrefs.getProperty(KEY_PREFIX + string);
        Double d2 = null;
        if (string2 != null) {
            try {
                d2 = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = null;
            }
            if (d2 != null) {
                return d2;
            }
        }
        return d;
    }

    public static boolean get(String string, boolean bl) {
        String string2 = ijPrefs.getProperty(KEY_PREFIX + string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    public static void saveLocation(String string, Point point) {
        Prefs.set(string, point.x + "," + point.y);
    }

    public static Point getLocation(String string) {
        String string2 = ijPrefs.getProperty(KEY_PREFIX + string);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(",");
        if (n == -1) {
            return null;
        }
        double d = Tools.parseDouble(string2.substring(0, n));
        if (Double.isNaN(d) || n == string2.length() - 1) {
            return null;
        }
        double d2 = Tools.parseDouble(string2.substring(n + 1));
        if (Double.isNaN(d2)) {
            return null;
        }
        Point point = new Point((int)d, (int)d2);
        Dimension dimension = IJ.getScreenSize();
        if (point.x > dimension.width - 100 || point.y > dimension.height - 40) {
            return null;
        }
        return point;
    }

    static void savePluginPrefs(Properties properties) {
        Enumeration<Object> enumeration = ijPrefs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf(KEY_PREFIX) != 0) continue;
            properties.put(string, ijPrefs.getProperty(string));
        }
    }

    public static void savePrefs(Properties properties, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        properties.store(bufferedOutputStream, "ImageJA 1.45p Preferences");
        bufferedOutputStream.close();
    }

    public static int getThreads() {
        if (threads == 0) {
            threads = Prefs.getInt(THREADS, 0);
            int n = Runtime.getRuntime().availableProcessors();
            if (threads < 1 || threads > n) {
                threads = n;
            }
        }
        return threads;
    }

    public static void setThreads(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 32) {
            n = 32;
        }
        threads = n;
    }

    public static void setTransparentIndex(int n) {
        if (n < -1 || n > 255) {
            n = -1;
        }
        transparentIndex = n;
    }

    public static int getTransparentIndex() {
        return transparentIndex;
    }

    public static Properties getControlPanelProperties() {
        return ijPrefs;
    }

    static {
        antialiasedTools = true;
        doubleBuffer = true;
        enableRMIListener = -1;
        ijPrefs = new Properties();
        props = new Properties(ijPrefs);
        transparentIndex = -1;
    }
}

