/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImageJApplet;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.OtherInstance;
import ij.Prefs;
import ij.RecentOpener;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.plugin.JavaProperties;
import ij.plugin.MacroInstaller;
import ij.plugin.Orthogonal_Views;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Editor;
import ij.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener,
Runnable {
    public static final String VERSION = "1.45p";
    public static final String BUILD = "";
    public static Color backgroundColor = new Color(220, 220, 220);
    public static final Font SansSerif12 = new Font("SansSerif", 0, 12);
    public static final int DEFAULT_PORT = 57294;
    public static final int STANDALONE = 0;
    public static final int EMBEDDED = 1;
    public static final int NO_SHOW = 2;
    private static final String IJ_X = "ij.x";
    private static final String IJ_Y = "ij.y";
    private static int port = 57294;
    private static String[] arguments;
    private static String title;
    private static String iconPath;
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private boolean firstTime = true;
    private ImageJApplet applet;
    private Vector classes = new Vector();
    private boolean exitWhenQuitting;
    private boolean quitting;
    private long keyPressedTime;
    private long actionPerformedTime;
    private String lastKeyCommand;
    private boolean embedded;
    private boolean windowClosed;
    private static boolean prefsLoaded;
    boolean hotkey;

    public ImageJ() {
        this(null, 0);
    }

    public ImageJ(int n) {
        this(null, n);
    }

    public ImageJ(ImageJApplet imageJApplet) {
        this(imageJApplet, 0);
    }

    public ImageJ(ImageJApplet imageJApplet, int n) {
        super(title);
        Object object;
        boolean bl = this.embedded = imageJApplet == null && (n == 1 || n == 2);
        if (!this.embedded && iconPath != null) {
            try {
                this.setIcon(new URL("file:" + iconPath));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.applet = imageJApplet;
        String string = ImageJ.loadPrefs(this, imageJApplet);
        if (IJ.isLinux()) {
            backgroundColor = new Color(240, 240, 240);
            this.setBackground(backgroundColor);
        }
        Menus menus = new Menus(this, imageJApplet);
        String string2 = menus.addMenuBar();
        menus.installPopupMenu(this);
        this.setLayout(new GridLayout(2, 1));
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        this.add(this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(backgroundColor);
        this.statusLine = new Label();
        this.statusLine.setFont(SansSerif12);
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(120, 20);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        this.statusBar.setSize(this.toolbar.getPreferredSize());
        this.add(this.statusBar);
        IJ.init(this, imageJApplet);
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.setFocusTraversalKeysEnabled(false);
        Point point = this.getPreferredLocation();
        Dimension dimension = this.toolbar.getPreferredSize();
        int n2 = dimension.width + 10;
        int n3 = 100;
        this.setCursor(Cursor.getDefaultCursor());
        if (n != 2) {
            if (IJ.isWindows()) {
                try {
                    this.setIcon();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setBounds(point.x, point.y, n2, n3);
            this.setLocation(point.x, point.y);
            this.pack();
            this.setResizable(!IJ.isMacintosh() && !IJ.isWindows());
            if (imageJApplet == null) {
                this.show();
            }
        }
        if (string != null) {
            IJ.error(string);
        }
        if (string2 != null) {
            IJ.error(string2);
            IJ.runPlugIn("ij.plugin.ClassChecker", BUILD);
        }
        menus.installStartupMacroSet();
        if (IJ.isMacintosh() && imageJApplet == null) {
            try {
                object = null;
                object = IJ.runPlugIn("MacAdapter", BUILD);
                if (object == null) {
                    IJ.runPlugIn("QuitHandler", BUILD);
                }
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                // empty catch block
            }
        }
        if (imageJApplet == null) {
            IJ.runPlugIn("ij.plugin.DragAndDrop", BUILD);
        }
        object = menus.getMacroCount() == 1 ? " macro" : " macros";
        IJ.showStatus(this.version() + menus.getPluginCount() + " commands; " + menus.getMacroCount() + (String)object);
        this.configureProxy();
    }

    public Component add(Component component) {
        if (this.applet != null) {
            return this.applet.add(component);
        }
        return super.add(component);
    }

    static String loadPrefs(Object object, ImageJApplet imageJApplet) {
        if (!prefsLoaded) {
            String string = Prefs.load(object, imageJApplet);
            prefsLoaded = true;
            return string;
        }
        return null;
    }

    void configureProxy() {
        if (Prefs.useSystemProxies) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (Exception exception) {}
        } else {
            String string = Prefs.get("proxy.server", null);
            if (string == null || string.equals(BUILD)) {
                return;
            }
            int n = (int)Prefs.get("proxy.port", 0.0);
            if (n == 0) {
                return;
            }
            Properties properties = System.getProperties();
            properties.put("proxySet", "true");
            properties.put("http.proxyHost", string);
            properties.put("http.proxyPort", BUILD + n);
        }
    }

    void setIcon() throws Exception {
        URL uRL = this.getClass().getResource("/microscope.gif");
        this.setIcon(uRL);
    }

    void setIcon(URL uRL) throws Exception {
        if (uRL == null) {
            return;
        }
        Image image = this.createImage((ImageProducer)uRL.getContent());
        if (image != null) {
            this.setIconImage(image);
        }
    }

    public Point getPreferredLocation() {
        int n;
        if (!IJ.isJava14()) {
            return new Point(0, 0);
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        int n2 = Prefs.getInt(IJ_X, -99);
        int n3 = Prefs.getInt(IJ_Y, -99);
        if (n2 >= 0 && n3 > 0 && n2 < rectangle.x + rectangle.width - 75) {
            return new Point(n2, n3);
        }
        Dimension dimension = this.toolbar.getPreferredSize();
        double d = rectangle.width > 832 ? 0.8 : 0.9;
        n2 = (int)(d * (double)(rectangle.width - (n = dimension.width + 10)));
        if (n2 < 10) {
            n2 = 10;
        }
        return new Point(n2, rectangle.y);
    }

    void showStatus(String string) {
        this.statusLine.setText(string);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public ImageJApplet getApplet() {
        return this.applet;
    }

    public Panel getStatusBar() {
        return this.statusBar;
    }

    void doCommand(String string) {
        new Executer(string, null);
    }

    public void runFilterPlugIn(Object object, String string, String string2) {
        new PlugInFilterRunner(object, string, string2);
    }

    public Object runUserPlugIn(String string, String string2, String string3, boolean bl) {
        return IJ.runUserPlugIn(string, string2, string3, bl);
    }

    public static String modifiers(int n) {
        String string = " [ ";
        if (n == 0) {
            return BUILD;
        }
        if ((n & 1) != 0) {
            string = string + "Shift ";
        }
        if ((n & 2) != 0) {
            string = string + "Control ";
        }
        if ((n & 4) != 0) {
            string = string + "Meta ";
        }
        if ((n & 8) != 0) {
            string = string + "Alt ";
        }
        string = string + "] ";
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuContainer menuContainer;
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            ImagePlus imagePlus = null;
            if (menuItem.getParent() == Menus.openRecentMenu) {
                new RecentOpener(string);
                return;
            }
            if (menuItem.getParent() == Menus.getPopupMenu() && (menuContainer = Menus.getPopupMenu().getParent()) instanceof ImageCanvas) {
                imagePlus = ((ImageCanvas)menuContainer).getImage();
            }
            int n = actionEvent.getModifiers();
            this.hotkey = false;
            this.actionPerformedTime = System.currentTimeMillis();
            long l = this.actionPerformedTime - this.keyPressedTime;
            if (!(string == null || l < 200L && string.equals(this.lastKeyCommand))) {
                if ((n & 8) != 0) {
                    IJ.setKeyDown(18);
                }
                if ((n & 1) != 0) {
                    IJ.setKeyDown(16);
                }
                new Executer(string, imagePlus);
            }
            this.lastKeyCommand = null;
            if (IJ.debugMode) {
                IJ.log("actionPerformed: time=" + l + ", " + actionEvent);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        MenuItem menuItem = (MenuItem)itemEvent.getSource();
        MenuComponent menuComponent = (MenuComponent)((Object)menuItem.getParent());
        String string = itemEvent.getItem().toString();
        if ((Menu)menuComponent == Menus.window) {
            WindowManager.activateWindow(string, menuItem);
        } else {
            this.doCommand(string);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Undo.reset();
        if (!Prefs.noClickToGC) {
            System.gc();
        }
        IJ.showStatus(this.version() + IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.log("Windows: " + WindowManager.getWindowCount());
        }
    }

    private String version() {
        return title + " " + VERSION + BUILD + "; Java " + System.getProperty("java.version") + (IJ.is64Bit() ? " [64-bit]; " : " [32-bit]; ");
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Cloneable cloneable;
        boolean bl;
        int n = keyEvent.getKeyCode();
        IJ.setKeyDown(n);
        this.hotkey = false;
        if (n == 17 || n == 16) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyPressed: code=" + n + " (" + KeyEvent.getKeyText(n) + "), char=\"" + c + "\" (" + c + "), flags=" + KeyEvent.getKeyModifiersText(n2));
        }
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = (n2 & 8) != 0;
        boolean bl5 = (n2 & 4) != 0;
        String string = null;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        boolean bl6 = bl = imagePlus != null && imagePlus.getStackSize() > 1;
        if (imagePlus != null && !bl3 && (c >= ' ' && c <= '\u00ff' || c == '\b' || c == '\n') && (cloneable = imagePlus.getRoi()) instanceof TextRoi) {
            if ((n2 & 4) != 0 && IJ.isMacOSX()) {
                return;
            }
            if (bl4) {
                switch (c) {
                    case 'm': 
                    case 'u': {
                        c = '\u00b5';
                        break;
                    }
                    case 'A': {
                        c = '\u00c5';
                        break;
                    }
                }
            }
            ((TextRoi)cloneable).addChar(c);
            return;
        }
        if (!bl3 && !bl5 && ((Hashtable)(cloneable = Menus.getMacroShortcuts())).size() > 0 && (string = bl2 ? (String)((Hashtable)cloneable).get(new Integer(n + 200)) : (String)((Hashtable)cloneable).get(new Integer(n))) != null) {
            MacroInstaller.runMacroShortcut(string);
            return;
        }
        if ((!Prefs.requireControlKey || bl3 || bl5) && c != '+') {
            cloneable = Menus.getShortcuts();
            string = bl2 ? (String)((Hashtable)cloneable).get(new Integer(n + 200)) : (String)((Hashtable)cloneable).get(new Integer(n));
        }
        if (string == null) {
            switch (c) {
                case ',': 
                case '<': {
                    string = "Previous Slice [<]";
                    break;
                }
                case '.': 
                case ';': 
                case '>': {
                    string = "Next Slice [>]";
                    break;
                }
                case '+': 
                case '=': {
                    string = "In [+]";
                    break;
                }
                case '-': {
                    string = "Out [-]";
                    break;
                }
                case '/': {
                    string = "Reslice [/]...";
                    break;
                }
            }
        }
        if (string == null) {
            switch (n) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    string = "Clear";
                    this.hotkey = true;
                    break;
                }
                case 61: {
                    string = "In [+]";
                    break;
                }
                case 45: {
                    string = "Out [-]";
                    break;
                }
                case 47: 
                case 191: {
                    string = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    string = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    string = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    boolean bl7;
                    if (imagePlus == null) {
                        return;
                    }
                    cloneable = imagePlus.getRoi();
                    if (IJ.shiftKeyDown() && imagePlus == Orthogonal_Views.getImage()) {
                        return;
                    }
                    boolean bl8 = imagePlus.getStackSize() > 1 && (cloneable == null || IJ.shiftKeyDown());
                    boolean bl9 = bl7 = cloneable == null || IJ.shiftKeyDown() || IJ.controlKeyDown();
                    if (bl8 && n == 39) {
                        string = "Next Slice [>]";
                        break;
                    }
                    if (bl8 && n == 37) {
                        string = "Previous Slice [<]";
                        break;
                    }
                    if (bl7 && n == 40 && !this.ignoreArrowKeys(imagePlus)) {
                        string = "Out [-]";
                        break;
                    }
                    if (bl7 && n == 38 && !this.ignoreArrowKeys(imagePlus)) {
                        string = "In [+]";
                        break;
                    }
                    if (cloneable == null) break;
                    if ((n2 & 8) != 0) {
                        ((Roi)cloneable).nudgeCorner(n);
                    } else {
                        ((Roi)cloneable).nudge(n);
                    }
                    return;
                }
                case 27: {
                    this.abortPluginOrMacro(imagePlus);
                    return;
                }
                case 10: {
                    WindowManager.toFront(this);
                    return;
                }
            }
        }
        if (string != null && !string.equals(BUILD)) {
            if (string.equals("Fill") || string.equals("Draw")) {
                this.hotkey = true;
            }
            if (string.charAt(0) == '^') {
                MacroInstaller.runMacroShortcut(string);
            } else {
                this.doCommand(string);
                this.keyPressedTime = System.currentTimeMillis();
                this.lastKeyCommand = string;
            }
        }
    }

    private boolean ignoreArrowKeys(ImagePlus imagePlus) {
        Frame frame = WindowManager.getFrontWindow();
        String string = frame.getTitle();
        if (string != null && string.equals("ROI Manager")) {
            return true;
        }
        if (frame != null && frame instanceof JFrame) {
            return true;
        }
        ImageWindow imageWindow = imagePlus.getWindow();
        return imagePlus.getStackSize() > 1 && imageWindow != null && imageWindow.getClass().getName().startsWith("loci");
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyTyped: char=\"" + c + "\" (" + c + "), flags= " + Integer.toHexString(n) + " (" + KeyEvent.getKeyModifiersText(n) + ")");
        }
        if (c == '\\' || c == '\u00ab' || c == '\u00df') {
            if ((n & 8) != 0) {
                this.doCommand("Animation Options...");
            } else {
                this.doCommand("Start Animation [\\]");
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        IJ.setKeyUp(keyEvent.getKeyCode());
    }

    void abortPluginOrMacro(ImagePlus imagePlus) {
        ImageWindow imageWindow;
        if (imagePlus != null && (imageWindow = imagePlus.getWindow()) != null) {
            imageWindow.running = false;
            imageWindow.running2 = false;
        }
        Macro.abort();
        Interpreter.abort();
        if (Interpreter.getInstance() != null) {
            IJ.beep();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doCommand("Quit");
        this.windowClosed = true;
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (IJ.isMacintosh() && !this.quitting) {
            IJ.wait(10);
            this.setMenuBar(Menus.getMenuBar());
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void register(Class clazz) {
        if (!this.classes.contains(clazz)) {
            this.classes.addElement(clazz);
        }
    }

    public void quit() {
        Thread thread = new Thread((Runnable)this, "Quit");
        thread.setPriority(5);
        thread.start();
        IJ.wait(10);
    }

    public boolean quitting() {
        return this.quitting;
    }

    public void savePreferences(Properties properties) {
        Point point = this.getLocation();
        properties.put(IJ_X, Integer.toString(point.x));
        properties.put(IJ_Y, Integer.toString(point.y));
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        if (System.getProperty("java.version").substring(0, 3).compareTo("1.5") < 0) {
            JOptionPane.showMessageDialog(null, title + " " + VERSION + " requires Java 1.5 or later.");
            System.exit(0);
        }
        boolean bl = false;
        int n2 = 0;
        arguments = stringArray;
        int n3 = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n3; ++i) {
            object = stringArray[i];
            if (object == null || !stringArray[i].startsWith("-")) continue;
            if (stringArray[i].startsWith("-batch")) {
                bl = true;
                continue;
            }
            if (stringArray[i].startsWith("-debug")) {
                IJ.debugMode = true;
                continue;
            }
            if (stringArray[i].startsWith("-ijpath") && i + 1 < n3) {
                Prefs.setHomeDir(stringArray[i + 1]);
                stringArray[i + 1] = null;
                continue;
            }
            if (stringArray[i].startsWith("-port")) {
                n = (int)Tools.parseDouble(stringArray[i].substring(5, stringArray[i].length()), 0.0);
                if (n == 0) {
                    n2 = 1;
                    continue;
                }
                if (n <= 0 || 57294 + n >= 65536) continue;
                port = 57294 + n;
                continue;
            }
            if (stringArray[i].startsWith("-title=")) {
                title = stringArray[i].substring(7);
                continue;
            }
            if (!stringArray[i].startsWith("-icon=")) continue;
            iconPath = stringArray[i].substring(6);
        }
        String string = ImageJ.loadPrefs(ImageJ.class, null);
        if (string != null) {
            IJ.error(string);
        }
        if (!bl && n2 == 0 && Prefs.enableRMIListener != 0 && ImageJ.isRunning(stringArray)) {
            return;
        }
        object = IJ.getInstance();
        if (!bl && (object == null || object != null && !((Window)object).isShowing())) {
            object = new ImageJ(null, n2);
            ((ImageJ)object).exitWhenQuitting = true;
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            Object object2;
            String string2 = stringArray[i];
            if (string2 == null) continue;
            if (string2.startsWith("-")) {
                if ((string2.startsWith("-macro") || string2.startsWith("-batch")) && i + 1 < n3) {
                    object2 = i + 2 < n3 ? stringArray[i + 2] : null;
                    Prefs.commandLineMacro = true;
                    if (bl && stringArray[i + 1].endsWith(".js")) {
                        Interpreter.batchMode = true;
                    }
                    IJ.runMacroFile(stringArray[i + 1], (String)object2);
                    break;
                }
                if (string2.startsWith("-eval") && i + 1 < n3) {
                    object2 = IJ.runMacro(stringArray[i + 1]);
                    if (object2 != null) {
                        System.out.print((String)object2);
                    }
                    stringArray[i + 1] = null;
                    continue;
                }
                if (!string2.startsWith("-run") || i + 1 >= n3) continue;
                IJ.run(stringArray[i + 1]);
                stringArray[i + 1] = null;
                continue;
            }
            if (n == 0 && (string2.endsWith(".ijm") || string2.endsWith(".txt"))) {
                IJ.runMacroFile(string2);
                ++n;
                continue;
            }
            if (string2.length() <= 0 || string2.indexOf("ij.ImageJ") != -1) continue;
            object2 = new File(string2);
            IJ.open(((File)object2).getAbsolutePath());
        }
        if (IJ.debugMode && IJ.getInstance() == null) {
            new JavaProperties().run(BUILD);
        }
        if (bl) {
            System.exit(0);
        }
    }

    static boolean isRunning(String[] stringArray) {
        if (IJ.debugMode) {
            IJ.log("isRunning: " + stringArray.length);
        }
        boolean bl = false;
        int n = stringArray != null ? stringArray.length : 0;
        boolean bl2 = false;
        return OtherInstance.sendArguments(stringArray);
    }

    public static int getPort() {
        return port;
    }

    public static String[] getArgs() {
        return arguments;
    }

    public void exitWhenQuitting(boolean bl) {
        this.exitWhenQuitting = bl;
    }

    public void run() {
        Frame[] frameArray;
        ImageObserver imageObserver;
        this.quitting = true;
        boolean bl = false;
        int[] nArray = WindowManager.getIDList();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                imageObserver = WindowManager.getImage(nArray[i]);
                if (imageObserver == null || !((ImagePlus)imageObserver).changes) continue;
                bl = true;
                break;
            }
        }
        if ((frameArray = WindowManager.getNonImageWindows()) != null) {
            for (int i = 0; i < frameArray.length; ++i) {
                if (frameArray[i] == null || !(frameArray[i] instanceof Editor) || !((Editor)frameArray[i]).fileChanged()) continue;
                bl = true;
                break;
            }
        }
        if (!(!this.windowClosed || bl || Menus.window.getItemCount() <= 5 || IJ.macroRunning() && WindowManager.getImageCount() == 0)) {
            imageObserver = new GenericDialog(this.getTitle(), this);
            ((GenericDialog)imageObserver).addMessage("Are you sure you want to quit " + this.getTitle() + "?");
            ((GenericDialog)imageObserver).showDialog();
            this.quitting = !((GenericDialog)imageObserver).wasCanceled();
            this.windowClosed = false;
        }
        if (!this.quitting) {
            return;
        }
        if (!WindowManager.closeAllWindows()) {
            this.quitting = false;
            return;
        }
        if (this.applet == null) {
            this.saveWindowLocations();
            Prefs.savePreferences();
        }
        IJ.cleanup();
        this.dispose();
        if (this.exitWhenQuitting) {
            System.exit(0);
        }
    }

    void saveWindowLocations() {
        Frame frame = WindowManager.getFrame("B&C");
        if (frame != null) {
            Prefs.saveLocation("b&c.loc", frame.getLocation());
        }
        if ((frame = WindowManager.getFrame("Threshold")) != null) {
            Prefs.saveLocation("threshold.loc", frame.getLocation());
        }
        if ((frame = WindowManager.getFrame("Results")) != null) {
            Prefs.saveLocation("results.loc", frame.getLocation());
            Dimension dimension = frame.getSize();
            Prefs.set("results.width", dimension.width);
            Prefs.set("results.height", dimension.height);
        }
    }

    static {
        title = "ImageJA";
    }
}

