/*
 * Decompiled with CFR 0.152.
 */
package ome.dsl;

import java.util.Properties;
import ome.dsl.Property;
import ome.dsl.SemanticType;

class ZeroManyField
extends Property {
    public ZeroManyField(SemanticType st, Properties attrs) {
        super(st, attrs);
        this.setRequired(Boolean.FALSE);
        this.setOne2Many(Boolean.TRUE);
        if (this.getOrdered().booleanValue()) {
            this.setRequired(Boolean.TRUE);
        }
    }

    public String getFieldType() {
        StringBuilder sb = new StringBuilder();
        if (this.getOrdered().booleanValue()) {
            sb.append("java.util.List<");
        } else {
            sb.append("java.util.Set<");
        }
        sb.append(this.getType());
        sb.append(">");
        return sb.toString();
    }

    public String getFieldInitializer() {
        StringBuilder sb = new StringBuilder();
        if (this.getOrdered().booleanValue()) {
            sb.append("new java.util.ArrayList<");
        } else {
            sb.append("new java.util.HashSet<");
        }
        sb.append(this.getType());
        sb.append(">()");
        return sb.toString();
    }

    public void validate() {
        super.validate();
        if (this.getInverse() == null) {
            throw new IllegalArgumentException("\n" + this.toString() + ": invalid " + this.getClass().getName() + " property.\n" + "\n All zeromany and onemany fields must provide either the \"inverse\" " + "\n \"ordered\" or \"tag\" attribute E.g.\n" + "\n" + "<type id=...>\n" + "\t<properties>\n" + "\t\t<onemany name=\"example\" type=\"Example\" inverse=\"parent\">");
        }
    }
}

