/*
 * Decompiled with CFR 0.152.
 */
package ome.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import ome.dsl.AbstractType;
import ome.dsl.BaseType;
import ome.dsl.ContainerType;
import ome.dsl.EntryField;
import ome.dsl.EnumType;
import ome.dsl.LinkType;
import ome.dsl.Property;
import ome.dsl.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SemanticType {
    private static final Pattern annPattern = Pattern.compile("annotation");
    private static final Pattern cntPattern = Pattern.compile("FK_count_to");
    private static final Pattern grpPattern = Pattern.compile("experimentergroup");
    private static final Pattern acqPattern = Pattern.compile("screenacquisition");
    private static final String VM_QUOTE = "\\\"";
    public static final Set<String> RESTRICTED_COLUMNS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("column", "constant", "file", "group", "mode", "power", "ref", "reverse", "rows", "row", "session", "size")));
    public static final Set<String> RESTRICTED_TABLE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("session", "share")));
    public static final String ABSTRACT = "abstract";
    public static final String TYPE = "type";
    public static final String CONTAINER = "container";
    public static final String RESULT = "result";
    public static final String LINK = "link";
    public static final String ENUM = "enum";
    public static final Set TYPES = new HashSet();
    public static final Map TYPES2CLASSES;
    public final String profile;
    private List<Property> properties = new ArrayList<Property>();
    private String id;
    private String table;
    private SemanticType superclass;
    private String discriminator;
    private Boolean abstrakt;
    private Boolean annotated;
    private Boolean described;
    private Boolean global;
    private Boolean immutable;
    private Boolean named;
    private final Set<String> uniqueConstraints = new HashSet<String>();

    public SemanticType(String profile, Properties attrs) {
        this.profile = profile;
        this.setId(attrs.getProperty("id", this.getId()));
        this.setTable(SemanticType.typeToColumn(this.getId()));
        if (null == this.getId()) {
            throw new IllegalStateException("All types must have an id");
        }
        this.setSuperclass(attrs.getProperty("superclass"));
        this.setDiscriminator(attrs.getProperty("discriminator"));
        this.setAnnotated(Boolean.valueOf(attrs.getProperty("annotated", "false")));
        this.setAbstract(Boolean.valueOf(attrs.getProperty(ABSTRACT, "false")));
        this.setDescribed(Boolean.valueOf(attrs.getProperty("described", "false")));
        this.setGlobal(Boolean.valueOf(attrs.getProperty("global", "false")));
        this.setImmutable(Boolean.valueOf(attrs.getProperty("immutable", "false")));
        this.setNamed(Boolean.valueOf(attrs.getProperty("named", "false")));
    }

    public boolean isRestrictive() {
        return !this.profile.equals("psql");
    }

    public void validate() {
    }

    public static SemanticType makeNew(String profile, String element, Properties attributes) throws IllegalArgumentException, IllegalStateException {
        SemanticType st;
        Class klass = (Class)TYPES2CLASSES.get(element);
        if (null == klass) {
            throw new IllegalArgumentException("TYPES2CLASSES does not contain type " + element);
        }
        try {
            st = (SemanticType)klass.getConstructor(String.class, Properties.class).newInstance(profile, attributes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate class " + klass, e);
        }
        return st;
    }

    public String toString() {
        String result = "\n" + this.getId();
        for (Property element : this.getProperties()) {
            result = result + "\n  " + element.toString();
        }
        return result;
    }

    public static String typeToColumn(String type) {
        return type.substring(type.lastIndexOf(".") + 1).toLowerCase();
    }

    public void setAbstract(Boolean abstrakt) {
        this.abstrakt = abstrakt;
    }

    public Boolean getAbstract() {
        return this.abstrakt;
    }

    public void setAnnotated(Boolean annotated) {
        this.annotated = annotated;
    }

    public Boolean getAnnotated() {
        return this.annotated;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int getLastDotInId() {
        int idx = this.id.lastIndexOf(".");
        if (idx < 0) {
            throw new RuntimeException(this.id + " doesn't have a package. " + "Use of default package prohibited.");
        }
        return idx;
    }

    public String getPackage() {
        return this.id.substring(0, this.getLastDotInId());
    }

    public String getShortname() {
        return this.id.substring(this.getLastDotInId() + 1, this.id.length());
    }

    public String countName(Property p) {
        String countName = String.format("count_%s_%s_by_owner", this.getShortname(), p.getName());
        return this.reduce(this.replace(countName));
    }

    public String indexName(Property p) {
        String indexName = String.format("i_%s_%s", this.getShortname(), p.getName());
        return this.reduce(this.replace(indexName));
    }

    public String columnName(Property p) {
        return this.columnName(p, VM_QUOTE);
    }

    public String columnName(Property p, String quote) {
        String columnName = p.getName();
        if (RESTRICTED_COLUMNS.contains(columnName)) {
            columnName = this.quote(columnName, quote);
        }
        return columnName;
    }

    public String tableName() {
        SemanticType base = this;
        while (base.superclass != null && base.getDiscriminator() != null) {
            base = base.superclass;
        }
        String tableName = base.getTable();
        if (this.isRestrictive() && RESTRICTED_TABLE.contains(tableName)) {
            tableName = tableName + "_";
        }
        return this.reduce(tableName);
    }

    public String inverse(Property p) {
        String inverse = p.getInverse();
        if (RESTRICTED_COLUMNS.contains(inverse)) {
            inverse = this.quote(inverse);
        }
        return inverse;
    }

    public String typeAnnotation(Property p) {
        String typeAnnotation = p.getTypeAnnotation();
        typeAnnotation = typeAnnotation.replace("@PROFILE@", this.profile);
        if (this.isRestrictive()) {
            if (typeAnnotation.contains("TextType")) {
                typeAnnotation = "@org.hibernate.annotations.ColumnTransformer(read=\"to_char(" + this.columnName(p) + ")\")";
            } else if ("java.lang.String".equals(p.getType()) && !p.getNullable().booleanValue()) {
                typeAnnotation = "@org.hibernate.annotations.ColumnTransformer(write=\"coalesce(?, ' ')\")";
            }
        }
        return typeAnnotation;
    }

    public String propName(Property p) {
        String name = p.getName();
        if (RESTRICTED_COLUMNS.contains(name)) {
            name = this.quote(name);
        }
        return name;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public String getSequenceName() {
        return this.getTable();
    }

    public String fk(String fkvalue) {
        return this.reduce(this.replace(fkvalue));
    }

    private String replace(String name) {
        if (this.isRestrictive()) {
            name = annPattern.matcher(name).replaceAll("ann");
            name = cntPattern.matcher(name).replaceAll("FK_cnt_");
            name = grpPattern.matcher(name).replaceAll("group");
            name = acqPattern.matcher(name).replaceAll("scr_acq");
        }
        return name;
    }

    private String reduce(String name) {
        if (this.isRestrictive() && name.length() > 30) {
            String keep = name.substring(0, 27);
            String reduce = name.substring(28);
            name = keep + reduce.length();
        }
        return name;
    }

    private String quote(String name) {
        return this.quote(name, VM_QUOTE);
    }

    private String quote(String name, String quote) {
        name = quote + name + quote;
        return name;
    }

    public void setActualSuperClass(SemanticType st) {
        this.superclass = st;
    }

    public SemanticType getActualSuperClass() {
        return this.superclass;
    }

    public void setSuperclass(String superclass) {
        if (superclass != null) {
            Properties p = new Properties();
            p.setProperty("id", superclass);
            this.superclass = new SemanticType(this.profile, p){};
        }
    }

    public String getSuperclass() {
        return this.superclass == null ? null : this.superclass.getId();
    }

    public void setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setNamed(Boolean named) {
        this.named = named;
    }

    public Boolean getNamed() {
        return this.named;
    }

    public void setDescribed(Boolean described) {
        this.described = described;
    }

    public Boolean getDescribed() {
        return this.described;
    }

    public void setImmutable(Boolean immutable) {
        this.immutable = immutable;
    }

    public Boolean getImmutable() {
        return this.immutable;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Property getProperty(String name) {
        for (Property p : this.getProperties()) {
            String fn = p.getName();
            if (!fn.equals(name)) continue;
            return p;
        }
        return null;
    }

    public List<Property> getClassProperties() {
        ArrayList<Property> rv = new ArrayList<Property>();
        for (Property property : this.getProperties()) {
            if (property instanceof EntryField) continue;
            rv.add(property);
        }
        return rv;
    }

    public List<Property> getPropertyClosure() {
        List<Property> rv = this.getClassProperties();
        if (this.superclass != null) {
            rv.addAll(this.superclass.getPropertyClosure());
        }
        return rv;
    }

    public List<Property> getRequiredSingleProperties() {
        ArrayList<Property> rv = new ArrayList<Property>();
        for (Property property : this.getClassProperties()) {
            boolean col;
            boolean req = property.getRequired() == null ? false : property.getRequired();
            boolean bl = col = property.getOne2Many() == null ? false : property.getOne2Many();
            if (!req || col) continue;
            rv.add(property);
        }
        return rv;
    }

    public String getCheck() {
        StringBuilder sb = new StringBuilder();
        for (Property p : this.getClassProperties()) {
            String check = null;
            if ("PositiveInteger".equals(p._getType())) {
                check = p.getName() + " > 0";
            } else if ("NonNegativeInteger".equals(p._getType())) {
                check = p.getName() + " >= 0";
            } else if ("PercentFraction".equals(p._getType())) {
                check = p.getName() + " >= 0 and " + p.getName() + " <= 1";
            }
            if (check == null) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(check);
        }
        return sb.toString();
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public String getDetails() {
        if (!this.getGlobal().booleanValue()) {
            if (!this.getImmutable().booleanValue()) {
                return "MutableDetails";
            }
            return "Details";
        }
        return "GlobalDetails";
    }

    public boolean getIsLink() {
        return false;
    }

    public boolean getIsAnnotationLink() {
        return false;
    }

    public boolean getIsEnum() {
        return false;
    }

    public Set<String> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public static String unqualify(String klass) {
        if (klass == null) {
            return null;
        }
        int idx = klass.lastIndexOf(".");
        if (idx < 0) {
            return klass;
        }
        return klass.substring(idx + 1, klass.length());
    }

    static {
        TYPES.add(ABSTRACT);
        TYPES.add(TYPE);
        TYPES.add(CONTAINER);
        TYPES.add(RESULT);
        TYPES.add(LINK);
        TYPES.add(ENUM);
        TYPES2CLASSES = new HashMap();
        TYPES2CLASSES.put(ABSTRACT, AbstractType.class);
        TYPES2CLASSES.put(TYPE, BaseType.class);
        TYPES2CLASSES.put(CONTAINER, ContainerType.class);
        TYPES2CLASSES.put(LINK, LinkType.class);
        TYPES2CLASSES.put(RESULT, ResultType.class);
        TYPES2CLASSES.put(ENUM, EnumType.class);
    }
}

