/*
 * Decompiled with CFR 0.152.
 */
package ome.dsl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import ome.dsl.DSLHandler;
import ome.dsl.SemanticType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxReader {
    private static Log log = LogFactory.getLog(SaxReader.class);
    URL xmlFile;
    DSLHandler handler;
    SAXParser parser;

    public SaxReader(String profile, File file) {
        this(file, new DSLHandler(profile));
    }

    public SaxReader(File file, DSLHandler dslHandler) {
        this.handler = dslHandler;
        try {
            this.xmlFile = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error determining file's path:" + file + " :\n" + e.getMessage(), e);
        }
        this.init();
    }

    private void init() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting up SaxReader :\n" + e.getMessage(), e);
        }
    }

    public void parse() {
        try {
            this.parser.parse(this.xmlFile.getPath(), (DefaultHandler)this.handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing " + this.xmlFile + " :\n" + e.getMessage(), e);
        }
    }

    public List<SemanticType> process() {
        return this.handler.process();
    }
}

