/*
 * Decompiled with CFR 0.152.
 */
package ome.dsl;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import ome.dsl.ChildLink;
import ome.dsl.EntryField;
import ome.dsl.LinkChild;
import ome.dsl.LinkParent;
import ome.dsl.ManyOneField;
import ome.dsl.ManyZeroField;
import ome.dsl.OneManyField;
import ome.dsl.OptionalField;
import ome.dsl.ParentLink;
import ome.dsl.RequiredField;
import ome.dsl.SemanticType;
import ome.dsl.ZeroManyField;

public abstract class Property {
    public static final String REQUIRED = "required";
    public static final String OPTIONAL = "optional";
    public static final String ONEMANY = "onemany";
    public static final String ZEROMANY = "zeromany";
    public static final String MANYONE = "manyone";
    public static final String MANYZERO = "manyzero";
    public static final String ENTRY = "entry";
    public static final String CHILD = "child";
    public static final String PARENT = "parent";
    public static final String TOCHILD = "to_child";
    public static final String FROMPARENT = "from_parent";
    public static final Set<String> FIELDS = new HashSet<String>();
    public static final Map<String, Class<? extends Property>> FIELDS2CLASSES;
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String INTEGER = "int";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String LONG = "long";
    public static final String TIMESTAMP = "timestamp";
    public static final String TEXT = "text";
    public static final String BYTES = "byte[]";
    public static final String DOUBLES = "double[]";
    public static final String STRINGS = "string[]";
    public static final String STRINGS2 = "string[][]";
    public static final String INTEGERS = "int[]";
    public static final String POSITIVEINTEGER = "PositiveInteger";
    public static final String NONNEGATIVEINTEGER = "NonNegativeInteger";
    public static final String PERCENTFRACTION = "PercentFraction";
    public static final Map<String, String> JAVATYPES;
    public static final Map<String, String> DBTYPES;
    private SemanticType st;
    private SemanticType actualType;
    private final String profile;
    private SemanticType actualTarget;
    private String name;
    private String type;
    private String defaultValue;
    private String foreignKey;
    private String tag;
    private String inverse;
    private String target;
    private Boolean required;
    private Boolean unique;
    private Boolean ordered;
    private Boolean insert;
    private Boolean update;
    private Boolean one2Many = Boolean.FALSE;
    private Boolean bidirectional;

    public void validate() {
        if (null == this.getName() || null == this.getType()) {
            throw new IllegalStateException("All propeties must have a name and a type. (" + this + ")");
        }
    }

    public static Property makeNew(String element, SemanticType st, Properties attributes) throws IllegalArgumentException, IllegalStateException {
        Property p;
        Class<? extends Property> klass = FIELDS2CLASSES.get(element);
        if (null == klass) {
            throw new IllegalArgumentException("FIELDS2CLASSES does not contain type " + element);
        }
        try {
            p = klass.getConstructor(SemanticType.class, Properties.class).newInstance(st, attributes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate class " + klass, e);
        }
        return p;
    }

    public String toString() {
        return "Property: " + this.getName() + " (" + this.getType() + ")";
    }

    public void setSt(SemanticType st) {
        this.st = st;
    }

    public SemanticType getSt() {
        return this.st;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getNameCapped() {
        return Property.firstCap(this.name);
    }

    public String getNameUpper() {
        return this.name.toUpperCase();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        String t = JAVATYPES.get(this.type);
        if (t == null) {
            return this.type;
        }
        return t;
    }

    public String _getType() {
        return this.type;
    }

    public void setActualType(SemanticType type) {
        this.actualType = type;
    }

    public SemanticType getActualType() {
        return this.actualType;
    }

    public void setActualTarget(SemanticType type) {
        this.actualTarget = type;
    }

    public SemanticType getActualTarget() {
        return this.actualTarget;
    }

    public String getDbType() {
        String t = DBTYPES.get(this.type);
        if (t == null) {
            return SemanticType.typeToColumn(this.type);
        }
        return t;
    }

    public String getTypeAnnotation() {
        String T = "@org.hibernate.annotations.Type";
        String P = ", parameters=@org.hibernate.annotations.Parameter(name=\"profile\", value=\"@PROFILE@\"))";
        if (this.type.equals(TEXT)) {
            return T + "(type=\"org.hibernate.type.TextType\")";
        }
        if (this.type.equals(STRINGS)) {
            return T + "(type=\"ome.tools.hibernate.ListAsSQLArrayUserType$STRING\"" + P;
        }
        if (this.type.equals(STRINGS2)) {
            return T + "(type=\"ome.tools.hibernate.ListAsSQLArrayUserType$STRING2\"" + P;
        }
        return "// No @Type annotation";
    }

    public String getShortType() {
        return Property.unqualify(this.type);
    }

    public String getFieldName() {
        SemanticType st = this.getActualType();
        if (st != null) {
            for (Property p : st.getPropertyClosure()) {
                if (p == this || p == null || !Property.unqualify(p.getType()).equals(Property.unqualify(this.type))) continue;
                return Property.firstCap(this.getName());
            }
        }
        return Property.unqualify(this.type);
    }

    public String getFieldType() {
        return this.getType();
    }

    public String getFieldInitializer() {
        return "null";
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public String getShortTarget() {
        return Property.unqualify(this.target);
    }

    public String getTargetName() {
        SemanticType st = this.getActualType();
        for (Property p : st.getPropertyClosure()) {
            if (p == this || p.getTarget() == null || !Property.unqualify(p.getTarget()).equals(Property.unqualify(this.target))) continue;
            String n = Property.firstCap(this.getName());
            if (n.endsWith("Link")) {
                n = n.substring(0, n.length() - 4);
            }
            return n;
        }
        return Property.unqualify(this.target);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean getNullable() {
        return this.required == false;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public void setOrdered(Boolean ordered) {
        this.ordered = ordered;
    }

    public Boolean getOrdered() {
        return this.ordered;
    }

    public void setInverse(String inverse) {
        this.inverse = inverse;
    }

    public String getInverse() {
        return this.inverse;
    }

    public String getInverseCapped() {
        if (this.inverse == null) {
            return null;
        }
        return this.inverse.substring(0, 1).toUpperCase() + this.inverse.substring(1, this.inverse.length());
    }

    public void setInsert(Boolean insert) {
        this.insert = insert;
    }

    public Boolean getInsert() {
        return this.insert;
    }

    public void setUpdate(Boolean update) {
        this.update = update;
    }

    public Boolean getUpdate() {
        return this.update;
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public void setOne2Many(Boolean one2Many) {
        this.one2Many = one2Many;
    }

    public Boolean getOne2Many() {
        return this.one2Many;
    }

    public void setBidirectional(Boolean bdir) {
        this.bidirectional = bdir;
    }

    public Boolean getBidirectional() {
        return this.bidirectional;
    }

    public String getDef() {
        if (this.type.equals(FLOAT)) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("double precision");
            if (!this.getNullable().booleanValue()) {
                sb.append(" not null");
            }
            if (this.getUnique().booleanValue()) {
                sb.append(" unique");
            }
            return sb.toString();
        }
        if (this.type.equals(BYTES)) {
            return "bytea";
        }
        if (this.type.equals(STRINGS)) {
            return "text[]";
        }
        if (this.type.equals(STRINGS2)) {
            return "text[][]";
        }
        return "";
    }

    public boolean getIsLink() {
        return false;
    }

    public Property(SemanticType st, Properties attrs) {
        this.profile = st.profile;
        this.setSt(st);
        this.setName(attrs.getProperty("name", null));
        this.setType(attrs.getProperty("type", null));
        this.setDefaultValue(attrs.getProperty("default", null));
        this.setTag(attrs.getProperty("tag", null));
        this.setTarget(attrs.getProperty("target", null));
        this.setInverse(attrs.getProperty("inverse", null));
        this.setBidirectional(Boolean.TRUE);
        this.setRequired(Boolean.valueOf(attrs.getProperty(REQUIRED, "false")));
        this.setUnique(Boolean.valueOf(attrs.getProperty("unique", "false")));
        this.setOrdered(Boolean.valueOf(attrs.getProperty("ordered", "false")));
        this.setInsert(Boolean.TRUE);
        this.setUpdate(Boolean.valueOf(attrs.getProperty("mutable", "true")));
        if (JAVATYPES.containsKey(this.type)) {
            this.setForeignKey(null);
        } else {
            this.setForeignKey(SemanticType.typeToColumn(st.getId()));
        }
    }

    private static String unqualify(String str) {
        if (str == null) {
            return null;
        }
        int idx = str.lastIndexOf(".");
        if (idx < 0) {
            return str;
        }
        return str.substring(idx + 1, str.length());
    }

    private static String firstCap(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    static {
        FIELDS.add(REQUIRED);
        FIELDS.add(OPTIONAL);
        FIELDS.add(ONEMANY);
        FIELDS.add(ZEROMANY);
        FIELDS.add(MANYONE);
        FIELDS.add(MANYZERO);
        FIELDS.add(ENTRY);
        FIELDS.add(CHILD);
        FIELDS.add(PARENT);
        FIELDS.add(FROMPARENT);
        FIELDS.add(TOCHILD);
        FIELDS2CLASSES = new HashMap<String, Class<? extends Property>>();
        FIELDS2CLASSES.put(REQUIRED, RequiredField.class);
        FIELDS2CLASSES.put(OPTIONAL, OptionalField.class);
        FIELDS2CLASSES.put(ONEMANY, OneManyField.class);
        FIELDS2CLASSES.put(ZEROMANY, ZeroManyField.class);
        FIELDS2CLASSES.put(MANYONE, ManyOneField.class);
        FIELDS2CLASSES.put(MANYZERO, ManyZeroField.class);
        FIELDS2CLASSES.put(ENTRY, EntryField.class);
        FIELDS2CLASSES.put(PARENT, ParentLink.class);
        FIELDS2CLASSES.put(CHILD, ChildLink.class);
        FIELDS2CLASSES.put(FROMPARENT, LinkParent.class);
        FIELDS2CLASSES.put(TOCHILD, LinkChild.class);
        JAVATYPES = new HashMap<String, String>();
        JAVATYPES.put(STRING, String.class.getName());
        JAVATYPES.put(BOOLEAN, Boolean.class.getName());
        JAVATYPES.put(INTEGER, Integer.class.getName());
        JAVATYPES.put(POSITIVEINTEGER, Integer.class.getName());
        JAVATYPES.put(NONNEGATIVEINTEGER, Integer.class.getName());
        JAVATYPES.put(FLOAT, Float.class.getName());
        JAVATYPES.put(PERCENTFRACTION, Double.class.getName());
        JAVATYPES.put(DOUBLE, Double.class.getName());
        JAVATYPES.put(LONG, Long.class.getName());
        JAVATYPES.put(TIMESTAMP, Timestamp.class.getName());
        JAVATYPES.put(TEXT, String.class.getName());
        JAVATYPES.put(BYTES, BYTES);
        JAVATYPES.put(DOUBLES, DOUBLES);
        JAVATYPES.put(STRINGS, "java.util.List<String>");
        JAVATYPES.put(STRINGS2, "java.util.List<String[]>");
        JAVATYPES.put(INTEGERS, INTEGERS);
        DBTYPES = new HashMap<String, String>();
        DBTYPES.putAll(JAVATYPES);
        DBTYPES.put(TEXT, TEXT);
    }
}

