/*
 * Decompiled with CFR 0.152.
 */
package ome.dsl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import ome.dsl.DSLHandler;
import ome.dsl.SaxReader;
import ome.dsl.SemanticType;
import ome.dsl.VelocityHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import org.springframework.util.ResourceUtils;

public class DSLTask
extends Task {
    public static final String PKG_PLACEHOLDER = "{package-dir}";
    public static final String CLS_PLACEHOLDER = "{class-name}";
    private final List<FileSet> _fileSets = new ArrayList<FileSet>();
    private String _filepattern;
    private String _template;
    private String _profile;
    private boolean singleType = false;

    public void setFilepattern(String filepattern) {
        this._filepattern = filepattern;
        if (this._filepattern.contains(CLS_PLACEHOLDER)) {
            this.singleType = true;
        }
    }

    public void setTemplate(String template) {
        this._template = template;
        if (this._template == null) {
            throw new BuildException("Template cannot be null");
        }
    }

    public void setProfile(String profile) {
        this._profile = profile;
    }

    public void addFileset(FileSet fileSet) {
        this._fileSets.add(fileSet);
    }

    public void execute() throws BuildException {
        if (this._profile == null) {
            throw new BuildException("No profile specified.");
        }
        if (this._fileSets.isEmpty()) {
            throw new BuildException("No fileset specified");
        }
        DSLHandler handler = new DSLHandler(this._profile);
        for (FileSet fileset : this._fileSets) {
            DirectoryScanner scanner = fileset.getDirectoryScanner(this.getProject());
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            if (files.length == 0) continue;
            this.log("Parsing " + files.length + " file(s).");
            for (int i = 0; i < files.length; ++i) {
                String filename = fileset.getDir(this.getProject()) + File.separator + files[i];
                File file = new File(filename);
                if (!file.exists()) {
                    this.log("File " + file + " not found.");
                    continue;
                }
                SaxReader sr = new SaxReader(file, handler);
                sr.parse();
            }
        }
        List<SemanticType> types = handler.process();
        if (types.size() == 0) {
            return;
        }
        if (this.singleType) {
            for (SemanticType st : types) {
                try {
                    VelocityHelper vh = new VelocityHelper();
                    vh.put("type", st);
                    String className = st.getShortname();
                    String packageName = st.getId();
                    packageName = packageName.substring(0, packageName.lastIndexOf("."));
                    String sep = File.separator.replaceAll("\\\\", "\\\\\\\\");
                    packageName = packageName.replaceAll("[.]", sep);
                    String target = this._filepattern;
                    target = target.replace(CLS_PLACEHOLDER, className);
                    target = target.replace(PKG_PLACEHOLDER, packageName);
                    this.writeToFile(vh, new File(target), this._template);
                }
                catch (Exception e) {
                    throw new BuildException("Error while writing type:" + st, (Throwable)e);
                }
            }
        } else {
            VelocityHelper vhData = new VelocityHelper();
            vhData.put("types", types);
            try {
                this.writeToFile(vhData, new File(this._filepattern), this._template);
            }
            catch (Exception e) {
                throw new BuildException("Error while generating for template:" + this._template, (Throwable)e);
            }
        }
    }

    public static InputStream getStream(String str) {
        InputStream in = null;
        try {
            in = DSLTask.class.getClassLoader().getResourceAsStream(str);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (in == null) {
            try {
                File file = new File(str);
                in = new FileInputStream(file);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (in == null) {
            try {
                URL url = ResourceUtils.getURL((String)str);
                in = url.openStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in == null && !str.startsWith("classpath:")) {
            in = DSLTask.getStream("classpath:" + str);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(VelocityHelper vh, File file, String template) throws IOException {
        InputStream in = DSLTask.getStream(template);
        if (in == null) {
            throw new BuildException("Cannot resolve template:" + template);
        }
        OutputStreamWriter fw = null;
        try {
            this.mkdir(file);
            fw = new FileWriter(file);
            vh.invoke(in, fw);
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    void mkdir(File file) {
        Mkdir mkdir = new Mkdir();
        mkdir.setProject(new Project());
        mkdir.setOwningTarget(new Target());
        mkdir.setDir(new File(file.getParent()));
        mkdir.execute();
    }

    static String fileAsString(File file) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get file contents", (Throwable)ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }
}

