/*
 * Decompiled with CFR 0.152.
 */
package ome.dsl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ome.dsl.AbstractLink;
import ome.dsl.ChildLink;
import ome.dsl.DetailsField;
import ome.dsl.LinkChild;
import ome.dsl.LinkParent;
import ome.dsl.LinkType;
import ome.dsl.ManyZeroField;
import ome.dsl.OptionalField;
import ome.dsl.Property;
import ome.dsl.RequiredField;
import ome.dsl.SemanticType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DSLHandler
extends DefaultHandler {
    private static Log log = LogFactory.getLog(DSLHandler.class);
    public boolean verbose = false;
    private String depth = "";
    private final Map<String, SemanticType> types = new HashMap<String, SemanticType>();
    private SemanticType type;
    private Property property;
    private final String profile;

    DSLHandler(String profile) {
        this.profile = profile;
    }

    @Override
    public void startElement(String arg0, String arg1, String element, Attributes attrs) throws SAXException {
        if (this.verbose) {
            this.outputStart(element, attrs);
        }
        this.handleEntry(element, attrs);
        super.startElement(arg0, arg1, element, attrs);
    }

    @Override
    public void endElement(String arg0, String arg1, String element) throws SAXException {
        super.endElement(arg0, arg1, element);
        this.handleExit(element);
        if (this.verbose) {
            this.outputStop(element);
        }
    }

    private void handleEntry(String element, Attributes attrs) {
        if (Property.FIELDS.contains(element)) {
            if (null != this.property) {
                throw new IllegalStateException("Trying to enter property " + element + " from within property" + this.property);
            }
            if (null == this.type) {
                throw new IllegalStateException("Trying to create property " + element + " without a type!");
            }
            this.property = Property.makeNew(element, this.type, this.attrs2props(attrs));
        } else if (!"properties".equals(element)) {
            if (SemanticType.TYPES.contains(element)) {
                if (null != this.type) {
                    throw new IllegalStateException("Trying to enter type " + element + " from within type " + this.type);
                }
                this.type = SemanticType.makeNew(this.profile, element, this.attrs2props(attrs));
            } else if (!"types".equals(element)) {
                log.debug((Object)("Deprecated: In the future elements of type " + element + " will be considered an error."));
            }
        }
    }

    private void handleExit(String element) {
        if (Property.FIELDS.contains(element)) {
            if (null == this.property) {
                throw new IllegalStateException("Exiting non-extant property!\nElement:" + element + "\nType:" + this.type + "\nProperty:" + this.property);
            }
            if (null == this.type) {
                throw new IllegalStateException("Inside of non-extant type!!\nElement:" + element + "\nType:" + this.type);
            }
            this.property.validate();
            this.type.getProperties().add(this.property);
            this.property = null;
        } else if (SemanticType.TYPES.contains(element)) {
            if (null == this.type) {
                throw new IllegalStateException("Exiting non-extent type!\nElement:" + element + "\nType:" + this.type);
            }
            this.type.validate();
            this.types.put(this.type.getId(), this.type);
            this.type = null;
        }
    }

    public List<SemanticType> process() {
        SemanticType t;
        HashSet<LinkType> additions = new HashSet<LinkType>();
        for (String string : this.types.keySet()) {
            t = this.types.get(string);
            if (t.getAnnotated() == null || !t.getAnnotated().booleanValue()) continue;
            String newId = "ome.model.annotations." + t.getShortname() + "AnnotationLink";
            SemanticType semanticType = this.types.get("ome.model.annotations.Annotation");
            Properties linkP = new Properties();
            linkP.setProperty("id", newId);
            LinkType l = new LinkType(this.profile, linkP);
            Properties parentP = new Properties();
            parentP.setProperty("type", t.getId());
            LinkParent lp = new LinkParent(l, parentP);
            lp.validate();
            l.getProperties().add(lp);
            Properties childP = new Properties();
            childP.setProperty("type", semanticType.getId());
            LinkChild lc = new LinkChild(l, childP);
            lc.validate();
            l.getProperties().add(lc);
            l.validate();
            additions.add(l);
            Properties clP = new Properties();
            clP.setProperty("name", "annotationLinks");
            clP.setProperty("type", newId);
            clP.setProperty("target", semanticType.getId());
            ChildLink cl = new ChildLink(t, clP);
            cl.setBidirectional(false);
            cl.validate();
            t.getProperties().add(cl);
        }
        for (SemanticType semanticType : additions) {
            this.types.put(semanticType.getId(), semanticType);
        }
        for (SemanticType semanticType : this.types.values()) {
            Boolean named = semanticType.getNamed();
            Boolean descrd = semanticType.getDescribed();
            if (named != null && named.booleanValue()) {
                Properties properties = new Properties();
                properties.setProperty("name", "name");
                properties.setProperty("type", "string");
                RequiredField r = new RequiredField(semanticType, properties);
                semanticType.getProperties().add(r);
            }
            if (descrd == null || !descrd.booleanValue()) continue;
            Properties properties = new Properties();
            properties.setProperty("name", "description");
            properties.setProperty("type", "text");
            OptionalField o = new OptionalField(semanticType, properties);
            semanticType.getProperties().add(o);
        }
        for (String string : this.types.keySet()) {
            t = this.types.get(string);
            for (Property property : t.getProperties()) {
                if (this.handleLink(property)) continue;
                String rev = property.getType();
                String inv = property.getInverse();
                if (inv == null || !this.types.containsKey(rev)) continue;
                SemanticType reverse = this.types.get(rev);
                for (Property inverse : reverse.getProperties()) {
                    if (!inverse.getType().equals(string)) continue;
                    inverse.setInverse(property.getName());
                }
            }
        }
        for (String string : this.types.keySet()) {
            t = this.types.get(string);
            for (Property property : t.getProperties()) {
                if (!(property instanceof AbstractLink)) continue;
                AbstractLink link = (AbstractLink)property;
                String targetId = link.getTarget();
                SemanticType target = this.types.get(targetId);
                if (target == null) {
                    throw new RuntimeException("No type " + targetId + " found as target of " + link);
                }
                boolean found = false;
                for (Property p2 : target.getProperties()) {
                    if (!string.equals(p2.getTarget())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                link.setBidirectional(Boolean.FALSE);
            }
        }
        for (String string : this.types.keySet()) {
            t = this.types.get(string);
            for (Property property : t.getClassProperties()) {
                Boolean ord;
                if (!(property instanceof ManyZeroField) || (ord = property.getOrdered()) == null || !ord.booleanValue()) continue;
                String name = property.getName();
                t.getUniqueConstraints().add(String.format("\"%s\",\"%s_index\"", name, name));
            }
        }
        for (String string : this.types.keySet()) {
            t = this.types.get(string);
            if (!(t instanceof LinkType)) continue;
            LinkType link = (LinkType)t;
            if (link.getGlobal().booleanValue()) {
                link.getUniqueConstraints().add("\"parent\",\"child\"");
                continue;
            }
            link.getUniqueConstraints().add("\"parent\",\"child\",\"owner_id\"");
        }
        for (SemanticType semanticType : this.types.values()) {
            for (Property property : semanticType.getPropertyClosure()) {
                SemanticType semanticType2 = this.types.get(property.getType());
                property.setActualTarget(semanticType2);
                SemanticType currentType = semanticType;
                SemanticType actualType = semanticType;
                while (currentType != null) {
                    List<Property> classProperties = currentType.getClassProperties();
                    if (classProperties.contains(property)) {
                        actualType = currentType;
                        break;
                    }
                    String superclass = currentType.getSuperclass();
                    currentType = superclass == null ? null : this.types.get(currentType.getSuperclass());
                }
                property.setActualType(actualType);
            }
        }
        for (String string : this.types.keySet()) {
            t = this.types.get(string);
            String superclass = t.getSuperclass();
            if (superclass != null) {
                SemanticType semanticType = this.types.get(superclass);
                t.setActualSuperClass(semanticType);
                continue;
            }
            t.getProperties().add(new DetailsField(t, new Properties()));
        }
        return new ArrayList<SemanticType>(this.types.values());
    }

    private boolean handleLink(Property p) {
        if (!p.getIsLink()) {
            return false;
        }
        String name = p.getName();
        return name.equals("child") || !name.equals("parent");
    }

    private void outputStart(String element, Attributes attrs) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.depth + element + "("));
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attr = attrs.getQName(i);
            String value = attrs.getValue(i);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(" " + attr + "=\"" + value + "\" "));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"): ");
        }
        this.depth = this.depth + "  ";
    }

    private void outputStop(String element) {
        this.depth = this.depth.substring(2);
    }

    private Properties attrs2props(Attributes attrs) {
        Properties p = new Properties();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            String value = attrs.getValue(i);
            p.put(key, value);
        }
        return p;
    }
}

