/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.io.img.virtual;

import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.io.img.virtual.VirtualAccessor;
import net.imglib2.io.img.virtual.VirtualImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class VirtualRandomAccess<T extends NativeType<T> & RealType<T>>
extends Point
implements RandomAccess<T> {
    private final VirtualImg<T> virtImage;
    private final VirtualAccessor<T> accessor;

    public VirtualRandomAccess(VirtualImg<T> image) {
        super(image.numDimensions());
        this.accessor = new VirtualAccessor<T>(image);
        this.virtImage = image;
    }

    @Override
    public void setPosition(long pos, int d) {
        this.position[d] = pos;
    }

    @Override
    public VirtualRandomAccess<T> copy() {
        return new VirtualRandomAccess<T>(this.virtImage);
    }

    @Override
    public VirtualRandomAccess<T> copyRandomAccess() {
        return new VirtualRandomAccess<T>(this.virtImage);
    }

    @Override
    public T get() {
        return this.accessor.get(this.position);
    }

    public Object getCurrentPlane() {
        return this.accessor.getCurrentPlane();
    }
}

