/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.io.img.virtual;

import loci.formats.FormatTools;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.io.ImgIOUtils;
import net.imglib2.io.img.virtual.VirtualImg;
import ome.scifio.common.DataTools;

public class VirtualPlaneLoader {
    private final VirtualImg<?> virtImage;
    private final PlanarImg<?, ? extends ArrayDataAccess<?>> planeImg;
    private final long[] planeDims;
    private final long[] planePosLoaded;
    private final boolean bytesOnly;

    public VirtualPlaneLoader(VirtualImg<?> image, PlanarImg<?, ? extends ArrayDataAccess<?>> planeImg, boolean bytesOnly) {
        this.virtImage = image;
        this.planeImg = planeImg;
        this.planeDims = new long[image.numDimensions() - 2];
        for (int i = 0; i < this.planeDims.length; ++i) {
            this.planeDims[i] = image.dimension(i + 2);
        }
        this.planePosLoaded = new long[this.planeDims.length];
        this.bytesOnly = bytesOnly;
        this.loadPlane(new long[image.numDimensions()]);
    }

    public boolean virtualSwap(long[] pos) {
        if (!this.planeLoaded(pos)) {
            this.loadPlane(pos);
            return true;
        }
        return false;
    }

    public void loadPlane(long[] pos) {
        for (int i = 0; i < this.planePosLoaded.length; ++i) {
            this.planePosLoaded[i] = pos[i + 2];
        }
        int planeNum = VirtualPlaneLoader.planeIndex(this.planeDims, this.planePosLoaded);
        byte[] planeBytes = null;
        try {
            planeBytes = this.virtImage.getReader().openBytes(planeNum);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot load plane " + planeNum);
        }
        Object primitivePlane = this.bytesOnly ? planeBytes : (Object)this.typeConvert(planeBytes);
        ArrayDataAccess<?> wrappedPlane = ImgIOUtils.makeArray(primitivePlane);
        this.planeImg.setPlane(0, wrappedPlane);
    }

    private boolean planeLoaded(long[] pos) {
        for (int i = 2; i < pos.length; ++i) {
            if (pos[i] == this.planePosLoaded[i - 2]) continue;
            return false;
        }
        return true;
    }

    private static int planeIndex(long[] planeDimensions, long[] planePos) {
        int index = 0;
        for (int i = 0; i < planePos.length; ++i) {
            int delta = 1;
            for (int j = 1; j <= i; ++j) {
                delta = (int)((long)delta * planeDimensions[j - 1]);
            }
            index = (int)((long)index + (long)delta * planePos[i]);
        }
        return index;
    }

    private Object typeConvert(byte[] bytes) {
        int pixelType = this.virtImage.getReader().getPixelType();
        int bytesPerPix = FormatTools.getBytesPerPixel((int)pixelType);
        boolean floating = FormatTools.isFloatingPoint((int)pixelType);
        return DataTools.makeDataArray((byte[])bytes, (int)bytesPerPix, (boolean)floating, (boolean)this.virtImage.getReader().isLittleEndian());
    }
}

