/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.io.img.virtual;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import net.imglib2.img.AbstractImg;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.io.ImgIOException;
import net.imglib2.io.ImgOpener;
import net.imglib2.io.img.virtual.VirtualCursor;
import net.imglib2.io.img.virtual.VirtualImgFactory;
import net.imglib2.io.img.virtual.VirtualRandomAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class VirtualImg<T extends NativeType<T> & RealType<T>>
extends AbstractImg<T> {
    private final long[] dims;
    private final IFormatReader reader;
    private final T type;
    private final boolean bytesOnly;

    private VirtualImg(long[] dims, IFormatReader reader, T type, boolean bytesOnly) {
        super(dims);
        this.dims = (long[])dims.clone();
        this.reader = reader;
        this.type = (NativeType)type.copy();
        this.bytesOnly = bytesOnly;
        this.checkDimensions();
    }

    public static VirtualImg<? extends RealType<?>> create(String fileName, boolean bytesOnly) throws ImgIOException {
        IFormatReader rdr = null;
        try {
            rdr = ImgOpener.createReader(fileName, false);
        }
        catch (FormatException e) {
            throw new ImgIOException(e);
        }
        catch (IOException e) {
            throw new ImgIOException(e);
        }
        long[] dimensions = ImgOpener.getDimLengths(rdr);
        if (bytesOnly) {
            dimensions[0] = dimensions[0] * (long)FormatTools.getBytesPerPixel((int)rdr.getPixelType());
            return VirtualImg.byteTypedVirtualImg(dimensions, rdr);
        }
        return VirtualImg.correctlyTypedVirtualImg(dimensions, rdr);
    }

    @Override
    public VirtualRandomAccess<T> randomAccess() {
        return new VirtualRandomAccess(this);
    }

    @Override
    public VirtualCursor<T> cursor() {
        return new VirtualCursor(this);
    }

    @Override
    public VirtualCursor<T> localizingCursor() {
        return new VirtualCursor(this);
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public ImgFactory<T> factory() {
        return new VirtualImgFactory();
    }

    @Override
    public Img<T> copy() {
        return new VirtualImg<T>(this.dims, this.reader, this.type, this.bytesOnly);
    }

    public T getType() {
        return this.type;
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public boolean isByteOnly() {
        return this.bytesOnly;
    }

    private void checkDimensions() {
        if (this.dims.length < 2) {
            throw new IllegalArgumentException("VirtualImg must be of dimension two or higher");
        }
    }

    private static VirtualImg<? extends RealType<?>> byteTypedVirtualImg(long[] dimensions, IFormatReader rdr) {
        return new VirtualImg<UnsignedByteType>(dimensions, rdr, new UnsignedByteType(), true);
    }

    private static VirtualImg<? extends RealType<?>> correctlyTypedVirtualImg(long[] dimensions, IFormatReader rdr) {
        switch (rdr.getPixelType()) {
            case 1: {
                return new VirtualImg<UnsignedByteType>(dimensions, rdr, new UnsignedByteType(), false);
            }
            case 0: {
                return new VirtualImg<ByteType>(dimensions, rdr, new ByteType(), false);
            }
            case 3: {
                return new VirtualImg<UnsignedShortType>(dimensions, rdr, new UnsignedShortType(), false);
            }
            case 2: {
                return new VirtualImg<ShortType>(dimensions, rdr, new ShortType(), false);
            }
            case 5: {
                return new VirtualImg<UnsignedIntType>(dimensions, rdr, new UnsignedIntType(), false);
            }
            case 4: {
                return new VirtualImg<IntType>(dimensions, rdr, new IntType(), false);
            }
            case 6: {
                return new VirtualImg<FloatType>(dimensions, rdr, new FloatType(), false);
            }
            case 7: {
                return new VirtualImg<DoubleType>(dimensions, rdr, new DoubleType(), false);
            }
        }
        throw new IllegalArgumentException("VirtualImg : unsupported pixel format");
    }
}

