/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.io.img.virtual;

import net.imglib2.AbstractCursor;
import net.imglib2.io.img.virtual.VirtualAccessor;
import net.imglib2.io.img.virtual.VirtualImg;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class VirtualCursor<T extends NativeType<T> & RealType<T>>
extends AbstractCursor<T> {
    private final VirtualImg<T> virtImage;
    private final IntervalIterator iter;
    private final long[] position;
    private final VirtualAccessor<T> accessor;

    public VirtualCursor(VirtualImg<T> image) {
        super(image.numDimensions());
        this.virtImage = image;
        long[] fullDimensions = new long[image.numDimensions()];
        image.dimensions(fullDimensions);
        this.iter = new IntervalIterator(fullDimensions);
        this.position = new long[fullDimensions.length];
        this.accessor = new VirtualAccessor<T>(this.virtImage);
    }

    @Override
    public T get() {
        this.iter.localize(this.position);
        return this.accessor.get(this.position);
    }

    @Override
    public void fwd() {
        this.iter.fwd();
    }

    @Override
    public void reset() {
        this.iter.reset();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public void localize(long[] pos) {
        this.iter.localize(pos);
    }

    @Override
    public long getLongPosition(int d) {
        return this.iter.getLongPosition(d);
    }

    @Override
    public VirtualCursor<T> copy() {
        return new VirtualCursor<T>(this.virtImage);
    }

    @Override
    public VirtualCursor<T> copyCursor() {
        return new VirtualCursor<T>(this.virtImage);
    }

    public Object getCurrentPlane() {
        return this.accessor.getCurrentPlane();
    }
}

