/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.io.img.virtual;

import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.img.planar.PlanarRandomAccess;
import net.imglib2.io.img.virtual.VirtualImg;
import net.imglib2.io.img.virtual.VirtualPlaneLoader;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class VirtualAccessor<T extends NativeType<T> & RealType<T>> {
    private final PlanarImg<T, ? extends ArrayDataAccess<?>> planeImg;
    private final PlanarRandomAccess<T> accessor;
    private final VirtualPlaneLoader planeLoader;

    public VirtualAccessor(VirtualImg<T> virtImage) {
        long[] planeSize = new long[]{virtImage.dimension(0), virtImage.dimension(1)};
        this.planeImg = new PlanarImgFactory().create(planeSize, (NativeType)virtImage.getType().copy());
        this.planeLoader = new VirtualPlaneLoader(virtImage, this.planeImg, virtImage.isByteOnly());
        this.accessor = this.planeImg.randomAccess();
    }

    public T get(long[] position) {
        if (this.planeLoader.virtualSwap(position)) {
            this.accessor.get().updateContainer(this.accessor);
        }
        this.accessor.setPosition(position[0], 0);
        this.accessor.setPosition(position[1], 1);
        return (T)this.accessor.get();
    }

    public Object getCurrentPlane() {
        return this.planeImg.getPlane(0);
    }
}

