/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import net.imglib2.exception.ImgLibException;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgPlus;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.io.ImgIOException;
import net.imglib2.io.ImgIOUtils;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import ome.scifio.common.DataTools;
import ome.scifio.common.StatusEvent;
import ome.scifio.common.StatusListener;
import ome.scifio.common.StatusReporter;

public class ImgSaver
implements StatusReporter {
    private final List<StatusListener> listeners = new ArrayList<StatusListener>();
    private final OMEXMLService omexmlService = this.createOMEXMLService();

    public <T extends RealType<T> & NativeType<T>> boolean isCompressible(Img<T> img) {
        return this.isCompressible(ImgPlus.wrap(img));
    }

    public <T extends RealType<T> & NativeType<T>> boolean isCompressible(ImgPlus<T> img) {
        AxisType[] axes = new AxisType[img.numDimensions()];
        img.axes(axes);
        long[] axisLengths = new long[5];
        long[] oldLengths = new long[img.numDimensions()];
        img.dimensions(oldLengths);
        boolean foundUnknown = false;
        block3: for (int i = 0; i < axes.length; ++i) {
            AxisType axis = axes[i];
            switch (axis.getLabel().toUpperCase().charAt(0)) {
                case 'C': 
                case 'T': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    continue block3;
                }
                default: {
                    if (oldLengths[i] <= 1L) continue block3;
                    foundUnknown = true;
                }
            }
        }
        if (!foundUnknown) {
            return false;
        }
        String dimOrder = ImgSaver.guessDimOrder(axes, oldLengths, axisLengths);
        return dimOrder != null;
    }

    public <T extends RealType<T> & NativeType<T>> void saveImg(String id, Img<T> img) throws ImgIOException, IncompatibleTypeException {
        this.saveImg(id, ImgPlus.wrap(img));
    }

    public <T extends RealType<T> & NativeType<T>> void saveImg(String id, ImgPlus<T> img) throws ImgIOException, IncompatibleTypeException {
        img.setSource(id);
        img.setName(new File(id).getName());
        this.saveImg(this.initializeWriter(id, img), img, false);
    }

    public <T extends RealType<T> & NativeType<T>> void saveImg(IFormatWriter w, Img<T> img) throws ImgIOException, IncompatibleTypeException {
        this.saveImg(w, ImgPlus.wrap(img));
    }

    public <T extends RealType<T> & NativeType<T>> void saveImg(IFormatWriter w, ImgPlus<T> img) throws ImgIOException, IncompatibleTypeException {
        this.saveImg(w, img, true);
    }

    public static String guessDimOrder(AxisType[] axes, long[] dimLengths, long[] newLengths) {
        int i;
        String oldOrder = "";
        String newOrder = "";
        for (int i2 = 0; i2 < newLengths.length; ++i2) {
            newLengths[i2] = 1L;
        }
        boolean[] haveDim = new boolean[5];
        int contiguousUnknown = 0;
        int missingAxisCount = 0;
        boolean unknownBlock = false;
        block18: for (int i3 = 0; i3 < axes.length; ++i3) {
            switch (axes[i3].getLabel().toUpperCase().charAt(0)) {
                case 'X': {
                    oldOrder = oldOrder + "X";
                    haveDim[0] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'Y': {
                    oldOrder = oldOrder + "Y";
                    haveDim[1] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'Z': {
                    oldOrder = oldOrder + "Z";
                    haveDim[2] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'C': {
                    oldOrder = oldOrder + "C";
                    haveDim[3] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'T': {
                    oldOrder = oldOrder + "T";
                    haveDim[4] = true;
                    unknownBlock = false;
                    continue block18;
                }
                default: {
                    oldOrder = oldOrder + "U";
                    if (dimLengths[i3] <= 1L || unknownBlock) continue block18;
                    unknownBlock = true;
                    ++contiguousUnknown;
                }
            }
        }
        for (boolean d : haveDim) {
            if (d) continue;
            ++missingAxisCount;
        }
        if (contiguousUnknown > missingAxisCount) {
            return null;
        }
        int axesPlaced = 0;
        unknownBlock = false;
        boolean sizeOneUnknown = false;
        block20: for (i = 0; i < axes.length; ++i) {
            switch (oldOrder.charAt(0)) {
                case 'U': {
                    if (dimLengths[i] <= 1L && contiguousUnknown >= missingAxisCount) continue block20;
                    if (!unknownBlock) {
                        unknownBlock = true;
                        if (contiguousUnknown < missingAxisCount) {
                            ++contiguousUnknown;
                            sizeOneUnknown = true;
                        }
                        if (!haveDim[0]) {
                            newOrder = newOrder + "X";
                            haveDim[0] = true;
                        } else if (!haveDim[1]) {
                            newOrder = newOrder + "Y";
                            haveDim[1] = true;
                        } else if (!haveDim[2]) {
                            newOrder = newOrder + "Z";
                            haveDim[2] = true;
                        } else if (!haveDim[3]) {
                            newOrder = newOrder + "C";
                            haveDim[3] = true;
                        } else if (!haveDim[4]) {
                            newOrder = newOrder + "T";
                            haveDim[4] = true;
                        }
                    } else if (dimLengths[i] > 1L && sizeOneUnknown) {
                        sizeOneUnknown = false;
                        --contiguousUnknown;
                    }
                    int n = axesPlaced;
                    newLengths[n] = newLengths[n] * dimLengths[i];
                    continue block20;
                }
                default: {
                    if (unknownBlock) {
                        ++axesPlaced;
                        unknownBlock = false;
                        sizeOneUnknown = false;
                    }
                    newOrder = newOrder + oldOrder.charAt(i);
                    newLengths[axesPlaced] = dimLengths[i];
                    ++axesPlaced;
                }
            }
        }
        block21: for (i = 0; i < haveDim.length; ++i) {
            if (haveDim[i]) continue;
            switch (i) {
                case 0: {
                    newOrder = newOrder + "X";
                    continue block21;
                }
                case 1: {
                    newOrder = newOrder + "Y";
                    continue block21;
                }
                case 2: {
                    newOrder = newOrder + "Z";
                    continue block21;
                }
                case 3: {
                    newOrder = newOrder + "C";
                    continue block21;
                }
                case 4: {
                    newOrder = newOrder + "T";
                }
            }
        }
        return newOrder;
    }

    private <T extends RealType<T> & NativeType<T>> void saveImg(IFormatWriter w, ImgPlus<T> img, boolean initializeWriter) throws ImgIOException, IncompatibleTypeException {
        if (initializeWriter) {
            this.populateMeta(w, img);
        }
        if (img.getSource().length() == 0) {
            throw new ImgIOException("Provided Image has no attached source.");
        }
        long startTime = System.currentTimeMillis();
        String id = img.getSource();
        int sliceCount = this.countSlices(img);
        this.writePlanes(w, img);
        long endTime = System.currentTimeMillis();
        float time = (float)(endTime - startTime) / 1000.0f;
        this.notifyListeners(new StatusEvent(sliceCount, sliceCount, id + ": wrote " + sliceCount + " planes in " + time + " s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener l) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener l) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(StatusEvent e) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            for (StatusListener l : this.listeners) {
                l.statusUpdated(e);
            }
        }
    }

    private <T extends RealType<T> & NativeType<T>> int countSlices(ImgPlus<T> img) {
        int sliceCount = 1;
        for (int i = 0; i < img.numDimensions(); ++i) {
            if (img.axis(i).equals(Axes.X) || img.axis(i).equals(Axes.Y)) continue;
            sliceCount = (int)((long)sliceCount * img.dimension(i));
        }
        return sliceCount;
    }

    private <T extends RealType<T> & NativeType<T>> void writePlanes(IFormatWriter w, ImgPlus<T> img) throws ImgIOException, IncompatibleTypeException {
        PlanarAccess<ArrayDataAccess<?>> planarAccess = ImgIOUtils.getPlanarAccess(img);
        if (planarAccess == null) {
            throw new IncompatibleTypeException(new ImgLibException(), "Only " + PlanarAccess.class + " images supported at this time.");
        }
        PlanarImg planarImg = (PlanarImg)planarAccess;
        int planeCount = planarImg.numSlices();
        if (img.numDimensions() > 0) {
            File f;
            Class<?> arrayType = planarImg.getPlane(0).getCurrentStorageArray().getClass();
            byte[] plane = null;
            if ((arrayType == int[].class || arrayType == byte[].class || arrayType == short[].class || arrayType == long[].class || arrayType == double[].class || arrayType == float[].class) && (f = new File(img.getSource())).exists()) {
                f.delete();
                w = this.initializeWriter(img.getSource(), img);
                this.populateMeta(w, img);
            }
            for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                this.notifyListeners(new StatusEvent(planeIndex, planeCount, "Saving plane " + (planeIndex + 1) + "/" + planeCount));
                Object curPlane = planarImg.getPlane(planeIndex).getCurrentStorageArray();
                if (arrayType == int[].class) {
                    plane = DataTools.intsToBytes((int[])((int[])curPlane), (boolean)false);
                } else if (arrayType == byte[].class) {
                    plane = (byte[])curPlane;
                } else if (arrayType == short[].class) {
                    plane = DataTools.shortsToBytes((short[])((short[])curPlane), (boolean)false);
                } else if (arrayType == long[].class) {
                    plane = DataTools.longsToBytes((long[])((long[])curPlane), (boolean)false);
                } else if (arrayType == double[].class) {
                    plane = DataTools.doublesToBytes((double[])((double[])curPlane), (boolean)false);
                } else if (arrayType == float[].class) {
                    plane = DataTools.floatsToBytes((float[])((float[])curPlane), (boolean)false);
                } else {
                    throw new IncompatibleTypeException(new ImgLibException(), "PlanarImgs of type " + planarImg.getPlane(0).getClass() + " not supported.");
                }
                try {
                    w.saveBytes(planeIndex, plane);
                    continue;
                }
                catch (FormatException e) {
                    throw new ImgIOException(e);
                }
                catch (IOException e) {
                    throw new ImgIOException(e);
                }
            }
        }
        try {
            w.close();
        }
        catch (IOException e) {
            throw new ImgIOException(e);
        }
    }

    private <T extends RealType<T> & NativeType<T>> IFormatWriter initializeWriter(String id, ImgPlus<T> img) throws ImgIOException {
        ImageWriter writer = new ImageWriter();
        IMetadata store = MetadataTools.createOMEXMLMetadata();
        store.createRoot();
        writer.setMetadataRetrieve((MetadataRetrieve)store);
        this.populateMeta((IFormatWriter)writer, img);
        try {
            writer.setId(id);
        }
        catch (FormatException e) {
            throw new ImgIOException(e);
        }
        catch (IOException e) {
            throw new ImgIOException(e);
        }
        return writer;
    }

    private <T extends RealType<T> & NativeType<T>> void populateMeta(IFormatWriter w, ImgPlus<T> img) throws ImgIOException {
        this.notifyListeners(new StatusEvent("Initializing " + img.getName()));
        MetadataRetrieve retrieve = w.getMetadataRetrieve();
        if (this.omexmlService == null) {
            throw new ImgIOException("No OMEXMLService found. Invoke ImgSaver constructor first.");
        }
        if (this.omexmlService.asStore(retrieve) != null) {
            IMetadata meta = (IMetadata)retrieve;
            int pixelType = ImgIOUtils.makeType((RealType)img.firstElement());
            AxisType[] axes = new AxisType[img.numDimensions()];
            img.axes(axes);
            String dimOrder = "";
            long[] axisLengths = new long[5];
            long[] oldLengths = new long[img.numDimensions()];
            img.dimensions(oldLengths);
            dimOrder = ImgSaver.guessDimOrder(axes, oldLengths, axisLengths);
            if (dimOrder == null) {
                throw new ImgIOException("Image has more than 5 dimensions in an order that could not be compressed.");
            }
            int sizeX = 0;
            int sizeY = 0;
            int sizeZ = 0;
            int sizeC = 0;
            int sizeT = 0;
            block7: for (int i = 0; i < dimOrder.length(); ++i) {
                switch (dimOrder.charAt(i)) {
                    case 'X': {
                        sizeX = new Long(axisLengths[i]).intValue();
                        continue block7;
                    }
                    case 'Y': {
                        sizeY = new Long(axisLengths[i]).intValue();
                        continue block7;
                    }
                    case 'Z': {
                        sizeZ = new Long(axisLengths[i]).intValue();
                        continue block7;
                    }
                    case 'C': {
                        sizeC = new Long(axisLengths[i]).intValue();
                        continue block7;
                    }
                    case 'T': {
                        sizeT = new Long(axisLengths[i]).intValue();
                    }
                }
            }
            MetadataTools.populateMetadata((MetadataStore)meta, (int)0, (String)img.getName(), (boolean)false, (String)dimOrder, (String)FormatTools.getPixelTypeString((int)pixelType), (int)sizeX, (int)sizeY, (int)sizeZ, (int)sizeC, (int)sizeT, (int)1);
        }
    }

    private OMEXMLService createOMEXMLService() {
        try {
            return (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
        }
        catch (DependencyException exc) {
            return null;
        }
    }
}

