/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.ReaderWrapper;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import net.imglib2.RandomAccess;
import net.imglib2.display.ColorTable16;
import net.imglib2.display.ColorTable8;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.ImgPlus;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.io.ImgIOException;
import net.imglib2.io.ImgIOUtils;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import ome.scifio.common.DataTools;
import ome.scifio.common.StatusEvent;
import ome.scifio.common.StatusListener;
import ome.scifio.common.StatusReporter;
import ome.xml.model.primitives.PositiveFloat;

public class ImgOpener
implements StatusReporter {
    private final List<StatusListener> listeners = new ArrayList<StatusListener>();

    public static <T extends RealType<T> & NativeType<T>> ImgPlus<T> open(String id) throws ImgIOException {
        ImgPlus<T> img = null;
        ImgOpener opener = new ImgOpener();
        try {
            try {
                img = opener.openImg(id, new ArrayImgFactory());
            }
            catch (NegativeArraySizeException e1) {
                try {
                    img = opener.openImg(id, new PlanarImgFactory());
                }
                catch (NegativeArraySizeException e2) {
                    try {
                        img = opener.openImg(id, new CellImgFactory(256));
                    }
                    catch (Exception e) {
                        throw new ImgIOException("Cannot open file '" + id + "': " + e);
                    }
                }
            }
        }
        catch (IncompatibleTypeException e) {
            throw new ImgIOException("File is incompatible with opener (not a real type?) '" + id + "': " + e);
        }
        return img;
    }

    public static ImgPlus<FloatType> openFloat(String id) throws ImgIOException {
        FloatType tmp = new FloatType();
        ImgPlus<FloatType> img = null;
        ImgOpener opener = new ImgOpener();
        try {
            img = opener.openImg(id, new ArrayImgFactory(), tmp);
        }
        catch (NegativeArraySizeException e1) {
            try {
                img = opener.openImg(id, new PlanarImgFactory(), tmp);
            }
            catch (NegativeArraySizeException e2) {
                try {
                    img = opener.openImg(id, new CellImgFactory(256), tmp);
                }
                catch (Exception e) {
                    throw new ImgIOException("Cannot open file '" + id + "': " + e);
                }
            }
        }
        return img;
    }

    public static ImgPlus<DoubleType> openDouble(String id) throws ImgIOException {
        DoubleType tmp = new DoubleType();
        ImgPlus<DoubleType> img = null;
        ImgOpener opener = new ImgOpener();
        try {
            img = opener.openImg(id, new ArrayImgFactory(), tmp);
        }
        catch (NegativeArraySizeException e1) {
            try {
                img = opener.openImg(id, new PlanarImgFactory(), tmp);
            }
            catch (NegativeArraySizeException e2) {
                try {
                    img = opener.openImg(id, new CellImgFactory(256), tmp);
                }
                catch (Exception e) {
                    throw new ImgIOException("Cannot open file '" + id + "': " + e);
                }
            }
        }
        return img;
    }

    public <T extends RealType<T> & NativeType<T>> ImgPlus<T> openImg(String id) throws ImgIOException, IncompatibleTypeException {
        return this.openImg(id, new PlanarImgFactory());
    }

    public <T extends RealType<T> & NativeType<T>> ImgPlus<T> openImg(String id, boolean computeMinMax) throws ImgIOException, IncompatibleTypeException {
        return this.openImg(id, (ImgFactory<T>)new PlanarImgFactory(), (T)computeMinMax);
    }

    public <T extends RealType<T> & NativeType<T>> ImgPlus<T> openImg(String id, ImgFactory<?> imgFactory) throws ImgIOException, IncompatibleTypeException {
        return this.openImg(id, (ImgFactory<T>)imgFactory, (T)true);
    }

    public <T extends RealType<T> & NativeType<T>> ImgPlus<T> openImg(String id, ImgFactory<?> imgFactory, boolean computeMinMax) throws ImgIOException, IncompatibleTypeException {
        try {
            IFormatReader r = this.initializeReader(id, computeMinMax);
            Object type = ImgIOUtils.makeType(r.getPixelType());
            ImgFactory imgFactoryT = imgFactory.imgFactory(type);
            return this.openImg(r, imgFactoryT, type, computeMinMax);
        }
        catch (FormatException e) {
            throw new ImgIOException(e);
        }
        catch (IOException e) {
            throw new ImgIOException(e);
        }
    }

    public <T extends RealType<T> & NativeType<T>> ImgPlus<T> openImg(String id, ImgFactory<T> imgFactory, T type) throws ImgIOException {
        return this.openImg(id, imgFactory, type, false);
    }

    public <T extends RealType<T> & NativeType<T>> ImgPlus<T> openImg(String id, ImgFactory<T> imgFactory, T type, boolean computeMinMax) throws ImgIOException {
        try {
            IFormatReader r = this.initializeReader(id, computeMinMax);
            return this.openImg(r, imgFactory, type, computeMinMax);
        }
        catch (FormatException e) {
            throw new ImgIOException(e);
        }
        catch (IOException e) {
            throw new ImgIOException(e);
        }
    }

    public <T extends RealType<T> & NativeType<T>> ImgPlus<T> openImg(IFormatReader r, ImgFactory<T> imgFactory, T type) throws ImgIOException {
        return this.openImg(r, imgFactory, type, true);
    }

    public <T extends RealType<T> & NativeType<T>> ImgPlus<T> openImg(IFormatReader r, ImgFactory<T> imgFactory, T type, boolean computeMinMax) throws ImgIOException {
        long[] dimLengths = ImgOpener.getDimLengths(r);
        Img<T> img = imgFactory.create(dimLengths, type);
        ImgPlus<T> imgPlus = this.makeImgPlus(img, r);
        long startTime = System.currentTimeMillis();
        String id = r.getCurrentFile();
        int planeCount = r.getImageCount();
        try {
            this.readPlanes(r, type, imgPlus, computeMinMax);
        }
        catch (FormatException e) {
            throw new ImgIOException(e);
        }
        catch (IOException e) {
            throw new ImgIOException(e);
        }
        imgPlus.setSource(id);
        long endTime = System.currentTimeMillis();
        float time = (float)(endTime - startTime) / 1000.0f;
        this.notifyListeners(new StatusEvent(planeCount, planeCount, id + ": read " + planeCount + " planes in " + time + "s"));
        return imgPlus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener l) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener l) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(StatusEvent e) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            for (StatusListener l : this.listeners) {
                l.statusUpdated(e);
            }
        }
    }

    public static IFormatReader createReader(String id, boolean computeMinMax) throws FormatException, IOException {
        ImageReader r = null;
        r = new ImageReader();
        r = new ChannelFiller((IFormatReader)r);
        r = new ChannelSeparator((IFormatReader)r);
        if (computeMinMax) {
            r = new MinMaxCalculator((IFormatReader)r);
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            OMEXMLMetadata meta = service.createOMEXMLMetadata();
            r.setMetadataStore((MetadataStore)meta);
        }
        catch (ServiceException e) {
            throw new FormatException((Throwable)e);
        }
        catch (DependencyException e) {
            throw new FormatException((Throwable)e);
        }
        r.setId(id);
        return r;
    }

    public static long[] getDimLengths(IFormatReader r) {
        long sizeX = r.getSizeX();
        long sizeY = r.getSizeY();
        long sizeZ = r.getSizeZ();
        long sizeT = r.getSizeT();
        int[] cDimLengths = r.getChannelDimLengths();
        String dimOrder = r.getDimensionOrder();
        ArrayList<Long> dimLengthsList = new ArrayList<Long>();
        block7: for (int i = 0; i < dimOrder.length(); ++i) {
            char dim = dimOrder.charAt(i);
            switch (dim) {
                case 'X': {
                    if (sizeX <= 0L) continue block7;
                    dimLengthsList.add(sizeX);
                    continue block7;
                }
                case 'Y': {
                    if (sizeY <= 0L) continue block7;
                    dimLengthsList.add(sizeY);
                    continue block7;
                }
                case 'Z': {
                    if (sizeZ <= 1L) continue block7;
                    dimLengthsList.add(sizeZ);
                    continue block7;
                }
                case 'T': {
                    if (sizeT <= 1L) continue block7;
                    dimLengthsList.add(sizeT);
                    continue block7;
                }
                case 'C': {
                    for (int c = 0; c < cDimLengths.length; ++c) {
                        long len = cDimLengths[c];
                        if (len <= 1L) continue;
                        dimLengthsList.add(len);
                    }
                    continue block7;
                }
            }
        }
        long[] dimLengths = new long[dimLengthsList.size()];
        for (int i = 0; i < dimLengths.length; ++i) {
            dimLengths[i] = (Long)dimLengthsList.get(i);
        }
        return dimLengths;
    }

    private IFormatReader initializeReader(String id, boolean computeMinMax) throws FormatException, IOException {
        this.notifyListeners(new StatusEvent("Initializing " + id));
        return ImgOpener.createReader(id, computeMinMax);
    }

    private AxisType[] getDimTypes(IFormatReader r) {
        int sizeX = r.getSizeX();
        int sizeY = r.getSizeY();
        int sizeZ = r.getSizeZ();
        int sizeT = r.getSizeT();
        String[] cDimTypes = r.getChannelDimTypes();
        int[] cDimLengths = r.getChannelDimLengths();
        String dimOrder = r.getDimensionOrder();
        ArrayList<AxisType> dimTypes = new ArrayList<AxisType>();
        block7: for (char dim : dimOrder.toCharArray()) {
            switch (dim) {
                case 'X': {
                    if (sizeX <= 1) continue block7;
                    dimTypes.add(Axes.X);
                    continue block7;
                }
                case 'Y': {
                    if (sizeY <= 1) continue block7;
                    dimTypes.add(Axes.Y);
                    continue block7;
                }
                case 'Z': {
                    if (sizeZ <= 1) continue block7;
                    dimTypes.add(Axes.Z);
                    continue block7;
                }
                case 'T': {
                    if (sizeT <= 1) continue block7;
                    dimTypes.add(Axes.TIME);
                    continue block7;
                }
                case 'C': {
                    for (int c = 0; c < cDimTypes.length; ++c) {
                        int len = cDimLengths[c];
                        if (len <= 1) continue;
                        dimTypes.add(Axes.get(cDimTypes[c]));
                    }
                    continue block7;
                }
            }
        }
        return dimTypes.toArray(new AxisType[0]);
    }

    private double[] getCalibration(IFormatReader r) {
        long sizeX = r.getSizeX();
        long sizeY = r.getSizeY();
        long sizeZ = r.getSizeZ();
        long sizeT = r.getSizeT();
        int[] cDimLengths = r.getChannelDimLengths();
        String dimOrder = r.getDimensionOrder();
        IMetadata meta = (IMetadata)r.getMetadataStore();
        PositiveFloat xCalin = meta.getPixelsPhysicalSizeX(0);
        PositiveFloat yCalin = meta.getPixelsPhysicalSizeY(0);
        PositiveFloat zCalin = meta.getPixelsPhysicalSizeZ(0);
        Double tCal = meta.getPixelsTimeIncrement(0);
        Double xCal = xCalin == null ? Double.valueOf(Double.NaN) : (Double)xCalin.getValue();
        Double yCal = yCalin == null ? Double.valueOf(Double.NaN) : (Double)yCalin.getValue();
        Double zCal = zCalin == null ? Double.valueOf(Double.NaN) : (Double)zCalin.getValue();
        if (tCal == null) {
            tCal = Double.NaN;
        }
        ArrayList<Double> calibrationList = new ArrayList<Double>();
        block7: for (int i = 0; i < dimOrder.length(); ++i) {
            char dim = dimOrder.charAt(i);
            switch (dim) {
                case 'X': {
                    if (sizeX <= 1L) continue block7;
                    calibrationList.add(xCal);
                    continue block7;
                }
                case 'Y': {
                    if (sizeY <= 1L) continue block7;
                    calibrationList.add(yCal);
                    continue block7;
                }
                case 'Z': {
                    if (sizeZ <= 1L) continue block7;
                    calibrationList.add(zCal);
                    continue block7;
                }
                case 'T': {
                    if (sizeT <= 1L) continue block7;
                    calibrationList.add(tCal);
                    continue block7;
                }
                case 'C': {
                    for (int c = 0; c < cDimLengths.length; ++c) {
                        long len = cDimLengths[c];
                        if (len <= 1L) continue;
                        calibrationList.add(Double.NaN);
                    }
                    continue block7;
                }
            }
        }
        double[] calibration = new double[calibrationList.size()];
        for (int i = 0; i < calibration.length; ++i) {
            calibration[i] = (Double)calibrationList.get(i);
        }
        return calibration;
    }

    private <T extends RealType<T>> ImgPlus<T> makeImgPlus(Img<T> img, IFormatReader r) throws ImgIOException {
        String colorMode;
        IFormatReader base;
        String id = r.getCurrentFile();
        File idFile = new File(id);
        String name = idFile.exists() ? idFile.getName() : id;
        AxisType[] dimTypes = this.getDimTypes(r);
        double[] cal = this.getCalibration(r);
        try {
            base = this.unwrap(r);
        }
        catch (FormatException exc) {
            throw new ImgIOException(exc);
        }
        catch (IOException exc) {
            throw new ImgIOException(exc);
        }
        int rgbChannelCount = base.getRGBChannelCount();
        int validBits = r.getBitsPerPixel();
        ImgPlus<T> imgPlus = new ImgPlus<T>(img, name, dimTypes, cal);
        imgPlus.setValidBits(validBits);
        int compositeChannelCount = rgbChannelCount;
        if (rgbChannelCount == 1 && "composite".equals(colorMode = (String)r.getMetadataValue("Color mode"))) {
            compositeChannelCount = r.getSizeC();
        }
        imgPlus.setCompositeChannelCount(compositeChannelCount);
        return imgPlus;
    }

    private IFormatReader unwrap(IFormatReader r) throws FormatException, IOException {
        if (!(r instanceof ReaderWrapper)) {
            return r;
        }
        ReaderWrapper rw = (ReaderWrapper)r;
        IFormatReader channelFiller = rw.unwrap(ChannelFiller.class, null);
        if (channelFiller != null) {
            return channelFiller;
        }
        return rw.unwrap();
    }

    private <T extends RealType<T>> void readPlanes(IFormatReader r, T type, ImgPlus<T> imgPlus, boolean computeMinMax) throws FormatException, IOException {
        PlanarAccess<ArrayDataAccess<?>> planarAccess = ImgIOUtils.getPlanarAccess(imgPlus);
        Object inputType = ImgIOUtils.makeType(r.getPixelType());
        T outputType = type;
        boolean compatibleTypes = outputType.getClass().isAssignableFrom(inputType.getClass());
        int planeCount = r.getImageCount();
        boolean isPlanar = planarAccess != null && compatibleTypes;
        imgPlus.initializeColorTables(planeCount);
        byte[] plane = null;
        for (int no = 0; no < planeCount; ++no) {
            short[][] lut16;
            this.notifyListeners(new StatusEvent(no, planeCount, "Reading plane " + (no + 1) + "/" + planeCount));
            if (plane == null) {
                plane = r.openBytes(no);
            } else {
                r.openBytes(no, plane);
            }
            if (isPlanar) {
                this.populatePlane(r, no, plane, planarAccess);
            } else {
                this.populatePlane(r, no, plane, imgPlus);
            }
            byte[][] lut8 = r.get8BitLookupTable();
            if (lut8 != null) {
                imgPlus.setColorTable(new ColorTable8(lut8), no);
            }
            if ((lut16 = r.get16BitLookupTable()) == null) continue;
            imgPlus.setColorTable(new ColorTable16(lut16), no);
        }
        if (computeMinMax) {
            this.populateMinMax(r, imgPlus);
        }
        r.close();
    }

    private void populatePlane(IFormatReader r, int no, byte[] plane, PlanarAccess planarAccess) {
        boolean little;
        boolean fp;
        int pixelType = r.getPixelType();
        int bpp = FormatTools.getBytesPerPixel((int)pixelType);
        Object planeArray = DataTools.makeDataArray((byte[])plane, (int)bpp, (boolean)(fp = FormatTools.isFloatingPoint((int)pixelType)), (boolean)(little = r.isLittleEndian()));
        if (planeArray == plane) {
            byte[] planeCopy = new byte[plane.length];
            System.arraycopy(plane, 0, planeCopy, 0, plane.length);
            planeArray = planeCopy;
        }
        planarAccess.setPlane(no, ImgIOUtils.makeArray(planeArray));
    }

    private <T extends RealType<T>> void populatePlane(IFormatReader r, int no, byte[] plane, ImgPlus<T> img) {
        int pixelType = r.getPixelType();
        boolean little = r.isLittleEndian();
        long[] dimLengths = ImgOpener.getDimLengths(r);
        long[] pos = new long[dimLengths.length];
        boolean planeX = false;
        boolean planeY = true;
        this.getPosition(r, no, pos);
        int sX = (int)img.dimension(0);
        int sY = (int)img.dimension(1);
        RandomAccess<T> randomAccess = img.randomAccess();
        int index = 0;
        for (int y = 0; y < sY; ++y) {
            pos[0] = 0L;
            pos[1] = y;
            randomAccess.setPosition(pos);
            for (int x = 1; x < sX; ++x) {
                ((RealType)randomAccess.get()).setReal(ImgOpener.decodeWord(plane, index++, pixelType, little));
                randomAccess.fwd(0);
            }
            ((RealType)randomAccess.get()).setReal(ImgOpener.decodeWord(plane, index++, pixelType, little));
        }
    }

    private void populateMinMax(IFormatReader r, ImgPlus<?> imgPlus) throws FormatException, IOException {
        int sizeC = r.getSizeC();
        ReaderWrapper rw = (ReaderWrapper)r;
        MinMaxCalculator minMaxCalc = (MinMaxCalculator)rw.unwrap(MinMaxCalculator.class, null);
        for (int c = 0; c < sizeC; ++c) {
            Double min = minMaxCalc.getChannelKnownMinimum(c);
            Double max = minMaxCalc.getChannelKnownMaximum(c);
            imgPlus.setChannelMinimum(c, min == null ? Double.NaN : min);
            imgPlus.setChannelMaximum(c, max == null ? Double.NaN : max);
        }
    }

    private void getPosition(IFormatReader r, int no, long[] pos) {
        int sizeX = r.getSizeX();
        int sizeY = r.getSizeY();
        int sizeZ = r.getSizeZ();
        int sizeT = r.getSizeT();
        int[] cDimLengths = r.getChannelDimLengths();
        String dimOrder = r.getDimensionOrder();
        int[] zct = r.getZCTCoords(no);
        int index = 0;
        block7: for (int i = 0; i < dimOrder.length(); ++i) {
            char dim = dimOrder.charAt(i);
            switch (dim) {
                case 'X': {
                    if (sizeX <= 1) continue block7;
                    ++index;
                    continue block7;
                }
                case 'Y': {
                    if (sizeY <= 1) continue block7;
                    ++index;
                    continue block7;
                }
                case 'Z': {
                    if (sizeZ <= 1) continue block7;
                    pos[index++] = zct[0];
                    continue block7;
                }
                case 'T': {
                    if (sizeT <= 1) continue block7;
                    pos[index++] = zct[2];
                    continue block7;
                }
                case 'C': {
                    int[] cPos = FormatTools.rasterToPosition((int[])cDimLengths, (int)zct[1]);
                    for (int c = 0; c < cDimLengths.length; ++c) {
                        if (cDimLengths[c] <= 1) continue;
                        pos[index++] = cPos[c];
                    }
                    continue block7;
                }
            }
        }
    }

    private static double decodeWord(byte[] plane, int index, int pixelType, boolean little) {
        double value;
        switch (pixelType) {
            case 1: {
                value = plane[index] & 0xFF;
                break;
            }
            case 0: {
                value = plane[index];
                break;
            }
            case 3: {
                value = DataTools.bytesToShort((byte[])plane, (int)(2 * index), (int)2, (boolean)little) & 0xFFFF;
                break;
            }
            case 2: {
                value = DataTools.bytesToShort((byte[])plane, (int)(2 * index), (int)2, (boolean)little);
                break;
            }
            case 5: {
                value = (long)DataTools.bytesToInt((byte[])plane, (int)(4 * index), (int)4, (boolean)little) & 0xFFFFFFFFL;
                break;
            }
            case 4: {
                value = DataTools.bytesToInt((byte[])plane, (int)(4 * index), (int)4, (boolean)little);
                break;
            }
            case 6: {
                value = DataTools.bytesToFloat((byte[])plane, (int)(4 * index), (int)4, (boolean)little);
                break;
            }
            case 7: {
                value = DataTools.bytesToDouble((byte[])plane, (int)(8 * index), (int)8, (boolean)little);
                break;
            }
            default: {
                value = Double.NaN;
            }
        }
        return value;
    }
}

