/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.imglib2.img.ImgPlus;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.io.ImgIOException;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public final class ImgIOUtils {
    private static final int BUFFER_SIZE = 262144;

    private ImgIOUtils() {
    }

    public static String cacheId(String urlPath) throws ImgIOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int r;
            int dot;
            URL url = new URL(urlPath);
            String path = url.getPath();
            boolean zip = path.endsWith(".zip");
            boolean gz = path.endsWith(".gz");
            String filename = path.substring(path.lastIndexOf("/") + 1);
            ZipInputStream inZip = null;
            in = url.openStream();
            if (zip) {
                inZip = new ZipInputStream(in);
                in = inZip;
                ZipEntry zipEntry = inZip.getNextEntry();
                filename = zipEntry.getName();
            }
            if (gz) {
                in = new GZIPInputStream(in);
                filename = filename.substring(0, filename.length() - 3);
            }
            String prefix = (dot = filename.lastIndexOf(".")) < 0 ? filename : filename.substring(0, dot);
            String suffix = dot < 0 ? "" : "." + filename.substring(dot + 1);
            File tmpFile = File.createTempFile(prefix + "-", suffix);
            tmpFile.deleteOnExit();
            out = new FileOutputStream(tmpFile);
            byte[] buf = new byte[262144];
            while ((r = in.read(buf)) >= 0) {
                out.write(buf, 0, r);
            }
            String string = tmpFile.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new ImgIOException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new ImgIOException(e);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new ImgIOException(e);
            }
        }
    }

    public static PlanarAccess<ArrayDataAccess<?>> getPlanarAccess(ImgPlus<?> img) {
        if (img.getImg() instanceof PlanarAccess) {
            return (PlanarAccess)((Object)img.getImg());
        }
        return null;
    }

    public static <T extends RealType<T>> T makeType(int pixelType) {
        AbstractRealType type;
        switch (pixelType) {
            case 1: {
                type = new UnsignedByteType();
                break;
            }
            case 0: {
                type = new ByteType();
                break;
            }
            case 3: {
                type = new UnsignedShortType();
                break;
            }
            case 2: {
                type = new ShortType();
                break;
            }
            case 5: {
                type = new UnsignedIntType();
                break;
            }
            case 4: {
                type = new IntType();
                break;
            }
            case 6: {
                type = new FloatType();
                break;
            }
            case 7: {
                type = new DoubleType();
                break;
            }
            default: {
                type = null;
            }
        }
        return (T)type;
    }

    public static int makeType(RealType type) throws ImgIOException {
        int pixelType = 1;
        if (type instanceof UnsignedByteType) {
            pixelType = 1;
        } else if (type instanceof ByteType) {
            pixelType = 0;
        } else if (type instanceof UnsignedShortType) {
            pixelType = 3;
        } else if (type instanceof ShortType) {
            pixelType = 2;
        } else if (type instanceof UnsignedIntType) {
            pixelType = 5;
        } else if (type instanceof IntType) {
            pixelType = 4;
        } else if (type instanceof FloatType) {
            pixelType = 6;
        } else if (type instanceof DoubleType) {
            pixelType = 7;
        } else {
            throw new ImgIOException("Pixel type not supported. Please convert your image to a supported type.");
        }
        return pixelType;
    }

    public static ArrayDataAccess<?> makeArray(Object array) {
        ArrayDataAccess<ByteArray> access = array instanceof byte[] ? new ByteArray((byte[])array) : (array instanceof char[] ? new CharArray((char[])array) : (array instanceof double[] ? new DoubleArray((double[])array) : (array instanceof int[] ? new IntArray((int[])array) : (array instanceof float[] ? new FloatArray((float[])array) : (array instanceof short[] ? new ShortArray((short[])array) : (array instanceof long[] ? new LongArray((long[])array) : null))))));
        return access;
    }
}

