/*
 * Decompiled with CFR 0.152.
 */
package fj.test;

import fj.Bottom;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P2;
import fj.Unit;
import fj.data.Array;
import fj.data.List;
import fj.pre.Monoid;
import fj.pre.Ord;
import fj.test.Gen;
import fj.test.Rand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Gen<A> {
    private final F<Integer, F<Rand, A>> f;

    private Gen(F<Integer, F<Rand, A>> f2) {
        this.f = f2;
    }

    public A gen(int i, Rand r) {
        return this.f.f(i).f(r);
    }

    public <B> Gen<B> map(final F<A, B> f2) {
        return new Gen<A>(new F<Integer, F<Rand, B>>(){

            @Override
            public F<Rand, B> f(final Integer i) {
                return new F<Rand, B>(){

                    @Override
                    public B f(Rand r) {
                        return f2.f(Gen.this.gen(i, r));
                    }
                };
            }
        });
    }

    public Gen<A> filter(final F<A, Boolean> f2) {
        return Gen.gen(Function.curry(new F2<Integer, Rand, A>(){

            @Override
            public A f(Integer i, Rand r) {
                Object a;
                while (!((Boolean)f2.f(a = Gen.this.gen(i, r))).booleanValue()) {
                }
                return a;
            }
        }));
    }

    public Unit foreach(Integer i, Rand r, F<A, Unit> f2) {
        return f2.f(this.f.f(i).f(r));
    }

    public void foreach(Integer i, Rand r, Effect<A> f2) {
        f2.e(this.f.f(i).f(r));
    }

    public <B> Gen<B> bind(final F<A, Gen<B>> f2) {
        return new Gen<A>(new F<Integer, F<Rand, B>>(){

            @Override
            public F<Rand, B> f(final Integer i) {
                return new F<Rand, B>(){

                    @Override
                    public B f(Rand r) {
                        return ((F)((Gen)f2.f(Gen.this.gen(i, r))).f.f(i)).f(r);
                    }
                };
            }
        });
    }

    public <B, C> Gen<C> bind(Gen<B> gb, F<A, F<B, C>> f2) {
        return gb.apply(this.map(f2));
    }

    public <B, C, D> Gen<D> bind(Gen<B> gb, Gen<C> gc, F<A, F<B, F<C, D>>> f2) {
        return gc.apply(this.bind(gb, f2));
    }

    public <B, C, D, E> Gen<E> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, F<A, F<B, F<C, F<D, E>>>> f2) {
        return gd.apply(this.bind(gb, gc, f2));
    }

    public <B, C, D, E, F$> Gen<F$> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, Gen<E> ge, F<A, F<B, F<C, F<D, F<E, F$>>>>> f2) {
        return ge.apply(this.bind(gb, gc, gd, f2));
    }

    public <B, C, D, E, F$, G> Gen<G> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, Gen<E> ge, Gen<F$> gf, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f2) {
        return gf.apply(this.bind(gb, gc, gd, ge, f2));
    }

    public <B, C, D, E, F$, G, H> Gen<H> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, Gen<E> ge, Gen<F$> gf, Gen<G> gg, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f2) {
        return gg.apply(this.bind(gb, gc, gd, ge, gf, f2));
    }

    public <B, C, D, E, F$, G, H, I> Gen<I> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, Gen<E> ge, Gen<F$> gf, Gen<G> gg, Gen<H> gh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f2) {
        return gh.apply(this.bind(gb, gc, gd, ge, gf, gg, f2));
    }

    public <B> Gen<B> apply(Gen<F<A, B>> gf) {
        return gf.bind(new F<F<A, B>, Gen<B>>(){

            @Override
            public Gen<B> f(final F<A, B> f2) {
                return Gen.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f2.f(a);
                    }
                });
            }
        });
    }

    public Gen<A> resize(final int s) {
        return new Gen<A>(new F<Integer, F<Rand, A>>(){

            @Override
            public F<Rand, A> f(Integer i) {
                return new F<Rand, A>(){

                    @Override
                    public A f(Rand r) {
                        return ((F)Gen.this.f.f(s)).f(r);
                    }
                };
            }
        });
    }

    public static <A> Gen<A> gen(F<Integer, F<Rand, A>> f2) {
        return new Gen<A>(f2);
    }

    public static <A> Gen<List<A>> sequence(List<Gen<A>> gs) {
        return gs.foldRight(new F<Gen<A>, F<Gen<List<A>>, Gen<List<A>>>>(){

            @Override
            public F<Gen<List<A>>, Gen<List<A>>> f(final Gen<A> ga) {
                return new F<Gen<List<A>>, Gen<List<A>>>(){

                    @Override
                    public Gen<List<A>> f(Gen<List<A>> gas) {
                        return ga.bind(gas, List.cons());
                    }
                };
            }
        }, Gen.value(List.nil()));
    }

    public static <A> Gen<List<A>> sequenceN(int n, Gen<A> g2) {
        return Gen.sequence(List.replicate(n, g2));
    }

    public static <A> Gen<A> parameterised(final F<Integer, F<Rand, Gen<A>>> f2) {
        return new Gen<A>(Function.curry(new F2<Integer, Rand, A>(){

            @Override
            public A f(Integer i, Rand r) {
                return ((Gen)((F)f2.f(i)).f(r)).gen(i, r);
            }
        }));
    }

    public static <A> Gen<A> sized(F<Integer, Gen<A>> f2) {
        return Gen.parameterised(Function.flip(Function.constant(f2)));
    }

    public static <A> Gen<A> value(final A a) {
        return new Gen<A>(new F<Integer, F<Rand, A>>(){

            @Override
            public F<Rand, A> f(Integer i) {
                return new F<Rand, A>(){

                    @Override
                    public A f(Rand r) {
                        return a;
                    }
                };
            }
        });
    }

    public static Gen<Integer> choose(int from, int to) {
        final int f2 = Math.min(from, to);
        final int t = Math.max(from, to);
        return Gen.parameterised(Function.curry(new F2<Integer, Rand, Gen<Integer>>(){

            @Override
            public Gen<Integer> f(Integer i, Rand r) {
                return Gen.value(r.choose(f2, t));
            }
        }));
    }

    public static Gen<Double> choose(double from, double to) {
        final double f2 = Math.min(from, to);
        final double t = Math.max(from, to);
        return Gen.parameterised(new F<Integer, F<Rand, Gen<Double>>>(){

            @Override
            public F<Rand, Gen<Double>> f(Integer i) {
                return new F<Rand, Gen<Double>>(){

                    @Override
                    public Gen<Double> f(Rand r) {
                        return Gen.value(r.choose(f2, t));
                    }
                };
            }
        });
    }

    public static <A> Gen<A> fail() {
        return new Gen<A>(new F<Integer, F<Rand, A>>(){

            @Override
            public F<Rand, A> f(Integer i) {
                return new F<Rand, A>(){

                    @Override
                    public A f(Rand r) {
                        throw Bottom.error("Failing generator");
                    }
                };
            }
        });
    }

    public static <A> Gen<A> join(Gen<Gen<A>> g2) {
        return g2.bind(Function.identity());
    }

    public static <A> Gen<A> frequency(final List<P2<Integer, Gen<A>>> gs) {
        F f2 = P2.__1();
        return Gen.choose(1, Monoid.intAdditionMonoid.sumLeft(gs.map(f2))).bind(new F<Integer, Gen<A>>(){

            @Override
            public Gen<A> f(Integer i) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                final class Pick {
                    Pick() {
                    }

                    <A> Gen<A> pick(int n, List<P2<Integer, Gen<A>>> gs) {
                        if (gs.isEmpty()) {
                            return Gen.fail();
                        }
                        int k = gs.head()._1();
                        return n <= k ? gs.head()._2() : this.pick(n - k, gs.tail());
                    }
                }
                return new Pick().pick(i, gs);
            }
        });
    }

    public static <A> Gen<A> elemFrequency(List<P2<Integer, A>> as) {
        return Gen.frequency(as.map(new F<P2<Integer, A>, P2<Integer, Gen<A>>>(){

            @Override
            public P2<Integer, Gen<A>> f(P2<Integer, A> p) {
                return p.map2(new F<A, Gen<A>>(){

                    @Override
                    public Gen<A> f(A a) {
                        return Gen.value(a);
                    }
                });
            }
        }));
    }

    public static <A> Gen<A> elements(final A ... as) {
        return Array.array(as).isEmpty() ? Gen.fail() : Gen.choose(0, as.length - 1).map(new F<Integer, A>(){

            @Override
            public A f(Integer i) {
                return as[i];
            }
        });
    }

    public static <A> Gen<A> oneOf(final List<Gen<A>> gs) {
        return gs.isEmpty() ? Gen.fail() : Gen.choose(0, gs.length() - 1).bind(new F<Integer, Gen<A>>(){

            @Override
            public Gen<A> f(Integer i) {
                return (Gen)gs.index(i);
            }
        });
    }

    public static <A> Gen<List<A>> listOf(final Gen<A> g2, final int x) {
        return Gen.sized(new F<Integer, Gen<List<A>>>(){

            @Override
            public Gen<List<A>> f(Integer size) {
                return Gen.choose(x, size).bind(new F<Integer, Gen<List<A>>>(){

                    @Override
                    public Gen<List<A>> f(Integer n) {
                        return Gen.sequenceN(n, g2);
                    }
                });
            }
        });
    }

    public static <A> Gen<List<A>> listOf(Gen<A> g2) {
        return Gen.listOf(g2, 0);
    }

    public static <A> Gen<List<A>> listOf1(Gen<A> g2) {
        return Gen.listOf(g2, 1);
    }

    public static <A> Gen<List<A>> pick(int n, final List<A> as) {
        return n < 0 || n > as.length() ? Gen.fail() : Gen.sequenceN(n, Gen.choose(0, as.length() - 1)).map(new F<List<Integer>, List<A>>(){

            @Override
            public List<A> f(List<Integer> is) {
                List r = List.nil();
                List<Integer> iis = is.sort(Ord.intOrd);
                List aas = as.zipIndex();
                while (iis.isNotEmpty() && aas.isNotEmpty()) {
                    if (iis.head().equals(aas.head()._2())) {
                        iis = iis.tail();
                    } else {
                        r = r.snoc(aas.head()._1());
                    }
                    aas = aas.tail();
                }
                return r;
            }
        });
    }

    public static <A> Gen<List<A>> someOf(final List<A> as) {
        return Gen.choose(0, as.length()).bind(new F<Integer, Gen<List<A>>>(){

            @Override
            public Gen<List<A>> f(Integer i) {
                return Gen.pick(i, as);
            }
        });
    }

    public static <A, B> Gen<F<A, B>> promote(final F<A, Gen<B>> f2) {
        return new Gen<F<A, B>>(new F<Integer, F<Rand, F<A, B>>>(){

            @Override
            public F<Rand, F<A, B>> f(final Integer i) {
                return new F<Rand, F<A, B>>(){

                    @Override
                    public F<A, B> f(final Rand r) {
                        return new F<A, B>(){

                            @Override
                            public B f(A a) {
                                return ((F)((Gen)f2.f(a)).f.f(i)).f(r);
                            }
                        };
                    }
                };
            }
        });
    }
}

