/*
 * Decompiled with CFR 0.152.
 */
package fj.pre;

import fj.Class;
import fj.F;
import fj.Function;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.Validation;
import fj.data.hlist.HList;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Show<A> {
    private final F<A, List<Character>> f;
    public static final Show<Boolean> booleanShow = Show.anyShow();
    public static final Show<Byte> byteShow = Show.anyShow();
    public static final Show<Character> charShow = Show.anyShow();
    public static final Show<Double> doubleShow = Show.anyShow();
    public static final Show<Float> floatShow = Show.anyShow();
    public static final Show<Integer> intShow = Show.anyShow();
    public static final Show<BigInteger> bigintShow = Show.anyShow();
    public static final Show<BigDecimal> bigdecimalShow = Show.anyShow();
    public static final Show<Long> longShow = Show.anyShow();
    public static final Show<Short> shortShow = Show.anyShow();
    public static final Show<String> stringShow = Show.anyShow();
    public static final Show<StringBuffer> stringBufferShow = Show.anyShow();
    public static final Show<StringBuilder> stringBuilderShow = Show.anyShow();
    public static final Show<HList.HNil> hListShow = Show.showS(Function.constant("Nil"));

    private Show(F<A, List<Character>> f2) {
        this.f = f2;
    }

    public <B> Show<B> comap(F<B, A> f2) {
        return Show.show(Function.compose(this.f, f2));
    }

    public List<Character> show(A a) {
        return this.f.f(a);
    }

    public String showS(A a) {
        return List.asString(this.show(a));
    }

    public F<A, String> showS_() {
        return new F<A, String>(){

            @Override
            public String f(A a) {
                return Show.this.showS(a);
            }
        };
    }

    public F<A, List<Character>> show_() {
        return this.f;
    }

    public Unit print(A a) {
        System.out.print(this.showS(a));
        return Unit.unit();
    }

    public Unit println(A a) {
        System.out.println(this.showS(a));
        return Unit.unit();
    }

    public void printE(A a) {
        System.err.print(this.showS(a));
    }

    public void printlnE(A a) {
        System.err.println(this.showS(a));
    }

    public static <A> Show<A> show(F<A, List<Character>> f2) {
        return new Show<A>(f2);
    }

    public static <A> Show<A> showS(final F<A, String> f2) {
        return new Show<A>(new F<A, List<Character>>(){

            @Override
            public List<Character> f(A a) {
                return List.fromString((String)f2.f(a));
            }
        });
    }

    public static <A> Show<A> anyShow() {
        return new Show<A>(new F<A, List<Character>>(){

            @Override
            public List<Character> f(A a) {
                return List.fromString(a.toString());
            }
        });
    }

    public static <A> Show<Option<A>> optionShow(final Show<A> sa) {
        return new Show<Option<A>>(new F<Option<A>, List<Character>>(){

            @Override
            public List<Character> f(Option<A> o) {
                return o.isNone() ? List.fromString("None") : List.fromString("Some(").append((List)sa.f.f(o.some())).append(List.single(Character.valueOf(')')));
            }
        });
    }

    public static <A, B> Show<Either<A, B>> eitherShow(final Show<A> sa, final Show<B> sb) {
        return new Show<Either<A, B>>(new F<Either<A, B>, List<Character>>(){

            @Override
            public List<Character> f(Either<A, B> e) {
                return e.isLeft() ? List.fromString("Left(").append((List)sa.f.f(e.left().value())).append(List.single(Character.valueOf(')'))) : List.fromString("Right(").append((List)sb.f.f(e.right().value())).append(List.single(Character.valueOf(')')));
            }
        });
    }

    public static <A, B> Show<Validation<A, B>> validationShow(final Show<A> sa, final Show<B> sb) {
        return new Show<Validation<A, B>>(new F<Validation<A, B>, List<Character>>(){

            @Override
            public List<Character> f(Validation<A, B> v) {
                return v.isFail() ? List.fromString("Fail(").append((List)sa.f.f(v.fail())).append(List.single(Character.valueOf(')'))) : List.fromString("Success(").append((List)sb.f.f(v.success())).append(List.single(Character.valueOf(')')));
            }
        });
    }

    public static <A> Show<List<A>> listShow(final Show<A> sa) {
        return new Show<List<A>>(new F<List<A>, List<Character>>(){

            @Override
            public List<Character> f(List<A> as) {
                List.Buffer<Character> b = List.Buffer.empty();
                List xs = as;
                while (xs.isNotEmpty()) {
                    b.append((List)sa.f.f(xs.head()));
                    if (xs.tail().isNotEmpty()) {
                        b.snoc(Character.valueOf(','));
                    }
                    xs = xs.tail();
                }
                b.snoc(Character.valueOf(']'));
                return List.cons(Character.valueOf('['), b.toList());
            }
        });
    }

    public static <A> Show<NonEmptyList<A>> nonEmptyListShow(Show<A> sa) {
        return Show.listShow(sa).comap(NonEmptyList.toList_());
    }

    public static <A> Show<Tree<A>> treeShow(final Show<A> sa) {
        return new Show<Tree<A>>(new F<Tree<A>, List<Character>>(){

            @Override
            public List<Character> f(Tree<A> a) {
                List.Buffer<Character> b = List.Buffer.empty();
                b.append((List)sa.f.f(a.root()));
                b.append((List)Show.listShow(Show.treeShow(sa)).f.f(a.subForest()));
                b.snoc(Character.valueOf(')'));
                return List.cons(Character.valueOf('('), b.toList());
            }
        });
    }

    public static <A> Show<Stream<A>> streamShow(final Show<A> sa) {
        return new Show<Stream<A>>(new F<Stream<A>, List<Character>>(){

            @Override
            public List<Character> f(Stream<A> as) {
                List.Buffer<Character> b = List.Buffer.empty();
                Stream xs = as;
                while (xs.isNotEmpty()) {
                    b.append((List)sa.f.f(xs.head()));
                    if (xs.tail()._1().isNotEmpty()) {
                        b.snoc(Character.valueOf(','));
                    }
                    xs = xs.tail()._1();
                }
                b.snoc(Character.valueOf('>'));
                return List.cons(Character.valueOf('<'), b.toList());
            }
        });
    }

    public static <A> Show<Array<A>> arrayShow(final Show<A> sa) {
        return new Show<Array<A>>(new F<Array<A>, List<Character>>(){

            @Override
            public List<Character> f(Array<A> as) {
                List.Buffer<Character> b = List.Buffer.empty();
                for (int i = 0; i < as.length(); ++i) {
                    b.append((List)sa.f.f(as.get(i)));
                    if (i == as.length() - 1) continue;
                    b.snoc(Character.valueOf(','));
                }
                b.snoc(Character.valueOf('}'));
                return List.cons(Character.valueOf('{'), b.toList());
            }
        });
    }

    public static <A> Show<Class<A>> classShow() {
        return new Show<Class<A>>(new F<Class<A>, List<Character>>(){

            @Override
            public List<Character> f(Class<A> c) {
                return Show.anyShow().show(c.clas());
            }
        });
    }

    public static <A> Show<P1<A>> p1Show(final Show<A> sa) {
        return new Show<P1<A>>(new F<P1<A>, List<Character>>(){

            @Override
            public List<Character> f(P1<A> p) {
                return List.cons(Character.valueOf('('), sa.show(p._1())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B> Show<P2<A, B>> p2Show(final Show<A> sa, final Show<B> sb) {
        return new Show<P2<A, B>>(new F<P2<A, B>, List<Character>>(){

            @Override
            public List<Character> f(P2<A, B> p) {
                return List.cons(Character.valueOf('('), sa.show(p._1())).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C> Show<P3<A, B, C>> p3Show(final Show<A> sa, final Show<B> sb, final Show<C> sc) {
        return new Show<P3<A, B, C>>(new F<P3<A, B, C>, List<Character>>(){

            @Override
            public List<Character> f(P3<A, B, C> p) {
                return List.cons(Character.valueOf('('), sa.show(p._1())).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D> Show<P4<A, B, C, D>> p4Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd) {
        return new Show<P4<A, B, C, D>>(new F<P4<A, B, C, D>, List<Character>>(){

            @Override
            public List<Character> f(P4<A, B, C, D> p) {
                return List.cons(Character.valueOf('('), sa.show(p._1())).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E> Show<P5<A, B, C, D, E>> p5Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd, final Show<E> se) {
        return new Show<P5<A, B, C, D, E>>(new F<P5<A, B, C, D, E>, List<Character>>(){

            @Override
            public List<Character> f(P5<A, B, C, D, E> p) {
                return List.cons(Character.valueOf('('), sa.show(p._1())).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$> Show<P6<A, B, C, D, E, F$>> p6Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd, final Show<E> se, final Show<F$> sf) {
        return new Show<P6<A, B, C, D, E, F$>>(new F<P6<A, B, C, D, E, F$>, List<Character>>(){

            @Override
            public List<Character> f(P6<A, B, C, D, E, F$> p) {
                return List.cons(Character.valueOf('('), sa.show(p._1())).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$, G> Show<P7<A, B, C, D, E, F$, G>> p7Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd, final Show<E> se, final Show<F$> sf, final Show<G> sg) {
        return new Show<P7<A, B, C, D, E, F$, G>>(new F<P7<A, B, C, D, E, F$, G>, List<Character>>(){

            @Override
            public List<Character> f(P7<A, B, C, D, E, F$, G> p) {
                return List.cons(Character.valueOf('('), sa.show(p._1())).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(',')).append(sg.show(p._7())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$, G, H> Show<P8<A, B, C, D, E, F$, G, H>> p8Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd, final Show<E> se, final Show<F$> sf, final Show<G> sg, final Show<H> sh) {
        return new Show<P8<A, B, C, D, E, F$, G, H>>(new F<P8<A, B, C, D, E, F$, G, H>, List<Character>>(){

            @Override
            public List<Character> f(P8<A, B, C, D, E, F$, G, H> p) {
                return List.cons(Character.valueOf('('), sa.show(p._1())).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(',')).append(sg.show(p._7())).snoc(Character.valueOf(',')).append(sh.show(p._8())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A> Show<V2<A>> v2Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V2.toStream_());
    }

    public static <A> Show<V3<A>> v3Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V3.toStream_());
    }

    public static <A> Show<V4<A>> v4Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V4.toStream_());
    }

    public static <A> Show<V5<A>> v5Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V5.toStream_());
    }

    public static <A> Show<V6<A>> v6Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V6.toStream_());
    }

    public static <A> Show<V7<A>> v7Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V7.toStream_());
    }

    public static <A> Show<V8<A>> v8Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V8.toStream_());
    }

    public static <E, L extends HList<L>> Show<HList.HCons<E, L>> hListShow(final Show<E> e, final Show<L> l) {
        return Show.show(new F<HList.HCons<E, L>, List<Character>>(){

            @Override
            public List<Character> f(HList.HCons<E, L> c) {
                return e.show(c.head()).cons(Character.valueOf('[')).append(l.show(c.tail())).snoc(Character.valueOf(']'));
            }
        });
    }
}

