/*
 * Decompiled with CFR 0.152.
 */
package fj.pre;

import fj.F;
import fj.Function;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.Validation;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Hash<A> {
    private final F<A, Integer> f;
    public static final Hash<Boolean> booleanHash = Hash.anyHash();
    public static final Hash<Byte> byteHash = Hash.anyHash();
    public static final Hash<Character> charHash = Hash.anyHash();
    public static final Hash<Double> doubleHash = Hash.anyHash();
    public static final Hash<Float> floatHash = Hash.anyHash();
    public static final Hash<Integer> intHash = Hash.anyHash();
    public static final Hash<Long> longHash = Hash.anyHash();
    public static final Hash<Short> shortHash = Hash.anyHash();
    public static final Hash<String> stringHash = Hash.anyHash();
    public static final Hash<StringBuffer> stringBufferHash = new Hash<StringBuffer>(new F<StringBuffer, Integer>(){

        @Override
        public Integer f(StringBuffer sb) {
            int p = 419;
            int r = 239;
            for (int i = 0; i < sb.length(); ++i) {
                r = 419 * r + sb.charAt(i);
            }
            return r;
        }
    });
    public static final Hash<StringBuilder> stringBuilderHash = new Hash<StringBuilder>(new F<StringBuilder, Integer>(){

        @Override
        public Integer f(StringBuilder sb) {
            int p = 419;
            int r = 239;
            for (int i = 0; i < sb.length(); ++i) {
                r = 419 * r + sb.charAt(i);
            }
            return r;
        }
    });

    private Hash(F<A, Integer> f2) {
        this.f = f2;
    }

    public int hash(A a) {
        return this.f.f(a);
    }

    public <B> Hash<B> comap(F<B, A> g2) {
        return new Hash<B>(Function.compose(this.f, g2));
    }

    public static <A> Hash<A> hash(F<A, Integer> f2) {
        return new Hash<A>(f2);
    }

    public static <A> Hash<A> anyHash() {
        return new Hash<A>(new F<A, Integer>(){

            @Override
            public Integer f(A a) {
                return a.hashCode();
            }
        });
    }

    public static <A, B> Hash<Either<A, B>> eitherHash(final Hash<A> ha, final Hash<B> hb) {
        return new Hash<Either<A, B>>(new F<Either<A, B>, Integer>(){

            @Override
            public Integer f(Either<A, B> e) {
                return e.isLeft() ? ha.hash(e.left().value()) : hb.hash(e.right().value());
            }
        });
    }

    public static <A, B> Hash<Validation<A, B>> validationHash(Hash<A> ha, Hash<B> hb) {
        return Hash.eitherHash(ha, hb).comap(Validation.either());
    }

    public static <A> Hash<List<A>> listHash(final Hash<A> ha) {
        return new Hash<List<A>>(new F<List<A>, Integer>(){

            @Override
            public Integer f(List<A> as) {
                int p = 419;
                int r = 239;
                List aas = as;
                while (!aas.isEmpty()) {
                    r = 419 * r + ha.hash(aas.head());
                    aas = aas.tail();
                }
                return r;
            }
        });
    }

    public static <A> Hash<NonEmptyList<A>> nonEmptyListHash(Hash<A> ha) {
        return Hash.listHash(ha).comap(NonEmptyList.toList_());
    }

    public static <A> Hash<Option<A>> optionHash(final Hash<A> ha) {
        return new Hash<Option<A>>(new F<Option<A>, Integer>(){

            @Override
            public Integer f(Option<A> o) {
                return o.isNone() ? 0 : ha.hash(o.some());
            }
        });
    }

    public static <A> Hash<Stream<A>> streamHash(final Hash<A> ha) {
        return new Hash<Stream<A>>(new F<Stream<A>, Integer>(){

            @Override
            public Integer f(Stream<A> as) {
                int p = 419;
                int r = 239;
                Stream aas = as;
                while (!aas.isEmpty()) {
                    r = 419 * r + ha.hash(aas.head());
                    aas = aas.tail()._1();
                }
                return r;
            }
        });
    }

    public static <A> Hash<Array<A>> arrayHash(final Hash<A> ha) {
        return new Hash<Array<A>>(new F<Array<A>, Integer>(){

            @Override
            public Integer f(Array<A> as) {
                int p = 419;
                int r = 239;
                for (int i = 0; i < as.length(); ++i) {
                    r = 419 * r + ha.hash(as.get(i));
                }
                return r;
            }
        });
    }

    public static <A> Hash<Tree<A>> treeHash(Hash<A> ha) {
        return Hash.listHash(ha).comap(Tree.flatten_());
    }

    public static <A> Hash<P1<A>> p1Hash(Hash<A> ha) {
        return ha.comap(P1.__1());
    }

    public static <A, B> Hash<P2<A, B>> p2Hash(final Hash<A> ha, final Hash<B> hb) {
        return new Hash<P2<A, B>>(new F<P2<A, B>, Integer>(){

            @Override
            public Integer f(P2<A, B> p2) {
                int p = 419;
                int r = 239;
                r = 419 * r + ha.hash(p2._1());
                r = 419 * r + hb.hash(p2._2());
                return r;
            }
        });
    }

    public static <A, B, C> Hash<P3<A, B, C>> p3Hash(final Hash<A> ha, final Hash<B> hb, final Hash<C> hc) {
        return new Hash<P3<A, B, C>>(new F<P3<A, B, C>, Integer>(){

            @Override
            public Integer f(P3<A, B, C> p3) {
                int p = 419;
                int r = 239;
                r = 419 * r + ha.hash(p3._1());
                r = 419 * r + hb.hash(p3._2());
                r = 419 * r + hc.hash(p3._3());
                return r;
            }
        });
    }

    public static <A, B, C, D> Hash<P4<A, B, C, D>> p4Hash(final Hash<A> ha, final Hash<B> hb, final Hash<C> hc, final Hash<D> hd) {
        return new Hash<P4<A, B, C, D>>(new F<P4<A, B, C, D>, Integer>(){

            @Override
            public Integer f(P4<A, B, C, D> p4) {
                int p = 419;
                int r = 239;
                r = 419 * r + ha.hash(p4._1());
                r = 419 * r + hb.hash(p4._2());
                r = 419 * r + hc.hash(p4._3());
                r = 419 * r + hd.hash(p4._4());
                return r;
            }
        });
    }

    public static <A, B, C, D, E> Hash<P5<A, B, C, D, E>> p5Hash(final Hash<A> ha, final Hash<B> hb, final Hash<C> hc, final Hash<D> hd, final Hash<E> he) {
        return new Hash<P5<A, B, C, D, E>>(new F<P5<A, B, C, D, E>, Integer>(){

            @Override
            public Integer f(P5<A, B, C, D, E> p5) {
                int p = 419;
                int r = 239;
                r = 419 * r + ha.hash(p5._1());
                r = 419 * r + hb.hash(p5._2());
                r = 419 * r + hc.hash(p5._3());
                r = 419 * r + hd.hash(p5._4());
                r = 419 * r + he.hash(p5._5());
                return r;
            }
        });
    }

    public static <A, B, C, D, E, F$> Hash<P6<A, B, C, D, E, F$>> p6Hash(final Hash<A> ha, final Hash<B> hb, final Hash<C> hc, final Hash<D> hd, final Hash<E> he, final Hash<F$> hf) {
        return new Hash<P6<A, B, C, D, E, F$>>(new F<P6<A, B, C, D, E, F$>, Integer>(){

            @Override
            public Integer f(P6<A, B, C, D, E, F$> p6) {
                int p = 419;
                int r = 239;
                r = 419 * r + ha.hash(p6._1());
                r = 419 * r + hb.hash(p6._2());
                r = 419 * r + hc.hash(p6._3());
                r = 419 * r + hd.hash(p6._4());
                r = 419 * r + he.hash(p6._5());
                r = 419 * r + hf.hash(p6._6());
                return r;
            }
        });
    }

    public static <A, B, C, D, E, F$, G> Hash<P7<A, B, C, D, E, F$, G>> p7Hash(final Hash<A> ha, final Hash<B> hb, final Hash<C> hc, final Hash<D> hd, final Hash<E> he, final Hash<F$> hf, final Hash<G> hg) {
        return new Hash<P7<A, B, C, D, E, F$, G>>(new F<P7<A, B, C, D, E, F$, G>, Integer>(){

            @Override
            public Integer f(P7<A, B, C, D, E, F$, G> p7) {
                int p = 419;
                int r = 239;
                r = 419 * r + ha.hash(p7._1());
                r = 419 * r + hb.hash(p7._2());
                r = 419 * r + hc.hash(p7._3());
                r = 419 * r + hd.hash(p7._4());
                r = 419 * r + he.hash(p7._5());
                r = 419 * r + hf.hash(p7._6());
                r = 419 * r + hg.hash(p7._7());
                return r;
            }
        });
    }

    public static <A, B, C, D, E, F$, G, H> Hash<P8<A, B, C, D, E, F$, G, H>> p8Hash(final Hash<A> ha, final Hash<B> hb, final Hash<C> hc, final Hash<D> hd, final Hash<E> he, final Hash<F$> hf, final Hash<G> hg, final Hash<H> hh) {
        return new Hash<P8<A, B, C, D, E, F$, G, H>>(new F<P8<A, B, C, D, E, F$, G, H>, Integer>(){

            @Override
            public Integer f(P8<A, B, C, D, E, F$, G, H> p8) {
                int p = 419;
                int r = 239;
                r = 419 * r + ha.hash(p8._1());
                r = 419 * r + hb.hash(p8._2());
                r = 419 * r + hc.hash(p8._3());
                r = 419 * r + hd.hash(p8._4());
                r = 419 * r + he.hash(p8._5());
                r = 419 * r + hf.hash(p8._6());
                r = 419 * r + hg.hash(p8._7());
                r = 419 * r + hh.hash(p8._8());
                return r;
            }
        });
    }

    public static <A> Hash<V2<A>> v2Hash(Hash<A> ea) {
        return Hash.streamHash(ea).comap(V2.toStream_());
    }

    public static <A> Hash<V3<A>> v3Hash(Hash<A> ea) {
        return Hash.streamHash(ea).comap(V3.toStream_());
    }

    public static <A> Hash<V4<A>> v4Hash(Hash<A> ea) {
        return Hash.streamHash(ea).comap(V4.toStream_());
    }

    public static <A> Hash<V5<A>> v5Hash(Hash<A> ea) {
        return Hash.streamHash(ea).comap(V5.toStream_());
    }

    public static <A> Hash<V6<A>> v6Hash(Hash<A> ea) {
        return Hash.streamHash(ea).comap(V6.toStream_());
    }

    public static <A> Hash<V7<A>> v7Hash(Hash<A> ea) {
        return Hash.streamHash(ea).comap(V7.toStream_());
    }

    public static <A> Hash<V8<A>> v8Hash(Hash<A> ea) {
        return Hash.streamHash(ea).comap(V8.toStream_());
    }
}

