/*
 * Decompiled with CFR 0.152.
 */
package fj.data.hlist;

import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.P;
import fj.P2;
import fj.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HList<A extends HList<A>> {
    private static final HNil nil = new HNil();

    protected HList() {
    }

    public abstract <E> HCons<E, A> extend(E var1);

    public abstract <E> Apply<Unit, P2<E, A>, HCons<E, A>> extender();

    public static HNil nil() {
        return nil;
    }

    public static <E, L extends HList<L>> HCons<E, L> cons(E e, L l) {
        return new HCons<E, L>(e, l);
    }

    public static <E> HCons<E, HNil> single(E e) {
        return HList.cons(e, HList.nil());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HNil
    extends HList<HNil> {
        HNil() {
        }

        @Override
        public <E> HCons<E, HNil> extend(E e) {
            return HNil.cons(e, this);
        }

        @Override
        public <E> Apply<Unit, P2<E, HNil>, HCons<E, HNil>> extender() {
            return Apply.cons();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HCons<E, L extends HList<L>>
    extends HList<HCons<E, L>> {
        private E e;
        private L l;

        HCons(E e, L l) {
            this.e = e;
            this.l = l;
        }

        public E head() {
            return this.e;
        }

        public L tail() {
            return this.l;
        }

        @Override
        public <X> Apply<Unit, P2<X, HCons<E, L>>, HCons<X, HCons<E, L>>> extender() {
            return Apply.cons();
        }

        @Override
        public <X> HCons<X, HCons<E, L>> extend(X e) {
            return HCons.cons(e, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HFoldr<G, V, L, R> {
        private final F3<G, V, L, R> foldRight;

        private HFoldr(F3<G, V, L, R> foldRight) {
            this.foldRight = foldRight;
        }

        public static <G, V> HFoldr<G, V, HNil, V> hFoldr() {
            return new HFoldr(new F3<G, V, HNil, V>(){

                @Override
                public V f(G f2, V v, HNil hNil) {
                    return v;
                }
            });
        }

        public static <E, G, V, L extends HList<L>, R, RR, H extends HFoldr<G, V, L, R>, PP extends Apply<G, P2<E, R>, RR>> HFoldr<G, V, HCons<E, L>, RR> hFoldr(final PP p, final H h) {
            return new HFoldr<G, V, L, R>(new F3<G, V, HCons<E, L>, RR>(){

                @Override
                public RR f(G f2, V v, HCons<E, L> c) {
                    return p.apply(f2, P.p(c.head(), h.foldRight(f2, v, c.tail())));
                }
            });
        }

        public R foldRight(G f2, V v, L l) {
            return this.foldRight.f(f2, v, l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Apply<F$, A, R> {
        public abstract R apply(F$ var1, A var2);

        public static <X, Y> Apply<F<X, Y>, X, Y> f() {
            return new Apply<F<X, Y>, X, Y>(){

                @Override
                public Y apply(F<X, Y> f2, X x) {
                    return f2.f(x);
                }
            };
        }

        public static <X> Apply<Unit, X, X> id() {
            return new Apply<Unit, X, X>(){

                @Override
                public X apply(Unit f2, X x) {
                    return x;
                }
            };
        }

        public static <X, Y, Z> Apply<Unit, P2<F<X, Y>, F<Y, Z>>, F<X, Z>> comp() {
            return new Apply<Unit, P2<F<X, Y>, F<Y, Z>>, F<X, Z>>(){

                @Override
                public F<X, Z> apply(Unit f2, P2<F<X, Y>, F<Y, Z>> fs) {
                    return Function.compose(fs._2(), fs._1());
                }
            };
        }

        public static <E, L extends HList<L>> Apply<Unit, P2<E, L>, HCons<E, L>> cons() {
            return new Apply<Unit, P2<E, L>, HCons<E, L>>(){

                @Override
                public HCons<E, L> apply(Unit f2, P2<E, L> p) {
                    return HList.cons(p._1(), (HList)p._2());
                }
            };
        }

        public static <A, B, C> Apply<HAppend<A, B, C>, P2<A, B>, C> append() {
            return new Apply<HAppend<A, B, C>, P2<A, B>, C>(){

                @Override
                public C apply(HAppend<A, B, C> f2, P2<A, B> p) {
                    return f2.append(p._1(), p._2());
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HAppend<A, B, C> {
        private final F2<A, B, C> append;

        private HAppend(F2<A, B, C> f2) {
            this.append = f2;
        }

        public C append(A a, B b) {
            return this.append.f(a, b);
        }

        public static <L extends HList<L>> HAppend<HNil, L, L> append() {
            return new HAppend(new F2<HNil, L, L>(){

                @Override
                public L f(HNil hNil, L l) {
                    return l;
                }
            });
        }

        public static <X, A extends HList<A>, B, C extends HList<C>, H extends HAppend<A, B, C>> HAppend<HCons<X, A>, B, HCons<X, C>> append(final H h) {
            return new HAppend<A, B, C>(new F2<HCons<X, A>, B, HCons<X, C>>(){

                @Override
                public HCons<X, C> f(HCons<X, A> c, B l) {
                    return HList.cons(c.head(), (HList)h.append(c.tail(), l));
                }
            });
        }
    }
}

