/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.F3;
import fj.F4;
import fj.F5;
import fj.F6;
import fj.F7;
import fj.F8;
import fj.Function;
import fj.P;
import fj.P1;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.pre.Semigroup;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validation<E, T>
implements Iterable<T> {
    private final Either<E, T> e;

    private Validation(Either<E, T> e) {
        this.e = e;
    }

    public boolean isFail() {
        return this.e.isLeft();
    }

    public boolean isSuccess() {
        return this.e.isRight();
    }

    public E fail() {
        if (this.isFail()) {
            return this.e.left().value();
        }
        throw Bottom.error("Validation: fail on success value");
    }

    public T success() {
        if (this.isSuccess()) {
            return this.e.right().value();
        }
        throw Bottom.error("Validation: success on fail value");
    }

    public <X> X validation(F<E, X> fail2, F<T, X> success) {
        return this.e.either(fail2, success);
    }

    public FailProjection<E, T> f() {
        return new FailProjection(this);
    }

    public Either<E, T> toEither() {
        return this.e;
    }

    public T successE(P1<String> err) {
        return this.e.right().valueE(err);
    }

    public T successE(String err) {
        return this.e.right().valueE(P.p(err));
    }

    public T orSuccess(P1<T> t) {
        return this.e.right().orValue(t);
    }

    public T orSuccess(T t) {
        return this.e.right().orValue(P.p(t));
    }

    public T on(F<E, T> f2) {
        return this.e.right().on(f2);
    }

    public Unit foreach(F<T, Unit> f2) {
        return this.e.right().foreach(f2);
    }

    public void foreach(Effect<T> f2) {
        this.e.right().foreach(f2);
    }

    public <A> Validation<E, A> map(F<T, A> f2) {
        return this.isFail() ? Validation.fail(this.fail()) : Validation.success(f2.f(this.success()));
    }

    public <A> Validation<E, A> bind(F<T, Validation<E, A>> f2) {
        return this.isSuccess() ? f2.f(this.success()) : Validation.fail(this.fail());
    }

    public <A> Validation<E, A> sequence(Validation<E, A> v) {
        return this.bind(Function.constant(v));
    }

    public <A> Option<Validation<A, T>> filter(F<T, Boolean> f2) {
        return this.e.right().filter(f2).map(Validation.<E, T>validation());
    }

    public <A> Validation<E, A> apply(Validation<E, F<T, A>> v) {
        return v.bind(new F<F<T, A>, Validation<E, A>>(){

            @Override
            public Validation<E, A> f(F<T, A> f2) {
                return Validation.this.map(f2);
            }
        });
    }

    public boolean forall(F<T, Boolean> f2) {
        return this.e.right().forall(f2);
    }

    public boolean exists(F<T, Boolean> f2) {
        return this.e.right().exists(f2);
    }

    public List<T> toList() {
        return this.e.right().toList();
    }

    public Option<T> toOption() {
        return this.e.right().toOption();
    }

    public Array<T> toArray() {
        return this.e.right().toArray();
    }

    public Array<T> toArray(Class<T[]> c) {
        return this.e.right().toArray(c);
    }

    public Stream<T> toStream() {
        return this.e.right().toStream();
    }

    public <A> Validation<E, A> accumapply(Semigroup<E> s, Validation<E, F<T, A>> v) {
        return this.isFail() ? Validation.fail(v.isFail() ? s.sum(v.fail(), this.fail()) : this.fail()) : (v.isFail() ? Validation.fail(v.fail()) : Validation.success(v.success().f(this.success())));
    }

    public <A, B> Validation<E, B> accumulate(Semigroup<E> s, Validation<E, A> va, F<T, F<A, B>> f2) {
        return va.accumapply(s, this.map(f2));
    }

    public <A, B> Validation<E, B> accumulate(Semigroup<E> s, Validation<E, A> va, F2<T, A, B> f2) {
        return va.accumapply(s, this.map(Function.curry(f2)));
    }

    public <A> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va) {
        return this.accumulate(s, va, new F2<T, A, Unit>(){

            @Override
            public Unit f(T t, A a) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C> Validation<E, C> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, F<T, F<A, F<B, C>>> f2) {
        return vb.accumapply(s, this.accumulate(s, va, f2));
    }

    public <A, B, C> Validation<E, C> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, F3<T, A, B, C> f2) {
        return vb.accumapply(s, this.accumulate(s, va, Function.curry(f2)));
    }

    public <A, B> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb) {
        return this.accumulate(s, va, vb, new F3<T, A, B, Unit>(){

            @Override
            public Unit f(T t, A a, B b) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D> Validation<E, D> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, F<T, F<A, F<B, F<C, D>>>> f2) {
        return vc.accumapply(s, this.accumulate(s, va, vb, f2));
    }

    public <A, B, C, D> Validation<E, D> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, F4<T, A, B, C, D> f2) {
        return vc.accumapply(s, this.accumulate(s, va, vb, Function.curry(f2)));
    }

    public <A, B, C> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc) {
        return this.accumulate(s, va, vb, vc, new F4<T, A, B, C, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$> Validation<E, E$> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, F<T, F<A, F<B, F<C, F<D, E$>>>>> f2) {
        return vd.accumapply(s, this.accumulate(s, va, vb, vc, f2));
    }

    public <A, B, C, D, E$> Validation<E, E$> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, F5<T, A, B, C, D, E$> f2) {
        return vd.accumapply(s, this.accumulate(s, va, vb, vc, Function.curry(f2)));
    }

    public <A, B, C, D> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd) {
        return this.accumulate(s, va, vb, vc, vd, new F5<T, A, B, C, D, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$> Validation<E, F$> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, F<T, F<A, F<B, F<C, F<D, F<E$, F$>>>>>> f2) {
        return ve.accumapply(s, this.accumulate(s, va, vb, vc, vd, f2));
    }

    public <A, B, C, D, E$, F$> Validation<E, F$> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, F6<T, A, B, C, D, E$, F$> f2) {
        return ve.accumapply(s, this.accumulate(s, va, vb, vc, vd, Function.curry(f2)));
    }

    public <A, B, C, D, E$> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve) {
        return this.accumulate(s, va, vb, vc, vd, ve, new F6<T, A, B, C, D, E$, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ e) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$, G> Validation<E, G> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, F<T, F<A, F<B, F<C, F<D, F<E$, F<F$, G>>>>>>> f2) {
        return vf.accumapply(s, this.accumulate(s, va, vb, vc, vd, ve, f2));
    }

    public <A, B, C, D, E$, F$, G> Validation<E, G> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, F7<T, A, B, C, D, E$, F$, G> f2) {
        return vf.accumapply(s, this.accumulate(s, va, vb, vc, vd, ve, Function.curry(f2)));
    }

    public <A, B, C, D, E$, F$> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf) {
        return this.accumulate(s, va, vb, vc, vd, ve, vf, new F7<T, A, B, C, D, E$, F$, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ e, F$ f2) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$, G, H> Validation<E, H> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg, F<T, F<A, F<B, F<C, F<D, F<E$, F<F$, F<G, H>>>>>>>> f2) {
        return vg.accumapply(s, this.accumulate(s, va, vb, vc, vd, ve, vf, f2));
    }

    public <A, B, C, D, E$, F$, G, H> Validation<E, H> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg, F8<T, A, B, C, D, E$, F$, G, H> f2) {
        return vg.accumapply(s, this.accumulate(s, va, vb, vc, vd, ve, vf, Function.curry(f2)));
    }

    public <A, B, C, D, E$, F$, G> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg) {
        return this.accumulate(s, va, vb, vc, vd, ve, vf, vg, new F8<T, A, B, C, D, E$, F$, G, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ e, F$ f2, G g2) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toEither().right().iterator();
    }

    public Validation<NonEmptyList<E>, T> nel() {
        return this.isSuccess() ? Validation.success(this.success()) : Validation.fail(NonEmptyList.nel(this.fail()));
    }

    public static <E, T> Validation<E, T> validation(Either<E, T> e) {
        return new Validation<E, T>(e);
    }

    public static <E, T> F<Either<E, T>, Validation<E, T>> validation() {
        return new F<Either<E, T>, Validation<E, T>>(){

            @Override
            public Validation<E, T> f(Either<E, T> e) {
                return Validation.validation(e);
            }
        };
    }

    public static <E, T> F<Validation<E, T>, Either<E, T>> either() {
        return new F<Validation<E, T>, Either<E, T>>(){

            @Override
            public Either<E, T> f(Validation<E, T> v) {
                return v.toEither();
            }
        };
    }

    public static <E, T> Validation<E, T> success(T t) {
        return Validation.validation(Either.right(t));
    }

    public static <E, T> Validation<E, T> fail(E e) {
        return Validation.validation(Either.left(e));
    }

    public static <E, T> Validation<NonEmptyList<E>, T> failNEL(E e) {
        return Validation.fail(NonEmptyList.nel(e));
    }

    public static <E, T> Validation<E, T> condition(boolean c, E e, T t) {
        return c ? Validation.success(t) : Validation.fail(e);
    }

    public static Validation<NumberFormatException, Byte> parseByte(String s) {
        try {
            return Validation.success(Byte.parseByte(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Double> parseDouble(String s) {
        try {
            return Validation.success(Double.parseDouble(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Float> parseFloat(String s) {
        try {
            return Validation.success(Float.valueOf(Float.parseFloat(s)));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Integer> parseInt(String s) {
        try {
            return Validation.success(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Long> parseLong(String s) {
        try {
            return Validation.success(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Short> parseShort(String s) {
        try {
            return Validation.success(Short.parseShort(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class FailProjection<E, T>
    implements Iterable<E> {
        private final Validation<E, T> v;

        private FailProjection(Validation<E, T> v) {
            this.v = v;
        }

        public Validation<E, T> validation() {
            return this.v;
        }

        public E failE(P1<String> err) {
            return this.v.toEither().left().valueE(err);
        }

        public E failE(String err) {
            return this.failE(P.p(err));
        }

        public E orFail(P1<E> e) {
            return (E)this.v.toEither().left().orValue((E)e);
        }

        public E orFail(E e) {
            return (E)this.orFail((E)P.p(e));
        }

        public E on(F<T, E> f2) {
            return this.v.toEither().left().on(f2);
        }

        public Unit foreach(F<E, Unit> f2) {
            return this.v.toEither().left().foreach(f2);
        }

        public void foreach(Effect<E> f2) {
            this.v.toEither().left().foreach(f2);
        }

        public <A> Validation<A, T> map(F<E, A> f2) {
            return Validation.validation(this.v.toEither().left().map(f2));
        }

        public <A> Validation<A, T> bind(F<E, Validation<A, T>> f2) {
            return this.v.isFail() ? f2.f(this.v.fail()) : Validation.success(this.v.success());
        }

        public <A> Validation<A, T> sequence(final Validation<A, T> v) {
            return this.bind(new F<E, Validation<A, T>>(){

                @Override
                public Validation<A, T> f(E e) {
                    return v;
                }
            });
        }

        public <A> Option<Validation<E, A>> filter(F<E, Boolean> f2) {
            return this.v.toEither().left().filter(f2).map(Validation.validation());
        }

        public <A> Validation<A, T> apply(Validation<F<E, A>, T> v) {
            return v.f().bind(new F<F<E, A>, Validation<A, T>>(){

                @Override
                public Validation<A, T> f(F<E, A> f2) {
                    return FailProjection.this.map(f2);
                }
            });
        }

        public boolean forall(F<E, Boolean> f2) {
            return this.v.toEither().left().forall(f2);
        }

        public boolean exists(F<E, Boolean> f2) {
            return this.v.toEither().left().exists(f2);
        }

        public List<E> toList() {
            return this.v.toEither().left().toList();
        }

        public Option<E> toOption() {
            return this.v.toEither().left().toOption();
        }

        public Array<E> toArray() {
            return this.v.toEither().left().toArray();
        }

        public Array<E> toArray(Class<E[]> c) {
            return this.v.toEither().left().toArray(c);
        }

        public Stream<E> toStream() {
            return this.v.toEither().left().toStream();
        }

        @Override
        public Iterator<E> iterator() {
            return this.v.toEither().left().iterator();
        }
    }
}

