/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.F2;
import fj.Function;
import fj.P2;
import fj.data.List;
import fj.pre.Monoid;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tree<A>
implements Iterable<A> {
    private final A root;
    private final List<Tree<A>> subForest;

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    private Tree(A root, List<Tree<A>> subForest) {
        this.root = root;
        this.subForest = subForest;
    }

    public static <A> Tree<A> leaf(A root) {
        return Tree.node(root, List.nil());
    }

    public static <A> Tree<A> node(A root, List<Tree<A>> forest) {
        return new Tree<A>(root, forest);
    }

    public A root() {
        return this.root;
    }

    public List<Tree<A>> subForest() {
        return this.subForest;
    }

    public static <A> F<Tree<A>, A> root_() {
        return new F<Tree<A>, A>(){

            @Override
            public A f(Tree<A> a) {
                return a.root();
            }
        };
    }

    public static <A> F<Tree<A>, List<Tree<A>>> subForest_() {
        return new F<Tree<A>, List<Tree<A>>>(){

            @Override
            public List<Tree<A>> f(Tree<A> a) {
                return a.subForest();
            }
        };
    }

    public List<A> flatten() {
        F2 squish = new F2<Tree<A>, List<A>, List<A>>(){

            @Override
            public List<A> f(Tree<A> t, List<A> xs) {
                return List.cons(t.root(), t.subForest().foldRight(Function.curry(this), xs));
            }
        };
        return (List)squish.f(this, List.nil());
    }

    public static <A> F<Tree<A>, List<A>> flatten_() {
        return new F<Tree<A>, List<A>>(){

            @Override
            public List<A> f(Tree<A> t) {
                return t.flatten();
            }
        };
    }

    public List<List<A>> levels() {
        F flatSubForests = List.bind_().f(Tree.<Tree<A>>subForest_());
        F roots = List.map_().f(Tree.<Tree<A>>root_());
        return List.iterateWhile(flatSubForests, List.isNotEmpty_(), List.single(this)).map(roots);
    }

    public <B> Tree<B> fmap(F<A, B> f2) {
        return Tree.node(f2.f(this.root()), this.subForest().map(Tree.fmap_().f(f2)));
    }

    public static <A, B> F<F<A, B>, F<Tree<A>, Tree<B>>> fmap_() {
        return new F<F<A, B>, F<Tree<A>, Tree<B>>>(){

            @Override
            public F<Tree<A>, Tree<B>> f(final F<A, B> f2) {
                return new F<Tree<A>, Tree<B>>(){

                    @Override
                    public Tree<B> f(Tree<A> a) {
                        return a.fmap(f2);
                    }
                };
            }
        };
    }

    public <B> B foldMap(F<A, B> f2, Monoid<B> m) {
        return m.sum(f2.f(this.root()), m.sumRight(this.subForest().map(Tree.foldMap_(f2, m))));
    }

    public Collection<A> toCollection() {
        return this.flatten().toCollection();
    }

    public static <A, B> F<Tree<A>, B> foldMap_(final F<A, B> f2, final Monoid<B> m) {
        return new F<Tree<A>, B>(){

            @Override
            public B f(Tree<A> t) {
                return t.foldMap(f2, m);
            }
        };
    }

    public static <A, B> F<B, Tree<A>> unfoldTree(final F<B, P2<A, List<B>>> f2) {
        return new F<B, Tree<A>>(){

            @Override
            public Tree<A> f(B b) {
                P2 p = (P2)f2.f(b);
                return Tree.node(p._1(), List.map_().f(Tree.unfoldTree(f2)).f(p._2()));
            }
        };
    }
}

