/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.Enumerator;
import fj.data.List;
import fj.data.Option;
import fj.pre.Ordering;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stream<A>
implements Iterable<A> {
    private Stream() {
    }

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract P1<Stream<A>> tail();

    public boolean isEmpty() {
        return this instanceof Nil;
    }

    public boolean isNotEmpty() {
        return this instanceof Cons;
    }

    public <B> B stream(B nil, F<A, F<P1<Stream<A>>, B>> cons) {
        return this.isEmpty() ? nil : cons.f(this.head()).f(this.tail());
    }

    public <B> B foldRight(final F<A, F<P1<B>, B>> f2, final B b) {
        return this.isEmpty() ? b : f2.f(this.head()).f(new P1<B>(){

            @Override
            public B _1() {
                return Stream.this.tail()._1().foldRight(f2, b);
            }
        });
    }

    public <B> B foldRight(F2<A, P1<B>, B> f2, B b) {
        return this.foldRight(Function.curry(f2), b);
    }

    public <B> B foldRight1(F<A, F<B, B>> f2, B b) {
        return (B)this.foldRight(Function.compose(Function.andThen().f(P1.__1()), f2), b);
    }

    public <B> B foldRight1(F2<A, B, B> f2, B b) {
        return this.foldRight1(Function.curry(f2), b);
    }

    public <B> B foldLeft(F<B, F<A, B>> f2, B b) {
        B x = b;
        Stream<A> xs = this;
        while (!xs.isEmpty()) {
            x = f2.f(x).f(xs.head());
            xs = xs.tail()._1();
        }
        return x;
    }

    public <B> B foldLeft(F2<B, A, B> f2, B b) {
        return this.foldLeft(Function.curry(f2), b);
    }

    public A orHead(P1<A> a) {
        return this.isEmpty() ? a._1() : this.head();
    }

    public P1<Stream<A>> orTail(P1<Stream<A>> as) {
        return this.isEmpty() ? as : this.tail();
    }

    public <B> Stream<B> map(final F<A, B> f2) {
        return this.foldRight(new F<A, F<P1<Stream<B>>, Stream<B>>>(){

            @Override
            public F<P1<Stream<B>>, Stream<B>> f(final A a) {
                return new F<P1<Stream<B>>, Stream<B>>(){

                    @Override
                    public Stream<B> f(P1<Stream<B>> bs) {
                        return Stream.cons(f2.f(a), bs);
                    }
                };
            }
        }, Stream.<A>nil());
    }

    public static <A, B> F<F<A, B>, F<Stream<A>, Stream<B>>> map_() {
        return new F<F<A, B>, F<Stream<A>, Stream<B>>>(){

            @Override
            public F<Stream<A>, Stream<B>> f(final F<A, B> f2) {
                return new F<Stream<A>, Stream<B>>(){

                    @Override
                    public Stream<B> f(Stream<A> as) {
                        return as.map(f2);
                    }
                };
            }
        };
    }

    public Unit foreach(F<A, Unit> f2) {
        Stream<A> xs = this;
        while (xs.isNotEmpty()) {
            f2.f(xs.head());
            xs = xs.tail()._1();
        }
        return Unit.unit();
    }

    public void foreach(Effect<A> f2) {
        Stream<A> xs = this;
        while (xs.isNotEmpty()) {
            f2.e(xs.head());
            xs = xs.tail()._1();
        }
    }

    public Stream<A> filter(final F<A, Boolean> f2) {
        return this.foldRight(new F<A, F<P1<Stream<A>>, Stream<A>>>(){

            @Override
            public F<P1<Stream<A>>, Stream<A>> f(final A a) {
                return new F<P1<Stream<A>>, Stream<A>>(){

                    @Override
                    public Stream<A> f(P1<Stream<A>> as) {
                        return (Boolean)f2.f(a) != false ? Stream.cons(a, as) : as._1();
                    }
                };
            }
        }, Stream.<A>nil());
    }

    public Stream<A> append(Stream<A> as) {
        return this.append(P.p(as));
    }

    public Stream<A> append(final P1<Stream<A>> as) {
        return this.isEmpty() ? as._1() : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().append(as);
            }
        });
    }

    public <B> Stream<B> bind(final F<A, Stream<B>> f2) {
        return this.foldRight(new F<A, F<P1<Stream<B>>, Stream<B>>>(){

            @Override
            public F<P1<Stream<B>>, Stream<B>> f(final A a) {
                return new F<P1<Stream<B>>, Stream<B>>(){

                    @Override
                    public Stream<B> f(P1<Stream<B>> bs) {
                        return ((Stream)f2.f(a)).append(bs._1());
                    }
                };
            }
        }, Stream.<A>nil());
    }

    public <B, C> Stream<C> bind(Stream<B> sb, F<A, F<B, C>> f2) {
        return sb.apply(this.map(f2));
    }

    public <B, C, D> Stream<D> bind(Stream<B> sb, Stream<C> sc, F<A, F<B, F<C, D>>> f2) {
        return sc.apply(this.bind(sb, f2));
    }

    public <B, C, D, E> Stream<E> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, F<A, F<B, F<C, F<D, E>>>> f2) {
        return sd.apply(this.bind(sb, sc, f2));
    }

    public <B, C, D, E, F$> Stream<F$> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, F<A, F<B, F<C, F<D, F<E, F$>>>>> f2) {
        return se.apply(this.bind(sb, sc, sd, f2));
    }

    public <B, C, D, E, F$, G> Stream<G> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f2) {
        return sf.apply(this.bind(sb, sc, sd, se, f2));
    }

    public <B, C, D, E, F$, G, H> Stream<H> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, Stream<G> sg, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f2) {
        return sg.apply(this.bind(sb, sc, sd, se, sf, f2));
    }

    public <B, C, D, E, F$, G, H, I> Stream<I> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, Stream<G> sg, Stream<H> sh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f2) {
        return sh.apply(this.bind(sb, sc, sd, se, sf, sg, f2));
    }

    public <B> Stream<B> sequence(Stream<B> bs) {
        F c = Function.constant(bs);
        return this.bind(c);
    }

    public <B> Stream<B> apply(Stream<F<A, B>> sf) {
        return sf.bind(new F<F<A, B>, Stream<B>>(){

            @Override
            public Stream<B> f(final F<A, B> f2) {
                return Stream.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f2.f(a);
                    }
                });
            }
        });
    }

    public Stream<A> interleave(final Stream<A> as) {
        if (this.isEmpty()) {
            return as;
        }
        if (as.isEmpty()) {
            return this;
        }
        return Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.cons(as.head(), new P1<Stream<A>>(){

                    @Override
                    public Stream<A> _1() {
                        return as.tail()._1().interleave(as.tail()._1());
                    }
                });
            }
        });
    }

    public Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private Stream<A> xs;
                    {
                        this.xs = Stream.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail()._1();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Stream.this.length();
            }
        };
    }

    public static Stream<Integer> range(final int from, final int to) {
        return from >= to ? Stream.nil() : Stream.cons(from, new P1<Stream<Integer>>(){

            @Override
            public Stream<Integer> _1() {
                return Stream.range(from + 1, to);
            }
        });
    }

    public static <A> Stream<A> forever(Enumerator<A> e, A from) {
        return Stream.forever(e, from, 1L);
    }

    public static <A> Stream<A> forever(final Enumerator<A> e, final A from, final long step) {
        return Stream.cons(from, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.join(e.plus(from, step).map(new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.forever(e, a, step);
                    }
                }).toStream());
            }
        });
    }

    public static <A> Stream<A> range(Enumerator<A> e, A from, A to) {
        return Stream.range(e, from, to, 1L);
    }

    public static <A> Stream<A> range(final Enumerator<A> e, final A from, final A to, final long step) {
        final Ordering o = e.order().compare(from, to);
        if (o == Ordering.EQ || step > 0L && o == Ordering.GT || step < 0L && o == Ordering.LT) {
            return Stream.single(from);
        }
        return Stream.cons(from, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.join(e.plus(from, step).filter(new F<A, Boolean>(){

                    @Override
                    public Boolean f(A a) {
                        return !(o != Ordering.LT ? e.order().isGreaterThan(to, a) : e.order().isLessThan(to, a));
                    }
                }).map(new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.range(e, a, to, step);
                    }
                }).toStream());
            }
        });
    }

    public static Stream<Integer> range(final int from) {
        return Stream.cons(from, new P1<Stream<Integer>>(){

            @Override
            public Stream<Integer> _1() {
                return Stream.range(from + 1);
            }
        });
    }

    public <B> Stream<B> zapp(final Stream<F<A, B>> fs) {
        return fs.isEmpty() || this.isEmpty() ? Stream.nil() : Stream.cons(fs.head().f(this.head()), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Stream.this.tail()._1().zapp(fs.tail()._1());
            }
        });
    }

    public <B, C> Stream<C> zipWith(Stream<B> bs, F<A, F<B, C>> f2) {
        return bs.zapp(this.zapp(Stream.repeat(f2)));
    }

    public <B> Stream<P2<A, B>> zip(Stream<B> bs) {
        F __2 = P.p2();
        return this.zipWith(bs, __2);
    }

    public Stream<P2<A, Integer>> zipIndex() {
        return this.zipWith(Stream.range(0, this.length()), new F<A, F<Integer, P2<A, Integer>>>(){

            @Override
            public F<Integer, P2<A, Integer>> f(final A a) {
                return new F<Integer, P2<A, Integer>>(){

                    @Override
                    public P2<A, Integer> f(Integer i) {
                        return P.p(a, i);
                    }
                };
            }
        });
    }

    public <X> Either<X, A> toEither(P1<X> x) {
        return this.isEmpty() ? Either.left(x._1()) : Either.right(this.head());
    }

    public Option<A> toOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public List<A> toList() {
        List<A> as = List.nil();
        Stream<A> x = this;
        while (!x.isEmpty()) {
            as = as.snoc(x.head());
            x = x.tail()._1();
        }
        return as;
    }

    public Array<A> toArray() {
        ArrayList<A> a = new ArrayList<A>();
        Stream<A> x = this;
        while (x.isNotEmpty()) {
            a.add(x.head());
            x = x.tail()._1();
        }
        return Array.array(a.toArray(new Object[a.size()]));
    }

    public Array<A> toArray(Class<A[]> c) {
        Object[] a = (Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), this.length());
        int i = 0;
        for (A x : this) {
            a[i] = x;
            ++i;
        }
        return Array.array(a);
    }

    public Stream<A> cons(A a) {
        return new Cons<A>(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this;
            }
        });
    }

    public Stream<A> snoc(final P1<A> a) {
        return this.append(new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.single(a._1());
            }
        });
    }

    public Stream<A> take(final int n) {
        return n <= 0 || this.isEmpty() ? Stream.nil() : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().take(n - 1);
            }
        });
    }

    public Stream<A> drop(int i) {
        Stream<A> xs = this;
        for (int c = 0; xs.isNotEmpty() && c < i; ++c) {
            xs = xs.tail()._1();
        }
        return xs;
    }

    public Stream<A> takeWhile(final F<A, Boolean> f2) {
        return this.isEmpty() ? this : (f2.f(this.head()) != false ? Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().takeWhile(f2);
            }
        }) : Stream.nil());
    }

    public Stream<A> dropWhile(F<A, Boolean> f2) {
        Stream<A> as = this;
        while (!as.isEmpty() && f2.f(as.head()).booleanValue()) {
            as = as.tail()._1();
        }
        return as;
    }

    public Stream<A> reverse() {
        return this.foldLeft(new F<Stream<A>, F<A, Stream<A>>>(){

            @Override
            public F<A, Stream<A>> f(final Stream<A> as) {
                return new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.cons(a, new P1<Stream<A>>(){

                            @Override
                            public Stream<A> _1() {
                                return as;
                            }
                        });
                    }
                };
            }
        }, Stream.<A>nil());
    }

    public int length() {
        return this.foldLeft(new F<Integer, F<A, Integer>>(){

            @Override
            public F<A, Integer> f(final Integer i) {
                return new F<A, Integer>(){

                    @Override
                    public Integer f(A a) {
                        return i + 1;
                    }
                };
            }
        }, Integer.valueOf(0));
    }

    public A index(int i) {
        if (i < 0) {
            throw Bottom.error("index " + i + " out of range on stream");
        }
        Stream<A> xs = this;
        for (int c = 0; c < i; ++c) {
            if (xs.isEmpty()) {
                throw Bottom.error("index " + i + " out of range on stream");
            }
            xs = xs.tail()._1();
        }
        if (xs.isEmpty()) {
            throw Bottom.error("index " + i + " out of range on stream");
        }
        return xs.head();
    }

    public boolean forall(F<A, Boolean> f2) {
        return this.isEmpty() || f2.f(this.head()) != false && this.tail()._1().forall(f2);
    }

    public boolean exists(F<A, Boolean> f2) {
        return this.isNotEmpty() && (f2.f(this.head()) != false || this.tail()._1().exists(f2));
    }

    public Option<A> find(F<A, Boolean> f2) {
        Stream<A> as = this;
        while (as.isNotEmpty()) {
            if (f2.f(as.head()).booleanValue()) {
                return Option.some(as.head());
            }
            as = as.tail()._1();
        }
        return Option.none();
    }

    public static <A, B> P2<Stream<A>, Stream<B>> unzip(Stream<P2<A, B>> xs) {
        return xs.foldRight(new F2<P2<A, B>, P1<P2<Stream<A>, Stream<B>>>, P2<Stream<A>, Stream<B>>>(){

            @Override
            public P2<Stream<A>, Stream<B>> f(P2<A, B> p, P1<P2<Stream<A>, Stream<B>>> ps) {
                P2 pp = ps._1();
                return P.p(Stream.cons(p._1(), P.p(pp._1())), Stream.cons(p._2(), P.p(pp._2())));
            }
        }, P.p(Stream.<A>nil(), Stream.<A>nil()));
    }

    public static <A> F<A, F<P1<Stream<A>>, Stream<A>>> cons() {
        return new F<A, F<P1<Stream<A>>, Stream<A>>>(){

            @Override
            public F<P1<Stream<A>>, Stream<A>> f(final A a) {
                return new F<P1<Stream<A>>, Stream<A>>(){

                    @Override
                    public Stream<A> f(P1<Stream<A>> list) {
                        return Stream.cons(a, list);
                    }
                };
            }
        };
    }

    public static <A> F<A, F<Stream<A>, Stream<A>>> cons_() {
        return Function.curry(new F2<A, Stream<A>, Stream<A>>(){

            @Override
            public Stream<A> f(A a, Stream<A> as) {
                return as.cons(a);
            }
        });
    }

    public static <A> Stream<A> nil() {
        return new Nil();
    }

    public static <A> P1<Stream<A>> nil_() {
        return new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return new Nil();
            }
        };
    }

    public static <A> F<Stream<A>, Boolean> isEmpty_() {
        return new F<Stream<A>, Boolean>(){

            @Override
            public Boolean f(Stream<A> as) {
                return as.isEmpty();
            }
        };
    }

    public static <A> F<Stream<A>, Boolean> isNotEmpty_() {
        return new F<Stream<A>, Boolean>(){

            @Override
            public Boolean f(Stream<A> as) {
                return as.isNotEmpty();
            }
        };
    }

    public static <A> Stream<A> single(A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.nil();
            }
        });
    }

    public static <A> F<A, Stream<A>> single() {
        return new F<A, Stream<A>>(){

            @Override
            public Stream<A> f(A a) {
                return Stream.single(a);
            }
        };
    }

    public static <A> Stream<A> cons(A head, P1<Stream<A>> tail) {
        return new Cons<A>(head, tail);
    }

    public static <A> Stream<A> join(Stream<Stream<A>> o) {
        F id2 = Function.identity();
        return o.bind(id2);
    }

    public static <A> F<Stream<Stream<A>>, Stream<A>> join() {
        return new F<Stream<Stream<A>>, Stream<A>>(){

            @Override
            public Stream<A> f(Stream<Stream<A>> as) {
                return Stream.join(as);
            }
        };
    }

    public static <A, B> Stream<A> unfold(final F<B, Option<P2<A, B>>> f2, B b) {
        Option<P2<A, B>> o = f2.f(b);
        if (o.isNone()) {
            return Stream.nil();
        }
        final P2<A, B> p = o.some();
        return Stream.cons(p._1(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.unfold(f2, p._2());
            }
        });
    }

    public static <A> Stream<A> iterableStream(Iterable<A> i) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Util {
            Util() {
            }

            public <A> Stream<A> iteratorStream(final Iterator<A> i) {
                if (i.hasNext()) {
                    A a = i.next();
                    return Stream.cons(a, new P1<Stream<A>>(){

                        @Override
                        public Stream<A> _1() {
                            return this.iteratorStream(i);
                        }
                    });
                }
                return Stream.nil();
            }
        }
        return new Util().iteratorStream(i.iterator());
    }

    public static <A> Stream<A> repeat(final A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.repeat(a);
            }
        });
    }

    public static <A> Stream<A> iterate(final F<A, A> f2, final A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.iterate(f2, f2.f(a));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Cons<A>
    extends Stream<A> {
        private final A head;
        private final P1<Stream<A>> tail;

        Cons(A head, P1<Stream<A>> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public P1<Stream<A>> tail() {
            return this.tail;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Nil<A>
    extends Stream<A> {
        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty stream");
        }

        @Override
        public P1<Stream<A>> tail() {
            throw Bottom.error("tail on empty stream");
        }
    }
}

