/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P3;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Booleans;
import fj.pre.Monoid;
import fj.pre.Ord;
import fj.pre.Ordering;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Set<A>
implements Iterable<A> {
    private final Ord<A> ord;

    private Set(Ord<A> ord2) {
        this.ord = ord2;
    }

    public boolean isEmpty() {
        return this instanceof Empty;
    }

    abstract Color color();

    abstract Set<A> l();

    abstract A head();

    abstract Set<A> r();

    public static <A> Set<A> empty(Ord<A> ord2) {
        return new Empty(ord2);
    }

    public boolean member(A x) {
        return !this.isEmpty() && (this.ord.isLessThan(x, this.head()) && this.l().member(x) || this.ord.eq(this.head(), x) || this.r().member(x));
    }

    public F<Set<A>, F<A, Boolean>> member() {
        return Function.curry(new F2<Set<A>, A, Boolean>(){

            @Override
            public Boolean f(Set<A> s, A a) {
                return s.member(a);
            }
        });
    }

    public Set<A> insert(A x) {
        return super.makeBlack();
    }

    private Set<A> ins(A x) {
        return this.isEmpty() ? new Tree(this.ord, Color.R, Set.empty(this.ord), x, Set.empty(this.ord)) : (this.ord.isLessThan(x, this.head()) ? Set.balance(this.ord, this.color(), super.ins(x), this.head(), this.r()) : (this.ord.eq(x, this.head()) ? this : Set.balance(this.ord, this.color(), this.l(), this.head(), super.ins(x))));
    }

    private Set<A> makeBlack() {
        return new Tree(this.ord, Color.B, this.l(), this.head(), this.r());
    }

    private static <A> Tree<A> tr(Ord<A> o, Set<A> a, A x, Set<A> b, A y, Set<A> c, A z, Set<A> d) {
        return new Tree(o, Color.R, new Tree(o, Color.B, a, x, b), y, new Tree(o, Color.B, c, z, d));
    }

    private static <A> Set<A> balance(Ord<A> ord2, Color c, Set<A> l, A h, Set<A> r) {
        if (c == Color.B && super.isTR() && super.isTR()) {
            return Set.tr(ord2, l.l().l(), l.l().head(), l.l().r(), l.head(), l.r(), h, r);
        }
        if (c == Color.B && super.isTR() && super.isTR()) {
            return Set.tr(ord2, l.l(), l.head(), l.r().l(), l.r().head(), l.r().r(), h, r);
        }
        if (c == Color.B && super.isTR() && super.isTR()) {
            return Set.tr(ord2, l, h, r.l().l(), r.l().head(), r.l().r(), r.head(), r.r());
        }
        if (c == Color.B && super.isTR() && super.isTR()) {
            return Set.tr(ord2, l, h, r.l(), r.head(), r.r().l(), r.r().head(), r.r().r());
        }
        return new Tree(ord2, c, l, h, r);
    }

    private boolean isTR() {
        return !this.isEmpty() && this.color() == Color.R;
    }

    @Override
    public Iterator<A> iterator() {
        return this.toStream().iterator();
    }

    public static <A> Set<A> single(Ord<A> o, A a) {
        return Set.empty(o).insert(a);
    }

    public <B> Set<B> map(Ord<B> o, F<A, B> f2) {
        return Set.iterableSet(o, this.toStream().map(f2));
    }

    public <B> B foldMap(F<A, B> f2, Monoid<B> m) {
        return this.isEmpty() ? m.zero() : m.sum(m.sum(this.r().foldMap(f2, m), f2.f(this.head())), this.l().foldMap(f2, m));
    }

    public List<A> toList() {
        return this.foldMap(List.cons(List.nil()), Monoid.listMonoid());
    }

    public Stream<A> toStream() {
        return this.foldMap(Stream.single(), Monoid.streamMonoid());
    }

    public <B> Set<B> bind(Ord<B> o, F<A, Set<B>> f2) {
        return Set.join(o, this.map(Ord.setOrd(o), f2));
    }

    public Set<A> union(Set<A> s) {
        return Set.iterableSet(this.ord, s.toStream().append(this.toStream()));
    }

    public Set<A> filter(F<A, Boolean> f2) {
        return Set.iterableSet(this.ord, this.toStream().filter(f2));
    }

    public Set<A> delete(A a) {
        return this.minus(Set.single(this.ord, a));
    }

    public Set<A> intersect(Set<A> s) {
        return this.filter(this.member().f(s));
    }

    public Set<A> minus(Set<A> s) {
        return this.filter(Function.compose(Booleans.not, this.member().f(s)));
    }

    public int size() {
        F one = Function.constant(1);
        return this.foldMap(one, Monoid.intAdditionMonoid);
    }

    public P3<Set<A>, Option<A>, Set<A>> split(A a) {
        if (this.isEmpty()) {
            return P.p(Set.empty(this.ord), Option.none(), Set.empty(this.ord));
        }
        Ordering i = this.ord.compare(a, this.head());
        if (i == Ordering.LT) {
            P3<Set<A>, Option<A>, Set<A>> lg = this.l().split(a);
            return P.p(lg._1(), lg._2(), lg._3().insert(this.head()).union(this.r()));
        }
        if (i == Ordering.GT) {
            P3<Set<A>, Option<A>, Set<A>> lg = this.r().split(a);
            return P.p(lg._1().insert(this.head()).union(this.l()), lg._2(), lg._3());
        }
        return P.p(this.l(), Option.some(a), this.r());
    }

    public boolean subsetOf(Set<A> s) {
        if (this.isEmpty() || s.isEmpty()) {
            return this.isEmpty();
        }
        P3<Set<A>, Option<A>, Set<A>> find = s.split(this.head());
        return find._2().isSome() && this.l().subsetOf(find._1()) && this.r().subsetOf(find._3());
    }

    public static <A> Set<A> join(Ord<A> o, Set<Set<A>> s) {
        F id2 = Function.identity();
        return s.foldMap(id2, Monoid.setMonoid(o));
    }

    public static <A> Set<A> iterableSet(Ord<A> o, Iterable<A> as) {
        Set<A> s = Set.empty(o);
        for (A a : as) {
            s = s.insert(a);
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Tree<A>
    extends Set<A> {
        private final Color c;
        private final Set<A> a;
        private final A x;
        private final Set<A> b;

        private Tree(Ord<A> ord2, Color c, Set<A> a, A x, Set<A> b) {
            super(ord2);
            this.c = c;
            this.a = a;
            this.x = x;
            this.b = b;
        }

        @Override
        public Color color() {
            return this.c;
        }

        @Override
        public Set<A> l() {
            return this.a;
        }

        @Override
        public A head() {
            return this.x;
        }

        @Override
        public Set<A> r() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Empty<A>
    extends Set<A> {
        private Empty(Ord<A> ord2) {
            super(ord2);
        }

        @Override
        public Color color() {
            return Color.B;
        }

        @Override
        public Set<A> l() {
            throw new Error("Left on empty set.");
        }

        @Override
        public Set<A> r() {
            throw new Error("Right on empty set.");
        }

        @Override
        public A head() {
            throw new Error("Head on empty set.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Color {
        R,
        B;

    }
}

