/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P1;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.Stream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<A>
implements Iterable<A> {
    private Option() {
    }

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A some();

    public boolean isSome() {
        return this instanceof Some;
    }

    public boolean isNone() {
        return this instanceof None;
    }

    public <B> B option(B b, F<A, B> f2) {
        return this.isSome() ? f2.f(this.some()) : b;
    }

    public int length() {
        return this.isSome() ? 1 : 0;
    }

    public A orSome(P1<A> a) {
        return this.isSome() ? this.some() : a._1();
    }

    public A orSome(A a) {
        return this.isSome() ? this.some() : a;
    }

    public <B> Option<B> map(F<A, B> f2) {
        return this.isSome() ? Option.some(f2.f(this.some())) : Option.none();
    }

    public Unit foreach(F<A, Unit> f2) {
        return this.isSome() ? f2.f(this.some()) : Unit.unit();
    }

    public void foreach(Effect<A> f2) {
        if (this.isSome()) {
            f2.e(this.some());
        }
    }

    public Option<A> filter(F<A, Boolean> f2) {
        return this.isSome() ? (f2.f(this.some()).booleanValue() ? this : Option.none()) : Option.none();
    }

    public <B> Option<B> bind(F<A, Option<B>> f2) {
        return this.isSome() ? f2.f(this.some()) : Option.none();
    }

    public <B, C> Option<C> bind(Option<B> ob, F<A, F<B, C>> f2) {
        return ob.apply(this.map(f2));
    }

    public <B, C, D> Option<D> bind(Option<B> ob, Option<C> oc, F<A, F<B, F<C, D>>> f2) {
        return oc.apply(this.bind(ob, f2));
    }

    public <B, C, D, E> Option<E> bind(Option<B> ob, Option<C> oc, Option<D> od, F<A, F<B, F<C, F<D, E>>>> f2) {
        return od.apply(this.bind(ob, oc, f2));
    }

    public <B, C, D, E, F$> Option<F$> bind(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, F<A, F<B, F<C, F<D, F<E, F$>>>>> f2) {
        return oe.apply(this.bind(ob, oc, od, f2));
    }

    public <B, C, D, E, F$, G> Option<G> bind(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f2) {
        return of.apply(this.bind(ob, oc, od, oe, f2));
    }

    public <B, C, D, E, F$, G, H> Option<H> bind(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of, Option<G> og, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f2) {
        return og.apply(this.bind(ob, oc, od, oe, of, f2));
    }

    public <B, C, D, E, F$, G, H, I> Option<I> bind(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of, Option<G> og, Option<H> oh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f2) {
        return oh.apply(this.bind(ob, oc, od, oe, of, og, f2));
    }

    public <B> Option<B> sequence(Option<B> o) {
        F c = Function.constant(o);
        return this.bind(c);
    }

    public <B> Option<B> apply(Option<F<A, B>> of) {
        return of.bind(new F<F<A, B>, Option<B>>(){

            @Override
            public Option<B> f(final F<A, B> f2) {
                return Option.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f2.f(a);
                    }
                });
            }
        });
    }

    public Option<A> orElse(P1<Option<A>> o) {
        return this.isSome() ? this : o._1();
    }

    public Option<A> orElse(Option<A> o) {
        return this.isSome() ? this : o;
    }

    public <X> Either<X, A> toEither(P1<X> x) {
        return this.isSome() ? Either.right(this.some()) : Either.left(x._1());
    }

    public <X> Either<X, A> toEither(X x) {
        return this.isSome() ? Either.right(this.some()) : Either.left(x);
    }

    public List<A> toList() {
        return this.isSome() ? List.cons(this.some(), List.nil()) : List.nil();
    }

    public Stream<A> toStream() {
        return this.isSome() ? Stream.nil().cons(this.some()) : Stream.nil();
    }

    public Array<A> toArray() {
        return this.isSome() ? Array.array(this.some()) : Array.empty();
    }

    public Array<A> toArray(Class<A[]> c) {
        if (this.isSome()) {
            Object[] a = (Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), 1);
            a[0] = this.some();
            return Array.array(a);
        }
        return Array.array((Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), 0));
    }

    public boolean forall(F<A, Boolean> f2) {
        return this.isNone() || f2.f(this.some()) != false;
    }

    public boolean exists(F<A, Boolean> f2) {
        return this.isSome() && f2.f(this.some()) != false;
    }

    public Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    public static <T> F<T, Option<T>> some_() {
        return new F<T, Option<T>>(){

            @Override
            public Option<T> f(T t) {
                return Option.some(t);
            }
        };
    }

    public static <T> Option<T> some(T t) {
        return new Some<T>(t);
    }

    public static <T> Option<T> none() {
        return new None();
    }

    public static <T> Option<T> fromNull(T t) {
        return t == null ? Option.none() : Option.some(t);
    }

    public static <A> Option<A> join(Option<Option<A>> o) {
        F id2 = Function.identity();
        return o.bind(id2);
    }

    public static <A> Option<List<A>> sequence(final List<Option<A>> a) {
        return a.isEmpty() ? Option.some(List.nil()) : a.head().bind(new F<A, Option<List<A>>>(){

            @Override
            public Option<List<A>> f(A aa) {
                return Option.sequence(a.tail()).map(List.cons_(aa));
            }
        });
    }

    public static <A> Option<A> iif(F<A, Boolean> f2, A a) {
        return f2.f(a) != false ? Option.some(a) : Option.none();
    }

    public static <A> F2<F<A, Boolean>, A, Option<A>> iif() {
        return new F2<F<A, Boolean>, A, Option<A>>(){

            @Override
            public Option<A> f(F<A, Boolean> p, A a) {
                return Option.iif(p, a);
            }
        };
    }

    public static <A> List<A> somes(List<Option<A>> as) {
        return as.filter(new F<Option<A>, Boolean>(){

            @Override
            public Boolean f(Option<A> o) {
                return o.isSome();
            }
        }).map(new F<Option<A>, A>(){

            @Override
            public A f(Option<A> o) {
                return o.some();
            }
        });
    }

    public static Option<String> fromString(String s) {
        return Option.fromNull(s).bind(new F<String, Option<String>>(){

            @Override
            public Option<String> f(String s) {
                Option none = Option.none();
                return s.length() == 0 ? none : Option.some(s);
            }
        });
    }

    public static F<String, Option<String>> fromString() {
        return new F<String, Option<String>>(){

            @Override
            public Option<String> f(String s) {
                return Option.fromString(s);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Some<A>
    extends Option<A> {
        private final A a;

        Some(A a) {
            this.a = a;
        }

        @Override
        public A some() {
            return this.a;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class None<A>
    extends Option<A> {
        private None() {
        }

        @Override
        public A some() {
            throw Bottom.error("some on None");
        }
    }
}

