/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Booleans;
import fj.pre.Equal;
import fj.pre.Monoid;
import fj.pre.Ord;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class List<A>
implements Iterable<A> {
    private List() {
    }

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract List<A> tail();

    public int length() {
        return this.foldLeft(new F<Integer, F<A, Integer>>(){

            @Override
            public F<A, Integer> f(final Integer i) {
                return new F<A, Integer>(){

                    @Override
                    public Integer f(A a) {
                        return i + 1;
                    }
                };
            }
        }, Integer.valueOf(0));
    }

    public boolean isEmpty() {
        return this instanceof Nil;
    }

    public boolean isNotEmpty() {
        return this instanceof Cons;
    }

    public <B> B list(B nil, F<A, F<List<A>, B>> cons) {
        return this.isEmpty() ? nil : cons.f(this.head()).f(this.tail());
    }

    public A orHead(P1<A> a) {
        return this.isEmpty() ? a._1() : this.head();
    }

    public List<A> orTail(P1<List<A>> as) {
        return this.isEmpty() ? as._1() : this.tail();
    }

    public Option<A> toOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public <X> Either<X, A> toEither(P1<X> x) {
        return this.isEmpty() ? Either.left(x._1()) : Either.right(this.head());
    }

    public Stream<A> toStream() {
        Stream nil = Stream.nil();
        return this.foldRight(new F<A, F<Stream<A>, Stream<A>>>(){

            @Override
            public F<Stream<A>, Stream<A>> f(final A a) {
                return new F<Stream<A>, Stream<A>>(){

                    @Override
                    public Stream<A> f(Stream<A> as) {
                        return as.cons(a);
                    }
                };
            }
        }, nil);
    }

    public Array<A> toArray() {
        Object[] a = new Object[this.length()];
        List<A> x = this;
        for (int i = 0; i < this.length(); ++i) {
            a[i] = x.head();
            x = x.tail();
        }
        return Array.array(a);
    }

    public Array<A> toArray(Class<A[]> c) {
        Object[] a = (Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), this.length());
        List<A> x = this;
        for (int i = 0; i < this.length(); ++i) {
            a[i] = x.head();
            x = x.tail();
        }
        return Array.array(a);
    }

    public List<A> cons(A a) {
        return new Cons<A>(a, this);
    }

    public <B> List<B> map(F<A, B> f2) {
        Buffer<B> bs = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            bs.snoc(f2.f(xs.head()));
            xs = xs.tail();
        }
        return bs.toList();
    }

    public Unit foreach(F<A, Unit> f2) {
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            f2.f(xs.head());
            xs = xs.tail();
        }
        return Unit.unit();
    }

    public void foreach(Effect<A> f2) {
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            f2.e(xs.head());
            xs = xs.tail();
        }
    }

    public List<A> filter(F<A, Boolean> f2) {
        Buffer<A> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            A h = xs.head();
            if (f2.f(h).booleanValue()) {
                b.snoc(h);
            }
            xs = xs.tail();
        }
        return b.toList();
    }

    public List<A> removeAll(F<A, Boolean> f2) {
        return this.filter(Function.compose(Booleans.not, f2));
    }

    public List<A> delete(A a, Equal<A> e) {
        P2<List<A>, List<A>> p = this.span(Function.compose(Booleans.not, e.eq(a)));
        return p._2().isEmpty() ? p._1() : p._1().append(p._2().tail());
    }

    public List<A> takeWhile(F<A, Boolean> f2) {
        Buffer<A> b = Buffer.empty();
        boolean taking = true;
        List<A> xs = this;
        while (xs.isNotEmpty() && taking) {
            A h = xs.head();
            if (f2.f(h).booleanValue()) {
                b.snoc(h);
            } else {
                taking = false;
            }
            xs = xs.tail();
        }
        return b.toList();
    }

    public List<A> dropWhile(F<A, Boolean> f2) {
        List<A> xs = this;
        while (xs.isNotEmpty() && f2.f(xs.head()).booleanValue()) {
            xs = xs.tail();
        }
        return xs;
    }

    public P2<List<A>, List<A>> span(F<A, Boolean> p) {
        Buffer<A> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            if (!p.f(xs.head()).booleanValue()) {
                return P.p(b.toList(), xs);
            }
            b.snoc(xs.head());
            xs = xs.tail();
        }
        return P.p(b.toList(), List.<A>nil());
    }

    public <B> List<B> bind(F<A, List<B>> f2) {
        Buffer<B> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            b.append(f2.f(xs.head()));
            xs = xs.tail();
        }
        return b.toList();
    }

    public <B, C> List<C> bind(List<B> lb, F<A, F<B, C>> f2) {
        return lb.apply(this.map(f2));
    }

    public static <A, B, C> F<List<A>, F<List<B>, List<C>>> liftM2(final F<A, F<B, C>> f2) {
        return Function.curry(new F2<List<A>, List<B>, List<C>>(){

            @Override
            public List<C> f(List<A> as, List<B> bs) {
                return as.bind(bs, f2);
            }
        });
    }

    public <B, C, D> List<D> bind(List<B> lb, List<C> lc, F<A, F<B, F<C, D>>> f2) {
        return lc.apply(this.bind(lb, f2));
    }

    public <B, C, D, E> List<E> bind(List<B> lb, List<C> lc, List<D> ld, F<A, F<B, F<C, F<D, E>>>> f2) {
        return ld.apply(this.bind(lb, lc, f2));
    }

    public <B, C, D, E, F$> List<F$> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, F<A, F<B, F<C, F<D, F<E, F$>>>>> f2) {
        return le.apply(this.bind(lb, lc, ld, f2));
    }

    public <B, C, D, E, F$, G> List<G> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f2) {
        return lf.apply(this.bind(lb, lc, ld, le, f2));
    }

    public <B, C, D, E, F$, G, H> List<H> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, List<G> lg, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f2) {
        return lg.apply(this.bind(lb, lc, ld, le, lf, f2));
    }

    public <B, C, D, E, F$, G, H, I> List<I> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, List<G> lg, List<H> lh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f2) {
        return lh.apply(this.bind(lb, lc, ld, le, lf, lg, f2));
    }

    public <B> List<B> sequence(List<B> bs) {
        F c = Function.constant(bs);
        return this.bind(c);
    }

    public <B> List<B> apply(List<F<A, B>> lf) {
        return lf.bind(new F<F<A, B>, List<B>>(){

            @Override
            public List<B> f(F<A, B> f2) {
                return List.this.map(f2);
            }
        });
    }

    public List<A> append(List<A> as) {
        return Buffer.fromList(this).append(as).toList();
    }

    public <B> B foldRight(F<A, F<B, B>> f2, B b) {
        return this.isEmpty() ? b : f2.f(this.head()).f(this.tail().foldRight(f2, b));
    }

    public <B> B foldRight(F2<A, B, B> f2, B b) {
        return this.foldRight(Function.curry(f2), b);
    }

    public <B> B foldLeft(F<B, F<A, B>> f2, B b) {
        B x = b;
        List<A> xs = this;
        while (!xs.isEmpty()) {
            x = f2.f(x).f(xs.head());
            xs = xs.tail();
        }
        return x;
    }

    public <B> B foldLeft(F2<B, A, B> f2, B b) {
        return this.foldLeft(Function.curry(f2), b);
    }

    public A foldLeft1(F2<A, A, A> f2) {
        return this.foldLeft1(Function.curry(f2));
    }

    public A foldLeft1(F<A, F<A, A>> f2) {
        if (this.isEmpty()) {
            throw Bottom.error("Undefined: foldLeft1 on empty list");
        }
        return this.tail().foldLeft(f2, this.head());
    }

    public List<A> reverse() {
        return this.foldLeft(new F<List<A>, F<A, List<A>>>(){

            @Override
            public F<A, List<A>> f(final List<A> as) {
                return new F<A, List<A>>(){

                    @Override
                    public List<A> f(A a) {
                        return List.cons(a, as);
                    }
                };
            }
        }, List.<A>nil());
    }

    public A index(int i) {
        if (i < 0 || i > this.length() - 1) {
            throw Bottom.error("index " + i + " out of range on list with length " + this.length());
        }
        List<A> xs = this;
        for (int c = 0; c < i; ++c) {
            xs = xs.tail();
        }
        return xs.head();
    }

    public List<A> take(int i) {
        return i <= 0 || this.isEmpty() ? List.nil() : List.cons(this.head(), this.tail().take(i - 1));
    }

    public List<A> drop(int i) {
        int c = 0;
        List<A> xs = this;
        while (xs.isNotEmpty() && c < i) {
            ++c;
            xs = xs.tail();
        }
        return xs;
    }

    public P2<List<A>, List<A>> splitAt(int i) {
        P2<List<Object>, List<Object>> s = P.p(List.<A>nil(), List.<A>nil());
        int c = 0;
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            final A h = xs.head();
            s = c < i ? s.map1(new F<List<A>, List<A>>(){

                @Override
                public List<A> f(List<A> as) {
                    return as.snoc(h);
                }
            }) : s.map2(new F<List<A>, List<A>>(){

                @Override
                public List<A> f(List<A> as) {
                    return as.snoc(h);
                }
            });
            ++c;
            xs = xs.tail();
        }
        return s;
    }

    public List<List<A>> partition(final int n) {
        if (n < 1) {
            throw Bottom.error("Can't create list partitions shorter than 1 element long.");
        }
        if (this.isEmpty()) {
            throw Bottom.error("Partition on empty list.");
        }
        return List.unfold(new F<List<A>, Option<P2<List<A>, List<A>>>>(){

            @Override
            public Option<P2<List<A>, List<A>>> f(List<A> as) {
                return as.isEmpty() ? Option.none() : Option.some(as.splitAt(n));
            }
        }, this);
    }

    public List<List<A>> inits() {
        List<List<List<A>>> s = List.single(List.<A>nil());
        if (this.isNotEmpty()) {
            s = s.append(this.tail().inits().map(List.cons().f(this.head())));
        }
        return s;
    }

    public List<List<A>> tails() {
        if (this.isEmpty()) {
            return List.single(List.<A>nil());
        }
        return List.cons(this, this.tail().tails());
    }

    public List<A> sort(Ord<A> o) {
        if (this.isEmpty()) {
            return List.nil();
        }
        if (this.tail().isEmpty()) {
            return this;
        }
        P2<List<A>, List<A>> s = this.splitAt(this.length() / 2);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Merge<A> {
            Merge() {
            }

            List<A> merge(List<A> xs, List<A> ys, Ord<A> o) {
                return xs.isEmpty() ? ys : (ys.isEmpty() ? xs : (o.isGreaterThan(ys.head(), xs.head()) ? List.cons(xs.head(), this.merge(xs.tail(), ys, o)) : List.cons(ys.head(), this.merge(xs, ys.tail(), o))));
            }
        }
        return new Merge<A>().merge(s._1().sort(o), s._2().sort(o), o);
    }

    public <B, C> List<C> zipWith(List<B> bs, F<A, F<B, C>> f2) {
        return this.isEmpty() || bs.isEmpty() ? List.nil() : List.cons(f2.f(this.head()).f(bs.head()), this.tail().zipWith(bs.tail(), f2));
    }

    public static <A, B, C> F<List<A>, F<List<B>, F<F<A, F<B, C>>, List<C>>>> zipWith() {
        return Function.curry(new F3<List<A>, List<B>, F<A, F<B, C>>, List<C>>(){

            @Override
            public List<C> f(List<A> as, List<B> bs, F<A, F<B, C>> f2) {
                return as.zipWith(bs, f2);
            }
        });
    }

    public <B> List<P2<A, B>> zip(List<B> bs) {
        F __2 = P.p2();
        return this.zipWith(bs, __2);
    }

    public static <A, B> F<List<A>, F<List<B>, List<P2<A, B>>>> zip() {
        return Function.curry(new F2<List<A>, List<B>, List<P2<A, B>>>(){

            @Override
            public List<P2<A, B>> f(List<A> as, List<B> bs) {
                return as.zip(bs);
            }
        });
    }

    public List<P2<A, Integer>> zipIndex() {
        return this.zipWith(List.range(0, this.length()), new F<A, F<Integer, P2<A, Integer>>>(){

            @Override
            public F<Integer, P2<A, Integer>> f(final A a) {
                return new F<Integer, P2<A, Integer>>(){

                    @Override
                    public P2<A, Integer> f(Integer i) {
                        return P.p(a, i);
                    }
                };
            }
        });
    }

    public List<A> snoc(A a) {
        return Buffer.fromList(this).snoc(a).toList();
    }

    public boolean forall(F<A, Boolean> f2) {
        return this.isEmpty() || f2.f(this.head()) != false && this.tail().forall(f2);
    }

    public boolean exists(F<A, Boolean> f2) {
        return this.find(f2).isSome();
    }

    public Option<A> find(F<A, Boolean> f2) {
        List<A> as = this;
        while (as.isNotEmpty()) {
            if (f2.f(as.head()).booleanValue()) {
                return Option.some(as.head());
            }
            as = as.tail();
        }
        return Option.none();
    }

    public List<A> intersperse(A a) {
        return this.isEmpty() || this.tail().isEmpty() ? this : List.cons(this.head(), List.cons(a, this.tail().intersperse(a)));
    }

    public List<A> nub() {
        return this.nub(Equal.anyEqual());
    }

    public List<A> nub(final Equal<A> eq2) {
        return this.isEmpty() ? this : List.cons(this.head(), this.tail().filter(new F<A, Boolean>(){

            @Override
            public Boolean f(A a) {
                return !eq2.eq(a, List.this.head());
            }
        }).nub(eq2));
    }

    public List<A> minus(Equal<A> eq2, List<A> xs) {
        return this.removeAll(Function.compose(Monoid.disjunctionMonoid.sumLeft(), xs.mapM(Function.curry(eq2.eq()))));
    }

    public <B, C> F<B, List<C>> mapM(F<A, F<B, C>> f2) {
        return List.sequence(this.map(f2));
    }

    public Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private List<A> xs;
                    {
                        this.xs = List.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return List.this.length();
            }
        };
    }

    public static <A> List<A> list(A ... as) {
        return Array.array(as).toList();
    }

    public static <A> List<A> nil() {
        return new Nil();
    }

    public static <A> F<A, F<List<A>, List<A>>> cons() {
        return new F<A, F<List<A>, List<A>>>(){

            @Override
            public F<List<A>, List<A>> f(final A a) {
                return new F<List<A>, List<A>>(){

                    @Override
                    public List<A> f(List<A> tail) {
                        return List.cons(a, tail);
                    }
                };
            }
        };
    }

    public static <A> F<A, List<A>> cons(final List<A> tail) {
        return new F<A, List<A>>(){

            @Override
            public List<A> f(A a) {
                return tail.cons(a);
            }
        };
    }

    public static <A> F<List<A>, List<A>> cons_(final A a) {
        return new F<List<A>, List<A>>(){

            @Override
            public List<A> f(List<A> as) {
                return as.cons(a);
            }
        };
    }

    public static <A> List<A> cons(A head, List<A> tail) {
        return new Cons<A>(head, tail);
    }

    public static <A> F<List<A>, Boolean> isEmpty_() {
        return new F<List<A>, Boolean>(){

            @Override
            public Boolean f(List<A> as) {
                return as.isEmpty();
            }
        };
    }

    public static <A> F<List<A>, Boolean> isNotEmpty_() {
        return new F<List<A>, Boolean>(){

            @Override
            public Boolean f(List<A> as) {
                return as.isNotEmpty();
            }
        };
    }

    public static <A> List<A> join(List<List<A>> o) {
        F id2 = Function.identity();
        return o.bind(id2);
    }

    public static <A> F<List<List<A>>, List<A>> join() {
        return new F<List<List<A>>, List<A>>(){

            @Override
            public List<A> f(List<List<A>> as) {
                return List.join(as);
            }
        };
    }

    public static <A, B> List<A> unfold(F<B, Option<P2<A, B>>> f2, B b) {
        Buffer<A> buf = Buffer.empty();
        Option<P2<A, B>> o = f2.f(b);
        while (o.isSome()) {
            buf = buf.snoc(o.some()._1());
            o = f2.f(o.some()._2());
        }
        return buf.toList();
    }

    public static <A, B> P2<List<A>, List<B>> unzip(List<P2<A, B>> xs) {
        Buffer<A> ba = Buffer.empty();
        Buffer<B> bb = Buffer.empty();
        for (P2<A, B> p : xs) {
            ba = ba.snoc(p._1());
            bb = bb.snoc(p._2());
        }
        return P.p(ba.toList(), bb.toList());
    }

    public static <A> List<A> replicate(int n, A a) {
        return n <= 0 ? List.nil() : List.replicate(n - 1, a).cons(a);
    }

    public static List<Integer> range(int from, int to) {
        return from >= to ? List.nil() : List.cons(from, List.range(from + 1, to));
    }

    public static List<Character> fromString(String s) {
        List<Character> cs = List.nil();
        for (int i = s.length() - 1; i >= 0; --i) {
            cs = List.cons(Character.valueOf(s.charAt(i)), cs);
        }
        return cs;
    }

    public static F<String, List<Character>> fromString() {
        return new F<String, List<Character>>(){

            @Override
            public List<Character> f(String s) {
                return List.fromString(s);
            }
        };
    }

    public static String asString(List<Character> cs) {
        final StringBuilder sb = new StringBuilder();
        cs.foreach(new F<Character, Unit>(){

            @Override
            public Unit f(Character c) {
                sb.append(c);
                return Unit.unit();
            }
        });
        return sb.toString();
    }

    public static F<List<Character>, String> asString() {
        return new F<List<Character>, String>(){

            @Override
            public String f(List<Character> cs) {
                return List.asString(cs);
            }
        };
    }

    public static <A> List<A> single(A a) {
        return List.cons(a, List.<A>nil());
    }

    public static <A> List<A> iterateWhile(final F<A, A> f2, final F<A, Boolean> p, A a) {
        return List.unfold(new F<A, Option<P2<A, A>>>(){

            @Override
            public Option<P2<A, A>> f(final A o) {
                return Option.iif(new F<P2<A, A>, Boolean>(){

                    @Override
                    public Boolean f(P2<A, A> p2) {
                        return (Boolean)p.f(o);
                    }
                }, P.p(o, f2.f(o)));
            }
        }, a);
    }

    public static <A, B> Option<B> lookup(final Equal<A> e, List<P2<A, B>> x, final A a) {
        return x.find(new F<P2<A, B>, Boolean>(){

            @Override
            public Boolean f(P2<A, B> p) {
                return e.eq(p._1(), a);
            }
        }).map(P2.__2());
    }

    public static <A, B> F2<List<P2<A, B>>, A, Option<B>> lookup(final Equal<A> e) {
        return new F2<List<P2<A, B>>, A, Option<B>>(){

            @Override
            public Option<B> f(List<P2<A, B>> x, A a) {
                return List.lookup(e, x, a);
            }
        };
    }

    public static <A, B> F<F<A, List<B>>, F<List<A>, List<B>>> bind_() {
        return Function.curry(new F2<F<A, List<B>>, List<A>, List<B>>(){

            @Override
            public List<B> f(F<A, List<B>> f2, List<A> as) {
                return as.bind(f2);
            }
        });
    }

    public static <A, B> F<F<A, B>, F<List<A>, List<B>>> map_() {
        return Function.curry(new F2<F<A, B>, List<A>, List<B>>(){

            @Override
            public List<B> f(F<A, B> f2, List<A> as) {
                return as.map(f2);
            }
        });
    }

    public static <A, B> F<B, List<A>> sequence(List<F<B, A>> fs) {
        return fs.foldRight(Function.lift(List.<A>cons()), Function.constant(List.<A>nil()));
    }

    public static <A, B> F<F<B, F<A, B>>, F<B, F<List<A>, B>>> foldLeft() {
        return Function.curry(new F3<F<B, F<A, B>>, B, List<A>, B>(){

            @Override
            public B f(F<B, F<A, B>> f2, B b, List<A> as) {
                return as.foldLeft(f2, b);
            }
        });
    }

    public static <A> List<A> iterableList(Iterable<A> i) {
        Buffer<A> bs = Buffer.empty();
        for (A a : i) {
            bs.snoc(a);
        }
        return bs.toList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Buffer<A>
    implements Iterable<A> {
        private List<A> start = List.nil();
        private Cons<A> tail;
        private boolean exported;

        @Override
        public Iterator<A> iterator() {
            return this.start.iterator();
        }

        public Buffer<A> snoc(A a) {
            if (this.exported) {
                this.copy();
            }
            Cons<A> t = new Cons<A>(a, List.nil());
            if (this.tail == null) {
                this.start = t;
            } else {
                ((Cons)this.tail).tail(t);
            }
            this.tail = t;
            return this;
        }

        public Buffer<A> append(List<A> as) {
            List<A> xs = as;
            while (xs.isNotEmpty()) {
                this.snoc(xs.head());
                xs = xs.tail();
            }
            return this;
        }

        public List<A> toList() {
            this.exported = !this.start.isEmpty();
            return this.start;
        }

        public Collection<A> toCollection() {
            return this.start.toCollection();
        }

        public static <A> Buffer<A> empty() {
            return new Buffer<A>();
        }

        public static <A> Buffer<A> fromList(List<A> as) {
            Buffer<A> b = new Buffer<A>();
            List<A> xs = as;
            while (xs.isNotEmpty()) {
                b.snoc(xs.head());
                xs = xs.tail();
            }
            return b;
        }

        public static <A> Buffer<A> iterableBuffer(Iterable<A> i) {
            Buffer<A> b = Buffer.empty();
            for (A a : i) {
                b.snoc(a);
            }
            return b;
        }

        private void copy() {
            Cons<A> t = this.tail;
            this.start = List.nil();
            this.exported = false;
            for (List<A> s = this.start; s != t; s = s.tail()) {
                this.snoc(s.head());
            }
            if (t != null) {
                this.snoc(t.head());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Cons<A>
    extends List<A> {
        private final A head;
        private List<A> tail;

        Cons(A head, List<A> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public List<A> tail() {
            return this.tail;
        }

        private void tail(List<A> tail) {
            this.tail = tail;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Nil<A>
    extends List<A> {
        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty list");
        }

        @Override
        public List<A> tail() {
            throw Bottom.error("tail on empty list");
        }
    }
}

