/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.P1;
import fj.P2;
import fj.data.Option;
import fj.data.Stream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IterableW<A>
implements Iterable<A> {
    private final Iterable<A> i;

    private IterableW(Iterable<A> i) {
        this.i = i;
    }

    public static <A> IterableW<A> wrap(Iterable<A> a) {
        return new IterableW<A>(a);
    }

    public static <A, T extends Iterable<A>> F<T, IterableW<A>> wrap() {
        return new F<T, IterableW<A>>(){

            @Override
            public IterableW<A> f(T a) {
                return IterableW.wrap(a);
            }
        };
    }

    public static <A> IterableW<A> iterable(A a) {
        return IterableW.wrap(Option.some(a));
    }

    public static <A, B> F<A, IterableW<B>> iterable(final F<A, B> f2) {
        return new F<A, IterableW<B>>(){

            @Override
            public IterableW<B> f(A a) {
                return IterableW.iterable(f2.f(a));
            }
        };
    }

    public static <A, B> F<F<A, B>, F<A, IterableW<B>>> arrow() {
        return new F<F<A, B>, F<A, IterableW<B>>>(){

            @Override
            public F<A, IterableW<B>> f(F<A, B> f2) {
                return IterableW.iterable(f2);
            }
        };
    }

    public <B, T extends Iterable<B>> IterableW<B> bind(final F<A, T> f2) {
        return IterableW.wrap(Stream.iterableStream(this).bind(new F<A, Stream<B>>(){

            @Override
            public Stream<B> f(A a) {
                return Stream.iterableStream((Iterable)f2.f(a));
            }
        }));
    }

    public <B> IterableW<B> apply(Iterable<F<A, B>> f2) {
        return IterableW.wrap(f2).bind(new F<F<A, B>, Iterable<B>>(){

            @Override
            public Iterable<B> f(F<A, B> f2) {
                return IterableW.this.map(f2);
            }
        });
    }

    public static <A, B, C> IterableW<C> bind(Iterable<A> a, Iterable<B> b, F<A, F<B, C>> f2) {
        return IterableW.wrap(b).apply(IterableW.wrap(a).map(f2));
    }

    public static <A, B, C> F<Iterable<A>, F<Iterable<B>, IterableW<C>>> liftM2(final F<A, F<B, C>> f2) {
        return Function.curry(new F2<Iterable<A>, Iterable<B>, IterableW<C>>(){

            @Override
            public IterableW<C> f(Iterable<A> ca, Iterable<B> cb) {
                return IterableW.bind(ca, cb, f2);
            }
        });
    }

    public static <A, T extends Iterable<A>> IterableW<IterableW<A>> sequence(Iterable<T> as) {
        final Stream<T> ts = Stream.iterableStream(as);
        return ts.isEmpty() ? IterableW.iterable(IterableW.wrap(Option.none())) : IterableW.wrap((Iterable)ts.head()).bind(new F<A, Iterable<IterableW<A>>>(){

            @Override
            public Iterable<IterableW<A>> f(final A a) {
                return IterableW.sequence(ts.tail().map(IterableW.wrap())._1()).bind(new F<IterableW<A>, Iterable<IterableW<A>>>(){

                    @Override
                    public Iterable<IterableW<A>> f(final IterableW<A> as) {
                        return IterableW.iterable(IterableW.wrap(Stream.cons(a, new P1<Stream<A>>(){

                            @Override
                            public Stream<A> _1() {
                                return Stream.iterableStream(as);
                            }
                        })));
                    }
                });
            }
        });
    }

    public static <A, B, T extends Iterable<B>> F<IterableW<A>, F<F<A, T>, IterableW<B>>> bind() {
        return new F<IterableW<A>, F<F<A, T>, IterableW<B>>>(){

            @Override
            public F<F<A, T>, IterableW<B>> f(final IterableW<A> a) {
                return new F<F<A, T>, IterableW<B>>(){

                    @Override
                    public IterableW<B> f(F<A, T> f2) {
                        return a.bind(f2);
                    }
                };
            }
        };
    }

    public static <A, T extends Iterable<A>> IterableW<A> join(Iterable<T> as) {
        F id2 = Function.identity();
        return IterableW.wrap(as).bind(id2);
    }

    public static <A, T extends Iterable<A>> F<Iterable<T>, IterableW<A>> join() {
        return new F<Iterable<T>, IterableW<A>>(){

            @Override
            public IterableW<A> f(Iterable<T> a) {
                return IterableW.join(a);
            }
        };
    }

    public <B> IterableW<B> map(F<A, B> f2) {
        return this.bind(IterableW.iterable(f2));
    }

    public static <A, B> F<F<A, B>, F<IterableW<A>, IterableW<B>>> map() {
        return new F<F<A, B>, F<IterableW<A>, IterableW<B>>>(){

            @Override
            public F<IterableW<A>, IterableW<B>> f(final F<A, B> f2) {
                return new F<IterableW<A>, IterableW<B>>(){

                    @Override
                    public IterableW<B> f(IterableW<A> a) {
                        return a.map(f2);
                    }
                };
            }
        };
    }

    public <B> B foldLeft(F<B, F<A, B>> f2, B z) {
        B p = z;
        for (A x : this) {
            p = f2.f(p).f(x);
        }
        return p;
    }

    public <B> B foldRight(final F2<A, B, B> f2, B z) {
        F id2 = Function.identity();
        return (B)this.foldLeft(Function.curry(new F3<F<B, B>, A, B, B>(){

            @Override
            public B f(F<B, B> k, A a, B b) {
                return k.f(f2.f(a, b));
            }
        }), id2).f(z);
    }

    @Override
    public Iterator<A> iterator() {
        return this.i.iterator();
    }

    public <B> IterableW<B> zapp(Iterable<F<A, B>> fs) {
        return IterableW.wrap(Stream.iterableStream(this).zapp(Stream.iterableStream(fs)));
    }

    public <B, C> Iterable<C> zipWith(Iterable<B> bs, F<A, F<B, C>> f2) {
        return IterableW.wrap(Stream.iterableStream(this).zipWith(Stream.iterableStream(bs), f2));
    }

    public <B> Iterable<P2<A, B>> zip(Iterable<B> bs) {
        return IterableW.wrap(Stream.iterableStream(this).zip(Stream.iterableStream(bs)));
    }

    public Iterable<P2<A, Integer>> zipIndex() {
        return IterableW.wrap(Stream.iterableStream(this).zipIndex());
    }
}

