/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.P;
import fj.P2;
import fj.data.List;
import fj.data.Option;
import fj.pre.Equal;
import fj.pre.Hash;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashMap<K, V>
implements Iterable<K> {
    private final java.util.HashMap<Key<K>, V> m;
    private final Equal<K> e;
    private final Hash<K> h;

    @Override
    public Iterator<K> iterator() {
        return this.keys().iterator();
    }

    public HashMap(Equal<K> e, Hash<K> h) {
        this.m = new java.util.HashMap();
        this.e = e;
        this.h = h;
    }

    public HashMap(Equal<K> e, Hash<K> h, int initialCapacity) {
        this.m = new java.util.HashMap(initialCapacity);
        this.e = e;
        this.h = h;
    }

    public HashMap(Equal<K> e, Hash<K> h, int initialCapacity, float loadFactor) {
        this.m = new java.util.HashMap(initialCapacity, loadFactor);
        this.e = e;
        this.h = h;
    }

    public static <K, V> HashMap<K, V> hashMap() {
        Equal e = Equal.anyEqual();
        Hash h = Hash.anyHash();
        return new HashMap(e, h);
    }

    public boolean eq(K k1, K k2) {
        return this.e.eq(k1, k2);
    }

    public int hash(K k) {
        return this.h.hash(k);
    }

    public Option<V> get(K k) {
        return Option.fromNull(this.m.get(new Key<K>(k, this.e, this.h)));
    }

    public F<K, Option<V>> get() {
        return new F<K, Option<V>>(){

            @Override
            public Option<V> f(K k) {
                return HashMap.this.get(k);
            }
        };
    }

    public void clear() {
        this.m.clear();
    }

    public boolean contains(K k) {
        return this.m.containsKey(new Key<K>(k, this.e, this.h));
    }

    public List<K> keys() {
        List.Buffer<K> b = new List.Buffer<K>();
        for (Key<K> k : this.m.keySet()) {
            b.snoc(k.k());
        }
        return b.toList();
    }

    public List<V> values() {
        return this.keys().map(new F<K, V>(){

            @Override
            public V f(K k) {
                return HashMap.this.m.get(new Key(k, HashMap.this.e, HashMap.this.h));
            }
        });
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public int size() {
        return this.m.size();
    }

    public void set(K k, V v) {
        this.m.put(new Key<K>(k, this.e, this.h), v);
    }

    public void delete(K k) {
        this.m.remove(new Key<K>(k, this.e, this.h));
    }

    public Option<V> getDelete(K k) {
        return Option.fromNull(this.m.remove(new Key<K>(k, this.e, this.h)));
    }

    public Collection<P2<K, V>> toCollection() {
        return this.keys().map(new F<K, P2<K, V>>(){

            @Override
            public P2<K, V> f(K k) {
                return P.p(k, HashMap.this.get(k).some());
            }
        }).toCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Key<K> {
        private final K k;
        private final Equal<K> e;
        private final Hash<K> h;

        Key(K k, Equal<K> e, Hash<K> h) {
            this.k = k;
            this.e = e;
            this.h = h;
        }

        K k() {
            return this.k;
        }

        public boolean equals(Object o) {
            return o instanceof Key && this.e.eq(this.k, ((Key)o).k());
        }

        public int hashCode() {
            return this.h.hash(this.k);
        }
    }
}

