/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array<A>
implements Iterable<A> {
    private final A[] a;

    private Array(A[] a) {
        this.a = a;
    }

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public A get(int index) {
        return this.a[index];
    }

    public Unit set(int index, A a) {
        this.a[index] = a;
        return Unit.unit();
    }

    public int length() {
        return this.a.length;
    }

    public ImmutableProjection<A> immutable() {
        return new ImmutableProjection(this);
    }

    public boolean isEmpty() {
        return this.a.length == 0;
    }

    public boolean isNotEmpty() {
        return this.a.length != 0;
    }

    public A[] array() {
        return this.a;
    }

    public Option<A> toOption() {
        return this.a.length == 0 ? Option.none() : Option.some(this.a[0]);
    }

    public <X> Either<X, A> toEither(P1<X> x) {
        return this.a.length == 0 ? Either.left(x._1()) : Either.right(this.a[0]);
    }

    public List<A> toList() {
        List<A> x = List.nil();
        for (int i = this.a.length - 1; i >= 0; --i) {
            x = x.cons(this.a[i]);
        }
        return x;
    }

    public Stream<A> toStream() {
        Stream<A> x = Stream.nil();
        for (int i = this.a.length - 1; i >= 0; --i) {
            x = x.cons(this.a[i]);
        }
        return x;
    }

    public <B> Array<B> map(F<A, B> f2) {
        Object[] bs = new Object[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            bs[i] = f2.f(this.a[i]);
        }
        return new Array<Object>(bs);
    }

    public Array<A> filter(F<A, Boolean> f2) {
        List<A> x = List.nil();
        for (int i = this.a.length - 1; i >= 0; --i) {
            if (!f2.f(this.a[i]).booleanValue()) continue;
            x = x.cons(this.a[i]);
        }
        return x.toArray();
    }

    public Unit foreach(F<A, Unit> f2) {
        for (A x : this.a) {
            f2.f(x);
        }
        return Unit.unit();
    }

    public void foreach(Effect<A> f2) {
        for (A x : this.a) {
            f2.e(x);
        }
    }

    public <B> B foldRight(F<A, F<B, B>> f2, B b) {
        B x = b;
        for (int i = this.a.length - 1; i >= 0; --i) {
            x = f2.f(this.a[i]).f(x);
        }
        return x;
    }

    public <B> B foldRight(F2<A, B, B> f2, B b) {
        return this.foldRight(Function.curry(f2), b);
    }

    public <B> B foldLeft(F<B, F<A, B>> f2, B b) {
        B x = b;
        for (A aa : this.a) {
            x = f2.f(x).f(aa);
        }
        return x;
    }

    public <B> B foldLeft(F2<B, A, B> f2, B b) {
        return this.foldLeft(Function.curry(f2), b);
    }

    public <B> Array<B> bind(F<A, Array<B>> f2) {
        List<Array<B>> x = List.nil();
        int len = 0;
        for (int i = this.a.length - 1; i >= 0; --i) {
            Array<B> bs = f2.f(this.a[i]);
            len += bs.length();
            x = x.cons(bs);
        }
        final Object[] bs = new Object[len];
        x.foreach(new F<Array<B>, Unit>(){
            private int i;

            @Override
            public Unit f(Array<B> x) {
                System.arraycopy(x.a, 0, bs, this.i, x.a.length);
                this.i += x.a.length;
                return Unit.unit();
            }
        });
        return new Array<Object>(bs);
    }

    public <B> Array<B> sequence(Array<B> bs) {
        F c = Function.constant(bs);
        return this.bind(c);
    }

    public <B> Array<B> apply(Array<F<A, B>> lf) {
        return lf.bind(new F<F<A, B>, Array<B>>(){

            @Override
            public Array<B> f(final F<A, B> f2) {
                return Array.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f2.f(a);
                    }
                });
            }
        });
    }

    public Array<A> reverse() {
        Object[] x = new Object[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            x[this.a.length - 1 - i] = this.a[i];
        }
        return new Array<Object>(x);
    }

    public Array<A> append(Array<A> aas) {
        Object[] x = new Object[this.a.length + aas.a.length];
        System.arraycopy(this.a, 0, x, 0, this.a.length);
        System.arraycopy(aas.a, 0, x, this.a.length, aas.a.length);
        return new Array<Object>(x);
    }

    public static <A> Array<A> empty() {
        return new Array<Object>(new Object[0]);
    }

    public static <A> Array<A> array(A ... a) {
        return new Array<A>(a);
    }

    public static <A> Array<A> join(Array<Array<A>> o) {
        F id2 = Function.identity();
        return o.bind(id2);
    }

    public static <A> F<Array<Array<A>>, Array<A>> join() {
        return new F<Array<Array<A>>, Array<A>>(){

            @Override
            public Array<A> f(Array<Array<A>> as) {
                return Array.join(as);
            }
        };
    }

    public boolean forall(F<A, Boolean> f2) {
        for (A x : this.a) {
            if (f2.f(x).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean exists(F<A, Boolean> f2) {
        for (A x : this.a) {
            if (!f2.f(x).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Option<A> find(F<A, Boolean> f2) {
        for (A x : this.a) {
            if (!f2.f(x).booleanValue()) continue;
            return Option.some(x);
        }
        return Option.none();
    }

    public static Array<Integer> range(int from, int to) {
        if (from >= to) {
            return Array.empty();
        }
        Array<Integer> a = new Array<Integer>(new Integer[to - from]);
        for (int i = from; i < to; ++i) {
            a.set(i - from, i);
        }
        return a;
    }

    public <B, C> Array<C> zipWith(Array<B> bs, F<A, F<B, C>> f2) {
        int len = Math.min(this.a.length, bs.length());
        Array<Object> x = new Array<Object>(new Object[len]);
        for (int i = 0; i < len; ++i) {
            x.set(i, f2.f(this.get(i)).f(bs.get(i)));
        }
        return x;
    }

    public <B> Array<P2<A, B>> zip(Array<B> bs) {
        F __2 = P.p2();
        return this.zipWith(bs, __2);
    }

    public Array<P2<A, Integer>> zipIndex() {
        return this.zipWith(Array.range(0, this.length()), new F<A, F<Integer, P2<A, Integer>>>(){

            @Override
            public F<Integer, P2<A, Integer>> f(final A a) {
                return new F<Integer, P2<A, Integer>>(){

                    @Override
                    public P2<A, Integer> f(Integer i) {
                        return P.p(a, i);
                    }
                };
            }
        });
    }

    public Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < Array.this.a.length;
                    }

                    @Override
                    public A next() {
                        if (this.i >= Array.this.a.length) {
                            throw new NoSuchElementException();
                        }
                        Object aa = Array.this.a[this.i];
                        ++this.i;
                        return aa;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Array.this.a.length;
            }
        };
    }

    public static <A> Array<A> iterableArray(Iterable<A> i) {
        return List.iterableList(i).toArray();
    }

    public static <A, B> P2<Array<A>, Array<B>> unzip(Array<P2<A, B>> xs) {
        int len = xs.length();
        Array<Object> aa = new Array<Object>(new Object[len]);
        Array<Object> ab = new Array<Object>(new Object[len]);
        for (int i = len - 1; i >= 0; --i) {
            P2<A, B> p = xs.get(i);
            aa.set(i, p._1());
            ab.set(i, p._2());
        }
        return P.p(aa, ab);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ImmutableProjection<A>
    implements Iterable<A> {
        private final Array<A> a;

        private ImmutableProjection(Array<A> a) {
            this.a = a;
        }

        @Override
        public Iterator<A> iterator() {
            return this.a.iterator();
        }

        public A get(int index) {
            return this.a.get(index);
        }

        public int length() {
            return this.a.length();
        }

        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        public boolean isNotEmpty() {
            return this.a.isNotEmpty();
        }

        public Option<A> toOption() {
            return this.a.toOption();
        }

        public <X> Either<X, A> toEither(P1<X> x) {
            return this.a.toEither(x);
        }

        public List<A> toList() {
            return this.a.toList();
        }

        public Stream<A> toStream() {
            return this.a.toStream();
        }

        public <B> Array<B> map(F<A, B> f2) {
            return this.a.map(f2);
        }

        public Array<A> filter(F<A, Boolean> f2) {
            return this.a.filter(f2);
        }

        public Unit foreach(F<A, Unit> f2) {
            return this.a.foreach(f2);
        }

        public <B> B foldRight(F<A, F<B, B>> f2, B b) {
            return this.a.foldRight(f2, b);
        }

        public <B> B foldLeft(F<B, F<A, B>> f2, B b) {
            return this.a.foldLeft(f2, b);
        }

        public <B> Array<B> bind(F<A, Array<B>> f2) {
            return this.a.bind(f2);
        }

        public <B> Array<B> sequence(Array<B> bs) {
            return this.a.sequence(bs);
        }

        public <B> Array<B> apply(Array<F<A, B>> lf) {
            return this.a.apply(lf);
        }

        public Array<A> reverse() {
            return this.a.reverse();
        }

        public Array<A> append(Array<A> aas) {
            return this.a.append(aas);
        }

        public Collection<A> toCollection() {
            return this.a.toCollection();
        }
    }
}

