/*
 * Decompiled with CFR 0.152.
 */
package fj.control.db;

import fj.F;
import fj.Function;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DB<A> {
    public abstract A run(Connection var1) throws SQLException;

    public static <A> DB<A> db(final F<Connection, A> f2) {
        return new DB<A>(){

            @Override
            public A run(Connection c) {
                return f2.f(c);
            }
        };
    }

    public F<Connection, Callable<A>> asFunction() {
        return new F<Connection, Callable<A>>(){

            @Override
            public Callable<A> f(final Connection c) {
                return new Callable<A>(){

                    @Override
                    public A call() throws Exception {
                        return DB.this.run(c);
                    }
                };
            }
        };
    }

    public <B> DB<B> map(final F<A, B> f2) {
        return new DB<B>(){

            @Override
            public B run(Connection c) throws SQLException {
                return f2.f(DB.this.run(c));
            }
        };
    }

    public static <A, B> F<DB<A>, DB<B>> liftM(final F<A, B> f2) {
        return new F<DB<A>, DB<B>>(){

            @Override
            public DB<B> f(DB<A> a) {
                return a.map(f2);
            }
        };
    }

    public static <A> DB<A> unit(final A a) {
        return new DB<A>(){

            @Override
            public A run(Connection c) {
                return a;
            }
        };
    }

    public <B> DB<B> bind(final F<A, DB<B>> f2) {
        return new DB<B>(){

            @Override
            public B run(Connection c) throws SQLException {
                return ((DB)f2.f(DB.this.run(c))).run(c);
            }
        };
    }

    public static <A> DB<A> join(DB<DB<A>> a) {
        return a.bind(Function.identity());
    }
}

