/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.math.fn;

import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.FloatType;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumberFunction
implements IFunction {
    private final double val;

    public NumberFunction(Number number) {
        this.val = NumberFunction.asType(number).getRealDouble();
    }

    public NumberFunction(double d) {
        this.val = d;
    }

    @Override
    public final double eval() {
        return this.val;
    }

    private static final RealType<?> asType(Number number) {
        Class<?> clazz = number.getClass();
        if (clazz == Double.class) {
            return new DoubleType(number.doubleValue());
        }
        if (clazz == Long.class) {
            return new LongType(number.longValue());
        }
        if (clazz == Float.class) {
            return new FloatType(number.floatValue());
        }
        if (clazz == Byte.class) {
            return new UnsignedByteType((int)number.byteValue());
        }
        if (clazz == Integer.class) {
            return new IntType(number.intValue());
        }
        if (clazz == Short.class) {
            return new ShortType(number.shortValue());
        }
        return new DoubleType(number.doubleValue());
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> collection) {
    }

    @Override
    public IFunction duplicate() {
        return new NumberFunction(this.val);
    }
}

