/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.math.fn;

import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.fn.FloatImageOperation;
import script.imglib.math.fn.IFunction;
import script.imglib.math.fn.ImageFunction;
import script.imglib.math.fn.NumberFunction;
import script.imglib.math.fn.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryOperation
extends FloatImageOperation {
    private final IFunction a;
    private final IFunction b;

    public BinaryOperation(Image<? extends RealType<?>> image, Image<? extends RealType<?>> image2) {
        this.a = new ImageFunction(image);
        this.b = new ImageFunction(image2);
    }

    public BinaryOperation(IFunction iFunction, Image<? extends RealType<?>> image) {
        this.a = iFunction;
        this.b = new ImageFunction(image);
    }

    public BinaryOperation(Image<? extends RealType<?>> image, IFunction iFunction) {
        this.a = new ImageFunction(image);
        this.b = iFunction;
    }

    public BinaryOperation(IFunction iFunction, IFunction iFunction2) {
        this.a = iFunction;
        this.b = iFunction2;
    }

    public BinaryOperation(Image<? extends RealType<?>> image, Number number) {
        this.a = new ImageFunction(image);
        this.b = new NumberFunction(number);
    }

    public BinaryOperation(Number number, Image<? extends RealType<?>> image) {
        this.a = new NumberFunction(number);
        this.b = new ImageFunction(image);
    }

    public BinaryOperation(IFunction iFunction, Number number) {
        this.a = iFunction;
        this.b = new NumberFunction(number);
    }

    public BinaryOperation(Number number, IFunction iFunction) {
        this.a = new NumberFunction(number);
        this.b = iFunction;
    }

    public BinaryOperation(Number number, Number number2) {
        this.a = new NumberFunction(number);
        this.b = new NumberFunction(number2);
    }

    public BinaryOperation(Object ... objectArray) throws Exception {
        this.a = Util.wrap(objectArray[0]);
        IFunction iFunction = Util.wrap(objectArray[objectArray.length - 1]);
        for (int i = objectArray.length - 2; i > 0; --i) {
            IFunction iFunction2;
            iFunction = iFunction2 = (IFunction)this.getClass().getConstructor(IFunction.class, IFunction.class).newInstance(Util.wrap(objectArray[i]), iFunction);
        }
        this.b = iFunction;
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> collection) {
        this.a.findCursors(collection);
        this.b.findCursors(collection);
    }

    public final IFunction a() {
        return this.a;
    }

    public final IFunction b() {
        return this.b;
    }

    @Override
    public IFunction duplicate() throws Exception {
        return (IFunction)this.getClass().getConstructor(IFunction.class, IFunction.class).newInstance(this.a.duplicate(), this.b.duplicate());
    }
}

