/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.math;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.FloatType;
import script.imglib.math.fn.IFunction;
import script.imglib.math.fn.ImageFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compute {
    public static final void checkContainers(Collection<Image<?>> collection) throws Exception {
        if (collection.isEmpty()) {
            throw new Exception("There aren't any images!");
        }
        Image<?> image = collection.iterator().next();
        for (Image<?> image2 : collection) {
            if (!image2.getContainer().compareStorageContainerDimensions(image.getContainer())) {
                throw new Exception("Images have different dimensions!");
            }
            if (image2.getContainer().compareStorageContainerCompatibility(image.getContainer())) continue;
            throw new Exception("Images are of incompatible container types!");
        }
    }

    public static final Set<Image<?>> findImages(IFunction iFunction) throws Exception {
        HashSet hashSet = new HashSet();
        iFunction.findCursors(hashSet);
        HashSet hashSet2 = new HashSet();
        for (Cursor<?> cursor : hashSet) {
            hashSet2.add(cursor.getImage());
        }
        return hashSet2;
    }

    public static final <R extends RealType<R>> Image<R> apply(IFunction iFunction, R r, int n) throws Exception {
        Loop loop = new Loop<R>(iFunction, r, n){

            @Override
            public final void loop(Cursor<R> cursor, long l, IFunction iFunction) {
                for (long i = l; i > 0L; --i) {
                    cursor.fwd();
                    ((RealType)cursor.getType()).setReal(iFunction.eval());
                }
            }
        };
        return loop.run();
    }

    public static final Image<RGBALegacyType> apply(IFunction iFunction, RGBALegacyType rGBALegacyType, int n) throws Exception {
        Loop<RGBALegacyType> loop = new Loop<RGBALegacyType>(iFunction, rGBALegacyType, n){

            @Override
            public final void loop(Cursor<RGBALegacyType> cursor, long l, IFunction iFunction) {
                for (long i = l; i > 0L; --i) {
                    cursor.fwd();
                    ((RGBALegacyType)cursor.getType()).set((int)iFunction.eval());
                }
            }
        };
        return loop.run();
    }

    public static final Image<FloatType> inFloats(IFunction iFunction) throws Exception {
        return Compute.inFloats(Runtime.getRuntime().availableProcessors(), iFunction);
    }

    public static final Image<FloatType> inFloats(int n, IFunction iFunction) throws Exception {
        return Compute.apply(iFunction, new FloatType(), n);
    }

    public static final Image<DoubleType> inDoubles(int n, IFunction iFunction) throws Exception {
        return Compute.apply(iFunction, new DoubleType(), n);
    }

    public static final Image<DoubleType> inDoubles(IFunction iFunction) throws Exception {
        return Compute.inDoubles(Runtime.getRuntime().availableProcessors(), iFunction);
    }

    public static final Image<RGBALegacyType> inRGBA(int n, IFunction iFunction) throws Exception {
        return Compute.apply(iFunction, new RGBALegacyType(), n);
    }

    public static final Image<RGBALegacyType> inRGBA(IFunction iFunction) throws Exception {
        return Compute.apply(iFunction, new RGBALegacyType(), Runtime.getRuntime().availableProcessors());
    }

    public static final Image<FloatType> inFloats(Image<? extends RealType<?>> image) throws Exception {
        return Compute.inFloats(new ImageFunction(image));
    }

    public static final Image<DoubleType> inDoubles(Image<? extends RealType<?>> image) throws Exception {
        return Compute.inDoubles(new ImageFunction(image));
    }

    public static final Image<RGBALegacyType> inRGBA(Image<? extends RealType<?>> image) throws Exception {
        return Compute.inRGBA(new ImageFunction(image));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Loop<R extends NumericType<R>> {
        private final IFunction op;
        private final Collection<Image<?>> images;
        private final Collection<Cursor<?>> cursors;
        private final R output;
        private int numThreads;

        public Loop(IFunction iFunction, R r, int n) throws Exception {
            this.op = iFunction;
            this.output = r;
            this.numThreads = Math.max(1, n);
            this.cursors = new HashSet();
            iFunction.findCursors(this.cursors);
            this.images = new HashSet();
            for (Cursor<?> cursor : this.cursors) {
                this.images.add(cursor.getImage());
            }
        }

        public abstract void loop(Cursor<R> var1, long var2, IFunction var4);

        protected void cleanupCursors() {
            for (Cursor<?> cursor : this.cursors) {
                cursor.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image<R> run() throws Exception {
            try {
                Image<R> image = this.innerRun();
                return image;
            }
            finally {
                this.cleanupCursors();
            }
        }

        private final Image<R> innerRun() throws Exception {
            if (this.images.size() > 0) {
                Compute.checkContainers(this.images);
                Image<?> image = this.images.iterator().next();
                ImageFactory imageFactory = new ImageFactory(this.output, image.getContainerFactory());
                final Image image2 = imageFactory.createImage(image.getDimensions(), "result");
                final AtomicInteger atomicInteger = new AtomicInteger(0);
                final IFunction[] iFunctionArray = new IFunction[this.numThreads];
                try {
                    for (int i = 0; i < this.numThreads; ++i) {
                        iFunctionArray[i] = this.op.duplicate();
                    }
                }
                catch (Exception exception) {
                    System.out.println("Running single threaded, operations cannot be duplicated:\n" + exception);
                    this.numThreads = 1;
                }
                Thread[] threadArray = SimpleMultiThreading.newThreads((int)this.numThreads);
                final Vector vector = SimpleMultiThreading.divideIntoChunks((long)image.getNumPixels(), (int)this.numThreads);
                for (int i = 0; i < threadArray.length; ++i) {
                    threadArray[i] = new Thread(new Runnable(){

                        public void run() {
                            int n = atomicInteger.getAndIncrement();
                            Chunk chunk = (Chunk)vector.get(n);
                            Cursor cursor = image2.createCursor();
                            cursor.fwd(chunk.getStartPosition());
                            IFunction iFunction = iFunctionArray[n];
                            HashSet hashSet = new HashSet();
                            iFunction.findCursors(hashSet);
                            for (Cursor cursor2 : hashSet) {
                                cursor2.fwd(chunk.getStartPosition());
                            }
                            Loop.this.cursors.addAll(hashSet);
                            Loop.this.cursors.add(cursor);
                            Loop.this.loop(cursor, chunk.getLoopSize(), iFunction);
                        }
                    });
                }
                SimpleMultiThreading.startAndJoin((Thread[])threadArray);
                return image2;
            }
            ImageFactory imageFactory = new ImageFactory(this.output, (ContainerFactory)new ArrayContainerFactory());
            Image image = imageFactory.createImage(new int[]{1}, "result");
            Cursor cursor = image.createCursor();
            this.cursors.add(cursor);
            this.loop(cursor, image.size(), this.op);
            return image;
        }
    }
}

